/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.authentication;

import java.util.function.Function;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.zaproxy.zap.extension.script.ScriptVars;
import org.zaproxy.zap.network.HttpSenderListener;

class HttpSenderAuthHeaderListener
implements HttpSenderListener {
    public static final String ZAP_AUTH_HEADER_VALUE = "ZAP_AUTH_HEADER_VALUE";
    public static final String ZAP_AUTH_HEADER = "ZAP_AUTH_HEADER";
    public static final String ZAP_AUTH_HEADER_SITE = "ZAP_AUTH_HEADER_SITE";

    public HttpSenderAuthHeaderListener(Function<String, String> propertyProvider) {
        String authHeaderVar;
        String authHeaderValueVar = propertyProvider.apply(ZAP_AUTH_HEADER_VALUE);
        if (authHeaderValueVar != null && !authHeaderValueVar.isEmpty()) {
            ScriptVars.setGlobalVar(ZAP_AUTH_HEADER_VALUE, authHeaderValueVar);
        }
        if ((authHeaderVar = propertyProvider.apply(ZAP_AUTH_HEADER)) != null && !authHeaderVar.isEmpty()) {
            ScriptVars.setGlobalVar(ZAP_AUTH_HEADER, authHeaderVar);
        } else {
            ScriptVars.setGlobalVar(ZAP_AUTH_HEADER, "Authorization");
        }
        String authHeaderSiteVar = propertyProvider.apply(ZAP_AUTH_HEADER_SITE);
        if (authHeaderSiteVar != null && !authHeaderSiteVar.isEmpty()) {
            ScriptVars.setGlobalVar(ZAP_AUTH_HEADER_SITE, authHeaderSiteVar);
        }
    }

    @Override
    public int getListenerOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void onHttpRequestSend(HttpMessage msg, int initiator, HttpSender sender) {
        String authHeaderValue = ScriptVars.getGlobalVar(ZAP_AUTH_HEADER_VALUE);
        if (authHeaderValue != null) {
            String authHeaderSite;
            String authHeader = ScriptVars.getGlobalVar(ZAP_AUTH_HEADER);
            if (authHeader == null) {
                authHeader = "Authorization";
                ScriptVars.setGlobalVar(ZAP_AUTH_HEADER, authHeader);
            }
            if ((authHeaderSite = ScriptVars.getGlobalVar(ZAP_AUTH_HEADER_SITE)) == null || msg.getRequestHeader().getHostName().contains(authHeaderSite)) {
                msg.getRequestHeader().setHeader(authHeader, authHeaderValue);
            }
        }
    }

    @Override
    public void onHttpResponseReceive(HttpMessage msg, int initiator, HttpSender sender) {
    }
}

