/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.components.all.response;

import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextArea;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.response.ResponseStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.AutoDetectSyntaxHttpPanelTextArea;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.ContentSplitter;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextArea;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextView;
import org.zaproxy.zap.extension.httppanel.view.util.HttpTextViewUtils;
import org.zaproxy.zap.extension.search.SearchMatch;

public class HttpResponseAllPanelSyntaxHighlightTextView
extends HttpPanelSyntaxHighlightTextView {
    private static final String CSS = Constant.messages.getString("http.panel.view.syntaxtext.syntax.css");
    private static final String HTML = Constant.messages.getString("http.panel.view.syntaxtext.syntax.html");
    private static final String JAVASCRIPT = Constant.messages.getString("http.panel.view.syntaxtext.syntax.javascript");
    private static final String JSON = Constant.messages.getString("http.panel.view.syntaxtext.syntax.json");
    private static final String XML = Constant.messages.getString("http.panel.view.syntaxtext.syntax.xml");
    private ContentSplitter contentSplitter;

    public HttpResponseAllPanelSyntaxHighlightTextView(ResponseStringHttpPanelViewModel model) {
        super(model);
    }

    @Override
    protected HttpPanelSyntaxHighlightTextArea createHttpPanelTextArea() {
        this.contentSplitter = new ContentSplitter(this.getMainPanel());
        HttpResponseAllPanelSyntaxHighlightTextArea textArea = new HttpResponseAllPanelSyntaxHighlightTextArea(this.contentSplitter);
        this.contentSplitter.setTextArea(textArea);
        return textArea;
    }

    @Override
    protected void setModelData(String data) {
        if (data.isEmpty()) {
            super.setModelData(data);
            return;
        }
        int separator = data.indexOf("\n\n") + 2;
        String header = data.substring(0, separator);
        String body = this.contentSplitter.process(data.substring(separator));
        super.setModelData(header + body);
    }

    private static class HttpResponseAllPanelSyntaxHighlightTextArea
    extends AutoDetectSyntaxHttpPanelTextArea {
        private static final long serialVersionUID = 3665478428546560762L;
        private static final Logger log = LogManager.getLogger(HttpResponseAllPanelSyntaxHighlightTextArea.class);
        private final ContentSplitter contentSplitter;
        private static ResponseAllTokenMakerFactory tokenMakerFactory = null;

        public HttpResponseAllPanelSyntaxHighlightTextArea(ContentSplitter contentSplitter) {
            this.contentSplitter = contentSplitter;
            this.addSyntaxStyle(CSS, "text/css");
            this.addSyntaxStyle(HTML, "text/html");
            this.addSyntaxStyle(JAVASCRIPT, "text/javascript");
            this.addSyntaxStyle(JSON, "text/json");
            this.addSyntaxStyle(XML, "text/xml");
        }

        @Override
        public void search(Pattern p, List<SearchMatch> matches) {
            String header = ((HttpMessage)this.getMessage()).getResponseHeader().toString();
            Matcher m = p.matcher(this.getText());
            while (m.find()) {
                int[] position = HttpTextViewUtils.getViewToHeaderBodyPosition((JTextArea)((Object)this), header, m.start(), m.end());
                if (position.length == 0) {
                    return;
                }
                SearchMatch.Location location = position.length == 2 ? SearchMatch.Location.RESPONSE_HEAD : SearchMatch.Location.RESPONSE_BODY;
                matches.add(new SearchMatch(location, position[0], position[1]));
            }
        }

        @Override
        public void highlight(SearchMatch sm) {
            int[] pos;
            if (!SearchMatch.Location.RESPONSE_HEAD.equals((Object)sm.getLocation()) && !SearchMatch.Location.RESPONSE_BODY.equals((Object)sm.getLocation())) {
                return;
            }
            if (SearchMatch.Location.RESPONSE_HEAD.equals((Object)sm.getLocation())) {
                pos = HttpTextViewUtils.getHeaderToViewPosition((JTextArea)((Object)this), sm.getMessage().getResponseHeader().toString(), sm.getStart(), sm.getEnd());
            } else {
                pos = HttpTextViewUtils.getBodyToViewPosition((JTextArea)((Object)this), sm.getMessage().getResponseHeader().toString(), sm.getStart(), sm.getEnd());
                if (pos.length != 0) {
                    pos = this.contentSplitter.highlightOffsets(pos[0], pos[1]);
                }
            }
            if (pos.length == 0) {
                return;
            }
            this.highlight(pos[0], pos[1]);
        }

        @Override
        protected String detectSyntax(HttpMessage httpMessage) {
            String contentType;
            String syntax = null;
            if (httpMessage != null && (contentType = httpMessage.getResponseHeader().getHeader("Content-Type")) != null && !contentType.isEmpty()) {
                int pos = (contentType = contentType.toLowerCase(Locale.ENGLISH)).indexOf(59);
                if (pos != -1) {
                    contentType = contentType.substring(0, pos).trim();
                }
                syntax = contentType.contains("javascript") ? "text/javascript" : (contentType.contains("json") ? "text/json" : (contentType.contains("xhtml") ? "text/html" : (contentType.contains("xml") ? "text/xml" : contentType)));
            }
            return syntax;
        }

        @Override
        protected synchronized HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory getTokenMakerFactory() {
            if (tokenMakerFactory == null) {
                tokenMakerFactory = new ResponseAllTokenMakerFactory();
            }
            return tokenMakerFactory;
        }

        private static class ResponseAllTokenMakerFactory
        extends HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory {
            public ResponseAllTokenMakerFactory() {
                String pkg = "org.fife.ui.rsyntaxtextarea.modes.";
                this.putMapping("text/css", pkg + "CSSTokenMaker");
                this.putMapping("text/html", pkg + "HTMLTokenMaker");
                this.putMapping("text/javascript", pkg + "JavaScriptTokenMaker");
                this.putMapping("text/json", pkg + "JsonTokenMaker");
                this.putMapping("text/xml", pkg + "XMLTokenMaker");
            }
        }
    }
}

