/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.keyboard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.keyboard.DialogEditShortcut;
import org.zaproxy.zap.extension.keyboard.ExtensionKeyboard;
import org.zaproxy.zap.extension.keyboard.KeyboardShortcut;
import org.zaproxy.zap.extension.keyboard.KeyboardShortcutTableModel;
import org.zaproxy.zap.utils.DesktopUtils;
import org.zaproxy.zap.view.MultipleOptionsTablePanel;
import org.zaproxy.zap.view.panels.TableFilterPanel;

public class OptionsKeyboardShortcutPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogManager.getLogger(OptionsKeyboardShortcutPanel.class);
    private ExtensionKeyboard extension;
    private KeyboardOptionsPanel tkeyboardOptionsPanel;
    private JButton resetButton = null;
    private JButton cheatsheetAction = null;
    private JButton cheatsheetKey = null;
    private boolean reset = false;
    private KeyboardShortcutTableModel keyboardModel = null;

    public OptionsKeyboardShortcutPanel(ExtensionKeyboard extension) {
        this.extension = extension;
        this.initialize();
    }

    private void initialize() {
        this.setName(Constant.messages.getString("keyboard.options.title"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 5;
        gbc.anchor = 21;
        gbc.fill = 2;
        this.tkeyboardOptionsPanel = new KeyboardOptionsPanel(this.getShortcutModel());
        this.add(new TableFilterPanel<JXTable>(this.tkeyboardOptionsPanel.getTableImpl()), gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.add((Component)this.tkeyboardOptionsPanel, gbc);
        ++gbc.gridy;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        this.add((Component)new JLabel(), gbc);
        gbc.weightx = 0.0;
        if (DesktopUtils.canOpenUrlInBrowser()) {
            ++gbc.gridx;
            this.add((Component)this.getCheatsheetAction(), gbc);
            ++gbc.gridx;
            this.add((Component)this.getCheatsheetKey(), gbc);
        }
        ++gbc.gridx;
        this.add((Component)this.getResetButton(), gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        this.add((Component)new JLabel(), gbc);
    }

    @Override
    public void initParam(Object obj) {
        this.setShortcuts(this.extension.getShortcuts());
        this.getCheatsheetAction().setEnabled(API.getInstance().isEnabled());
        this.getCheatsheetKey().setEnabled(API.getInstance().isEnabled());
        this.tkeyboardOptionsPanel.packAll();
    }

    public void setShortcuts(List<KeyboardShortcut> shortcuts) {
        this.getShortcutModel().setShortcuts(shortcuts);
    }

    public List<KeyboardShortcut> getShortcuts() {
        return this.getShortcutModel().getElements();
    }

    public void addShortcut(KeyboardShortcut shortcut) {
        this.getShortcutModel().addShortcut(shortcut);
    }

    private JButton getResetButton() {
        if (this.resetButton == null) {
            this.resetButton = new JButton(Constant.messages.getString("keyboard.options.button.reset"));
            this.resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionsKeyboardShortcutPanel.this.setShortcuts(OptionsKeyboardShortcutPanel.this.extension.getShortcuts(true));
                    OptionsKeyboardShortcutPanel.this.reset = true;
                }
            });
        }
        return this.resetButton;
    }

    private JButton getCheatsheetAction() {
        if (this.cheatsheetAction == null) {
            this.cheatsheetAction = new JButton(Constant.messages.getString("keyboard.options.button.cheatAction"));
            this.cheatsheetAction.setToolTipText(Constant.messages.getString("keyboard.options.button.cheatAction.tooltip"));
            this.cheatsheetAction.setEnabled(API.getInstance().isEnabled());
            this.cheatsheetAction.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionsKeyboardShortcutPanel.this.extension.displayCheatsheetSortedByAction();
                }
            });
        }
        return this.cheatsheetAction;
    }

    private JButton getCheatsheetKey() {
        if (this.cheatsheetKey == null) {
            this.cheatsheetKey = new JButton(Constant.messages.getString("keyboard.options.button.cheatKey"));
            this.cheatsheetKey.setToolTipText(Constant.messages.getString("keyboard.options.button.cheatKey.tooltip"));
            this.cheatsheetKey.setEnabled(API.getInstance().isEnabled());
            this.cheatsheetKey.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionsKeyboardShortcutPanel.this.extension.displayCheatsheetSortedByKey();
                }
            });
        }
        return this.cheatsheetKey;
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        for (KeyboardShortcut ks : this.getShortcutModel().getElements()) {
            boolean setShortcut = ks.isChanged();
            if (this.reset) {
                KeyboardShortcut tmpKs = new KeyboardShortcut("temp", "temp", this.extension.getShortcut(ks.getIdentifier()));
                if (!ks.getKeyStrokeString().equals(tmpKs.getKeyStrokeString())) {
                    setShortcut = true;
                }
            }
            if (!setShortcut) continue;
            logger.debug("Setting keyboard shortcut for {} to {}", (Object)ks.getIdentifier(), (Object)ks.getKeyStroke());
            this.extension.setShortcut(ks.getIdentifier(), ks.getKeyStroke());
        }
        this.extension.getKeyboardParam().setConfigs();
    }

    private KeyboardShortcutTableModel getShortcutModel() {
        if (this.keyboardModel == null) {
            this.keyboardModel = new KeyboardShortcutTableModel();
        }
        return this.keyboardModel;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.keyboard";
    }

    private static class KeyboardOptionsPanel
    extends MultipleOptionsTablePanel {
        private static final long serialVersionUID = -115340627058929308L;
        private DialogEditShortcut modifyDialog = null;
        private KeyboardShortcutTableModel model;

        public KeyboardOptionsPanel(final KeyboardShortcutTableModel model) {
            super(model);
            this.model = model;
            this.getTable().setSortOrder(0, SortOrder.ASCENDING);
            this.getTable().addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int row;
                    if (SwingUtilities.isLeftMouseButton(e) && (row = this.getTable().getSelectedRow()) >= 0) {
                        this.showModifyDialogue(model.getElements().get(this.getTable().convertRowIndexToModel(row)));
                    }
                }
            });
        }

        JXTable getTableImpl() {
            return this.getTable();
        }

        protected void packAll() {
            this.getTable().packAll();
        }

        public void showModifyDialogue(KeyboardShortcut shortcut) {
            if (this.modifyDialog == null) {
                this.modifyDialog = new DialogEditShortcut((Window)View.getSingleton().getOptionsDialog(null));
                this.modifyDialog.pack();
            }
            this.modifyDialog.init(shortcut, this.model);
            this.modifyDialog.setVisible(true);
        }
    }
}

