/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.htmlparser.jericho.MasonTagTypes;
import net.htmlparser.jericho.MicrosoftConditionalCommentTagTypes;
import net.htmlparser.jericho.PHPTagTypes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.model.HistoryReference;
import org.zaproxy.zap.extension.alert.ExtensionAlert;
import org.zaproxy.zap.extension.pscan.ExtensionPassiveScan;
import org.zaproxy.zap.extension.pscan.PassiveScanParam;
import org.zaproxy.zap.extension.pscan.PassiveScanTask;
import org.zaproxy.zap.extension.pscan.PassiveScanner;
import org.zaproxy.zap.extension.pscan.PassiveScannerList;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;

public class PassiveScanTaskHelper {
    private static final Logger logger = LogManager.getLogger(PassiveScanTaskHelper.class);
    private static Set<Integer> optedInHistoryTypes = new HashSet<Integer>();
    private volatile boolean shutDown = false;
    private final ExtensionPassiveScan extPscan;
    private final ExtensionAlert extAlert;
    private final PassiveScanParam pscanParams;
    private Map<Integer, Integer> alertCounts = new HashMap<Integer, Integer>();
    private List<PassiveScanner> activeList = Collections.synchronizedList(new ArrayList());
    private List<PassiveScanTask> taskList = Collections.synchronizedList(new ArrayList());

    public PassiveScanTaskHelper(ExtensionPassiveScan extensionPscan, ExtensionAlert extensionAlert, PassiveScanParam pscanParams) {
        if (extensionAlert == null) {
            throw new IllegalArgumentException("Parameter extensionAlert must not be null.");
        }
        this.extPscan = extensionPscan;
        this.extAlert = extensionAlert;
        this.pscanParams = pscanParams;
        MicrosoftConditionalCommentTagTypes.register();
        PHPTagTypes.register();
        PHPTagTypes.PHP_SHORT.deregister();
        MasonTagTypes.register();
    }

    public void addActivePassiveScanner(PassiveScanner scanner) {
        this.activeList.add(scanner);
    }

    public void removeActivePassiveScanner(PassiveScanner scanner) {
        this.activeList.remove(scanner);
    }

    public synchronized void addTaskToList(PassiveScanTask task) {
        this.taskList.add(task);
    }

    public synchronized void removeTaskFromList(PassiveScanTask task) {
        this.taskList.remove(task);
    }

    public int getTaskListSize() {
        return this.taskList.size();
    }

    public synchronized void shutdownTasks() {
        this.taskList.stream().forEach(PassiveScanTask::shutdown);
    }

    public synchronized PassiveScanTask getOldestRunningTask() {
        for (PassiveScanTask task : this.taskList) {
            if (!Boolean.FALSE.equals(task.hasCompleted())) continue;
            return task;
        }
        return null;
    }

    public synchronized List<PassiveScanTask> getRunningTasks() {
        return this.taskList.stream().filter(task -> Boolean.FALSE.equals(task.hasCompleted())).collect(Collectors.toList());
    }

    public synchronized PassiveScanner getOldestRunningScanner() {
        for (PassiveScanTask task : this.taskList) {
            PassiveScanner scanner;
            if (!Boolean.FALSE.equals(task.hasCompleted()) || (scanner = task.getCurrentScanner()) == null) continue;
            return scanner;
        }
        return null;
    }

    public PassiveScannerList getPassiveScannerList() {
        return this.extPscan.getPassiveScannerList();
    }

    public int getMaxBodySizeInBytesToScan() {
        return this.pscanParams.getMaxBodySizeInBytesToScan();
    }

    public void raiseAlert(HistoryReference href, Alert alert) {
        if (this.shutDown) {
            return;
        }
        alert.setSource(Alert.Source.PASSIVE);
        this.extAlert.alertFound(alert, href);
        if (this.pscanParams.getMaxAlertsPerRule() > 0) {
            PassiveScanner scanner;
            Integer count = this.alertCounts.get(alert.getPluginId());
            if (count == null) {
                count = 0;
            }
            this.alertCounts.put(alert.getPluginId(), count + 1);
            if (count > this.pscanParams.getMaxAlertsPerRule() && (scanner = this.getPassiveScannerList().getScanner(alert.getPluginId())) != null) {
                logger.info("Disabling passive scan rule {} as it has raised more than {} alerts.", (Object)scanner.getName(), (Object)this.pscanParams.getMaxAlertsPerRule());
                scanner.setEnabled(false);
            }
        }
    }

    public void addHistoryTag(HistoryReference href, String tag) {
        if (this.shutDown) {
            return;
        }
        try {
            if (!href.getTags().contains(tag)) {
                href.addTag(tag);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void addApplicableHistoryType(int type) {
        optedInHistoryTypes.add(type);
    }

    public static void removeApplicableHistoryType(int type) {
        optedInHistoryTypes.remove(type);
    }

    public static Set<Integer> getOptedInHistoryTypes() {
        return Collections.unmodifiableSet(optedInHistoryTypes);
    }

    public static Set<Integer> getApplicableHistoryTypes() {
        HashSet<Integer> allApplicableTypes = new HashSet<Integer>();
        allApplicableTypes.addAll(PluginPassiveScanner.getDefaultHistoryTypes());
        if (!optedInHistoryTypes.isEmpty()) {
            allApplicableTypes.addAll(optedInHistoryTypes);
        }
        return allApplicableTypes;
    }
}

