/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.spider;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.httpclient.URI;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.zaproxy.zap.extension.help.ExtensionHelp;
import org.zaproxy.zap.extension.spider.OptionsSpiderPanel;
import org.zaproxy.zap.extension.spider.PopupMenuItemSpiderDialog;
import org.zaproxy.zap.extension.spider.PopupMenuItemSpiderDialogWithContext;
import org.zaproxy.zap.extension.spider.SpiderAPI;
import org.zaproxy.zap.extension.spider.SpiderDialog;
import org.zaproxy.zap.extension.spider.SpiderPanel;
import org.zaproxy.zap.extension.spider.SpiderScan;
import org.zaproxy.zap.extension.spider.SpiderScanController;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.DefaultValueGenerator;
import org.zaproxy.zap.model.ScanController;
import org.zaproxy.zap.model.StructuralNode;
import org.zaproxy.zap.model.StructuralSiteNode;
import org.zaproxy.zap.model.Target;
import org.zaproxy.zap.model.ValueGenerator;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.filters.FetchFilter;
import org.zaproxy.zap.spider.filters.HttpPrefixFetchFilter;
import org.zaproxy.zap.spider.filters.ParseFilter;
import org.zaproxy.zap.spider.parser.SpiderParser;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.view.ZapMenuItem;

@Deprecated
public class ExtensionSpider
extends ExtensionAdaptor
implements SessionChangedListener,
ScanController<SpiderScan> {
    private ValueGenerator generator = new DefaultValueGenerator();
    public static final int EXTENSION_ORDER = 30;
    private static final Logger log = LogManager.getLogger(ExtensionSpider.class);
    public static final String NAME = "ExtensionSpider";
    private SpiderPanel spiderPanel = null;
    SpiderDialog spiderDialog = null;
    private PopupMenuItemSpiderDialog popupMenuItemSpiderDialog;
    private PopupMenuItemSpiderDialogWithContext popupMenuItemSpiderDialogWithContext;
    private OptionsSpiderPanel optionsSpiderPanel = null;
    private SpiderParam params = null;
    private List<SpiderParser> customParsers;
    private List<FetchFilter> customFetchFilters;
    private List<ParseFilter> customParseFilters;
    private SpiderAPI spiderApi;
    private SpiderScanController scanController = null;
    private Icon icon;
    private boolean panelSwitch = true;
    private List<String> excludeList = Collections.emptyList();
    private ZapMenuItem menuItemCustomScan = null;

    public ExtensionSpider() {
        super(NAME);
        this.initialize();
    }

    private void initialize() {
        this.setOrder(30);
        this.customParsers = new LinkedList<SpiderParser>();
        this.customFetchFilters = new LinkedList<FetchFilter>();
        this.customParseFilters = new LinkedList<ParseFilter>();
        this.scanController = new SpiderScanController(this);
    }

    public void setValueGenerator(ValueGenerator generator) {
        if (generator == null) {
            throw new IllegalArgumentException("Parameter generator must not be null.");
        }
        this.generator = generator;
    }

    public ValueGenerator getValueGenerator() {
        return this.generator;
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("spider.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.addSessionListener(this);
        if (this.getView() != null) {
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuItemCustomScan());
            extensionHook.getHookView().addStatusPanel(this.getSpiderPanel());
            extensionHook.getHookView().addOptionPanel(this.getOptionsSpiderPanel());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuItemSpiderDialog());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuItemSpiderDialogWithContext());
            ExtensionHelp.enableHelpKey(this.getSpiderPanel(), "ui.tabs.spider");
        }
        extensionHook.addOptionsParamSet(this.getSpiderParam());
        this.spiderApi = new SpiderAPI(this);
        this.spiderApi.addApiOptions(this.getSpiderParam());
        extensionHook.addApiImplementor(this.spiderApi);
    }

    private PopupMenuItemSpiderDialog getPopupMenuItemSpiderDialog() {
        if (this.popupMenuItemSpiderDialog == null) {
            this.popupMenuItemSpiderDialog = new PopupMenuItemSpiderDialog(this);
        }
        return this.popupMenuItemSpiderDialog;
    }

    private PopupMenuItemSpiderDialogWithContext getPopupMenuItemSpiderDialogWithContext() {
        if (this.popupMenuItemSpiderDialogWithContext == null) {
            this.popupMenuItemSpiderDialogWithContext = new PopupMenuItemSpiderDialogWithContext(this);
        }
        return this.popupMenuItemSpiderDialogWithContext;
    }

    @Override
    public List<String> getActiveActions() {
        List<SpiderScan> activeSpiders = this.scanController.getActiveScans();
        if (activeSpiders.isEmpty()) {
            return null;
        }
        String spiderActionPrefix = Constant.messages.getString("spider.activeActionPrefix");
        ArrayList<String> activeActions = new ArrayList<String>(activeSpiders.size());
        for (SpiderScan activeSpider : activeSpiders) {
            activeActions.add(MessageFormat.format(spiderActionPrefix, activeSpider.getDisplayName()));
        }
        return activeActions;
    }

    protected SpiderParam getSpiderParam() {
        if (this.params == null) {
            this.params = new SpiderParam();
        }
        return this.params;
    }

    protected SpiderPanel getSpiderPanel() {
        if (this.spiderPanel == null) {
            this.spiderPanel = new SpiderPanel(this, this.getSpiderParam());
        }
        return this.spiderPanel;
    }

    @Override
    public void sessionAboutToChange(Session session) {
        this.scanController.reset();
        if (this.hasView()) {
            this.getSpiderPanel().reset();
            if (this.spiderDialog != null) {
                this.spiderDialog.reset();
            }
        }
    }

    @Override
    public void sessionChanged(final Session session) {
        if (EventQueue.isDispatchThread()) {
            this.sessionChangedEventHandler(session);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExtensionSpider.this.sessionChangedEventHandler(session);
                    }
                });
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void sessionChangedEventHandler(Session session) {
        if (this.hasView()) {
            this.getSpiderPanel().reset();
        }
        if (session == null) {
            return;
        }
    }

    private OptionsSpiderPanel getOptionsSpiderPanel() {
        if (this.optionsSpiderPanel == null) {
            this.optionsSpiderPanel = new OptionsSpiderPanel();
        }
        return this.optionsSpiderPanel;
    }

    public void setExcludeList(List<String> ignoredRegexs) {
        if (ignoredRegexs == null || ignoredRegexs.isEmpty()) {
            this.excludeList = Collections.emptyList();
            return;
        }
        this.excludeList = ignoredRegexs;
    }

    public List<String> getExcludeList() {
        return this.excludeList;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("spider.desc");
    }

    @Override
    public void sessionScopeChanged(Session session) {
        if (this.hasView()) {
            this.getSpiderPanel().sessionScopeChanged(session);
        }
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
        if (Control.Mode.safe.equals((Object)mode)) {
            this.scanController.stopAllScans();
        }
        if (this.hasView()) {
            this.getSpiderPanel().sessionModeChanged(mode);
            this.getMenuItemCustomScan().setEnabled(!Control.Mode.safe.equals((Object)mode));
        }
    }

    public void startScanNode(SiteNode node) {
        Target target = new Target(node);
        target.setRecurse(true);
        this.startScan(target, null, null);
    }

    public void startScanNode(SiteNode node, User user) {
        Target target = new Target(node);
        target.setRecurse(true);
        this.startScan(target, user, null);
    }

    public void startScanAllInScope() {
        Target target = new Target(true);
        target.setRecurse(true);
        this.startScan(target, null, null);
    }

    public void startScan(SiteNode startNode) {
        Target target = new Target(startNode);
        target.setRecurse(true);
        this.startScan(target, null, null);
    }

    public void startScanAllInContext(Context context, User user) {
        Target target = new Target(context);
        target.setRecurse(true);
        this.startScan(target, user, null);
    }

    @Override
    public void destroy() {
        this.stopAllScans();
        if (this.hasView()) {
            this.getSpiderPanel().reset();
        }
    }

    public List<SpiderParser> getCustomParsers() {
        return this.customParsers;
    }

    public List<FetchFilter> getCustomFetchFilters() {
        return this.customFetchFilters;
    }

    public List<ParseFilter> getCustomParseFilters() {
        return this.customParseFilters;
    }

    public void addCustomParser(SpiderParser parser) {
        ExtensionSpider.validateParameterNonNull(parser, "parser");
        this.customParsers.add(parser);
    }

    private static void validateParameterNonNull(Object object, String name) {
        if (object == null) {
            throw new IllegalArgumentException("Parameter " + name + " must not be null.");
        }
    }

    public void removeCustomParser(SpiderParser parser) {
        ExtensionSpider.validateParameterNonNull(parser, "parser");
        this.customParsers.remove(parser);
    }

    public void addCustomFetchFilter(FetchFilter filter) {
        ExtensionSpider.validateParameterNonNull(filter, "filter");
        this.customFetchFilters.add(filter);
    }

    public void removeCustomFetchFilter(FetchFilter filter) {
        ExtensionSpider.validateParameterNonNull(filter, "filter");
        this.customFetchFilters.remove(filter);
    }

    public void addCustomParseFilter(ParseFilter filter) {
        ExtensionSpider.validateParameterNonNull(filter, "filter");
        this.customParseFilters.add(filter);
    }

    public void removeCustomParseFilter(ParseFilter filter) {
        ExtensionSpider.validateParameterNonNull(filter, "filter");
        this.customParseFilters.remove(filter);
    }

    public int startScan(Target target, User user, Object[] customConfigurations) {
        return this.startScan(this.createDisplayName(target, customConfigurations), target, user, customConfigurations);
    }

    private String createDisplayName(Target target, Object[] customConfigurations) {
        HttpPrefixFetchFilter subtreeFecthFilter = this.getUriPrefixFecthFilter(customConfigurations);
        if (subtreeFecthFilter != null) {
            return ExtensionSpider.abbreviateDisplayName(subtreeFecthFilter.getNormalisedPrefix());
        }
        if (target.getContext() != null) {
            return Constant.messages.getString("context.prefixName", target.getContext().getName());
        }
        if (target.isInScopeOnly()) {
            return Constant.messages.getString("target.allInScope");
        }
        if (target.getStartNode() == null) {
            if (customConfigurations != null) {
                for (Object customConfiguration : customConfigurations) {
                    if (!(customConfiguration instanceof URI)) continue;
                    return ExtensionSpider.abbreviateDisplayName(((URI)customConfiguration).toString());
                }
            }
            return Constant.messages.getString("target.empty");
        }
        return ExtensionSpider.abbreviateDisplayName(target.getStartNode().getHierarchicNodeName(false));
    }

    private HttpPrefixFetchFilter getUriPrefixFecthFilter(Object[] customConfigurations) {
        if (customConfigurations != null) {
            for (Object customConfiguration : customConfigurations) {
                if (!(customConfiguration instanceof HttpPrefixFetchFilter)) continue;
                return (HttpPrefixFetchFilter)customConfiguration;
            }
        }
        return null;
    }

    private static String abbreviateDisplayName(String displayName) {
        return StringUtils.abbreviateMiddle((String)displayName, (String)"..", (int)30);
    }

    @Override
    public int startScan(String displayName, Target target, User user, Object[] customConfigurations) {
        switch (Control.getSingleton().getMode()) {
            case safe: {
                throw new IllegalStateException("Scans are not allowed in Safe mode");
            }
            case protect: {
                String uri = this.getTargetUriOutOfScope(target, customConfigurations);
                if (uri == null) break;
                throw new IllegalStateException("Scans are not allowed on targets not in scope when in Protected mode: " + uri);
            }
        }
        int id = this.scanController.startScan(displayName, target, user, customConfigurations);
        if (this.hasView()) {
            this.addScanToUi(this.scanController.getScan(id));
        }
        return id;
    }

    private void addScanToUi(final SpiderScan scan) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExtensionSpider.this.addScanToUi(scan);
                }
            });
            return;
        }
        this.getSpiderPanel().scannerStarted(scan);
        scan.setListener(this.getSpiderPanel());
        this.getSpiderPanel().switchView(scan);
        if (this.isPanelSwitch()) {
            this.getSpiderPanel().setTabFocus();
        }
    }

    public boolean isPanelSwitch() {
        return this.panelSwitch;
    }

    public void setPanelSwitch(boolean panelSwitch) {
        this.panelSwitch = panelSwitch;
    }

    protected String getTargetUriOutOfScope(Target target) {
        return this.getTargetUriOutOfScope(target, null);
    }

    protected String getTargetUriOutOfScope(Target target, Object[] contextSpecificObjects) {
        List<StructuralNode> nodes = target.getStartNodes();
        if (nodes != null) {
            for (StructuralNode node : nodes) {
                if (node == null) continue;
                if (node instanceof StructuralSiteNode) {
                    SiteNode siteNode = ((StructuralSiteNode)node).getSiteNode();
                    if (siteNode.isIncludedInScope()) continue;
                    return node.getURI().toString();
                }
                String uri = node.getURI().toString();
                if (this.isTargetUriInScope(uri)) continue;
                return uri;
            }
        }
        if (contextSpecificObjects != null) {
            for (Object obj : contextSpecificObjects) {
                String uri;
                if (!(obj instanceof URI) || this.isTargetUriInScope(uri = ((URI)obj).toString())) continue;
                return uri;
            }
        }
        return null;
    }

    protected boolean isTargetUriInScope(String uri) {
        if (uri == null) {
            return false;
        }
        return this.getModel().getSession().isInScope(uri);
    }

    @Override
    public List<SpiderScan> getAllScans() {
        return this.scanController.getAllScans();
    }

    @Override
    public List<SpiderScan> getActiveScans() {
        return this.scanController.getActiveScans();
    }

    @Override
    public SpiderScan getScan(int id) {
        return this.scanController.getScan(id);
    }

    @Override
    public void stopScan(int id) {
        this.scanController.stopScan(id);
    }

    @Override
    public void stopAllScans() {
        this.scanController.stopAllScans();
    }

    @Override
    public void pauseScan(int id) {
        this.scanController.pauseScan(id);
        if (this.hasView()) {
            this.getSpiderPanel().updateScannerUI();
        }
    }

    @Override
    public void pauseAllScans() {
        this.scanController.pauseAllScans();
        if (this.hasView()) {
            this.getSpiderPanel().updateScannerUI();
        }
    }

    @Override
    public void resumeScan(int id) {
        this.scanController.resumeScan(id);
        if (this.hasView()) {
            this.getSpiderPanel().updateScannerUI();
        }
    }

    @Override
    public void resumeAllScans() {
        this.scanController.resumeAllScans();
        if (this.hasView()) {
            this.getSpiderPanel().updateScannerUI();
        }
    }

    @Override
    public SpiderScan removeScan(int id) {
        return this.scanController.removeScan(id);
    }

    @Override
    public int removeAllScans() {
        return this.scanController.removeAllScans();
    }

    @Override
    public int removeFinishedScans() {
        return this.scanController.removeFinishedScans();
    }

    @Override
    public SpiderScan getLastScan() {
        return this.scanController.getLastScan();
    }

    private ZapMenuItem getMenuItemCustomScan() {
        if (this.menuItemCustomScan == null) {
            this.menuItemCustomScan = new ZapMenuItem("menu.tools.spider", this.getView().getMenuShortcutKeyStroke(83, 512, false));
            this.menuItemCustomScan.setEnabled(Control.getSingleton().getMode() != Control.Mode.safe);
            this.menuItemCustomScan.addActionListener(e -> this.showSpiderDialog((Target)null));
        }
        return this.menuItemCustomScan;
    }

    public void showSpiderDialog(SiteNode node) {
        this.showSpiderDialog(node != null ? new Target(node) : null);
    }

    public void showSpiderDialog(Target target) {
        if (this.spiderDialog == null) {
            this.spiderDialog = new SpiderDialog(this, this.getView().getMainFrame(), new Dimension(700, 430));
        }
        if (this.spiderDialog.isVisible()) {
            this.spiderDialog.toFront();
            return;
        }
        if (target != null) {
            this.spiderDialog.init(target);
        } else {
            this.spiderDialog.init(null);
        }
        this.spiderDialog.setVisible(true);
    }

    @Override
    public boolean supportsLowMemory() {
        return true;
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = new ImageIcon(ExtensionSpider.class.getResource("/resource/icon/16/spider.png"));
        }
        return this.icon;
    }
}

