/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.SSLException;
import net.htmlparser.jericho.Source;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpHeaderField;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.HttpResponseHeader;
import org.zaproxy.zap.spider.Spider;
import org.zaproxy.zap.spider.SpiderTaskResult;
import org.zaproxy.zap.spider.filters.ParseFilter;
import org.zaproxy.zap.spider.parser.SpiderParser;
import org.zaproxy.zap.spider.parser.SpiderResourceFound;

@Deprecated
public class SpiderTask
implements Runnable {
    private Spider parent;
    private HistoryReference reference;
    private SpiderResourceFound resourceFound;
    private ExtensionHistory extHistory = null;
    private static final Logger log = LogManager.getLogger(SpiderTask.class);

    public SpiderTask(Spider parent, SpiderResourceFound resourceFound, URI uri) {
        this.parent = parent;
        this.resourceFound = resourceFound;
        log.debug("New task submitted for uri: {}", (Object)uri);
        try {
            HttpRequestHeader requestHeader = new HttpRequestHeader(resourceFound.getMethod(), uri, "HTTP/1.1");
            for (HttpHeaderField header : resourceFound.getHeaders()) {
                requestHeader.addHeader(header.getName(), header.getValue());
            }
            if (resourceFound.getMessage() != null && parent.getSpiderParam().isSendRefererHeader()) {
                requestHeader.setHeader("Referer", resourceFound.getMessage().getRequestHeader().getURI().toString());
            }
            HttpMessage msg = new HttpMessage(requestHeader);
            if (!resourceFound.getBody().isEmpty()) {
                msg.getRequestHeader().setContentLength(resourceFound.getBody().length());
                msg.setRequestBody(resourceFound.getBody());
            }
            this.reference = new HistoryReference(parent.getModel().getSession(), 9, msg);
        }
        catch (HttpMalformedHeaderException e) {
            log.error("Error while building HttpMessage for uri: {}", (Object)uri, (Object)e);
        }
        catch (DatabaseException e) {
            log.error("Error while persisting HttpMessage for uri: {}", (Object)uri, (Object)e);
        }
    }

    @Override
    public void run() {
        try {
            if (this.reference == null) {
                log.warn("Null URI. Skipping crawling task: {}", (Object)this);
                return;
            }
            log.debug("Spider Task Started. Processing uri at depth {} using already constructed message: {}", (Object)this.resourceFound.getDepth(), (Object)this.reference.getURI());
            this.runImpl();
        }
        finally {
            this.parent.postTaskExecution();
            log.debug("Spider Task finished.");
        }
    }

    private void runImpl() {
        ParseFilter filter;
        HttpMessage msg;
        if (this.parent.isStopped()) {
            log.debug("Spider process is stopped. Skipping crawling task...");
            this.deleteHistoryReference();
            return;
        }
        this.parent.preTaskExecution();
        try {
            msg = this.prepareHttpMessage();
        }
        catch (Exception e) {
            log.error("Failed to prepare HTTP message: ", (Throwable)e);
            return;
        }
        try {
            this.fetchResource(msg);
        }
        catch (Exception e) {
            this.setErrorResponse(msg, e);
            this.parent.notifyListenersSpiderTaskResult(new SpiderTaskResult(msg, this.getSkippedMessage("ioerror")));
            return;
        }
        if (this.parent.isStopped()) {
            this.parent.notifyListenersSpiderTaskResult(new SpiderTaskResult(msg, this.getSkippedMessage("stopped")));
            log.debug("Spider process is stopped. Skipping crawling task...");
            return;
        }
        this.parent.checkPauseAndWait();
        ParseFilter.FilterResult filterResult = ParseFilter.FilterResult.NOT_FILTERED;
        boolean wanted = false;
        Iterator iterator = this.parent.getController().getParseFilters().iterator();
        while (iterator.hasNext() && !(filterResult = (filter = (ParseFilter)iterator.next()).filtered(msg)).isFiltered()) {
            if (filterResult != ParseFilter.FilterResult.WANTED) continue;
            wanted = true;
        }
        if (!wanted && !filterResult.isFiltered()) {
            filterResult = this.parent.getController().getDefaultParseFilter().filtered(msg);
        }
        if (filterResult.isFiltered()) {
            log.debug("Resource [{}] fetched, but will not be parsed due to a ParseFilter rule: {}", (Object)msg.getRequestHeader().getURI(), (Object)filterResult.getReason());
            this.parent.notifyListenersSpiderTaskResult(new SpiderTaskResult(msg, filterResult.getReason()));
            return;
        }
        if (this.parent.isStopped()) {
            this.parent.notifyListenersSpiderTaskResult(new SpiderTaskResult(msg, this.getSkippedMessage("stopped")));
            log.debug("Spider process is stopped. Skipping crawling task...");
            return;
        }
        this.parent.checkPauseAndWait();
        int maxDepth = this.parent.getSpiderParam().getMaxDepth();
        if (maxDepth == 0 || this.resourceFound.getDepth() < maxDepth) {
            this.parent.notifyListenersSpiderTaskResult(new SpiderTaskResult(msg));
            this.processResource(msg);
        } else {
            this.parent.notifyListenersSpiderTaskResult(new SpiderTaskResult(msg, this.getSkippedMessage("maxdepth")));
        }
    }

    private String getSkippedMessage(String key) {
        return this.parent.getExtensionSpider().getMessages().getString("spider.task.message.skipped." + key);
    }

    private HttpMessage prepareHttpMessage() throws HttpMalformedHeaderException, DatabaseException {
        HttpMessage msg;
        try {
            msg = this.reference.getHttpMessage();
            msg.setHistoryRef(null);
        }
        finally {
            this.deleteHistoryReference();
        }
        msg.getRequestHeader().setHeader("If-Modified-Since", null);
        msg.getRequestHeader().setHeader("If-None-Match", null);
        if (this.parent.getSpiderParam().getUserAgent() != null) {
            msg.getRequestHeader().setHeader("User-Agent", this.parent.getSpiderParam().getUserAgent());
        }
        if (this.parent.getScanUser() != null) {
            msg.setRequestingUser(this.parent.getScanUser());
        }
        return msg;
    }

    private void deleteHistoryReference() {
        if (this.reference == null) {
            return;
        }
        if (this.getExtensionHistory() != null) {
            this.getExtensionHistory().delete(this.reference);
            this.reference = null;
        }
    }

    private void setErrorResponse(HttpMessage msg, Exception cause) {
        StringBuilder strBuilder = new StringBuilder(250);
        if (cause instanceof SSLException) {
            strBuilder.append(Constant.messages.getString("network.ssl.error.connect"));
            strBuilder.append(msg.getRequestHeader().getURI().toString()).append('\n');
            strBuilder.append(Constant.messages.getString("network.ssl.error.exception")).append(cause.getMessage()).append('\n');
            strBuilder.append(Constant.messages.getString("network.ssl.error.exception.rootcause")).append(ExceptionUtils.getRootCauseMessage((Throwable)cause)).append('\n');
            strBuilder.append(Constant.messages.getString("network.ssl.error.help", Constant.messages.getString("network.ssl.error.help.url")));
            strBuilder.append("\n\nStack Trace:\n");
            for (String stackTraceFrame : ExceptionUtils.getRootCauseStackTrace((Throwable)cause)) {
                strBuilder.append(stackTraceFrame).append('\n');
            }
        } else {
            strBuilder.append(cause.getClass().getName()).append(": ").append(cause.getLocalizedMessage()).append("\n\nStack Trace:\n");
            for (String stackTraceFrame : ExceptionUtils.getRootCauseStackTrace((Throwable)cause)) {
                strBuilder.append(stackTraceFrame).append('\n');
            }
        }
        String message = strBuilder.toString();
        try {
            HttpResponseHeader responseHeader = new HttpResponseHeader("HTTP/1.1 400 ZAP IO Error");
            responseHeader.setHeader("Content-Type", "text/plain; charset=UTF-8");
            responseHeader.setHeader("Content-Length", Integer.toString(message.getBytes(StandardCharsets.UTF_8).length));
            msg.setResponseHeader(responseHeader);
            msg.setResponseBody(message);
        }
        catch (HttpMalformedHeaderException e) {
            log.error("Failed to create error response:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResource(HttpMessage message) {
        List<SpiderParser> parsers = this.parent.getController().getParsers();
        Source source = new Source((CharSequence)message.getResponseBody().toString());
        String path = null;
        try {
            path = message.getRequestHeader().getURI().getPath();
        }
        catch (URIException uRIException) {
        }
        finally {
            if (path == null) {
                path = "";
            }
        }
        boolean alreadyConsumed = false;
        for (SpiderParser parser : parsers) {
            if (parser.canParseResource(message, path, alreadyConsumed)) {
                log.debug("Parser {} can parse resource '{}'", (Object)parser, (Object)path);
                if (!parser.parseResource(message, source, this.resourceFound.getDepth())) continue;
                alreadyConsumed = true;
                continue;
            }
            log.debug("Parser {} cannot parse resource '{}'", (Object)parser, (Object)path);
        }
    }

    private ExtensionHistory getExtensionHistory() {
        if (this.extHistory == null) {
            this.extHistory = Control.getSingleton().getExtensionLoader().getExtension(ExtensionHistory.class);
        }
        return this.extHistory;
    }

    private void fetchResource(HttpMessage msg) throws IOException {
        if (this.parent.getHttpSender() == null) {
            return;
        }
        try {
            this.parent.getHttpSender().sendAndReceive(msg);
        }
        catch (ConnectException e) {
            log.debug("Failed to connect to: {}", (Object)msg.getRequestHeader().getURI(), (Object)e);
            throw e;
        }
        catch (SocketTimeoutException e) {
            log.debug("Socket timeout: {}", (Object)msg.getRequestHeader().getURI(), (Object)e);
            throw e;
        }
        catch (SocketException e) {
            log.debug("Socket exception: {}", (Object)msg.getRequestHeader().getURI(), (Object)e);
            throw e;
        }
        catch (UnknownHostException e) {
            log.debug("Unknown host: {}", (Object)msg.getRequestHeader().getURI(), (Object)e);
            throw e;
        }
        catch (Exception e) {
            log.error("An error occurred while fetching the resource [{}]: {}", (Object)msg.getRequestHeader().getURI(), (Object)e.getMessage(), (Object)e);
            throw e;
        }
    }

    void cleanup() {
        this.deleteHistoryReference();
    }
}

