/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.tree.TreeNode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.JXComboBox;
import org.jdesktop.swingx.decorator.FontHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.GenericScanner;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.utils.SortedComboBoxModel;
import org.zaproxy.zap.view.ScanStatus;
import org.zaproxy.zap.view.ZapToggleButton;

public abstract class ScanPanel
extends AbstractPanel {
    private static final long serialVersionUID = 1L;
    public String prefix;
    private ExtensionAdaptor extension = null;
    private JPanel panelCommand = null;
    private JToolBar panelToolbar = null;
    private JLabel scannedCountNameLabel = null;
    private JLabel foundCountNameLabel = null;
    private List<String> activeScans = new ArrayList<String>();
    private String currentSite = null;
    private JComboBox<ScanTarget> siteSelect;
    private SortedComboBoxModel<ScanTarget> siteModel = new SortedComboBoxModel();
    private JButton startScanButton = null;
    private JButton stopScanButton = null;
    private ZapToggleButton pauseScanButton = null;
    private JButton optionsButton = null;
    private JProgressBar progressBar = null;
    private Map<String, GenericScanner> scanMap = new HashMap<String, GenericScanner>();
    private AbstractParam scanParam = null;
    private ScanStatus scanStatus = null;
    private Control.Mode mode = Control.getSingleton().getMode();
    private static Logger log = LogManager.getLogger(ScanPanel.class);

    public ScanPanel(String prefix, ImageIcon icon, ExtensionAdaptor extension, AbstractParam scanParam) {
        this.prefix = prefix;
        this.extension = extension;
        this.scanParam = scanParam;
        this.initialize(icon);
        log.debug("Constructor {}", (Object)prefix);
    }

    private void initialize(ImageIcon icon) {
        this.setLayout(new CardLayout());
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(474, 251);
        }
        this.setName(Constant.messages.getString(this.prefix + ".panel.title"));
        this.setIcon(icon);
        this.add((Component)this.getPanelCommand(), this.prefix + ".panel");
        this.scanStatus = new ScanStatus(icon, Constant.messages.getString(this.prefix + ".panel.title"));
        if (View.isInitialised()) {
            View.getSingleton().getMainFrame().getMainFooterPanel().addFooterToolbarRightLabel(this.scanStatus.getCountLabel());
        }
    }

    private JPanel getPanelCommand() {
        if (this.panelCommand == null) {
            this.panelCommand = new JPanel();
            this.panelCommand.setLayout(new GridBagLayout());
            this.panelCommand.setName(this.prefix + ".panel");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints1.anchor = 18;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.anchor = 18;
            this.panelCommand.add((Component)this.getPanelToolbar(), gridBagConstraints1);
            this.panelCommand.add(this.getWorkPanel(), gridBagConstraints2);
        }
        return this.panelCommand;
    }

    protected GridBagConstraints getGBC(int gridx, int gridy) {
        return this.getGBC(gridx, gridy, 0.0, new Insets(0, 2, 0, 0));
    }

    protected GridBagConstraints getGBC(int gridx, int gridy, double weightx, Insets insets) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.weightx = weightx;
        if (weightx > 0.0) {
            gbc.fill = 2;
        }
        gbc.insets = insets;
        gbc.anchor = 17;
        return gbc;
    }

    private JToolBar getPanelToolbar() {
        if (this.panelToolbar == null) {
            this.panelToolbar = new JToolBar();
            this.panelToolbar.setLayout(new GridBagLayout());
            this.panelToolbar.setEnabled(true);
            this.panelToolbar.setFloatable(false);
            this.panelToolbar.setRollover(true);
            this.panelToolbar.setPreferredSize(new Dimension(800, 30));
            this.panelToolbar.setName(this.prefix + ".toolbar");
            int x = 0;
            x = this.addToolBarElements(this.panelToolbar, Location.start, x);
            this.panelToolbar.add((Component)new JLabel(Constant.messages.getString(this.prefix + ".toolbar.site.label")), this.getGBC(x++, 0));
            this.panelToolbar.add(this.getSiteSelect(), this.getGBC(x++, 0));
            x = this.addToolBarElements(this.panelToolbar, Location.beforeButtons, x);
            this.panelToolbar.add((Component)this.getStartScanButton(), this.getGBC(x++, 0));
            this.panelToolbar.add((Component)this.getPauseScanButton(), this.getGBC(x++, 0));
            this.panelToolbar.add((Component)this.getStopScanButton(), this.getGBC(x++, 0));
            x = this.addToolBarElements(this.panelToolbar, Location.beforeProgressBar, x);
            this.panelToolbar.add((Component)this.getProgressBar(), this.getGBC(x++, 0, 1.0, new Insets(0, 5, 0, 5)));
            this.panelToolbar.add((Component)this.getActiveScansNameLabel(), this.getGBC(x++, 0));
            this.panelToolbar.add((Component)this.getActiveScansValueLabel(), this.getGBC(x++, 0));
            x = this.addToolBarElements(this.panelToolbar, Location.afterProgressBar, x);
            this.panelToolbar.add((Component)new JLabel(), this.getGBC(x++, 0, 1.0, new Insets(0, 0, 0, 0)));
            this.panelToolbar.add((Component)this.getOptionsButton(), this.getGBC(x++, 0));
        }
        return this.panelToolbar;
    }

    protected int addToolBarElements(JToolBar toolBar, Location location, int gridX) {
        return gridX;
    }

    private JLabel getActiveScansNameLabel() {
        if (this.scannedCountNameLabel == null) {
            this.scannedCountNameLabel = new JLabel();
            this.scannedCountNameLabel.setText(Constant.messages.getString(this.prefix + ".toolbar.ascans.label"));
        }
        return this.scannedCountNameLabel;
    }

    private JLabel getActiveScansValueLabel() {
        if (this.foundCountNameLabel == null) {
            this.foundCountNameLabel = new JLabel();
            this.foundCountNameLabel.setText(String.valueOf(this.activeScans.size()));
        }
        return this.foundCountNameLabel;
    }

    private void setActiveScanLabels() {
        if (EventQueue.isDispatchThread()) {
            this.setActiveScanLabelsEventHandler();
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ScanPanel.this.setActiveScanLabelsEventHandler();
                    }
                });
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void setActiveScanLabelsEventHandler() {
        this.getActiveScansValueLabel().setText(String.valueOf(this.activeScans.size()));
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = this.activeScans.iterator();
        sb.append("<html>");
        while (iter.hasNext()) {
            sb.append(iter.next());
            sb.append("<br>");
        }
        sb.append("</html>");
        String toolTip = sb.toString();
        this.getActiveScansNameLabel().setToolTipText(toolTip);
        this.getActiveScansValueLabel().setToolTipText(toolTip);
        this.scanStatus.setScanCount(this.activeScans.size());
    }

    private JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setValue(0);
            this.progressBar.setSize(new Dimension(80, 20));
            this.progressBar.setStringPainted(true);
            this.progressBar.setEnabled(false);
        }
        return this.progressBar;
    }

    private JButton getStartScanButton() {
        if (this.startScanButton == null) {
            this.startScanButton = new JButton();
            this.startScanButton.setToolTipText(Constant.messages.getString(this.prefix + ".toolbar.button.start"));
            this.startScanButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(ScanPanel.class.getResource("/resource/icon/16/131.png"))));
            this.startScanButton.setEnabled(false);
            this.startScanButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScanPanel.this.startScan();
                }
            });
        }
        return this.startScanButton;
    }

    private JButton getStopScanButton() {
        if (this.stopScanButton == null) {
            this.stopScanButton = new JButton();
            this.stopScanButton.setToolTipText(Constant.messages.getString(this.prefix + ".toolbar.button.stop"));
            this.stopScanButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(ScanPanel.class.getResource("/resource/icon/16/142.png"))));
            this.stopScanButton.setEnabled(false);
            this.stopScanButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScanPanel.this.stopScan(ScanPanel.this.currentSite);
                }
            });
        }
        return this.stopScanButton;
    }

    private JToggleButton getPauseScanButton() {
        if (this.pauseScanButton == null) {
            this.pauseScanButton = new ZapToggleButton();
            this.pauseScanButton.setToolTipText(Constant.messages.getString(this.prefix + ".toolbar.button.pause"));
            this.pauseScanButton.setSelectedToolTipText(Constant.messages.getString(this.prefix + ".toolbar.button.unpause"));
            this.pauseScanButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(ScanPanel.class.getResource("/resource/icon/16/141.png"))));
            this.pauseScanButton.setRolloverIcon(DisplayUtils.getScaledIcon(new ImageIcon(ScanPanel.class.getResource("/resource/icon/16/141.png"))));
            this.pauseScanButton.setSelectedIcon(DisplayUtils.getScaledIcon(new ImageIcon(ScanPanel.class.getResource("/resource/icon/16/131.png"))));
            this.pauseScanButton.setRolloverSelectedIcon(DisplayUtils.getScaledIcon(new ImageIcon(ScanPanel.class.getResource("/resource/icon/16/131.png"))));
            this.pauseScanButton.setEnabled(false);
            this.pauseScanButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScanPanel.this.pauseScan(ScanPanel.this.currentSite);
                }
            });
        }
        return this.pauseScanButton;
    }

    private JButton getOptionsButton() {
        if (this.optionsButton == null) {
            this.optionsButton = new JButton();
            this.optionsButton.setToolTipText(Constant.messages.getString(this.prefix + ".toolbar.button.options"));
            this.optionsButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(ScanPanel.class.getResource("/resource/icon/16/041.png"))));
            this.optionsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Control.getSingleton().getMenuToolsControl().options(Constant.messages.getString(ScanPanel.this.prefix + ".options.title"));
                }
            });
        }
        return this.optionsButton;
    }

    protected JComboBox<ScanTarget> getSiteSelect() {
        if (this.siteSelect == null) {
            this.siteSelect = new JXComboBox(this.siteModel);
            ((JXComboBox)this.siteSelect).addHighlighter((Highlighter)new FontHighlighter((renderer, adapter) -> ((ScanTarget)adapter.getValue()).isScanned(), this.siteSelect.getFont().deriveFont(1)));
            this.resetSiteSelect();
            this.siteSelect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScanTarget item = (ScanTarget)ScanPanel.this.siteSelect.getSelectedItem();
                    if (item != null && ScanPanel.this.siteSelect.getSelectedIndex() > 0) {
                        ScanPanel.this.siteSelected(item.getSite());
                    } else {
                        ScanPanel.this.siteSelected(null);
                    }
                }
            });
        }
        return this.siteSelect;
    }

    public boolean isScanning(SiteNode node, boolean incPort) {
        GenericScanner scanThread;
        String site = ScanPanel.cleanSiteName(node, incPort);
        if (site != null && (scanThread = this.scanMap.get(site)) != null) {
            return scanThread.isRunning();
        }
        return false;
    }

    public void scanAllInScope() {
        log.debug("scanSite (all in scope)");
        this.setTabFocus();
        if (this.getStartScanButton().isEnabled()) {
            this.startScan(null, true, true, null, null);
        }
    }

    public void scanAllInContext(Context context) {
        this.scanAllInContext(context, null);
    }

    public void scanAllInContext(Context context, User user) {
        log.debug("Scan all in context: {}", (Object)context.getName());
        this.setTabFocus();
        if (this.getStartScanButton().isEnabled()) {
            this.startScan(null, true, true, context, user);
        }
    }

    public void scanSite(SiteNode node, boolean incPort) {
        log.debug("scanSite {} node={}", (Object)this.prefix, (Object)node.getNodeName());
        this.setTabFocus();
        this.nodeSelected(node, incPort);
        if (this.currentSite != null && this.getStartScanButton().isEnabled()) {
            this.startScan(node, false, true, null, null);
        }
    }

    public void scanNode(SiteNode node, boolean incPort) {
        this.scanNode(node, incPort, null);
    }

    public void scanNode(SiteNode node, boolean incPort, User user) {
        log.debug("scanNode{} node={}", (Object)this.prefix, (Object)node.getNodeName());
        this.setTabFocus();
        this.nodeSelected(node, incPort);
        if (this.currentSite != null && this.getStartScanButton().isEnabled()) {
            this.startScan(node, false, false, null, user);
        }
    }

    public void addSite(String site, boolean incPort) {
        if (!this.isSiteAdded(site = ScanPanel.cleanSiteName(site, incPort))) {
            this.addSite(site);
        }
    }

    private boolean isSiteAdded(String site) {
        return this.getScanTarget(site) != null;
    }

    private ScanTarget getScanTarget(String site) {
        for (int i = 1; i < this.siteModel.getSize(); ++i) {
            ScanTarget scanTarget = (ScanTarget)this.siteModel.getElementAt(i);
            if (!scanTarget.getSite().equals(site)) continue;
            return scanTarget;
        }
        return null;
    }

    private void addSite(String site) {
        log.debug("addSite {}", (Object)site);
        this.siteModel.addElement(new ScanTarget(site));
    }

    protected void siteSelected(String site) {
        this.siteSelected(site, false);
    }

    protected void siteSelected(String site, boolean forceRefresh) {
        if (site == null) {
            this.currentSite = null;
            this.switchView("");
            this.resetScanState();
            return;
        }
        if (Control.Mode.safe.equals((Object)this.mode)) {
            return;
        }
        if (forceRefresh || !site.equals(this.currentSite)) {
            if (!this.isSiteAdded(site)) {
                return;
            }
            ScanTarget scanTarget = this.getScanTarget(site);
            this.siteModel.setSelectedItem(scanTarget);
            GenericScanner scanThread = this.scanMap.get(site);
            if (scanThread == null) {
                scanThread = this.newScanThread(site, this.scanParam);
                this.scanMap.put(site, scanThread);
            }
            if (scanThread.isRunning()) {
                this.getStartScanButton().setEnabled(false);
                this.getStopScanButton().setEnabled(true);
                this.getPauseScanButton().setEnabled(true);
                this.getPauseScanButton().setSelected(scanThread.isPaused());
                this.getProgressBar().setEnabled(true);
            } else {
                this.resetScanButtonsAndProgressBarStates(true);
            }
            this.getProgressBar().setValue(scanThread.getProgress());
            this.getProgressBar().setMaximum(scanThread.getMaximum());
            this.currentSite = site;
            this.switchView(this.currentSite);
        }
        if (Control.Mode.protect.equals((Object)this.mode) && !Model.getSingleton().getSession().isInScope(this.getSiteNode(this.currentSite))) {
            this.resetScanButtonsAndProgressBarStates(false);
        }
    }

    private void resetScanButtonsAndProgressBarStates(boolean allowStartScan) {
        this.getStartScanButton().setEnabled(allowStartScan);
        this.getStopScanButton().setEnabled(false);
        this.getPauseScanButton().setEnabled(false);
        this.getPauseScanButton().setSelected(false);
        this.getProgressBar().setEnabled(false);
    }

    public static String cleanSiteName(String site, boolean incPort) {
        boolean ssl = false;
        if (((String)site).toLowerCase().startsWith("https:")) {
            ssl = true;
        }
        if (((String)site).indexOf("//") >= 0) {
            site = ((String)site).substring(((String)site).indexOf("//") + 2);
        }
        if (((String)site).indexOf(" (") >= 0) {
            site = ((String)site).substring(0, ((String)site).indexOf(" ("));
        }
        if (((String)site).indexOf(":") >= 0) {
            if (!incPort) {
                site = ((String)site).substring(0, ((String)site).indexOf(":"));
            }
        } else if (incPort) {
            site = ssl ? (String)site + ":443" : (String)site + ":80";
        }
        return site;
    }

    public static String cleanSiteName(SiteNode node, boolean incPort) {
        if (node != null) {
            while (node.getParent() != null && node.getParent().getParent() != null) {
                node = node.getParent();
            }
            return ScanPanel.cleanSiteName(node.getNodeName(), incPort);
        }
        return null;
    }

    protected SiteNode getSiteNode(String siteName) {
        SiteMap siteTree = this.getExtension().getModel().getSession().getSiteTree();
        SiteNode rootNode = siteTree.getRoot();
        Enumeration<TreeNode> en = rootNode.children();
        while (en.hasMoreElements()) {
            SiteNode sn = (SiteNode)en.nextElement();
            Object nodeName = sn.getNodeName();
            if (((String)nodeName).toLowerCase().startsWith("https:") && !ScanPanel.hasPort((String)nodeName)) {
                nodeName = (String)nodeName + ":443";
            }
            if (((String)nodeName).toLowerCase().startsWith("http:") && !ScanPanel.hasPort((String)nodeName)) {
                nodeName = (String)nodeName + ":80";
            }
            if (((String)nodeName).indexOf("//") >= 0) {
                nodeName = ((String)nodeName).substring(((String)nodeName).indexOf("//") + 2);
            }
            if (!siteName.equals(nodeName)) continue;
            return sn;
        }
        return null;
    }

    private static boolean hasPort(String nodeName) {
        return nodeName.lastIndexOf(":") != nodeName.indexOf(":");
    }

    public void nodeSelected(SiteNode node, boolean incPort) {
        String site = ScanPanel.cleanSiteName(node, incPort);
        if (!this.isSiteAdded(site)) {
            this.addSite(site);
        }
        this.siteSelected(site);
    }

    protected abstract GenericScanner newScanThread(String var1, AbstractParam var2);

    protected void startScan() {
        this.startScan(null, false, true, null, null);
    }

    protected void startSan(SiteNode startNode, boolean justScanInScope, boolean scanChildren, Context scanContext) {
        this.startScan(startNode, justScanInScope, scanChildren, scanContext, null);
    }

    protected void startScan(SiteNode startNode, boolean justScanInScope, boolean scanChildren, Context scanContext, User scanUser) {
        this.startScan(startNode, justScanInScope, scanChildren, scanContext, scanUser, null);
    }

    protected void handleContextSpecificObject(GenericScanner scanThread, Object[] contextSpecificObjects) {
    }

    protected void startScan(SiteNode startNode, boolean justScanInScope, boolean scanChildren, Context scanContext, User scanUser, Object[] contextSpecificObjects) {
        log.debug("startScan {} {}", (Object)this.prefix, (Object)startNode);
        this.getStartScanButton().setEnabled(false);
        this.getStopScanButton().setEnabled(true);
        this.getPauseScanButton().setEnabled(true);
        this.activeScans.add(this.currentSite);
        GenericScanner scanThread = this.scanMap.get(this.currentSite);
        if (scanThread.isStopped()) {
            scanThread.reset();
            scanThread = this.newScanThread(this.currentSite, this.scanParam);
            this.scanMap.put(this.currentSite, scanThread);
        }
        if (justScanInScope) {
            scanThread.setStartNode(null);
            scanThread.setJustScanInScope(true);
            scanThread.setScanContext(scanContext);
        } else {
            scanThread.setJustScanInScope(false);
            scanThread.setScanContext(null);
            if (scanThread.getStartNode() == null) {
                scanThread.setStartNode(startNode);
            }
        }
        scanThread.setScanAsUser(scanUser);
        if (scanContext != null) {
            scanThread.setTechSet(scanContext.getTechSet());
        }
        scanThread.setScanChildren(scanChildren);
        if (contextSpecificObjects != null) {
            this.handleContextSpecificObject(scanThread, contextSpecificObjects);
        }
        scanThread.start();
        this.scanMap.put(this.currentSite, scanThread);
        this.setActiveScanLabels();
        this.getProgressBar().setEnabled(true);
        this.getProgressBar().setMaximum(scanThread.getMaximum());
        ScanTarget scanTarget = this.getScanTarget(this.currentSite);
        if (scanTarget != null) {
            scanTarget.setScanned(true);
            this.siteModel.setSelectedItem(scanTarget);
            this.siteModel.elementChanged(scanTarget);
        }
        this.switchView(this.currentSite);
    }

    public void stopScan(String site) {
        log.debug("stopScan {} on {}", (Object)this.prefix, (Object)site);
        GenericScanner scan = this.scanMap.get(site);
        if (scan != null) {
            scan.stopScan();
        }
    }

    public void pauseScan(String site) {
        log.debug("pauseScan {} on  {}", (Object)this.prefix, (Object)site);
        GenericScanner scan = this.scanMap.get(site);
        if (scan != null) {
            if (scan.isPaused()) {
                scan.resumeScan();
            } else {
                scan.pauseScan();
            }
        }
    }

    public void scanFinshed(final String host) {
        if (EventQueue.isDispatchThread()) {
            this.scanFinshedEventHandler(host);
        } else {
            try {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ScanPanel.this.scanFinshedEventHandler(host);
                    }
                });
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void scanFinshedEventHandler(String host) {
        log.debug("scanFinished {} on {}", (Object)this.prefix, (Object)this.currentSite);
        if (host != null && host.equals(this.currentSite)) {
            this.resetScanButtonsAndProgressBarStates(true);
        }
        this.activeScans.remove(host);
        this.setActiveScanLabels();
    }

    public void scanProgress(final String host, final int progress, final int maximum) {
        if (EventQueue.isDispatchThread()) {
            this.scanProgressEventHandler(host, progress, maximum);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ScanPanel.this.scanProgressEventHandler(host, progress, maximum);
                    }
                });
            }
            catch (InterruptedException e) {
                log.info("Interrupt scan progress update on GUI.");
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void scanProgressEventHandler(String host, int progress, int maximum) {
        if (host.equals(this.currentSite)) {
            this.getProgressBar().setValue(progress);
            this.getProgressBar().setMaximum(maximum);
        }
    }

    public void reset() {
        log.debug("reset {}", (Object)this.prefix);
        this.stopAllScans();
        this.resetSiteSelect();
    }

    private void resetSiteSelect() {
        this.siteModel.removeAllElements();
        this.siteSelect.addItem(new ScanTarget(Constant.messages.getString(this.prefix + ".toolbar.site.select"), false));
        this.siteSelect.setSelectedIndex(0);
    }

    private void stopAllScans() {
        for (GenericScanner scanner : this.scanMap.values()) {
            scanner.stopScan();
            scanner.reset();
        }
        for (int i = 0; i < 20 && !this.activeScans.isEmpty(); ++i) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.scanMap.clear();
        this.activeScans.clear();
        this.setActiveScanLabels();
        this.resetScanState();
    }

    private void resetScanState() {
        this.resetScanButtonsAndProgressBarStates(false);
        this.getProgressBar().setValue(0);
    }

    public ExtensionAdaptor getExtension() {
        return this.extension;
    }

    public AbstractParam getScanParam() {
        return this.scanParam;
    }

    public GenericScanner getScanThread(String site) {
        return this.scanMap.get(site);
    }

    public Map<String, GenericScanner> getScanThreads() {
        return this.scanMap;
    }

    public boolean isCurrentSite(String site) {
        return this.currentSite != null && this.currentSite.equals(site);
    }

    public void sessionScopeChanged(Session session) {
        if (this.currentSite != null) {
            this.siteSelected(this.currentSite, true);
        }
    }

    public void sessionModeChanged(Control.Mode mode) {
        this.mode = mode;
        switch (mode) {
            case attack: 
            case standard: 
            case protect: {
                this.getSiteSelect().setEnabled(true);
                if (this.currentSite == null) break;
                this.siteSelected(this.currentSite, true);
                break;
            }
            case safe: {
                this.stopAllScans();
                this.getSiteSelect().setEnabled(false);
            }
        }
    }

    protected String getCurrentSite() {
        return this.currentSite;
    }

    protected void unload() {
        if (View.isInitialised()) {
            View.getSingleton().getMainFrame().getMainFooterPanel().removeFooterToolbarRightLabel(this.scanStatus.getCountLabel());
        }
    }

    protected abstract Component getWorkPanel();

    protected abstract void switchView(String var1);

    private static class ScanTarget
    implements Comparable<ScanTarget> {
        private final String site;
        private final boolean canScan;
        private boolean scanned;

        ScanTarget(String site) {
            this(site, true);
        }

        ScanTarget(String site, boolean canScan) {
            this.site = site;
            this.canScan = canScan;
        }

        String getSite() {
            return this.site;
        }

        boolean isScanned() {
            return this.scanned;
        }

        void setScanned(boolean scanned) {
            this.scanned = this.canScan && scanned;
        }

        @Override
        public int compareTo(ScanTarget o) {
            if (this.canScan) {
                return this.site.compareTo(o.site);
            }
            return -1;
        }

        public String toString() {
            return this.site;
        }
    }

    protected static enum Location {
        start,
        beforeSites,
        beforeButtons,
        beforeProgressBar,
        afterProgressBar;

    }
}

