/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractDialog;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.help.ExtensionHelp;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.Target;
import org.zaproxy.zap.utils.ZapLabel;
import org.zaproxy.zap.utils.ZapNumberSpinner;
import org.zaproxy.zap.utils.ZapTextArea;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.NodeSelectDialog;
import org.zaproxy.zap.view.widgets.ContextSelectComboBox;

public abstract class StandardFieldsDialog
extends AbstractDialog {
    private static final Logger logger = LogManager.getLogger(StandardFieldsDialog.class);
    private static final long serialVersionUID = 1L;
    private static final EmptyBorder FULL_BORDER = new EmptyBorder(8, 8, 8, 8);
    private static final EmptyBorder TOP_BOTTOM_BORDER = new EmptyBorder(8, 0, 8, 0);
    private static JPopupMenu mainPopupMenu;
    private JPanel mainPanel = null;
    private List<JPanel> tabPanels = null;
    private List<Integer> tabOffsets = null;
    private JTabbedPane tabbedPane = null;
    private Map<JPanel, JScrollPane> panelToScrollPaneMap;
    private double labelWeight = 0.0;
    private double fieldWeight = 1.0;
    private JButton helpButton = null;
    private JButton cancelButton = null;
    private JButton saveButton = null;
    private List<Component> fieldList = new ArrayList<Component>();
    private Map<String, Component> fieldMap = new HashMap<String, Component>();
    private Map<String, JPanel> tabNameMap = new HashMap<String, JPanel>();
    private boolean hideOnSave;

    public StandardFieldsDialog(Frame owner, String titleLabel, Dimension dim) {
        this((Window)owner, titleLabel, dim);
    }

    public StandardFieldsDialog(Window owner, String titleLabel, Dimension dim, boolean modal) {
        this(owner, titleLabel, dim, null, modal);
    }

    public StandardFieldsDialog(Window owner, String titleLabel, Dimension dim) {
        this(owner, titleLabel, dim, null);
    }

    public StandardFieldsDialog(Frame owner, String titleLabel, Dimension dim, String[] tabLabels) {
        this((Window)owner, titleLabel, dim, tabLabels);
    }

    public StandardFieldsDialog(Window owner, String titleLabel, Dimension dim, String[] tabLabels) {
        this(owner, titleLabel, dim, tabLabels, false);
    }

    public StandardFieldsDialog(Window owner, String titleLabel, Dimension dim, String[] tabLabels, boolean modal) {
        super(owner, modal);
        if (modal) {
            this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        }
        this.setDefaultCloseOperation(0);
        this.setTitle(Constant.messages.getString(titleLabel));
        this.initialize(dim, tabLabels);
        this.hideOnSave = true;
    }

    protected boolean isHideOnSave() {
        return this.hideOnSave;
    }

    protected void setHideOnSave(boolean hideOnSave) {
        this.hideOnSave = hideOnSave;
    }

    private boolean isTabbed() {
        return this.tabPanels != null;
    }

    private void initialize(Dimension dim, String[] tabLabels) {
        this.setLayout(new GridBagLayout());
        this.setSize(dim);
        if (tabLabels == null) {
            this.initializeSinglePane(dim);
        } else {
            this.initializeTabbed(dim, tabLabels);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                StandardFieldsDialog.this.handleCloseAction();
            }
        });
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                StandardFieldsDialog.this.handleCloseAction();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
    }

    private void handleCloseAction() {
        if (this.hasCancelSaveButtons()) {
            this.cancelPressed();
            return;
        }
        this.savePressed();
    }

    public void setXWeights(double labelWeight, double fieldWeight) {
        this.labelWeight = labelWeight;
        this.fieldWeight = fieldWeight;
    }

    private void initializeTabbed(Dimension dim, String[] tabLabels) {
        this.tabPanels = new ArrayList<JPanel>();
        this.tabOffsets = new ArrayList<Integer>();
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new GridBagLayout());
        contentPanel.setBorder(TOP_BOTTOM_BORDER);
        contentPanel.setPreferredSize(dim);
        this.setContentPane(contentPanel);
        this.tabbedPane = new JTabbedPane();
        this.panelToScrollPaneMap = new HashMap<JPanel, JScrollPane>();
        this.initContentPanel(contentPanel, this.tabbedPane, this.getExtraButtons(), this.getHelpIndex());
        for (String label : tabLabels) {
            JPanel tabPanel = new JPanel();
            tabPanel.setLayout(new GridBagLayout());
            tabPanel.setBorder(FULL_BORDER);
            this.tabbedPane.addTab(Constant.messages.getString(label), tabPanel);
            this.tabNameMap.put(label, tabPanel);
            this.tabPanels.add(tabPanel);
            this.tabOffsets.add(0);
        }
    }

    private void initContentPanel(JPanel contentPanel, JComponent component, JButton[] extraButtons, String helpIndex) {
        if (extraButtons == null) {
            contentPanel.add((Component)component, LayoutHelper.getGBC(0, 0, 4, 1.0, 1.0));
            if (helpIndex != null) {
                contentPanel.add((Component)this.getHelpButton(helpIndex), LayoutHelper.getGBC(0, 1, 1, 0.0));
            }
            contentPanel.add((Component)new JLabel(), LayoutHelper.getGBC(1, 1, 1, 1.0));
            contentPanel.add((Component)this.getSaveButton(), LayoutHelper.getGBC(2, 1, 1, 0.0));
            if (this.hasCancelSaveButtons()) {
                contentPanel.add((Component)this.getCancelButton(), LayoutHelper.getGBC(3, 1, 1, 0.0));
            }
        } else {
            contentPanel.add((Component)component, LayoutHelper.getGBC(0, 0, 4 + extraButtons.length, 1.0, 1.0));
            if (helpIndex != null) {
                contentPanel.add((Component)this.getHelpButton(helpIndex), LayoutHelper.getGBC(0, 1, 1, 0.0));
            }
            contentPanel.add((Component)new JLabel(), LayoutHelper.getGBC(1, 1, 1, 1.0));
            contentPanel.add((Component)this.getSaveButton(), LayoutHelper.getGBC(2, 1, 1, 0.0));
            int x = 3;
            for (JButton button : extraButtons) {
                contentPanel.add((Component)button, LayoutHelper.getGBC(x, 1, 1, 0.0));
                ++x;
            }
            if (this.hasCancelSaveButtons()) {
                contentPanel.add((Component)this.getCancelButton(), LayoutHelper.getGBC(x, 1, 1, 0.0));
            }
        }
    }

    public boolean hasCancelSaveButtons() {
        return true;
    }

    public String getHelpIndex() {
        return null;
    }

    private void initializeSinglePane(Dimension dim) {
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new GridBagLayout());
        contentPanel.setBorder(FULL_BORDER);
        contentPanel.setPreferredSize(dim);
        this.setContentPane(contentPanel);
        this.initContentPanel(contentPanel, this.getMainPanel(), this.getExtraButtons(), this.getHelpIndex());
    }

    public String getSaveButtonText() {
        if (this.hasCancelSaveButtons()) {
            return Constant.messages.getString("all.button.save");
        }
        return Constant.messages.getString("all.button.close");
    }

    public JButton[] getExtraButtons() {
        return null;
    }

    private JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton();
            this.saveButton.setText(this.getSaveButtonText());
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StandardFieldsDialog.this.savePressed();
                }
            });
        }
        return this.saveButton;
    }

    private void savePressed() {
        if (!this.validateFieldsCustomMessage()) {
            return;
        }
        String errorMsg = this.validateFields();
        if (errorMsg != null) {
            View.getSingleton().showWarningDialog((Window)this, errorMsg);
            return;
        }
        this.save();
        if (this.isHideOnSave()) {
            this.setVisible(false);
        }
    }

    protected boolean validateFieldsCustomMessage() {
        return true;
    }

    public String getCancelButtonText() {
        return Constant.messages.getString("all.button.cancel");
    }

    public void cancelPressed() {
        this.setVisible(false);
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText(this.getCancelButtonText());
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StandardFieldsDialog.this.cancelPressed();
                }
            });
        }
        return this.cancelButton;
    }

    private JButton getHelpButton(final String helpIndex) {
        if (this.helpButton == null) {
            this.helpButton = new JButton();
            this.helpButton.setIcon(ExtensionHelp.getHelpIcon());
            this.helpButton.setToolTipText(Constant.messages.getString("help.dialog.button.tooltip"));
            this.helpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExtensionHelp.showHelp(helpIndex);
                }
            });
        }
        return this.helpButton;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
        }
        return this.mainPanel;
    }

    private void addPadding(JPanel panel, int indexy) {
        panel.add((Component)new JLabel(""), LayoutHelper.getGBC(0, indexy, 1, 0.0, 1.0, 1, new Insets(4, 4, 4, 4)));
    }

    public void addPadding() {
        this.validateNotTabbed();
        this.addPadding(this.getMainPanel(), this.fieldList.size());
    }

    private void validateNotTabbed() {
        if (this.isTabbed()) {
            throw new IllegalArgumentException("Initialised as a tabbed dialog - must use method with tab parameters");
        }
    }

    private void incTabOffset(int tabIndex) {
        this.tabOffsets.set(tabIndex, this.tabOffsets.get(tabIndex) + 1);
    }

    public void addPadding(int tabIndex) {
        this.validateTabbed(tabIndex);
        this.addPadding(this.tabPanels.get(tabIndex), this.tabOffsets.get(tabIndex));
        this.incTabOffset(tabIndex);
    }

    private void validateTabbed(int tabIndex) {
        if (!this.isTabbed()) {
            throw new IllegalArgumentException("Not initialised as a tabbed dialog - must use method without tab parameters");
        }
        if (tabIndex < 0 || tabIndex >= this.tabPanels.size()) {
            throw new IllegalArgumentException("Invalid tab index: " + tabIndex);
        }
    }

    private void addField(JPanel panel, int indexy, String fieldLabel, Component field, Component wrapper, double weighty) {
        if (this.fieldList.contains(field)) {
            throw new IllegalArgumentException("Field already added: " + field);
        }
        JLabel label = new JLabel(Constant.messages.getString(fieldLabel));
        label.setLabelFor(field);
        label.setVerticalAlignment(1);
        panel.add((Component)label, LayoutHelper.getGBC(0, indexy, 1, this.labelWeight, weighty, 1, new Insets(4, 4, 4, 4)));
        panel.add(wrapper, LayoutHelper.getGBC(1, indexy, 1, this.fieldWeight, weighty, 1, new Insets(4, 4, 4, 4)));
        this.fieldList.add(field);
        this.fieldMap.put(fieldLabel, field);
        if (indexy == 0 && panel.equals(this.getMainPanel())) {
            field.requestFocusInWindow();
        }
    }

    private void addField(String fieldLabel, Component field, Component wrapper, double weighty) {
        this.validateNotTabbed();
        this.addField(this.getMainPanel(), this.fieldList.size(), fieldLabel, field, wrapper, weighty);
    }

    public void addTextField(String fieldLabel, String value) {
        this.addTextComponent(new ZapTextField(), fieldLabel, value);
    }

    private void addTextComponent(JTextComponent field, String fieldLabel, String value) {
        this.validateNotTabbed();
        StandardFieldsDialog.setTextAndDiscardEdits(field, value);
        this.addField(fieldLabel, field, field, 0.0);
    }

    public void addTextField(int tabIndex, String fieldLabel, String value) {
        this.addTextComponent(tabIndex, new ZapTextField(), fieldLabel, value);
    }

    private void addTextComponent(int tabIndex, JTextComponent field, String fieldLabel, String value) {
        this.validateTabbed(tabIndex);
        StandardFieldsDialog.setTextAndDiscardEdits(field, value);
        this.addField(this.tabPanels.get(tabIndex), this.tabOffsets.get(tabIndex), fieldLabel, field, field, 0.0);
        this.incTabOffset(tabIndex);
    }

    private static void setTextAndDiscardEdits(JTextComponent field, String value) {
        if (value == null) {
            return;
        }
        field.setText(value);
        if (field instanceof ZapTextField) {
            ((ZapTextField)field).discardAllEdits();
        } else if (field instanceof ZapTextArea) {
            ((ZapTextArea)field).discardAllEdits();
        }
    }

    public void addTextFieldReadOnly(String fieldLabel, String value) {
        this.addTextComponent(new ZapLabel(), fieldLabel, value);
    }

    public void addTextFieldReadOnly(int tabIndex, String fieldLabel, String value) {
        this.addTextComponent(tabIndex, new ZapLabel(), fieldLabel, value);
    }

    public void addPasswordField(String fieldLabel, String value) {
        this.addTextComponent(new JPasswordField(), fieldLabel, value);
    }

    public void addPasswordField(int tabIndex, String fieldLabel, String value) {
        this.addTextComponent(tabIndex, new JPasswordField(), fieldLabel, value);
    }

    public void addMultilineField(String fieldLabel, String value) {
        this.validateNotTabbed();
        ZapTextArea field = new ZapTextArea();
        field.setLineWrap(true);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setViewportView(field);
        StandardFieldsDialog.setTextAndDiscardEdits(field, value);
        this.addField(fieldLabel, field, scrollPane, 1.0);
    }

    public void addMultilineField(int tabIndex, String fieldLabel, String value) {
        this.validateTabbed(tabIndex);
        ZapTextArea field = new ZapTextArea();
        field.setLineWrap(true);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setViewportView(field);
        StandardFieldsDialog.setTextAndDiscardEdits(field, value);
        this.addField(this.tabPanels.get(tabIndex), this.tabOffsets.get(tabIndex), fieldLabel, field, scrollPane, 1.0);
        this.incTabOffset(tabIndex);
    }

    public void addComboField(String fieldLabel, String[] choices, String value) {
        this.addComboField(fieldLabel, choices, value, false);
    }

    public void addComboField(String fieldLabel, String[] choices, String value, boolean editable) {
        this.validateNotTabbed();
        JComboBox<String> field = new JComboBox<String>();
        field.setEditable(editable);
        for (String label : choices) {
            field.addItem(label);
        }
        if (value != null) {
            field.setSelectedItem(value);
        }
        this.addField(fieldLabel, field, field, 0.0);
    }

    public void addComboField(String fieldLabel, List<String> choices, String value) {
        this.addComboField(fieldLabel, choices, value, false);
    }

    public void addComboField(String fieldLabel, List<String> choices, String value, boolean editable) {
        this.validateNotTabbed();
        JComboBox<String> field = new JComboBox<String>();
        field.setEditable(editable);
        for (String label : choices) {
            field.addItem(label);
        }
        if (value != null) {
            field.setSelectedItem(value);
        }
        this.addField(fieldLabel, field, field, 0.0);
    }

    public void addComboField(int tabIndex, String fieldLabel, String[] choices, String value) {
        this.addComboField(tabIndex, fieldLabel, choices, value, false);
    }

    public void addComboField(int tabIndex, String fieldLabel, String[] choices, String value, boolean editable) {
        this.validateTabbed(tabIndex);
        JComboBox<String> field = new JComboBox<String>();
        field.setEditable(editable);
        for (String label : choices) {
            field.addItem(label);
        }
        if (value != null) {
            field.setSelectedItem(value);
        }
        this.addField(this.tabPanels.get(tabIndex), this.tabOffsets.get(tabIndex), fieldLabel, field, field, 0.0);
        this.incTabOffset(tabIndex);
    }

    public void addComboField(int tabIndex, String fieldLabel, List<String> choices, String value) {
        this.addComboField(tabIndex, fieldLabel, choices, value, false);
    }

    public void addComboField(int tabIndex, String fieldLabel, List<String> choices, String value, boolean editable) {
        this.validateTabbed(tabIndex);
        JComboBox<String> field = new JComboBox<String>();
        field.setEditable(editable);
        for (String label : choices) {
            field.addItem(label);
        }
        if (value != null) {
            field.setSelectedItem(value);
        }
        this.addField(this.tabPanels.get(tabIndex), this.tabOffsets.get(tabIndex), fieldLabel, field, field, 0.0);
        this.incTabOffset(tabIndex);
    }

    public void addComboField(String fieldLabel, int[] choices, int value) {
        this.validateNotTabbed();
        JComboBox<Integer> field = new JComboBox<Integer>();
        for (int label : choices) {
            field.addItem(label);
        }
        if (value >= 0) {
            field.setSelectedItem(value);
        }
        this.addField(fieldLabel, field, field, 0.0);
    }

    public <E> void addComboField(int tabIndex, String fieldLabel, ComboBoxModel<E> comboBoxModel) {
        this.addComboField(tabIndex, fieldLabel, comboBoxModel, false);
    }

    public <E> void addComboField(int tabIndex, String fieldLabel, ComboBoxModel<E> comboBoxModel, boolean editable) {
        this.validateTabbed(tabIndex);
        JComboBox<E> field = new JComboBox<E>(comboBoxModel);
        field.setEditable(editable);
        this.addField(this.tabPanels.get(tabIndex), this.tabOffsets.get(tabIndex), fieldLabel, field, field, 0.0);
        this.incTabOffset(tabIndex);
    }

    public <E> void addComboField(String fieldLabel, ComboBoxModel<E> comboBoxModel) {
        this.addComboField(fieldLabel, comboBoxModel, false);
    }

    public <E> void addComboField(String fieldLabel, ComboBoxModel<E> comboBoxModel, boolean editable) {
        this.validateNotTabbed();
        JComboBox<E> field = new JComboBox<E>(comboBoxModel);
        field.setEditable(editable);
        this.addField(fieldLabel, field, field, 0.0);
    }

    public void addTableField(String fieldLabel, JTable field) {
        this.addTableField(fieldLabel, field, null);
    }

    public void addTableField(JTable field, List<JButton> buttons) {
        this.addTableField(null, field, buttons);
    }

    public void addTableField(String fieldLabel, JTable field, List<JButton> buttons) {
        this.validateNotTabbed();
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setViewportView(field);
        field.setFillsViewportHeight(true);
        if (this.fieldList.contains(field)) {
            throw new IllegalArgumentException("Field already added: " + field);
        }
        if (buttons == null || buttons.isEmpty()) {
            if (fieldLabel == null) {
                this.getMainPanel().add((Component)scrollPane, LayoutHelper.getGBC(1, this.fieldList.size(), 1, this.fieldWeight, 1.0, 1, new Insets(4, 4, 4, 4)));
            } else {
                this.addField(fieldLabel, field, scrollPane, 1.0);
            }
        } else {
            JPanel tablePanel = new JPanel();
            tablePanel.setLayout(new GridBagLayout());
            tablePanel.add((Component)scrollPane, LayoutHelper.getGBC(0, 0, 1, 1.0, 1.0, 1, new Insets(4, 4, 4, 4)));
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new GridBagLayout());
            int buttonId = 0;
            for (JButton button : buttons) {
                buttonPanel.add((Component)button, LayoutHelper.getGBC(0, buttonId++, 1, 0.0, 0.0, 1, new Insets(2, 2, 2, 2)));
            }
            buttonPanel.add((Component)new JLabel(), LayoutHelper.getGBC(0, buttonId++, 1, 0.0, 1.0, 1, new Insets(2, 2, 2, 2)));
            tablePanel.add((Component)buttonPanel, LayoutHelper.getGBC(1, 0, 1, 0.0, 0.0, 1, new Insets(2, 2, 2, 2)));
            if (fieldLabel == null) {
                this.getMainPanel().add((Component)tablePanel, LayoutHelper.getGBC(1, this.fieldList.size(), 1, this.fieldWeight, 1.0, 1, new Insets(4, 4, 4, 4)));
            } else {
                this.addField(fieldLabel, field, tablePanel, 1.0);
            }
        }
        this.fieldList.add(field);
    }

    public void addTableField(int tabIndex, JTable field) {
        this.addTableField(tabIndex, field, null);
    }

    public void addTableField(int tabIndex, JTable field, List<JButton> buttons) {
        this.validateTabbed(tabIndex);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setViewportView(field);
        field.setFillsViewportHeight(true);
        if (this.fieldList.contains(field)) {
            throw new IllegalArgumentException("Field already added: " + field);
        }
        if (buttons == null || buttons.isEmpty()) {
            this.tabPanels.get(tabIndex).add((Component)scrollPane, LayoutHelper.getGBC(1, this.tabOffsets.get(tabIndex), 1, 1.0, 1.0, 1, new Insets(4, 4, 4, 4)));
        } else {
            JPanel tablePanel = new JPanel();
            tablePanel.setLayout(new GridBagLayout());
            tablePanel.add((Component)scrollPane, LayoutHelper.getGBC(0, 0, 1, 1.0, 1.0, 1, new Insets(4, 4, 4, 4)));
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new GridBagLayout());
            int buttonId = 0;
            for (JButton button : buttons) {
                buttonPanel.add((Component)button, LayoutHelper.getGBC(0, buttonId++, 1, 0.0, 0.0, 1, new Insets(2, 2, 2, 2)));
            }
            buttonPanel.add((Component)new JLabel(), LayoutHelper.getGBC(0, buttonId++, 1, 0.0, 1.0, 1, new Insets(2, 2, 2, 2)));
            tablePanel.add((Component)buttonPanel, LayoutHelper.getGBC(1, 0, 1, 0.0, 0.0, 1, new Insets(2, 2, 2, 2)));
            this.tabPanels.get(tabIndex).add((Component)tablePanel, LayoutHelper.getGBC(1, this.tabOffsets.get(tabIndex), 1, 1.0, 1.0, 1, new Insets(4, 4, 4, 4)));
        }
        this.fieldList.add(field);
        this.incTabOffset(tabIndex);
    }

    public void setComboFields(String fieldLabel, String[] choices, String value) {
        Component c = this.fieldMap.get(fieldLabel);
        if (c instanceof JComboBox) {
            JComboBox comboBox = (JComboBox)c;
            comboBox.removeAllItems();
            for (String str : choices) {
                comboBox.addItem(str);
            }
            if (value != null) {
                comboBox.setSelectedItem(value);
            }
        } else if (c == null) {
            logger.debug("No field for {}", (Object)fieldLabel);
        } else {
            StandardFieldsDialog.handleUnexpectedFieldClass(fieldLabel, c);
        }
    }

    private static void handleUnexpectedFieldClass(String fieldLabel, Component component) {
        logger.error("Unexpected field class {}: {}\n\t{}", (Object)fieldLabel, (Object)component.getClass().getCanonicalName(), (Object)StringUtils.join((Object[])Thread.currentThread().getStackTrace(), (String)"\n\t"));
    }

    public void setComboFields(String fieldLabel, List<String> choices, String value) {
        Component c = this.fieldMap.get(fieldLabel);
        if (c instanceof JComboBox) {
            JComboBox comboBox = (JComboBox)c;
            comboBox.removeAllItems();
            for (String str : choices) {
                comboBox.addItem(str);
            }
            if (value != null) {
                comboBox.setSelectedItem(value);
            }
        } else if (c == null) {
            logger.debug("No field for {}", (Object)fieldLabel);
        } else {
            StandardFieldsDialog.handleUnexpectedFieldClass(fieldLabel, c);
        }
    }

    public <E> void setComboBoxModel(String fieldLabel, ComboBoxModel<E> comboBoxModel) {
        Component c = this.fieldMap.get(fieldLabel);
        if (c instanceof JComboBox) {
            JComboBox comboBox = (JComboBox)c;
            comboBox.setModel(comboBoxModel);
        } else if (c == null) {
            logger.debug("No field for {}", (Object)fieldLabel);
        } else {
            StandardFieldsDialog.handleUnexpectedFieldClass(fieldLabel, c);
        }
    }

    public void addNumberField(String fieldLabel, Integer min, Integer max, int value) {
        this.validateNotTabbed();
        ZapNumberSpinner field = new ZapNumberSpinner(min, value, max);
        this.addField(fieldLabel, field, field, 0.0);
    }

    public void addNumberField(int tabIndex, String fieldLabel, Integer min, Integer max, int value) {
        this.validateTabbed(tabIndex);
        ZapNumberSpinner field = new ZapNumberSpinner(min, value, max);
        this.addField(this.tabPanels.get(tabIndex), this.tabOffsets.get(tabIndex), fieldLabel, field, field, 0.0);
        this.incTabOffset(tabIndex);
    }

    public void addCheckBoxField(String fieldLabel, boolean value) {
        this.validateNotTabbed();
        JCheckBox field = new JCheckBox();
        field.setSelected(value);
        this.addField(fieldLabel, field, field, 0.0);
    }

    public void addCheckBoxField(int tabIndex, String fieldLabel, boolean value) {
        this.validateTabbed(tabIndex);
        JCheckBox field = new JCheckBox();
        field.setSelected(value);
        this.addField(this.tabPanels.get(tabIndex), this.tabOffsets.get(tabIndex), fieldLabel, field, field, 0.0);
        this.incTabOffset(tabIndex);
    }

    public void addNodeSelectField(final String fieldLabel, final SiteNode value, boolean editable, final boolean allowRoot) {
        this.validateNotTabbed();
        final ZapTextField text = new ZapTextField();
        text.setEditable(editable);
        if (value != null) {
            text.setText(StandardFieldsDialog.getNodeText(value));
        }
        JButton selectButton = new JButton(Constant.messages.getString("all.button.select"));
        selectButton.setIcon(new ImageIcon(View.class.getResource("/resource/icon/16/094.png")));
        selectButton.addActionListener(new ActionListener(){
            SiteNode node;
            {
                this.node = value;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeSelectDialog nsd = new NodeSelectDialog((Window)StandardFieldsDialog.this);
                nsd.setAllowRoot(allowRoot);
                SiteNode node = nsd.showDialog(this.node);
                if (node != null) {
                    text.setText(StandardFieldsDialog.getNodeText(node));
                    this.node = node;
                    StandardFieldsDialog.this.siteNodeSelected(fieldLabel, node);
                }
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)text, LayoutHelper.getGBC(0, 0, 1, 1.0, 0.0, 1, new Insets(4, 4, 4, 4)));
        panel.add((Component)selectButton, LayoutHelper.getGBC(1, 0, 1, 0.0, 0.0, 1, new Insets(4, 4, 4, 4)));
        this.addField(fieldLabel, text, panel, 0.0);
    }

    public void addNodeSelectField(int tabIndex, final String fieldLabel, final SiteNode value, boolean editable, final boolean allowRoot) {
        this.validateTabbed(tabIndex);
        final ZapTextField text = new ZapTextField();
        text.setEditable(editable);
        if (value != null) {
            text.setText(StandardFieldsDialog.getNodeText(value));
        }
        JButton selectButton = new JButton(Constant.messages.getString("all.button.select"));
        selectButton.setIcon(new ImageIcon(View.class.getResource("/resource/icon/16/094.png")));
        selectButton.addActionListener(new ActionListener(){
            SiteNode node;
            {
                this.node = value;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeSelectDialog nsd = new NodeSelectDialog((Window)StandardFieldsDialog.this);
                nsd.setAllowRoot(allowRoot);
                SiteNode node = nsd.showDialog(this.node);
                if (node != null) {
                    text.setText(StandardFieldsDialog.getNodeText(node));
                    this.node = node;
                    StandardFieldsDialog.this.siteNodeSelected(fieldLabel, node);
                }
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)text, LayoutHelper.getGBC(0, 0, 1, 1.0, 0.0, 1, new Insets(4, 4, 4, 4)));
        panel.add((Component)selectButton, LayoutHelper.getGBC(1, 0, 1, 0.0, 0.0, 1, new Insets(4, 4, 4, 4)));
        this.addField(this.tabPanels.get(tabIndex), this.tabOffsets.get(tabIndex), fieldLabel, text, panel, 0.0);
        this.incTabOffset(tabIndex);
    }

    public void addTargetSelectField(final String fieldLabel, final Target value, boolean editable, final boolean allowRoot) {
        this.validateNotTabbed();
        final ZapTextField text = new ZapTextField();
        text.setEditable(editable);
        this.setTextTarget(text, value);
        JButton selectButton = new JButton(Constant.messages.getString("all.button.select"));
        selectButton.setIcon(new ImageIcon(View.class.getResource("/resource/icon/16/094.png")));
        selectButton.addActionListener(new ActionListener(){
            Target target;
            {
                this.target = value;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeSelectDialog nsd = new NodeSelectDialog((Window)StandardFieldsDialog.this);
                nsd.setAllowRoot(allowRoot);
                this.target = nsd.showDialog(this.target);
                StandardFieldsDialog.this.setTextTarget(text, this.target);
                StandardFieldsDialog.this.targetSelected(fieldLabel, this.target);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)text, LayoutHelper.getGBC(0, 0, 1, 1.0, 0.0, 1, new Insets(4, 4, 4, 4)));
        panel.add((Component)selectButton, LayoutHelper.getGBC(1, 0, 1, 0.0, 0.0, 1, new Insets(4, 4, 4, 4)));
        this.addField(fieldLabel, text, panel, 0.0);
    }

    public void addTargetSelectField(int tabIndex, final String fieldLabel, final Target value, boolean editable, final boolean allowRoot) {
        this.validateTabbed(tabIndex);
        final ZapTextField text = new ZapTextField();
        text.setEditable(editable);
        this.setTextTarget(text, value);
        JButton selectButton = new JButton(Constant.messages.getString("all.button.select"));
        selectButton.setIcon(new ImageIcon(View.class.getResource("/resource/icon/16/094.png")));
        selectButton.addActionListener(new ActionListener(){
            Target target;
            {
                this.target = value;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeSelectDialog nsd = new NodeSelectDialog((Window)StandardFieldsDialog.this);
                nsd.setAllowRoot(allowRoot);
                this.target = nsd.showDialog(this.target);
                StandardFieldsDialog.this.setTextTarget(text, this.target);
                StandardFieldsDialog.this.targetSelected(fieldLabel, this.target);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)text, LayoutHelper.getGBC(0, 0, 1, 1.0, 0.0, 1, new Insets(4, 4, 4, 4)));
        panel.add((Component)selectButton, LayoutHelper.getGBC(1, 0, 1, 0.0, 0.0, 1, new Insets(4, 4, 4, 4)));
        this.addField(this.tabPanels.get(tabIndex), this.tabOffsets.get(tabIndex), fieldLabel, text, panel, 0.0);
        this.incTabOffset(tabIndex);
    }

    private void setTextTarget(ZapTextField field, Target target) {
        String text = StandardFieldsDialog.getTargetText(target);
        if (text != null) {
            field.setText(text);
        }
    }

    protected static String getTargetText(Target target) {
        if (target != null) {
            if (target.getStartNode() != null) {
                return StandardFieldsDialog.getNodeText(target.getStartNode());
            }
            if (target.getContext() != null) {
                return Constant.messages.getString("context.prefixName", target.getContext().getName());
            }
            if (target.isInScopeOnly()) {
                return Constant.messages.getString("context.allInScope");
            }
        }
        return null;
    }

    private static String getNodeText(SiteNode node) {
        if (node != null && node.getHistoryReference() != null) {
            String url = node.getHistoryReference().getURI().toString();
            if (!node.isLeaf() && url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            return url;
        }
        return "";
    }

    public void addContextSelectField(String fieldLabel, Context selectedContext) {
        this.validateNotTabbed();
        ContextSelectComboBox field = new ContextSelectComboBox();
        if (selectedContext != null) {
            field.setSelectedItem(selectedContext);
        }
        this.addField(fieldLabel, field, field, 0.0);
    }

    public void addContextSelectField(int tabIndex, String fieldLabel, Context selectedContext) {
        this.validateTabbed(tabIndex);
        ContextSelectComboBox field = new ContextSelectComboBox();
        if (selectedContext != null) {
            field.setSelectedItem(selectedContext);
        }
        this.addField(this.tabPanels.get(tabIndex), this.tabOffsets.get(tabIndex), fieldLabel, field, field, 0.0);
        this.incTabOffset(tabIndex);
    }

    public void addFileSelectField(String fieldLabel, final File dir, final int mode, final FileFilter filter) {
        this.validateNotTabbed();
        final ZapTextField text = new ZapTextField();
        text.setEditable(false);
        if (dir != null) {
            text.setText(dir.getAbsolutePath());
        }
        final StandardFieldsDialog sfd = this;
        JButton selectButton = new JButton("...");
        selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rc;
                JFileChooser chooser = new JFileChooser(dir);
                chooser.setFileSelectionMode(mode);
                if (filter != null) {
                    chooser.setFileFilter(filter);
                }
                if ((rc = chooser.showSaveDialog(sfd)) == 0) {
                    File file = chooser.getSelectedFile();
                    if (file == null) {
                        return;
                    }
                    text.setText(file.getAbsolutePath());
                }
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)text, LayoutHelper.getGBC(0, 0, 1, 1.0, 0.0, 1, new Insets(4, 4, 4, 4)));
        panel.add((Component)selectButton, LayoutHelper.getGBC(1, 0, 1, 0.0, 0.0, 1, new Insets(4, 4, 4, 4)));
        this.addField(fieldLabel, text, panel, 0.0);
    }

    public void addFileSelectField(int tabIndex, String fieldLabel, final File dir, final int mode, final FileFilter filter) {
        this.validateTabbed(tabIndex);
        final ZapTextField text = new ZapTextField();
        text.setEditable(false);
        if (dir != null) {
            text.setText(dir.getAbsolutePath());
        }
        final StandardFieldsDialog sfd = this;
        JButton selectButton = new JButton("...");
        selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rc;
                JFileChooser chooser = new JFileChooser(dir);
                chooser.setFileSelectionMode(mode);
                if (filter != null) {
                    chooser.setFileFilter(filter);
                }
                if ((rc = chooser.showSaveDialog(sfd)) == 0) {
                    File file = chooser.getSelectedFile();
                    if (file == null) {
                        return;
                    }
                    text.setText(file.getAbsolutePath());
                }
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)text, LayoutHelper.getGBC(0, 0, 1, 1.0, 0.0, 1, new Insets(4, 4, 4, 4)));
        panel.add((Component)selectButton, LayoutHelper.getGBC(1, 0, 1, 0.0, 0.0, 1, new Insets(4, 4, 4, 4)));
        this.addField(this.tabPanels.get(tabIndex), this.tabOffsets.get(tabIndex), fieldLabel, text, panel, 0.0);
        this.incTabOffset(tabIndex);
    }

    public void addCustomComponent(int tabIndex, Component component) {
        this.validateTabbed(tabIndex);
        if (this.fieldList.contains(component)) {
            throw new IllegalArgumentException("Component already added: " + component);
        }
        this.tabPanels.get(tabIndex).add(component, LayoutHelper.getGBC(0, this.tabOffsets.get(tabIndex), 2, this.fieldWeight, 0.0, 1, new Insets(4, 4, 4, 4)));
        if (this.fieldList.isEmpty()) {
            component.requestFocusInWindow();
        }
        this.fieldList.add(component);
        this.incTabOffset(tabIndex);
    }

    public void addCustomComponent(Component component) {
        this.validateNotTabbed();
        if (this.fieldList.contains(component)) {
            throw new IllegalArgumentException("Component already added: " + component);
        }
        this.getMainPanel().add(component, LayoutHelper.getGBC(0, this.fieldList.size(), 2, this.fieldWeight, 0.0, 1, new Insets(4, 4, 4, 4)));
        if (this.fieldList.isEmpty()) {
            component.requestFocusInWindow();
        }
        this.fieldList.add(component);
    }

    public void addCustomComponent(int tabIndex, String componentLabel, Component component) {
        this.validateTabbed(tabIndex);
        this.addField(this.tabPanels.get(tabIndex), this.tabOffsets.get(tabIndex), componentLabel, component, component, 0.0);
        this.incTabOffset(tabIndex);
    }

    public void addCustomComponent(String componentLabel, Component component) {
        this.validateNotTabbed();
        this.addField(componentLabel, component, component, 0.0);
    }

    public void siteNodeSelected(String field, SiteNode node) {
    }

    public void targetSelected(String field, Target target) {
    }

    public Component getField(String fieldLabel) {
        return this.fieldMap.get(fieldLabel);
    }

    public String getStringValue(String fieldLabel) {
        Component c = this.fieldMap.get(fieldLabel);
        if (c != null) {
            if (c instanceof JTextComponent) {
                return ((JTextComponent)c).getText();
            }
            if (c instanceof JComboBox) {
                return (String)((JComboBox)c).getSelectedItem();
            }
            StandardFieldsDialog.handleUnexpectedFieldClass(fieldLabel, c);
        }
        return null;
    }

    public char[] getPasswordValue(String fieldLabel) {
        Component c = this.fieldMap.get(fieldLabel);
        if (!(c instanceof JPasswordField)) {
            return null;
        }
        return ((JPasswordField)c).getPassword();
    }

    public Context getContextValue(String fieldLabel) {
        Component c = this.fieldMap.get(fieldLabel);
        if (c != null) {
            if (c instanceof ContextSelectComboBox) {
                return ((ContextSelectComboBox)c).getSelectedContext();
            }
            StandardFieldsDialog.handleUnexpectedFieldClass(fieldLabel, c);
        }
        return null;
    }

    public void setContextValue(String fieldLabel, Context context) {
        Component c = this.fieldMap.get(fieldLabel);
        if (c != null) {
            if (c instanceof ContextSelectComboBox) {
                ((ContextSelectComboBox)c).setSelectedItem(context);
            } else {
                StandardFieldsDialog.handleUnexpectedFieldClass(fieldLabel, c);
            }
        }
    }

    public void setFieldValue(String fieldLabel, String value) {
        Component c = this.fieldMap.get(fieldLabel);
        if (c != null) {
            if (c instanceof JTextComponent) {
                ((JTextComponent)c).setText(value);
            } else if (c instanceof JComboBox) {
                ((JComboBox)c).setSelectedItem(value);
            } else if (c instanceof JLabel) {
                ((JLabel)c).setText(value);
            } else {
                StandardFieldsDialog.handleUnexpectedFieldClass(fieldLabel, c);
            }
        }
    }

    public void setFieldValue(String fieldLabel, boolean value) {
        Component c = this.fieldMap.get(fieldLabel);
        if (c != null) {
            if (c instanceof JCheckBox) {
                ((JCheckBox)c).setSelected(value);
            } else {
                StandardFieldsDialog.handleUnexpectedFieldClass(fieldLabel, c);
            }
        }
    }

    public boolean isEmptyField(String fieldLabel) {
        Component c = this.fieldMap.get(fieldLabel);
        if (c != null) {
            Object value = null;
            if (c instanceof JTextComponent) {
                return ((JTextComponent)c).getDocument().getLength() == 0;
            }
            if (c instanceof JComboBox) {
                value = ((JComboBox)c).getSelectedItem();
            } else if (c instanceof ZapNumberSpinner) {
                value = ((ZapNumberSpinner)c).getValue();
                if ((Integer)value < 0) {
                    value = null;
                }
            } else {
                StandardFieldsDialog.handleUnexpectedFieldClass(fieldLabel, c);
            }
            return value == null || value.toString().length() == 0;
        }
        return true;
    }

    public int getIntValue(String fieldLabel) {
        Component c = this.fieldMap.get(fieldLabel);
        if (c != null) {
            if (c instanceof ZapNumberSpinner) {
                return ((ZapNumberSpinner)c).getValue();
            }
            if (c instanceof JComboBox) {
                return (Integer)((JComboBox)c).getSelectedItem();
            }
            StandardFieldsDialog.handleUnexpectedFieldClass(fieldLabel, c);
        }
        return -1;
    }

    public void setFieldValue(String fieldLabel, int value) {
        Component c = this.fieldMap.get(fieldLabel);
        if (c != null) {
            if (c instanceof ZapNumberSpinner) {
                ((ZapNumberSpinner)c).setValue(value);
            } else if (c instanceof JComboBox) {
                ((JComboBox)c).setSelectedItem(value);
            } else {
                StandardFieldsDialog.handleUnexpectedFieldClass(fieldLabel, c);
            }
        }
    }

    public void addReadOnlyField(String fieldLabel, String value, boolean doubleWidth) {
        this.validateNotTabbed();
        JLabel field = new JLabel();
        if (value != null) {
            field.setText(value);
        }
        if (doubleWidth) {
            this.getMainPanel().add((Component)field, LayoutHelper.getGBC(0, this.fieldList.size(), 2, 0.0, 0.0, 1, new Insets(4, 4, 4, 4)));
            this.fieldList.add(field);
            this.fieldMap.put(fieldLabel, field);
        } else {
            this.addField(fieldLabel, field, field, 0.0);
        }
    }

    public void addReadOnlyField(int tabIndex, String fieldLabel, String value, boolean doubleWidth) {
        this.validateTabbed(tabIndex);
        JLabel field = new JLabel();
        if (value != null) {
            field.setText(value);
        }
        if (doubleWidth) {
            JPanel panel = this.tabPanels.get(tabIndex);
            panel.add((Component)field, LayoutHelper.getGBC(0, this.tabOffsets.get(tabIndex), 2, 1.0, 0.0, 1, new Insets(4, 4, 4, 4)));
            this.fieldList.add(field);
            this.fieldMap.put(fieldLabel, field);
            this.incTabOffset(tabIndex);
        } else {
            this.addField(this.tabPanels.get(tabIndex), this.tabOffsets.get(tabIndex), fieldLabel, field, field, 0.0);
        }
        this.incTabOffset(tabIndex);
    }

    public void setCustomTabPanel(int i, JComponent panel) {
        this.validateTabbed(i);
        this.tabPanels.get(i).add((Component)panel, LayoutHelper.getGBC(0, 0, 1, 1.0, 1.0, 1));
    }

    public Boolean getBoolValue(String fieldLabel) {
        Component c = this.fieldMap.get(fieldLabel);
        if (c != null) {
            if (c instanceof JCheckBox) {
                return ((JCheckBox)c).isSelected();
            }
            StandardFieldsDialog.handleUnexpectedFieldClass(fieldLabel, c);
        }
        return null;
    }

    public void addFieldListener(String fieldLabel, ActionListener listener) {
        Component c = this.fieldMap.get(fieldLabel);
        if (c != null) {
            if (c instanceof JTextField) {
                ((JTextField)c).addActionListener(listener);
            } else if (c instanceof JComboBox) {
                ((JComboBox)c).addActionListener(listener);
            } else if (c instanceof JCheckBox) {
                ((JCheckBox)c).addActionListener(listener);
            } else {
                StandardFieldsDialog.handleUnexpectedFieldClass(fieldLabel, c);
            }
        }
    }

    public void addFieldListener(String fieldLabel, MouseAdapter listener) {
        this.fieldMap.computeIfPresent(fieldLabel, (k, c) -> {
            c.addMouseListener(listener);
            return c;
        });
    }

    public void setFieldPopupMenu(String fieldLabel, JPopupMenu popup) {
        Component c = this.fieldMap.get(fieldLabel);
        if (c != null) {
            if (c instanceof JComponent) {
                ((JComponent)c).setComponentPopupMenu(popup);
            } else {
                StandardFieldsDialog.handleUnexpectedFieldClass(fieldLabel, c);
            }
        }
    }

    public void setFieldMainPopupMenu(String fieldLabel) {
        this.setFieldPopupMenu(fieldLabel, StandardFieldsDialog.getMainPopupMenu());
    }

    private static JPopupMenu getMainPopupMenu() {
        if (mainPopupMenu == null) {
            mainPopupMenu = new JPopupMenu(){
                private static final long serialVersionUID = 1L;

                @Override
                public void show(Component invoker, int x, int y) {
                    View.getSingleton().getPopupMenu().show(invoker, x, y);
                }
            };
        }
        return mainPopupMenu;
    }

    public void removeAllFields() {
        if (this.isTabbed()) {
            for (JPanel panel : this.tabPanels) {
                panel.removeAll();
            }
            Collections.fill(this.tabOffsets, 0);
        } else {
            this.getMainPanel().removeAll();
        }
        this.fieldList.clear();
        this.fieldMap.clear();
    }

    public void requestTabFocus(int tabIndex) {
        this.validateTabbed(tabIndex);
        this.tabbedPane.setSelectedComponent(this.getTabComponent(this.tabPanels.get(tabIndex)));
    }

    private JComponent getTabComponent(JPanel panel) {
        JScrollPane scrollPane = this.panelToScrollPaneMap.get(panel);
        if (scrollPane != null) {
            return scrollPane;
        }
        return panel;
    }

    public void setTabsVisible(String[] tabLabels, boolean visible) {
        if (visible) {
            for (String label : tabLabels) {
                String name = Constant.messages.getString(label);
                JPanel tabPanel = this.tabNameMap.get(label);
                this.tabbedPane.addTab(name, this.getTabComponent(tabPanel));
            }
        } else {
            for (String label : tabLabels) {
                JPanel tabPanel = this.tabNameMap.get(label);
                this.tabbedPane.remove(this.getTabComponent(tabPanel));
            }
        }
    }

    protected void setTabScrollable(String tabLabel, boolean scrollable) {
        JPanel tabPanel = this.tabNameMap.get(tabLabel);
        if (tabPanel == null) {
            return;
        }
        if (scrollable) {
            if (this.isTabScrollable(tabPanel)) {
                return;
            }
            String title = Constant.messages.getString(tabLabel);
            int tabIndex = this.tabbedPane.indexOfTab(title);
            boolean selected = this.tabbedPane.getSelectedIndex() == tabIndex;
            JScrollPane scrollPane = this.createTabScrollable(tabLabel, tabPanel);
            if (scrollPane == null) {
                return;
            }
            this.panelToScrollPaneMap.put(tabPanel, scrollPane);
            if (tabIndex == -1) {
                return;
            }
            this.tabbedPane.insertTab(title, null, scrollPane, null, tabIndex);
            if (selected) {
                this.tabbedPane.setSelectedIndex(tabIndex);
            }
            return;
        }
        if (!this.isTabScrollable(tabPanel)) {
            return;
        }
        String title = Constant.messages.getString(tabLabel);
        int tabIndex = this.tabbedPane.indexOfTab(title);
        this.tabbedPane.insertTab(title, null, tabPanel, null, tabIndex);
        this.tabbedPane.removeTabAt(tabIndex + 1);
        this.panelToScrollPaneMap.remove(tabPanel);
    }

    private boolean isTabScrollable(JPanel tabPanel) {
        return this.panelToScrollPaneMap.containsKey(tabPanel);
    }

    protected boolean isTabScrollable(String tabLabel) {
        JPanel tabPanel = this.tabNameMap.get(tabLabel);
        if (tabPanel == null) {
            return false;
        }
        return this.isTabScrollable(tabPanel);
    }

    protected JScrollPane createTabScrollable(String tabLabel, JPanel tabPanel) {
        return new JScrollPane(tabPanel, 20, 30);
    }

    public abstract void save();

    public abstract String validateFields();
}

