/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.lang.time.StopWatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.SampleResponse;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.network.HttpStatusCode;
import org.zaproxy.zap.model.StructuralNode;

public class Analyser {
    private static final Logger LOGGER = LogManager.getLogger(Analyser.class);
    private static final String PATTERN_REMOVE_HEADER = "(?m)(?i)(?s)<HEAD>.*?</HEAD>";
    private static final Pattern PATTERN_NOT_FOUND = Pattern.compile("(\\bnot\\b(found|exist))|(\\b404\\berror\\b)|(\\berror\\b404\\b)", 10);
    private static final String PATTERN_THREE_SEGMENT_TIME = "\\s[012]\\d:[0-5]\\d:[0-5]\\d\\s";
    private static Random staticRandomGenerator = new Random();
    private static final String[] staticSuffixList = new String[]{".cfm", ".jsp", ".php", ".asp", ".aspx", ".dll", ".exe", ".pl"};
    private HttpSender httpSender = null;
    private TreeMap<String, SampleResponse> mapVisited = new TreeMap();
    private boolean isStop = false;
    private StopWatch stopWatch;
    private boolean stopWatchStarted;
    private int delayInMs;
    private int requestCount;
    HostProcess parent = null;

    public Analyser() {
    }

    public Analyser(HttpSender httpSender, HostProcess parent) {
        this.httpSender = httpSender;
        this.parent = parent;
        this.stopWatch = new StopWatch();
    }

    public boolean isStop() {
        return this.isStop;
    }

    public void stop() {
        this.isStop = true;
    }

    public void start(StructuralNode node) {
        if (this.stopWatchStarted) {
            this.stopWatch.resume();
        } else {
            this.stopWatch.start();
            this.stopWatchStarted = true;
        }
        try {
            this.inOrderAnalyse(new HashSet<StructuralNode>(), node);
        }
        finally {
            this.stopWatch.suspend();
        }
    }

    private void addAnalysedHost(URI uri, HttpMessage msg, int errorIndicator) {
        try {
            this.mapVisited.put(uri.toString(), new SampleResponse(msg, errorIndicator));
        }
        catch (DatabaseException | HttpMalformedHeaderException e) {
            LOGGER.error("Failed to persist the message: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void analyse(StructuralNode node) throws Exception {
        if (node.getHistoryReference() == null) {
            LOGGER.debug("Node being analysed has no History Reference");
            return;
        }
        if (!this.parent.nodeInScope(node.getName())) {
            LOGGER.debug("Node being analysed is out of scope");
            return;
        }
        HttpMessage baseMsg = node.getHistoryReference().getHttpMessage();
        URI baseUri = (URI)baseMsg.getRequestHeader().getURI().clone();
        LOGGER.debug("Analysing {}", (Object)baseUri);
        baseUri.setQuery(null);
        if (this.mapVisited.get(baseUri.toString()) != null) {
            LOGGER.debug("Skipping: This node has already been analysed");
            return;
        }
        String path = this.getRandomPathSuffix(node, baseUri);
        HttpMessage msg = baseMsg.cloneRequest();
        URI uri = (URI)baseUri.clone();
        uri.setPath(path);
        msg.getRequestHeader().setURI(uri);
        LOGGER.debug("Sending first analyse request {}", (Object)uri);
        this.sendAndReceive(msg);
        if (msg.getResponseHeader().getStatusCode() == 404) {
            this.addAnalysedHost(baseUri, msg, 0);
            LOGGER.debug("Analysis determined standard 404 handling");
            return;
        }
        if (HttpStatusCode.isRedirection(msg.getResponseHeader().getStatusCode())) {
            this.addAnalysedHost(baseUri, msg, 2);
            LOGGER.debug("Analysis determined error page redirect handling");
            return;
        }
        if (msg.getResponseHeader().getStatusCode() != 200) {
            this.addAnalysedHost(baseUri, msg, 1);
            LOGGER.debug("Analysis determined non-RFC error page handling");
            return;
        }
        HttpMessage msg2 = baseMsg.cloneRequest();
        URI uri2 = msg2.getRequestHeader().getURI();
        String path2 = this.getRandomPathSuffix(node, uri2);
        uri2 = (URI)baseUri.clone();
        uri2.setPath(path2);
        msg2.getRequestHeader().setURI(uri2);
        LOGGER.debug("Sending second analyse request {}", (Object)uri2);
        this.sendAndReceive(msg2);
        String resBody1 = msg.getResponseBody().toString().replaceAll(PATTERN_REMOVE_HEADER, "");
        String resBody2 = msg2.getResponseBody().toString().replaceAll(PATTERN_REMOVE_HEADER, "");
        if (resBody1.equals(resBody2)) {
            msg.getResponseBody().setBody(resBody1);
            this.addAnalysedHost(baseUri, msg, 3);
            LOGGER.debug("Analysis determined static error page handling");
            return;
        }
        if ((resBody1 = resBody1.replaceAll(Analyser.getPathRegex(uri), "").replaceAll(PATTERN_THREE_SEGMENT_TIME, "")).equals(resBody2 = resBody2.replaceAll(Analyser.getPathRegex(uri2), "").replaceAll(PATTERN_THREE_SEGMENT_TIME, ""))) {
            msg.getResponseBody().setBody(resBody1);
            this.addAnalysedHost(baseUri, msg, 4);
            LOGGER.debug("Analysis determined dynamic but deterministic error page handling");
            return;
        }
        this.addAnalysedHost(baseUri, msg, 5);
        LOGGER.debug("Analysis fell all the way through to non-deterministic error page handling");
    }

    private String getChildSuffix(StructuralNode node, boolean performRecursiveCheck) {
        String resultSuffix = "";
        String suffix = null;
        StructuralNode child = null;
        try {
            for (int i = 0; i < staticSuffixList.length; ++i) {
                suffix = staticSuffixList[i];
                Iterator<StructuralNode> iter = node.getChildIterator();
                while (iter.hasNext()) {
                    child = iter.next();
                    try {
                        if (!child.getURI().getPath().endsWith(suffix)) continue;
                        return suffix;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            if (performRecursiveCheck) {
                Iterator<StructuralNode> iter = node.getChildIterator();
                while (iter.hasNext()) {
                    child = iter.next();
                    resultSuffix = this.getChildSuffix(child, performRecursiveCheck);
                    if (resultSuffix.equals("")) continue;
                    return resultSuffix;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resultSuffix;
    }

    static String getPathRegex(URI uri) throws URIException {
        URI newUri;
        try {
            newUri = (URI)uri.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new URIException(e.getMessage());
        }
        String query = newUri.getQuery();
        StringBuilder sb = new StringBuilder(100);
        newUri.setQuery(null);
        sb.append(newUri.toString());
        if (query != null) {
            String queryPattern = "(\\?" + Pattern.quote(query) + ")?";
            sb.append(queryPattern);
        }
        return sb.toString();
    }

    private String getRandomPathSuffix(StructuralNode node, URI uri) throws URIException {
        String resultSuffix = this.getChildSuffix(node, true);
        Object path = "";
        path = uri.getPath() == null ? "" : uri.getPath();
        path = (String)path + (((String)path).endsWith("/") ? "" : "/") + Long.toString(this.getRndPositiveLong());
        path = (String)path + resultSuffix;
        return path;
    }

    private long getRndPositiveLong() {
        long rnd = Long.MIN_VALUE;
        while (rnd == Long.MIN_VALUE) {
            rnd = staticRandomGenerator.nextLong();
        }
        return Math.abs(rnd);
    }

    private int inOrderAnalyse(Set<StructuralNode> traversedNodes, StructuralNode node) {
        int subtreeNodes;
        block7: {
            if (this.isStop || node == null) {
                return 0;
            }
            subtreeNodes = 0;
            if (traversedNodes.contains(node)) {
                return 0;
            }
            traversedNodes.add(node);
            try {
                if (node.isRoot()) break block7;
                if (!node.isLeaf() || node.isLeaf() && node.getParent().isRoot()) {
                    LOGGER.debug("Node being analysed isn't a leaf or is a leaf whose parent is root");
                    this.analyse(node);
                    break block7;
                }
                if (node.isLeaf() && !node.getParent().isRoot()) {
                    LOGGER.debug("Node being analysed is a leaf whose parent is not root");
                    this.inOrderAnalyse(traversedNodes, node.getParent());
                    break block7;
                }
                return 1;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Iterator<StructuralNode> iter = node.getChildIterator();
        LOGGER.debug("Iterating children of {} with URI {}", (Object)node.getName(), (Object)node.getURI());
        while (iter.hasNext()) {
            subtreeNodes += this.inOrderAnalyse(traversedNodes, iter.next());
        }
        return subtreeNodes + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileExist(HttpMessage msg) {
        if (msg.getResponseHeader().isEmpty()) {
            return false;
        }
        if (msg.getResponseHeader().getStatusCode() == 404) {
            return false;
        }
        URI uri = null;
        String sUri = null;
        try {
            uri = (URI)msg.getRequestHeader().getURI().clone();
            uri.setQuery(null);
            String path = uri.getPath();
            path = path.replaceAll("/[^/]*$", "");
            uri.setPath(path);
        }
        catch (Exception path) {
        }
        finally {
            if (uri != null) {
                sUri = uri.toString();
            }
        }
        SampleResponse sample = this.mapVisited.get(sUri);
        if (sample == null) {
            try {
                uri.setPath(null);
            }
            catch (URIException uRIException) {
                // empty catch block
            }
            String sHostOnly = uri.toString();
            sample = this.mapVisited.get(sHostOnly);
        }
        if (sample == null) {
            return msg.getResponseHeader().getStatusCode() == 200;
        }
        if (HttpStatusCode.isRedirection(msg.getResponseHeader().getStatusCode())) {
            try {
                String location;
                if (sample.getMessage().getResponseHeader().getStatusCode() == msg.getResponseHeader().getStatusCode() && (location = msg.getResponseHeader().getHeader("location")) != null && location.equals(sample.getMessage().getResponseHeader().getHeader("location"))) {
                    return false;
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            return true;
        }
        if (msg.getResponseHeader().getStatusCode() != 200) {
            return false;
        }
        Matcher matcher = PATTERN_NOT_FOUND.matcher(msg.getResponseBody().toString());
        if (matcher.find()) {
            return false;
        }
        String body = msg.getResponseBody().toString().replaceAll(PATTERN_REMOVE_HEADER, "");
        if (sample.getErrorPageType() == 3) {
            try {
                if (sample.getMessage().getResponseBody().toString().equals(body)) {
                    return false;
                }
            }
            catch (DatabaseException | HttpMalformedHeaderException e) {
                LOGGER.error("Failed to read the message: {}", (Object)e.getMessage(), (Object)e);
            }
            return true;
        }
        uri = msg.getRequestHeader().getURI();
        try {
            if (sample.getErrorPageType() == 4) {
                body = msg.getResponseBody().toString().replaceAll(Analyser.getPathRegex(uri), "").replaceAll(PATTERN_THREE_SEGMENT_TIME, "");
                return !sample.getMessage().getResponseBody().toString().equals(body);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private void sendAndReceive(HttpMessage msg) throws IOException {
        if (this.getDelayInMs() > 0) {
            try {
                Thread.sleep(this.getDelayInMs());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.httpSender.sendAndReceive(msg, this.parent.getRedirectRequestConfig());
        ++this.requestCount;
        this.parent.notifyNewMessage(msg);
    }

    public int getDelayInMs() {
        return this.delayInMs;
    }

    public void setDelayInMs(int delayInMs) {
        this.delayInMs = delayInMs;
    }

    public int getRequestCount() {
        return this.requestCount;
    }

    public long getRunningTime() {
        return this.stopWatch.getTime();
    }
}

