/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.core.scanner.MultipartFormParameter;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.core.scanner.InputVector;

public class VariantMultipartFormParameters
implements Variant {
    private static final Logger LOGGER = LogManager.getLogger(VariantMultipartFormParameters.class);
    private static final Pattern FIELD_NAME_PATTERN = Pattern.compile("\\s*content-disposition\\s*:.*\\s+name\\s*\\=?\\s*\\\"?(?<name>.[^;\\\"\\n]*)\\\"?\\;?.*", 2);
    private static final Pattern FIELD_VALUE_PATTERN = Pattern.compile("[\\r\\n]{2}(?<value>.*)");
    private static final Pattern FILENAME_PART_PATTERN = Pattern.compile("\\s*content-disposition\\s*:.*filename\\s*\\=?\\s*\\\"?(?<filename>.[^;\"\\n]*)\\\"?\\;?.*", 2);
    private static final Pattern CONTENTTYPE_PART_PATTERN = Pattern.compile("\\s*content-disposition.*content-type\\s*:\\s*\\s*\\\"?(?<contenttype>.[^;\"\\r\\n]*)\\\"?\\;?.*", 34);
    private List<NameValuePair> params = Collections.emptyList();
    private List<MultipartFormParameter> multiPartParams = new ArrayList<MultipartFormParameter>();
    private static final String SHORT_NAME = "multipart";

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMessage(HttpMessage msg) {
        if (msg == null) {
            throw new IllegalArgumentException("Parameter message must not be null.");
        }
        String contentType = msg.getRequestHeader().getHeader("content-type");
        if (contentType == null || !contentType.toLowerCase().startsWith("multipart/form-data")) {
            return;
        }
        ArrayList<NameValuePair> extractedParameters = new ArrayList<NameValuePair>();
        int position = 0;
        int offset = 0;
        String boundary = this.getBoundary(contentType) + "\r\n";
        for (String string : msg.getRequestBody().toString().split(boundary)) {
            void var10_10;
            if (!StringUtils.isBlank((String)string)) {
                String partHeaderLine = string.substring(0, string.indexOf("\r\n\r\n"));
                boolean isFileParam = partHeaderLine.contains("filename=");
                String string2 = boundary + string;
                Matcher nameMatcher = FIELD_NAME_PATTERN.matcher(partHeaderLine);
                Matcher valueMatcher = FIELD_VALUE_PATTERN.matcher(string2);
                nameMatcher.find();
                valueMatcher.find();
                if (StringUtils.isBlank((String)valueMatcher.group("value"))) {
                    valueMatcher.find();
                }
                String name = nameMatcher.group("name");
                String value = string2.replaceAll(Pattern.quote(boundary + partHeaderLine) + "\r\n\r\n", "");
                value = value.replaceAll("\r\n(" + Pattern.quote(this.getBoundary(contentType)) + "--\r\n)?$", "");
                if (isFileParam) {
                    extractedParameters.add(new NameValuePair(34, name, value, position += 2));
                } else {
                    extractedParameters.add(new NameValuePair(33, name, value, position));
                }
                int start = offset + string2.indexOf("\r\n\r\n") + 4;
                int end = start + value.length();
                LOGGER.debug("Name: {} O: {} S: {} E: {} Pos: {}", (Object)name, (Object)offset, (Object)start, (Object)end, (Object)position);
                this.multiPartParams.add(new MultipartFormParameter(name, valueMatcher.group("value"), start, end, position, MultipartFormParameter.Type.GENERAL));
                LOGGER.debug("Name: {} value: {}", (Object)name, (Object)valueMatcher.group("value"));
                if (isFileParam) {
                    Matcher fnValueMatcher = FILENAME_PART_PATTERN.matcher(string2);
                    fnValueMatcher.find();
                    String fnValue = fnValueMatcher.group("filename");
                    extractedParameters.add(extractedParameters.size() - 1, new NameValuePair(35, name, fnValue, position -= 2));
                    int fnStart = offset + string2.indexOf(fnValue);
                    int fnEnd = fnStart + fnValue.length();
                    LOGGER.debug("Name: {} O: {} S: {} E: {} Pos: {}", (Object)name, (Object)offset, (Object)fnStart, (Object)fnEnd, (Object)position);
                    this.multiPartParams.add(this.multiPartParams.size() - 1, new MultipartFormParameter(name, fnValue, fnStart, fnEnd, position, MultipartFormParameter.Type.FILE_NAME));
                    Matcher ctValueMatcher = CONTENTTYPE_PART_PATTERN.matcher(string2);
                    ctValueMatcher.find();
                    String ctValue = ctValueMatcher.group("contenttype");
                    extractedParameters.add(extractedParameters.size() - 1, new NameValuePair(36, name, ctValue, ++position));
                    int ctStart = offset + string2.indexOf(ctValue);
                    int ctEnd = ctStart + ctValue.length();
                    LOGGER.debug("Name: {} O: {} S: {} E: {} Pos: {}", (Object)name, (Object)offset, (Object)ctStart, (Object)ctEnd, (Object)position);
                    this.multiPartParams.add(this.multiPartParams.size() - 1, new MultipartFormParameter(name, ctValue, ctStart, ctEnd, position, MultipartFormParameter.Type.FILE_CONTENT_TYPE));
                }
            }
            ++position;
            offset += var10_10.length();
        }
        this.params = Collections.unmodifiableList(extractedParameters);
    }

    @Override
    public List<NameValuePair> getParamList() {
        return this.params;
    }

    @Override
    public String setParameter(HttpMessage msg, NameValuePair originalPair, String name, String value) {
        return this.setParameter(msg, Collections.singletonList(originalPair.getPosition()), Collections.singletonList(value));
    }

    @Override
    public String setEscapedParameter(HttpMessage msg, NameValuePair originalPair, String name, String value) {
        return this.setParameter(msg, Collections.singletonList(originalPair.getPosition()), Collections.singletonList(value));
    }

    @Override
    public void setParameters(HttpMessage msg, List<InputVector> inputVectors) {
        this.setParameter(msg, inputVectors.stream().map(InputVector::getPosition).collect(Collectors.toList()), inputVectors.stream().map(InputVector::getValue).collect(Collectors.toList()));
    }

    private String setParameter(HttpMessage msg, List<Integer> nameValuePairPositions, List<String> values) {
        StringBuilder newBodyBuilder = new StringBuilder(msg.getRequestBody().toString());
        int offset = 0;
        for (int index = 0; index < nameValuePairPositions.size(); ++index) {
            int originalPosition = nameValuePairPositions.get(index);
            String value = values.get(index);
            int idx = originalPosition - 1;
            MultipartFormParameter mpPart = this.multiPartParams.get(idx);
            LOGGER.debug("i: {} pos: {} S: {} E: {} O: {}", (Object)idx, (Object)originalPosition, (Object)mpPart.getStart(), (Object)mpPart.getEnd(), (Object)offset);
            newBodyBuilder.replace(mpPart.getStart() + offset, mpPart.getEnd() + offset, value);
            offset = offset + value.length() - mpPart.getEnd() + mpPart.getStart();
        }
        String newBody = newBodyBuilder.toString();
        msg.getRequestBody().setBody(newBody);
        return newBody;
    }

    private String getBoundary(String contentTypeHeader) {
        int index = contentTypeHeader.lastIndexOf("boundary=");
        if (index == -1) {
            return null;
        }
        Object boundary = contentTypeHeader.substring(index + 9);
        if (((String)boundary).charAt(0) == '\"') {
            index = ((String)boundary).lastIndexOf(34);
            boundary = ((String)boundary).substring(1, index);
        }
        boundary = "--" + (String)boundary;
        return boundary;
    }
}

