/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db.paros;

import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.db.AbstractDatabase;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DatabaseListener;
import org.parosproxy.paros.db.DatabaseServer;
import org.parosproxy.paros.db.TableAlert;
import org.parosproxy.paros.db.TableContext;
import org.parosproxy.paros.db.TableHistory;
import org.parosproxy.paros.db.TableParam;
import org.parosproxy.paros.db.TableScan;
import org.parosproxy.paros.db.TableSession;
import org.parosproxy.paros.db.TableSessionUrl;
import org.parosproxy.paros.db.TableStructure;
import org.parosproxy.paros.db.TableTag;
import org.parosproxy.paros.db.paros.ParosDatabaseServer;
import org.parosproxy.paros.db.paros.ParosTableAlert;
import org.parosproxy.paros.db.paros.ParosTableContext;
import org.parosproxy.paros.db.paros.ParosTableHistory;
import org.parosproxy.paros.db.paros.ParosTableParam;
import org.parosproxy.paros.db.paros.ParosTableScan;
import org.parosproxy.paros.db.paros.ParosTableSession;
import org.parosproxy.paros.db.paros.ParosTableSessionUrl;
import org.parosproxy.paros.db.paros.ParosTableStructure;
import org.parosproxy.paros.db.paros.ParosTableTag;
import org.parosproxy.paros.extension.option.DatabaseParam;
import org.zaproxy.zap.db.TableAlertTag;
import org.zaproxy.zap.db.paros.ParosTableAlertTag;

public class ParosDatabase
extends AbstractDatabase {
    private ParosDatabaseServer databaseServer = null;
    private TableHistory tableHistory = null;
    private TableSession tableSession = null;
    private TableAlert tableAlert = null;
    private TableAlertTag tableAlertTag = null;
    private TableScan tableScan = null;
    private TableTag tableTag = null;
    private TableSessionUrl tableSessionUrl = null;
    private TableParam tableParam = null;
    private TableContext tableContext = null;
    private TableStructure tableStructure = null;
    private List<DatabaseListener> internalDatabaseListeners = new ArrayList<DatabaseListener>();
    private DatabaseParam databaseOptions;

    public ParosDatabase() {
        this.tableHistory = new ParosTableHistory();
        this.tableSession = new ParosTableSession();
        this.tableAlert = new ParosTableAlert();
        this.tableAlertTag = new ParosTableAlertTag();
        this.tableScan = new ParosTableScan();
        this.tableTag = new ParosTableTag();
        this.tableSessionUrl = new ParosTableSessionUrl();
        this.tableParam = new ParosTableParam();
        this.tableContext = new ParosTableContext();
        this.tableStructure = new ParosTableStructure();
        this.internalDatabaseListeners.add(this.tableHistory);
        this.internalDatabaseListeners.add(this.tableSession);
        this.internalDatabaseListeners.add(this.tableAlert);
        this.internalDatabaseListeners.add(this.tableAlertTag);
        this.internalDatabaseListeners.add(this.tableScan);
        this.internalDatabaseListeners.add(this.tableTag);
        this.internalDatabaseListeners.add(this.tableSessionUrl);
        this.internalDatabaseListeners.add(this.tableParam);
        this.internalDatabaseListeners.add(this.tableContext);
        this.internalDatabaseListeners.add(this.tableStructure);
    }

    @Override
    public DatabaseServer getDatabaseServer() {
        return this.databaseServer;
    }

    private void setDatabaseServer(ParosDatabaseServer databaseServer) {
        this.databaseServer = databaseServer;
    }

    @Override
    public TableHistory getTableHistory() {
        return this.tableHistory;
    }

    @Override
    public TableSession getTableSession() {
        return this.tableSession;
    }

    @Override
    public void open(String path) throws ClassNotFoundException, Exception {
        this.getLogger().debug("open {}", (Object)path);
        this.setDatabaseServer(new ParosDatabaseServer(path, this.databaseOptions));
        this.notifyListenersDatabaseOpen(this.internalDatabaseListeners, this.getDatabaseServer());
        this.notifyListenersDatabaseOpen(this.getDatabaseServer());
    }

    @Override
    public void deleteSession(String sessionName) {
        this.getLogger().debug("deleteSession {}", (Object)sessionName);
        if (this.databaseServer == null) {
            return;
        }
        try {
            this.databaseServer.shutdown(false);
        }
        catch (SQLException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
        this.deleteDbFile(new File(sessionName));
        this.deleteDbFile(new File(sessionName + ".data"));
        this.deleteDbFile(new File(sessionName + ".script"));
        this.deleteDbFile(new File(sessionName + ".properties"));
        this.deleteDbFile(new File(sessionName + ".backup"));
        this.deleteDbFile(new File(sessionName + ".lobs"));
        this.databaseServer = null;
    }

    private void deleteDbFile(File file) {
        this.getLogger().debug("Deleting {}", (Object)file.getAbsolutePath());
        if (file.exists() && !file.delete()) {
            this.getLogger().error("Failed to delete {}", (Object)file.getAbsolutePath());
        }
    }

    @Override
    public void close(boolean compact, boolean cleanup) {
        this.getLogger().debug("close");
        if (this.databaseServer == null) {
            return;
        }
        super.close(compact, cleanup);
        try {
            if (cleanup) {
                this.getTableHistory().deleteTemporary();
            }
            this.databaseServer.shutdown(compact);
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public TableAlert getTableAlert() {
        return this.tableAlert;
    }

    @Override
    public void setTableAlert(TableAlert tableAlert) {
        this.tableAlert = tableAlert;
    }

    @Override
    public TableAlertTag getTableAlertTag() {
        return this.tableAlertTag;
    }

    @Override
    public void setTableAlertTag(TableAlertTag tableAlertTag) {
        this.tableAlertTag = tableAlertTag;
    }

    @Override
    public TableScan getTableScan() {
        return this.tableScan;
    }

    @Override
    public void setTableScan(TableScan tableScan) {
        this.tableScan = tableScan;
    }

    @Override
    public TableTag getTableTag() {
        return this.tableTag;
    }

    @Override
    public void setTableTag(TableTag tableTag) {
        this.tableTag = tableTag;
    }

    @Override
    public TableSessionUrl getTableSessionUrl() {
        return this.tableSessionUrl;
    }

    @Override
    public void setTableSessionUrl(TableSessionUrl tableSessionUrl) {
        this.tableSessionUrl = tableSessionUrl;
    }

    @Override
    public TableParam getTableParam() {
        return this.tableParam;
    }

    @Override
    public TableContext getTableContext() {
        return this.tableContext;
    }

    @Override
    public TableStructure getTableStructure() {
        return this.tableStructure;
    }

    @Override
    public String getType() {
        return "hsqldb";
    }

    public void setDatabaseParam(DatabaseParam databaseOptions) {
        if (databaseOptions == null) {
            throw new IllegalArgumentException("Parameter databaseOptions must not be null.");
        }
        this.databaseOptions = databaseOptions;
    }

    @Override
    public void discardSession(long sessionId) throws DatabaseException {
    }
}

