/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.model;

import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.control.ExtensionFactory;

public class SiteNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 7987615016786179150L;
    private String nodeName = null;
    private String hierarchicNodeName = null;
    private HistoryReference historyReference = null;
    private Vector<HistoryReference> pastHistoryList = new Vector(10);
    private SiteMap siteMap = null;
    private Set<Alert> alerts = Collections.synchronizedSet(new HashSet());
    private boolean justSpidered = false;
    private ArrayList<String> icons = null;
    private ArrayList<Boolean> clearIfManual = null;
    private static final Logger LOGGER = LogManager.getLogger(SiteNode.class);
    private boolean isIncludedInScope = false;
    private boolean isExcludedFromScope = false;
    private boolean filtered = false;
    private boolean dataDriven = false;
    private boolean calculateHighestAlert;
    private Alert highestAlert;

    public SiteNode(SiteMap siteMap, int type, String nodeName) {
        this.siteMap = siteMap;
        this.nodeName = nodeName;
        this.dataDriven = nodeName.contains("\u00ab");
        this.icons = new ArrayList();
        this.clearIfManual = new ArrayList();
        if (type == 2) {
            this.justSpidered = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomIcons(ArrayList<String> i, ArrayList<Boolean> c) {
        ArrayList<String> arrayList = this.icons;
        synchronized (arrayList) {
            this.icons.clear();
            this.icons.addAll(i);
            this.clearIfManual = c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCustomIcon(String resourceName, boolean clearIfManual) {
        ArrayList<String> arrayList = this.icons;
        synchronized (arrayList) {
            if (!this.icons.contains(resourceName)) {
                this.icons.add(resourceName);
                this.clearIfManual.add(clearIfManual);
                this.nodeChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCustomIcon(String resourceName) {
        ArrayList<String> arrayList = this.icons;
        synchronized (arrayList) {
            if (this.icons.contains(resourceName)) {
                int i = this.icons.indexOf(resourceName);
                this.icons.remove(i);
                this.clearIfManual.remove(i);
                this.nodeChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ImageIcon> getCustomIcons() {
        ArrayList<ImageIcon> iconList = new ArrayList<ImageIcon>();
        if (this.justSpidered) {
            iconList.add(new ImageIcon(Constant.class.getResource("/resource/icon/10/spider.png")));
        }
        ArrayList<String> arrayList = this.icons;
        synchronized (arrayList) {
            if (!this.icons.isEmpty()) {
                Iterator<String> it = this.icons.iterator();
                while (it.hasNext()) {
                    String icon = it.next();
                    URL url = Constant.class.getResource(icon);
                    if (url == null && (url = ExtensionFactory.getAddOnLoader().getResource(icon)) == null) {
                        LOGGER.warn("Failed to find icon: {}", (Object)icon);
                        it.remove();
                    }
                    if (url == null) continue;
                    iconList.add(new ImageIcon(url));
                }
            }
        }
        return iconList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateHighestAlert() {
        Set<Alert> set = this.alerts;
        synchronized (set) {
            this.highestAlert = null;
            for (Alert alert : this.alerts) {
                if (!this.isHighestAlert(alert)) continue;
                this.highestAlert = alert;
            }
            this.calculateHighestAlert = false;
        }
    }

    private boolean isHighestAlert(Alert alert) {
        if (alert.getConfidence() == 0) {
            return false;
        }
        if (this.highestAlert == null) {
            return true;
        }
        return alert.getRisk() > this.highestAlert.getRisk();
    }

    public Alert getHighestAlert() {
        return this.highestAlert;
    }

    @Override
    public String toString() {
        if (this.calculateHighestAlert) {
            this.calculateHighestAlert();
        }
        return this.nodeName;
    }

    public boolean isParentOf(String nodeName) {
        if (nodeName == null) {
            return false;
        }
        return nodeName.compareTo(this.nodeName) < 0;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getName() {
        int colonIndex;
        String name = this.getNodeName();
        if (this.isLeaf() && (colonIndex = name.indexOf(":")) > 0) {
            name = name.substring(colonIndex + 1);
        }
        return name;
    }

    public String getCleanNodeName() {
        return this.getCleanNodeName(true);
    }

    public String getCleanNodeName(boolean specialNodesAsRegex) {
        String name = this.getNodeName();
        if (specialNodesAsRegex && this.isDataDriven()) {
            name = "(.+?)";
        } else if (this.isLeaf()) {
            int queryIndex;
            int bracketIndex;
            int colonIndex = name.indexOf(":");
            if (colonIndex > 0) {
                name = name.substring(colonIndex + 1);
            }
            if ((bracketIndex = name.lastIndexOf("(")) > 0) {
                name = name.substring(0, bracketIndex);
            }
            if ((queryIndex = name.indexOf("?")) > 0) {
                name = name.substring(0, queryIndex);
            }
        }
        return name;
    }

    public String getHierarchicNodeName() {
        return this.getHierarchicNodeName(true);
    }

    public String getHierarchicNodeName(boolean specialNodesAsRegex) {
        if (this.hierarchicNodeName != null && specialNodesAsRegex) {
            return this.hierarchicNodeName;
        }
        if (this.isRoot()) {
            this.hierarchicNodeName = "";
        } else if (this.getParent().isRoot()) {
            this.hierarchicNodeName = this.getNodeName();
        } else {
            String nodeName = this.getCleanNodeName(specialNodesAsRegex);
            String name = nodeName.startsWith("/") ? this.getParent().getHierarchicNodeName(specialNodesAsRegex) + nodeName : this.getParent().getHierarchicNodeName(specialNodesAsRegex) + "/" + nodeName;
            if (!specialNodesAsRegex) {
                return name;
            }
            this.hierarchicNodeName = name;
        }
        return this.hierarchicNodeName;
    }

    public HistoryReference getHistoryReference() {
        return this.historyReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHistoryReference(HistoryReference historyReference) {
        if (this.getHistoryReference() != null) {
            if (this.justSpidered && (historyReference.getHistoryType() == 1 || historyReference.getHistoryType() == 15)) {
                this.justSpidered = false;
                this.nodeChanged();
            }
            if (!(this.icons.isEmpty() || historyReference.getHistoryType() != 1 && historyReference.getHistoryType() != 15)) {
                ArrayList<String> arrayList = this.icons;
                synchronized (arrayList) {
                    for (int i = 0; i < this.clearIfManual.size(); ++i) {
                        if (!this.clearIfManual.get(i).booleanValue() || this.icons.size() <= i) continue;
                        this.icons.remove(i);
                        this.clearIfManual.remove(i);
                    }
                }
                this.nodeChanged();
            }
            if (3 == historyReference.getHistoryType()) {
                this.getPastHistoryReference().add(historyReference);
                return;
            }
            if (!this.getPastHistoryReference().contains(this.getHistoryReference())) {
                this.getPastHistoryReference().add(this.getHistoryReference());
            }
        }
        this.historyReference = historyReference;
        this.historyReference.setSiteNode(this);
    }

    private void nodeChanged() {
        if (this.siteMap == null || !View.isInitialised()) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            this.nodeChangedEventHandler();
        } else {
            try {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SiteNode.this.nodeChangedEventHandler();
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void nodeChangedEventHandler() {
        this.siteMap.nodeChanged(this);
    }

    public Vector<HistoryReference> getPastHistoryReference() {
        return this.pastHistoryList;
    }

    public boolean hasAlert(Alert alert) {
        if (alert == null) {
            throw new IllegalArgumentException("Alert must not be null");
        }
        return this.alerts.contains(alert);
    }

    public void addAlert(Alert alert) {
        if (alert == null) {
            throw new IllegalArgumentException("Alert must not be null");
        }
        if (!this.alerts.add(alert)) {
            return;
        }
        if (this.isHighestAlert(alert)) {
            this.highestAlert = alert;
        }
        if (this.getParent() != null) {
            this.getParent().addAlert(alert);
        }
        if (this.siteMap != null) {
            this.siteMap.applyFilter(this);
        }
        this.nodeChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAlert(Alert alert) {
        if (alert == null) {
            throw new IllegalArgumentException("Alert must not be null");
        }
        boolean updated = false;
        Set<Alert> set = this.alerts;
        synchronized (set) {
            Iterator<Alert> it = this.alerts.iterator();
            while (it.hasNext()) {
                if (it.next().getAlertId() != alert.getAlertId()) continue;
                it.remove();
                updated = true;
                this.alerts.add(alert);
                this.setCalculateHighestAlertIfSameAlert(alert);
                break;
            }
        }
        if (updated) {
            if (this.getParent() != null) {
                this.getParent().updateAlert(alert);
            }
            if (this.siteMap != null) {
                this.siteMap.applyFilter(this);
            }
            this.nodeChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Alert> getAlerts() {
        Set<Alert> set = this.alerts;
        synchronized (set) {
            return new ArrayList<Alert>(this.alerts);
        }
    }

    private void clearChildAlert(Alert alert, SiteNode child) {
        boolean removed = true;
        this.alerts.remove(alert);
        if (this.getChildCount() > 0) {
            SiteNode c = (SiteNode)this.getFirstChild();
            while (c != null) {
                if (!c.equals(child) && c.hasAlert(alert)) {
                    this.alerts.add(alert);
                    removed = false;
                    break;
                }
                c = (SiteNode)this.getChildAfter(c);
            }
        }
        if (removed) {
            this.setCalculateHighestAlertIfSameAlert(alert);
            this.nodeChanged();
            if (this.getParent() != null) {
                this.getParent().clearChildAlert(alert, this);
            }
        }
    }

    public void deleteAlert(Alert alert) {
        if (alert == null) {
            throw new IllegalArgumentException("Alert must not be null");
        }
        if (!this.alerts.remove(alert)) {
            return;
        }
        this.setCalculateHighestAlertIfSameAlert(alert);
        if (this.getParent() != null) {
            this.getParent().clearChildAlert(alert, this);
        }
        if (this.siteMap != null) {
            this.siteMap.applyFilter(this);
        }
        this.nodeChanged();
    }

    private void setCalculateHighestAlertIfSameAlert(Alert alert) {
        if (this.highestAlert != null && this.highestAlert.getAlertId() == alert.getAlertId()) {
            this.calculateHighestAlert = true;
            this.highestAlert = null;
        }
    }

    public void deleteAlerts(List<Alert> alerts) {
        if (this.alerts.removeAll(alerts)) {
            if (this.getParent() != null) {
                this.getParent().clearChildAlerts(alerts);
            }
            if (this.siteMap != null) {
                this.siteMap.applyFilter(this);
            }
            this.calculateHighestAlert = true;
            this.nodeChanged();
        }
    }

    public void deleteAllAlerts() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            ((SiteNode)this.getChildAt(i)).deleteAllAlerts();
        }
        if (!this.alerts.isEmpty()) {
            this.alerts.clear();
            this.highestAlert = null;
            this.calculateHighestAlert = false;
            if (this.siteMap != null) {
                this.siteMap.applyFilter(this);
            }
            this.nodeChanged();
        }
    }

    private void clearChildAlerts(List<Alert> alerts) {
        boolean changed;
        ArrayList<Alert> alertsToRemove = new ArrayList<Alert>(alerts);
        if (this.getChildCount() > 0) {
            SiteNode c = (SiteNode)this.getFirstChild();
            while (c != null) {
                alertsToRemove.removeAll(c.alerts);
                c = (SiteNode)this.getChildAfter(c);
            }
        }
        if (changed = this.alerts.removeAll(alertsToRemove)) {
            this.calculateHighestAlert = true;
            if (this.getParent() != null) {
                this.getParent().clearChildAlerts(alertsToRemove);
            }
            this.nodeChangedEventHandler();
        }
    }

    public boolean hasHistoryType(int type) {
        if (this.historyReference == null) {
            return false;
        }
        if (this.historyReference.getHistoryType() == type) {
            return true;
        }
        for (HistoryReference href : this.pastHistoryList) {
            if (href.getHistoryType() != type) continue;
            return true;
        }
        return false;
    }

    public boolean hasJustHistoryType(int type) {
        if (this.historyReference == null) {
            return false;
        }
        if (this.historyReference.getHistoryType() != type) {
            return false;
        }
        for (HistoryReference href : this.pastHistoryList) {
            if (href.getHistoryType() == type) continue;
            return false;
        }
        return true;
    }

    public boolean isIncludedInScope() {
        return this.isIncludedInScope;
    }

    public void setIncludedInScope(boolean isIncludedInScope, boolean applyToChildNodes) {
        this.isIncludedInScope = isIncludedInScope;
        if (this.siteMap != null) {
            this.siteMap.applyFilter(this);
        }
        this.nodeChanged();
        if (applyToChildNodes && this.getChildCount() > 0) {
            SiteNode c = (SiteNode)this.getFirstChild();
            while (c != null) {
                c.setIncludedInScope(isIncludedInScope, applyToChildNodes);
                c = (SiteNode)this.getChildAfter(c);
            }
        }
    }

    public boolean isExcludedFromScope() {
        return this.isExcludedFromScope;
    }

    public void setExcludedFromScope(boolean isExcludedFromScope, boolean applyToChildNodes) {
        this.isExcludedFromScope = isExcludedFromScope;
        if (isExcludedFromScope) {
            this.isIncludedInScope = false;
        }
        if (this.siteMap != null) {
            this.siteMap.applyFilter(this);
        }
        this.nodeChanged();
        if (applyToChildNodes && this.getChildCount() > 0) {
            SiteNode c = (SiteNode)this.getFirstChild();
            while (c != null) {
                c.setExcludedFromScope(isExcludedFromScope, applyToChildNodes);
                c = (SiteNode)this.getChildAfter(c);
            }
        }
    }

    @Override
    public void setParent(MutableTreeNode newParent) {
        if (newParent == this) {
            return;
        }
        super.setParent(newParent);
    }

    @Override
    public SiteNode getParent() {
        return (SiteNode)super.getParent();
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    protected void setFiltered(boolean filtered) {
        this.filtered = filtered;
    }

    public boolean isDataDriven() {
        return this.dataDriven;
    }
}

