/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zaproxy.zap.utils.DisplayUtils;

public class AbstractFrame
extends JFrame {
    private static final long serialVersionUID = 6751593232255236597L;
    private static final String PREF_WINDOW_STATE = "window.state";
    private static final String PREF_WINDOW_SIZE = "window.size";
    private static final String PREF_WINDOW_POSITION = "window.position";
    private static final int WINDOW_DEFAULT_WIDTH = 800;
    private static final int WINDOW_DEFAULT_HEIGHT = 600;
    private final Preferences preferences;
    private final String prefnzPrefix = this.getClass().getSimpleName() + ".";
    private static final Logger LOGGER = LogManager.getLogger(AbstractFrame.class);

    public AbstractFrame() {
        this.preferences = Preferences.userNodeForPackage(this.getClass());
        this.initialize();
    }

    private void initialize() {
        Point point;
        this.setIconImages(DisplayUtils.getZapIconImages());
        this.setVisible(false);
        this.setTitle("OWASP ZAP");
        Dimension dim = this.restoreWindowSize();
        if (dim == null) {
            this.setSize(800, 600);
        }
        if ((point = this.restoreWindowLocation()) == null) {
            this.centerFrame();
        }
        this.restoreWindowState();
        this.addWindowStateListener(new FrameWindowStateListener());
        this.addComponentListener(new FrameResizedListener());
    }

    public void centerFrame() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    private void saveWindowState(int windowstate) {
        if ((windowstate & 1) == 1) {
            this.preferences.put(this.prefnzPrefix + PREF_WINDOW_STATE, SimpleWindowState.ICONIFIED.toString());
            LOGGER.debug("Saving preference {}={}", (Object)PREF_WINDOW_STATE, (Object)SimpleWindowState.ICONIFIED);
        }
        if ((windowstate & 6) == 6) {
            this.preferences.put(this.prefnzPrefix + PREF_WINDOW_STATE, SimpleWindowState.MAXIMIZED.toString());
            LOGGER.debug("Saving preference {}={}", (Object)PREF_WINDOW_STATE, (Object)SimpleWindowState.MAXIMIZED);
        }
        if (windowstate == 0) {
            this.preferences.put(this.prefnzPrefix + PREF_WINDOW_STATE, SimpleWindowState.NORMAL.toString());
            LOGGER.debug("Saving preference {}={}", (Object)PREF_WINDOW_STATE, (Object)SimpleWindowState.NORMAL);
        }
    }

    private SimpleWindowState restoreWindowState() {
        SimpleWindowState laststate = null;
        String statestr = this.preferences.get(this.prefnzPrefix + PREF_WINDOW_STATE, null);
        LOGGER.debug("Restoring preference {}={}", (Object)PREF_WINDOW_STATE, (Object)statestr);
        if (statestr != null) {
            SimpleWindowState state = null;
            try {
                state = SimpleWindowState.valueOf(statestr);
            }
            catch (IllegalArgumentException e) {
                state = null;
            }
            if (state != null) {
                switch (state) {
                    case ICONIFIED: {
                        this.setExtendedState(1);
                        break;
                    }
                    case NORMAL: {
                        this.setExtendedState(0);
                        break;
                    }
                    case MAXIMIZED: {
                        this.setExtendedState(6);
                        break;
                    }
                    default: {
                        LOGGER.error("Invalid window state (nothing will be changed): {}", (Object)statestr);
                    }
                }
            }
            laststate = state;
        }
        return laststate;
    }

    private void saveWindowSize(Dimension size) {
        if (size != null) {
            if (this.getExtendedState() == 0) {
                LOGGER.debug("Saving preference {}={},{}", (Object)PREF_WINDOW_SIZE, (Object)size.width, (Object)size.height);
                this.preferences.put(this.prefnzPrefix + PREF_WINDOW_SIZE, size.width + "," + size.height);
            } else {
                LOGGER.debug("Preference {} not saved, cause window state is not 'normal'.", (Object)PREF_WINDOW_SIZE);
            }
        }
    }

    private Dimension restoreWindowSize() {
        Dimension result = null;
        String sizestr = this.preferences.get(this.prefnzPrefix + PREF_WINDOW_SIZE, null);
        if (sizestr != null) {
            int width = 0;
            int height = 0;
            String[] sizes = sizestr.split("[,]");
            try {
                width = Integer.parseInt(sizes[0].trim());
                height = Integer.parseInt(sizes[1].trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (width > 0 && height > 0) {
                result = new Dimension(width, height);
                LOGGER.debug("Restoring preference {}={},{}", (Object)PREF_WINDOW_SIZE, (Object)result.width, (Object)result.height);
                this.setSize(result);
            }
        }
        return result;
    }

    private void saveWindowLocation(Point point) {
        if (point != null) {
            if (this.getExtendedState() == 0) {
                LOGGER.debug("Saving preference {}={},{}", (Object)PREF_WINDOW_POSITION, (Object)point.x, (Object)point.y);
                this.preferences.put(this.prefnzPrefix + PREF_WINDOW_POSITION, point.x + "," + point.y);
            } else {
                LOGGER.debug("Preference {} not saved, cause window state is not 'normal'.", (Object)PREF_WINDOW_POSITION);
            }
        }
    }

    private Point restoreWindowLocation() {
        Point result = null;
        String sizestr = this.preferences.get(this.prefnzPrefix + PREF_WINDOW_POSITION, null);
        if (sizestr != null) {
            int x = 0;
            int y = 0;
            String[] sizes = sizestr.split("[,]");
            try {
                x = Integer.parseInt(sizes[0].trim());
                y = Integer.parseInt(sizes[1].trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (x > 0 && y > 0) {
                result = new Point(x, y);
                LOGGER.debug("Restoring preference {}={},{}", (Object)PREF_WINDOW_POSITION, (Object)result.x, (Object)result.y);
                this.setLocation(result);
            }
        }
        return result;
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            LOGGER.error("Error while saving the preferences", (Throwable)e);
        }
    }

    private static enum SimpleWindowState {
        ICONIFIED,
        NORMAL,
        MAXIMIZED;

    }

    private final class FrameResizedListener
    extends ComponentAdapter {
        private FrameResizedListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (e.getComponent() != null) {
                AbstractFrame.this.saveWindowSize(e.getComponent().getSize());
            }
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            if (e.getComponent() != null) {
                AbstractFrame.this.saveWindowLocation(e.getComponent().getLocation());
            }
        }
    }

    private final class FrameWindowStateListener
    implements WindowStateListener {
        private FrameWindowStateListener() {
        }

        @Override
        public void windowStateChanged(WindowEvent e) {
            AbstractFrame.this.saveWindowState(e.getNewState());
        }
    }
}

