/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.authentication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.authentication.AbstractAuthenticationMethodOptionsPanel;
import org.zaproxy.zap.authentication.AuthenticationMethod;
import org.zaproxy.zap.authentication.AuthenticationMethodType;
import org.zaproxy.zap.authentication.PostBasedAuthenticationMethodType;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.DefaultNameValuePair;
import org.zaproxy.zap.model.NameValuePair;
import org.zaproxy.zap.users.User;

public class JsonBasedAuthenticationMethodType
extends PostBasedAuthenticationMethodType {
    private static final Logger LOGGER = LogManager.getLogger(JsonBasedAuthenticationMethodType.class);
    private static final int METHOD_IDENTIFIER = 5;
    private static final String METHOD_NAME = Constant.messages.getString("authentication.method.jb.name");
    private static final String API_METHOD_NAME = "jsonBasedAuthentication";

    public JsonBasedAuthenticationMethodType() {
        super(METHOD_NAME, 5, API_METHOD_NAME, "authentication.method.jb.popup.login.request", true);
    }

    private static void setValue(JSONObject jsonObject, String[] keys, int idx, String value) {
        Object obj = jsonObject.get(keys[idx]);
        if (obj instanceof JSONObject) {
            JsonBasedAuthenticationMethodType.setValue((JSONObject)obj, keys, idx + 1, value);
        } else if (obj instanceof String) {
            jsonObject.put((Object)keys[idx], (Object)value);
        }
    }

    @Override
    public boolean isTypeForMethod(AuthenticationMethod method) {
        return method instanceof JsonBasedAuthenticationMethod;
    }

    @Override
    public JsonBasedAuthenticationMethod createAuthenticationMethod(int contextId) {
        return new JsonBasedAuthenticationMethod();
    }

    @Override
    public AbstractAuthenticationMethodOptionsPanel buildOptionsPanel(Context uiSharedContext) {
        return new JsonBasedAuthenticationMethodOptionsPanel(uiSharedContext);
    }

    private class JsonBasedAuthenticationMethodOptionsPanel
    extends PostBasedAuthenticationMethodType.PostBasedAuthenticationMethodOptionsPanel {
        private static final long serialVersionUID = 1L;
        private JSONObject jsonObject;

        public JsonBasedAuthenticationMethodOptionsPanel(Context context) {
            super(JsonBasedAuthenticationMethodType.this, context, StringEscapeUtils::unescapeJson);
        }

        @Override
        protected List<NameValuePair> extractParameters(String postData) {
            if (postData.isEmpty()) {
                this.jsonObject = null;
                return Collections.emptyList();
            }
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            try {
                this.jsonObject = JSONObject.fromObject((Object)postData);
                this.extractJsonStrings(this.jsonObject, "", params);
            }
            catch (JSONException e) {
                LOGGER.debug("Unable to parse as JSON: {}", (Object)postData, (Object)e);
                this.jsonObject = null;
                return Collections.emptyList();
            }
            return params;
        }

        private void extractJsonStrings(JSONObject jsonObject, String parent, List<NameValuePair> params) {
            for (Object key : jsonObject.keySet()) {
                Object obj = jsonObject.get(key);
                if (obj instanceof JSONObject) {
                    this.extractJsonStrings((JSONObject)obj, this.normalisedKey(parent, (String)key), params);
                    continue;
                }
                if (!(obj instanceof String)) continue;
                params.add(new DefaultNameValuePair(this.normalisedKey(parent, (String)key), (String)obj));
            }
        }

        private String normalisedKey(String parent, String key) {
            return parent.isEmpty() ? key : parent + "." + key;
        }

        @Override
        protected String replaceParameterValue(String originalString, NameValuePair parameter, String replaceString) {
            if (this.jsonObject == null) {
                return originalString;
            }
            JsonBasedAuthenticationMethodType.setValue(this.jsonObject, parameter.getName().split("\\."), 0, replaceString);
            return this.jsonObject.toString();
        }
    }

    public class JsonBasedAuthenticationMethod
    extends PostBasedAuthenticationMethodType.PostBasedAuthenticationMethod {
        public JsonBasedAuthenticationMethod() {
            this(null);
        }

        private JsonBasedAuthenticationMethod(JsonBasedAuthenticationMethod jsonBasedAuthenticationMethod) {
            super(JsonBasedAuthenticationMethodType.this, "application/json", StringEscapeUtils::escapeJson, jsonBasedAuthenticationMethod);
        }

        @Override
        public AuthenticationMethodType getType() {
            return new JsonBasedAuthenticationMethodType();
        }

        @Override
        public AuthenticationMethod duplicate() {
            return new JsonBasedAuthenticationMethod(this);
        }

        @Override
        public void replaceUserDataInPollRequest(HttpMessage msg, User user) {
            PostBasedAuthenticationMethodType.replaceUserCredentialsDataInPollRequest(msg, user, AuthenticationMethodType.NULL_ENCODER);
        }
    }
}

