/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Year;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.zaproxy.zap.extension.api.AbstractAPIGenerator;
import org.zaproxy.zap.extension.api.ApiElement;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiParameter;

public class NodeJSAPIGenerator
extends AbstractAPIGenerator {
    private static final String DEFAULT_OUTPUT_DIR = "../zap-api-nodejs/src/";
    private final String HEADER = "/* Zed Attack Proxy (ZAP) and its related class files.\n *\n * ZAP is an HTTP/HTTPS proxy for assessing web application security.\n *\n * Copyright " + Year.now() + " the ZAP development team\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n";
    private static final Map<String, String> nameMap;

    public NodeJSAPIGenerator() {
        super(DEFAULT_OUTPUT_DIR);
    }

    public NodeJSAPIGenerator(String path, boolean optional) {
        super(path, optional);
    }

    public NodeJSAPIGenerator(String path, boolean optional, ResourceBundle resourceBundle) {
        super(path, optional, resourceBundle);
    }

    private void generateNodeJSElement(ApiElement element, String component, String type, Writer out) throws IOException {
        boolean hasParams;
        String className;
        block10: {
            className = NodeJSAPIGenerator.createClassName(component);
            hasParams = !element.getParameters().isEmpty();
            String descTag = element.getDescriptionTag();
            try {
                String desc = this.getMessages().getString(descTag);
                out.write("/**\n");
                out.write(" * " + desc + "\n");
                if (this.isOptional()) {
                    out.write(" * This component is optional and therefore the API will only work if it is installed\n");
                }
                if (hasParams) {
                    out.write(" * @param {string} " + element.getParameters().stream().map(parameter -> {
                        Object description = "";
                        if (this.getMessages().containsKey(parameter.getDescriptionKey())) {
                            String paramDesc = this.getMessages().getString(parameter.getDescriptionKey());
                            description = paramDesc.length() == 0 ? "" : " - " + paramDesc;
                        }
                        return NodeJSAPIGenerator.safeName(parameter.getName().toLowerCase(Locale.ROOT)) + (String)description;
                    }).collect(Collectors.joining("\n * @param {string} ")));
                    out.write("\n");
                }
                out.write(" **/\n");
            }
            catch (Exception e2) {
                System.out.println("No i18n for: " + descTag);
                if (!this.isOptional()) break block10;
                out.write("/**\n");
                out.write(" * This component is optional and therefore the API will only work if it is installed\n");
                out.write(" **/\n");
            }
        }
        out.write(className + ".prototype." + NodeJSAPIGenerator.createMethodName(element.getName()) + " = function (");
        if (hasParams) {
            out.write("args");
        }
        out.write(") {\n");
        String reqParams = "";
        if (hasParams) {
            StringBuilder reqParamsBuilder = new StringBuilder();
            reqParamsBuilder.append("{");
            reqParamsBuilder.append(element.getParameters().stream().filter(ApiParameter::isRequired).map(ApiParameter::getName).map(name -> "'" + name + "': args." + NodeJSAPIGenerator.safeName(name.toLowerCase(Locale.ROOT))).collect(Collectors.joining(", ")));
            reqParamsBuilder.append(" }");
            reqParams = reqParamsBuilder.toString();
            List optionalParameters = element.getParameters().stream().filter(e -> !e.isRequired()).collect(Collectors.toList());
            if (!optionalParameters.isEmpty()) {
                out.write("  const params = ");
                out.write(reqParams);
                out.write(";\n");
                reqParams = "params";
                for (ApiParameter parameter2 : optionalParameters) {
                    String name2 = parameter2.getName();
                    String varName = NodeJSAPIGenerator.safeName(name2.toLowerCase(Locale.ROOT));
                    out.write("  if (args." + varName + " && args." + varName + " !== null) {\n");
                    out.write("    params['" + name2 + "'] = args." + varName + ";\n");
                    out.write("  }\n");
                }
            }
        }
        out.write("    return this.api.request('/" + component + "/" + type + "/" + element.getName() + "/'");
        if (hasParams) {
            out.write(", ");
            out.write(reqParams);
        }
        if (type.equals("other")) {
            out.write(", 'other'");
        }
        out.write(")\n");
        out.write("}\n\n");
    }

    private static String safeName(String name) {
        if (nameMap.containsKey(name)) {
            return nameMap.get(name);
        }
        return name;
    }

    private static String createFileName(String name) {
        return NodeJSAPIGenerator.safeName(name) + ".js";
    }

    private static String createMethodName(String name) {
        return NodeJSAPIGenerator.removeAllFullStopCharacters(NodeJSAPIGenerator.safeName(name));
    }

    private static String createClassName(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private static String removeAllFullStopCharacters(String string) {
        return string.replaceAll("\\.", "");
    }

    @Override
    protected void generateAPIFiles(ApiImplementor imp) throws IOException {
        String className = NodeJSAPIGenerator.createClassName(imp.getPrefix());
        Path file = this.getDirectory().resolve(NodeJSAPIGenerator.createFileName(imp.getPrefix()));
        System.out.println("Generating " + file.toAbsolutePath());
        try (BufferedWriter out = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            out.write(this.HEADER);
            out.write("'use strict';\n\n");
            out.write("/**\n");
            out.write(" * This file was automatically generated.\n");
            out.write(" */\n");
            out.write("function " + className + "(clientApi) {\n");
            out.write("  this.api = clientApi;\n");
            out.write("}\n\n");
            for (ApiElement apiElement : imp.getApiViews()) {
                this.generateNodeJSElement(apiElement, imp.getPrefix(), "view", out);
            }
            for (ApiElement apiElement : imp.getApiActions()) {
                this.generateNodeJSElement(apiElement, imp.getPrefix(), "action", out);
            }
            for (ApiElement apiElement : imp.getApiOthers()) {
                this.generateNodeJSElement(apiElement, imp.getPrefix(), "other", out);
            }
            out.write("module.exports = " + className + ";\n");
        }
    }

    public static void main(String[] args) throws Exception {
        NodeJSAPIGenerator wapi = new NodeJSAPIGenerator();
        wapi.generateCoreAPIFiles();
    }

    static {
        HashMap<String, String> initMap = new HashMap<String, String>();
        initMap.put("break", "brk");
        initMap.put("boolean", "bool");
        initMap.put("continue", "cont");
        nameMap = Collections.unmodifiableMap(initMap);
    }
}

