/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.ScannerParam;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.core.scanner.VariantCookie;
import org.parosproxy.paros.core.scanner.VariantCustom;
import org.parosproxy.paros.core.scanner.VariantDdnPath;
import org.parosproxy.paros.core.scanner.VariantDirectWebRemotingQuery;
import org.parosproxy.paros.core.scanner.VariantFormQuery;
import org.parosproxy.paros.core.scanner.VariantGWTQuery;
import org.parosproxy.paros.core.scanner.VariantHeader;
import org.parosproxy.paros.core.scanner.VariantJSONQuery;
import org.parosproxy.paros.core.scanner.VariantMultipartFormParameters;
import org.parosproxy.paros.core.scanner.VariantODataFilterQuery;
import org.parosproxy.paros.core.scanner.VariantODataIdQuery;
import org.parosproxy.paros.core.scanner.VariantScript;
import org.parosproxy.paros.core.scanner.VariantURLPath;
import org.parosproxy.paros.core.scanner.VariantURLQuery;
import org.parosproxy.paros.core.scanner.VariantUserDefined;
import org.parosproxy.paros.core.scanner.VariantXMLQuery;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.extension.script.ScriptWrapper;
import org.zaproxy.zap.extension.script.ScriptsCache;

public class VariantFactory {
    private static final Logger LOGGER = LogManager.getLogger(VariantFactory.class);
    private ExtensionScript extension;
    private final List<Class<? extends Variant>> customVariants = new ArrayList<Class<? extends Variant>>();
    private ScriptsCache<VariantScript> scripts;

    public void addVariant(Class<? extends Variant> variantClass) {
        this.customVariants.add(variantClass);
    }

    public void removeVariant(Class<? extends Variant> variantClass) {
        this.customVariants.remove(variantClass);
    }

    public List<Variant> createVariants(ScannerParam scanOptions, HttpMessage message) {
        ArrayList<Variant> listVariant = new ArrayList<Variant>();
        int targets = scanOptions.getTargetParamsInjectable();
        int enabledRPC = scanOptions.getTargetParamsEnabledRPC();
        if ((targets & 1) != 0) {
            VariantURLQuery vuq = new VariantURLQuery();
            vuq.setAddQueryParam(scanOptions.isAddQueryParam());
            listVariant.add(vuq);
            if ((enabledRPC & 0x10) != 0) {
                listVariant.add(new VariantODataIdQuery());
                listVariant.add(new VariantODataFilterQuery());
            }
            if ((targets & 0x10) == 0) {
                listVariant.add(new VariantDdnPath());
            }
        }
        if ((targets & 2) != 0) {
            listVariant.add(new VariantFormQuery());
            if ((enabledRPC & 1) != 0) {
                listVariant.add(new VariantMultipartFormParameters());
            }
            if ((enabledRPC & 2) != 0) {
                listVariant.add(new VariantXMLQuery());
            }
            if ((enabledRPC & 4) != 0) {
                VariantJSONQuery variant = new VariantJSONQuery();
                variant.setScanNullValues(scanOptions.isScanNullJsonValues());
                listVariant.add(variant);
            }
            if ((enabledRPC & 8) != 0) {
                listVariant.add(new VariantGWTQuery());
            }
            if ((enabledRPC & 0x20) != 0) {
                listVariant.add(new VariantDirectWebRemotingQuery());
            }
        }
        if ((targets & 8) != 0) {
            boolean addVariant = scanOptions.isScanHeadersAllRequests();
            if (!addVariant) {
                char[] query = message.getRequestHeader().getURI().getRawQuery();
                boolean bl = addVariant = query != null && query.length != 0 || message.getRequestBody().length() != 0;
            }
            if (addVariant) {
                listVariant.add(new VariantHeader());
            }
        }
        if ((targets & 0x10) != 0) {
            listVariant.add(new VariantURLPath());
        }
        if ((targets & 4) != 0) {
            listVariant.add(new VariantCookie());
        }
        if ((enabledRPC & 0x80) != 0 && this.getExtension() != null) {
            List<ScriptWrapper> scripts = this.getExtension().getScripts("variant");
            for (ScriptWrapper script : scripts) {
                if (!script.isEnabled()) continue;
                listVariant.add(new VariantCustom(script, this.getExtension()));
            }
        }
        if ((enabledRPC & 0x100) != 0) {
            listVariant.add(new VariantUserDefined());
        }
        this.addCustomVariants(listVariant);
        return listVariant;
    }

    public List<Variant> createSiteModifyingVariants() {
        ArrayList<Variant> listVariant = new ArrayList<Variant>();
        this.addScriptVariants(listVariant);
        this.addCustomVariants(listVariant);
        return listVariant;
    }

    private void addScriptVariants(List<Variant> list) {
        if (this.getScripts() == null) {
            return;
        }
        this.scripts.refreshAndExecute((sw, s) -> list.add(new VariantCustom(sw, (VariantScript)s, this.extension)));
    }

    private void addCustomVariants(List<Variant> list) {
        for (Class<? extends Variant> variant : this.customVariants) {
            try {
                list.add(variant.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private ScriptsCache<VariantScript> getScripts() {
        if (this.scripts == null) {
            this.scripts = this.getExtension() != null ? this.extension.createScriptsCache(ScriptsCache.Configuration.builder().setScriptType("variant").setTargetInterface(VariantScript.class).setInterfaceErrorMessageProvider(sw -> Constant.messages.getString("variant.scripts.interface.variant.error", sw.getName())).build()) : null;
        }
        return this.scripts;
    }

    private ExtensionScript getExtension() {
        if (this.extension == null) {
            this.extension = Control.getSingleton().getExtensionLoader().getExtension(ExtensionScript.class);
        }
        return this.extension;
    }
}

