/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.compare;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.httpclient.URI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordHistory;
import org.parosproxy.paros.db.TableHistory;
import org.parosproxy.paros.db.paros.ParosDatabase;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.extension.option.DatabaseParam;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SessionListener;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.zaproxy.zap.utils.DesktopUtils;
import org.zaproxy.zap.utils.XmlUtils;
import org.zaproxy.zap.view.widgets.WritableFileChooser;

public class ExtensionCompare
extends ExtensionAdaptor
implements SessionChangedListener,
SessionListener {
    private static final String NAME = "ExtensionCompare";
    private static final SimpleDateFormat staticDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
    private static final String CRLF = "\r\n";
    private JMenuItem menuCompare = null;
    private static final Logger LOGGER = LogManager.getLogger(ExtensionCompare.class);

    public ExtensionCompare() {
        super(NAME);
        this.setOrder(44);
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("cmp.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.getHookMenu().addReportMenuItem(this.getMenuCompare());
        }
    }

    @Override
    public void sessionChanged(final Session session) {
        if (EventQueue.isDispatchThread()) {
            this.sessionChangedEventHandler(session);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExtensionCompare.this.sessionChangedEventHandler(session);
                    }
                });
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void sessionChangedEventHandler(Session session) {
    }

    @Override
    public void sessionScopeChanged(Session session) {
    }

    private JMenuItem getMenuCompare() {
        if (this.menuCompare == null) {
            this.menuCompare = new JMenuItem();
            this.menuCompare.setText(Constant.messages.getString("cmp.file.menu.compare"));
            this.menuCompare.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExtensionCompare.this.compareSessions();
                }
            });
        }
        return this.menuCompare;
    }

    private void buildHistoryMap(TableHistory th, Map<String, String> map) throws DatabaseException, HttpMalformedHeaderException {
        RecordHistory rh = null;
        for (int i = 0; i < 100 && (rh = th.read(i)) == null; ++i) {
        }
        if (rh == null) {
            return;
        }
        List<Integer> hIds = th.getHistoryIdsOfHistType(rh.getSessionId(), 1, 15, 2, 10);
        for (Integer hId : hIds) {
            RecordHistory recH = th.read(hId);
            URI uri = recH.getHttpMessage().getRequestHeader().getURI();
            Object mapKey = recH.getHttpMessage().getRequestHeader().getMethod() + " " + uri.toString();
            if (((String)mapKey).indexOf("?") > -1) {
                mapKey = ((String)mapKey).substring(0, ((String)mapKey).indexOf("?"));
            }
            String val = map.get(mapKey);
            String code = recH.getHttpMessage().getResponseHeader().getStatusCode() + " ";
            if (val == null) {
                map.put((String)mapKey, code);
                continue;
            }
            if (val.indexOf(code) >= 0) continue;
            map.put((String)mapKey, val + code);
        }
    }

    private void compareSessions() {
        block24: {
            JFileChooser chooser = new JFileChooser(Model.getSingleton().getOptionsParam().getUserDirectory());
            File file = null;
            chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    return file.isFile() && file.getName().endsWith(".session");
                }

                @Override
                public String getDescription() {
                    return Constant.messages.getString("file.format.zap.session");
                }
            });
            int rc = chooser.showOpenDialog(this.getView().getMainFrame());
            if (rc == 0) {
                try {
                    file = chooser.getSelectedFile();
                    if (file == null) {
                        return;
                    }
                    Model cmpModel = new Model();
                    Session session = cmpModel.getSession();
                    cmpModel.openSession(file, (SessionListener)this);
                    ParosDatabase db = new ParosDatabase();
                    db.setDatabaseParam(new DatabaseParam());
                    db.open(file.getAbsolutePath());
                    HashMap<String, String> curMap = new HashMap<String, String>();
                    HashMap<String, String> cmpMap = new HashMap<String, String>();
                    this.buildHistoryMap(Model.getSingleton().getDb().getTableHistory(), curMap);
                    this.buildHistoryMap(db.getTableHistory(), cmpMap);
                    File outputFile = this.getOutputFile();
                    if (outputFile == null) break block24;
                    try {
                        TreeSet sset = new TreeSet();
                        sset.addAll(curMap.keySet());
                        sset.addAll(cmpMap.keySet());
                        StringBuilder sb = new StringBuilder(500);
                        sb.append("<?xml version=\"1.0\"?>");
                        sb.append(CRLF);
                        sb.append("<report>");
                        sb.append(CRLF);
                        sb.append("<session-names>");
                        sb.append(CRLF);
                        sb.append("<session1>");
                        sb.append(Model.getSingleton().getSession().getSessionName());
                        sb.append("</session1>");
                        sb.append(CRLF);
                        sb.append("<session2>");
                        sb.append(session.getSessionName());
                        sb.append("</session2>");
                        sb.append(CRLF);
                        sb.append("</session-names>");
                        sb.append(CRLF);
                        Iterator iter = sset.iterator();
                        while (iter.hasNext()) {
                            sb.append("<urlrow>");
                            sb.append(CRLF);
                            String key = (String)iter.next();
                            String method = key.substring(0, key.indexOf(" "));
                            String url = key.substring(key.indexOf(" ") + 1);
                            sb.append("<method>");
                            sb.append(method);
                            sb.append("</method>");
                            sb.append(CRLF);
                            sb.append("<url>");
                            sb.append(url);
                            sb.append("</url>");
                            sb.append(CRLF);
                            sb.append("<code1>");
                            if (curMap.containsKey(key)) {
                                sb.append((String)curMap.get(key));
                            } else {
                                sb.append("---");
                            }
                            sb.append("</code1>");
                            sb.append(CRLF);
                            sb.append("<code2>");
                            if (cmpMap.containsKey(key)) {
                                sb.append((String)cmpMap.get(key));
                            } else {
                                sb.append("---");
                            }
                            sb.append("</code2>");
                            sb.append(CRLF);
                            sb.append("</urlrow>");
                            sb.append(CRLF);
                        }
                        sb.append("</report>");
                        sb.append(CRLF);
                        String fileName = "reportCompare.xsl";
                        Path xslFile = Paths.get(Constant.getZapInstall(), "xml", fileName);
                        if (Files.exists(xslFile, new LinkOption[0])) {
                            ExtensionCompare.stringToHtml(sb.toString(), xslFile.toString(), outputFile.getAbsolutePath());
                        } else {
                            String path = "/org/zaproxy/zap/resources/xml/" + fileName;
                            try (InputStream is = ExtensionCompare.class.getResourceAsStream(path);){
                                if (is == null) {
                                    LOGGER.error("Bundled file not found: {}", (Object)path);
                                    return;
                                }
                                ExtensionCompare.stringToHtml(sb.toString(), new StreamSource(is), outputFile.getAbsolutePath());
                            }
                        }
                        if (Files.notExists(outputFile.toPath(), new LinkOption[0])) {
                            LOGGER.info("Not opening report, does not exist: {}", (Object)outputFile);
                            return;
                        }
                        try {
                            DesktopUtils.openUrlInBrowser(outputFile.toURI());
                        }
                        catch (Exception e) {
                            LOGGER.error(e.getMessage(), (Throwable)e);
                            this.getView().showMessageDialog(Constant.messages.getString("report.complete.warning", outputFile.getAbsolutePath()));
                        }
                    }
                    catch (Exception e1) {
                        LOGGER.warn(e1.getMessage(), (Throwable)e1);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private static File stringToHtml(String inxml, String infilexsl, String outfilename) {
        return ExtensionCompare.stringToHtml(inxml, infilexsl != null ? new StreamSource(new File(infilexsl)) : null, outfilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File stringToHtml(String inxml, StreamSource stylesource, String outfilename) {
        if (stylesource != null) {
            Document doc = null;
            File outfile = null;
            StringReader inReader = new StringReader(inxml);
            String tempOutfilename = outfilename + ".temp";
            try {
                outfile = new File(tempOutfilename);
                DocumentBuilder builder = XmlUtils.newXxeDisabledDocumentBuilderFactory().newDocumentBuilder();
                doc = builder.parse(new InputSource(inReader));
                TransformerFactory tFactory = TransformerFactory.newInstance();
                Transformer transformer = tFactory.newTransformer(stylesource);
                transformer.setParameter("datetime", ExtensionCompare.getCurrentDateTimeString());
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(outfile.getPath());
                transformer.transform(source, result);
            }
            catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                BufferedWriter bw = null;
                try {
                    bw = Files.newBufferedWriter(new File(outfilename + "-orig.xml").toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
                    bw.write(inxml);
                    return new File(outfilename);
                }
                catch (IOException e2) {
                    LOGGER.error("Failed to write debug XML file", (Throwable)e);
                    File file = new File(outfilename);
                    return file;
                }
                finally {
                    try {
                        if (bw != null) {
                            bw.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            try (BufferedReader br = Files.newBufferedReader(new File(tempOutfilename).toPath(), StandardCharsets.UTF_8);
                 BufferedWriter bw = Files.newBufferedWriter(new File(outfilename).toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                String line;
                while ((line = br.readLine()) != null) {
                    bw.write(line.replace("&lt;p&gt;", "<p>").replace("&lt;/p&gt;", "</p>"));
                    bw.newLine();
                }
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            outfile.delete();
            return new File(outfilename);
        }
        BufferedWriter bw = null;
        try {
            bw = Files.newBufferedWriter(new File(outfilename).toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
            bw.write(inxml);
            return new File(outfilename);
        }
        catch (IOException e2) {
            LOGGER.error(e2.getMessage(), (Throwable)e2);
            return new File(outfilename);
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static String getCurrentDateTimeString() {
        Date dateTime = new Date(System.currentTimeMillis());
        return ExtensionCompare.getDateTimeString(dateTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDateTimeString(Date dateTime) {
        SimpleDateFormat simpleDateFormat = staticDateFormat;
        synchronized (simpleDateFormat) {
            return staticDateFormat.format(dateTime);
        }
    }

    private File getOutputFile() {
        WritableFileChooser chooser = new WritableFileChooser(this.getModel().getOptionsParam().getUserDirectory());
        chooser.setFileFilter(new FileNameExtensionFilter(Constant.messages.getString("file.format.html"), "htm", "html"));
        File file = null;
        int rc = chooser.showSaveDialog(this.getView().getMainFrame());
        if (rc == 0) {
            file = chooser.getSelectedFile();
            if (file == null) {
                return file;
            }
            String fileNameLc = file.getAbsolutePath().toLowerCase();
            if (!fileNameLc.endsWith(".htm") && !fileNameLc.endsWith(".html")) {
                file = new File(file.getAbsolutePath() + ".html");
            }
            return file;
        }
        return file;
    }

    @Override
    public void sessionOpened(File file, Exception e) {
    }

    @Override
    public void sessionSaved(Exception e) {
    }

    @Override
    public void sessionAboutToChange(Session session) {
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("cmp.desc");
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
    }

    @Override
    public void sessionSnapshot(Exception e) {
    }
}

