/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.extension.edit.ExtensionEdit;
import org.parosproxy.paros.view.FindDialog;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.httppanel.ComponentChangedEvent;
import org.zaproxy.zap.extension.httppanel.DisplayedMessageChangedListener;
import org.zaproxy.zap.extension.httppanel.InvalidMessageDataException;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.httppanel.MessagePanelEventListener;
import org.zaproxy.zap.extension.httppanel.MessageViewSelectedEvent;
import org.zaproxy.zap.extension.httppanel.component.HttpPanelComponentInterface;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelDefaultViewSelector;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelView;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.extension.search.SearchableHttpPanelComponent;

public abstract class HttpPanel
extends AbstractPanel {
    private static final long serialVersionUID = 5221591643257366570L;
    private static final Logger LOGGER = LogManager.getLogger(HttpPanel.class);
    private static final String NO_SUITABLE_COMPONENT_FOUND_LABEL = Constant.messages.getString("http.panel.noSuitableComponentFound");
    private static final String HTTP_PANEL_KEY = "httppanel.";
    private static final String COMPONENTS_KEY = "components.";
    private static final String DEFAULT_COMPONENT_KEY = "defaultcomponent";
    private static Comparator<HttpPanelComponentInterface> componentsComparator;
    private static Action findAction;
    private JPanel panelHeader;
    private JPanel panelContent;
    private boolean isEditable = false;
    private boolean isEnableViewSelect = false;
    protected Message message;
    private String baseConfigurationKey;
    private String componentsConfigurationKey;
    private List<DisplayedMessageChangedListener> displayedMessageChangedListeners = new ArrayList<DisplayedMessageChangedListener>();
    private SwitchComponentItemListener switchComponentItemListener;
    private Hashtable<String, HttpPanelComponentInterface> components = new Hashtable();
    private List<HttpPanelComponentInterface> enabledComponents = new ArrayList<HttpPanelComponentInterface>();
    private HttpPanelComponentInterface currentComponent;
    private JPanel noComponentsPanel;
    private String savedLastSelectedComponentName;
    private JPanel allOptions;
    private JPanel componentOptions;
    private JPanel moreOptionsComponent;
    private JToolBar toolBarComponents;
    private JToolBar toolBarMoreOptions;
    private JPanel endAllOptions;

    public HttpPanel(boolean isEditable, String configurationKey) {
        this.isEditable = isEditable;
        this.message = null;
        this.setConfigurationKey(configurationKey);
        this.initialize();
        this.initUi();
        this.initSpecial();
    }

    protected abstract void initComponents();

    protected abstract void initSpecial();

    private void setConfigurationKey(String key) {
        this.baseConfigurationKey = key + HTTP_PANEL_KEY;
        this.componentsConfigurationKey = this.baseConfigurationKey + COMPONENTS_KEY;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPanelHeader(), "North");
        this.add((Component)this.getPanelContent(), "Center");
    }

    private void initUi() {
        this.allOptions = new JPanel(new FlowLayout(1, 0, 0));
        this.componentOptions = new JPanel(new BorderLayout(0, 0));
        this.moreOptionsComponent = new JPanel(new BorderLayout(0, 0));
        this.toolBarComponents = new JToolBar();
        this.toolBarComponents.setFloatable(false);
        this.toolBarComponents.setBorder(BorderFactory.createEmptyBorder());
        this.toolBarComponents.setRollover(true);
        this.toolBarMoreOptions = new JToolBar();
        this.toolBarMoreOptions.setFloatable(false);
        this.toolBarMoreOptions.setBorder(BorderFactory.createEmptyBorder());
        this.toolBarMoreOptions.setRollover(true);
        this.toolBarMoreOptions.getActionMap().put("findAction", HttpPanel.getFindAction());
        this.toolBarMoreOptions.getInputMap(2).put(ExtensionEdit.getFindDefaultKeyStroke(), "findAction");
        this.endAllOptions = new JPanel();
        JPanel panel1 = new JPanel(new BorderLayout(0, 0));
        JPanel panelFlow = new JPanel(new FlowLayout(1, 0, 0));
        panelFlow.add(this.allOptions);
        panelFlow.add(this.componentOptions);
        panelFlow.add(this.toolBarComponents);
        panelFlow.add(this.moreOptionsComponent);
        panelFlow.add(this.toolBarMoreOptions);
        panel1.add((Component)panelFlow, "West");
        panelFlow = new JPanel(new FlowLayout(1, 0, 0));
        panelFlow.add(this.endAllOptions);
        panel1.add((Component)panelFlow, "East");
        this.panelHeader.add((Component)panel1, "North");
        this.initComponents();
        this.setMessage(null);
    }

    private JPanel getPanelContent() {
        if (this.panelContent == null) {
            this.panelContent = new JPanel(new CardLayout());
        }
        return this.panelContent;
    }

    private JPanel getPanelHeader() {
        if (this.panelHeader == null) {
            this.panelHeader = new JPanel(new BorderLayout());
        }
        return this.panelHeader;
    }

    private static Action getFindAction() {
        if (findAction == null) {
            findAction = new AbstractAction("findAction"){
                private static final long serialVersionUID = 8365172573382425660L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                    if (focusOwner instanceof JTextComponent) {
                        FindDialog findDialog = FindDialog.getDialog(SwingUtilities.getWindowAncestor(focusOwner), false);
                        findDialog.setLastInvoker((JTextComponent)focusOwner);
                    }
                }
            };
        }
        return findAction;
    }

    public void addDisplayedMessageChangedListener(DisplayedMessageChangedListener messageChangedListener) {
        this.displayedMessageChangedListeners.add(messageChangedListener);
    }

    public void removeDisplayedMessageChangedListener(DisplayedMessageChangedListener messageChangedListener) {
        this.displayedMessageChangedListeners.remove(messageChangedListener);
    }

    public void setMessage(Message msg) {
        Message oldMessage = this.message;
        this.message = msg;
        for (HttpPanelComponentInterface component : this.components.values()) {
            if (!component.isEnabled(this.message)) {
                if (!this.enabledComponents.contains(component)) continue;
                this.disableComponent(component);
                continue;
            }
            if (this.enabledComponents.contains(component)) continue;
            this.enableComponent(component);
        }
        if (this.enabledComponents.isEmpty()) {
            this.currentComponent = null;
            this.switchEmptyComponent();
            this.notifyDisplayedMessageChangedListeners(oldMessage, this.message);
            return;
        }
        boolean switchView = true;
        if (this.currentComponent != null && this.enabledComponents.contains(this.components.get(this.currentComponent.getName()))) {
            switchView = false;
        }
        this.validate();
        if (switchView) {
            this.switchComponent(this.enabledComponents.get(0).getName());
        } else {
            this.updateContent();
        }
        this.notifyDisplayedMessageChangedListeners(oldMessage, this.message);
    }

    private void notifyDisplayedMessageChangedListeners(Message oldMessage, Message message) {
        for (DisplayedMessageChangedListener changedListener : this.displayedMessageChangedListeners) {
            changedListener.messageChanged(oldMessage, message);
        }
    }

    protected HttpPanelComponentInterface getCurrentComponent() {
        return this.currentComponent;
    }

    public Message getMessage() {
        return this.message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEditable(boolean editable) {
        if (this.isEditable != editable) {
            this.isEditable = editable;
            Hashtable<String, HttpPanelComponentInterface> hashtable = this.components;
            synchronized (hashtable) {
                Iterator<HttpPanelComponentInterface> it = this.components.values().iterator();
                while (it.hasNext()) {
                    it.next().setEditable(editable);
                }
            }
        }
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void clearView() {
        this.setMessage(null);
        if (this.currentComponent != null) {
            this.currentComponent.clearView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnableViewSelect(boolean enableViewSelect) {
        if (this.isEnableViewSelect != enableViewSelect) {
            this.isEnableViewSelect = enableViewSelect;
            Hashtable<String, HttpPanelComponentInterface> hashtable = this.components;
            synchronized (hashtable) {
                for (HttpPanelComponentInterface component : this.components.values()) {
                    component.setEnableViewSelect(enableViewSelect);
                    component.getButton().setEnabled(enableViewSelect);
                }
            }
        }
    }

    public boolean isEnableViewSelect() {
        return this.isEnableViewSelect;
    }

    public void clearView(boolean enableViewSelect) {
        this.clearView();
        this.setEnableViewSelect(enableViewSelect);
    }

    public void setMessage(Message aMessage, boolean enableViewSelect) {
        this.setMessage(aMessage);
        this.setEnableViewSelect(enableViewSelect);
    }

    public void updateContent() {
        if (this.currentComponent != null) {
            this.currentComponent.setMessage(this.message);
        }
    }

    public void saveData() {
        if (this.message == null || this.currentComponent == null) {
            return;
        }
        this.currentComponent.save();
    }

    private void switchComponent(String name) {
        if (this.isCurrentComponent(name)) {
            this.currentComponent.setSelected(true);
            return;
        }
        HttpPanelComponentInterface newComponent = this.components.get(name);
        if (newComponent == null) {
            LOGGER.info("No component found with name: {}", (Object)name);
            return;
        }
        if (this.currentComponent != null) {
            this.currentComponent.setSelected(false);
            this.currentComponent.clearView();
            if (this.currentComponent.getOptionsPanel() != null) {
                this.componentOptions.remove(0);
            }
            if (this.currentComponent.getMoreOptionsPanel() != null) {
                this.moreOptionsComponent.remove(0);
            }
        }
        HttpPanelComponentInterface previousComponent = this.currentComponent;
        this.currentComponent = newComponent;
        this.updateContent();
        JPanel componentOptionsPanel = this.currentComponent.getOptionsPanel();
        if (componentOptionsPanel != null) {
            this.componentOptions.add(componentOptionsPanel);
        }
        this.componentOptions.validate();
        JPanel componentMoreOptionsPanel = this.currentComponent.getMoreOptionsPanel();
        if (componentMoreOptionsPanel != null) {
            this.moreOptionsComponent.add(componentMoreOptionsPanel);
        }
        this.moreOptionsComponent.validate();
        ((CardLayout)this.getPanelContent().getLayout()).show(this.panelContent, name);
        this.currentComponent.setSelected(true);
        this.fireComponentChangedEvent(previousComponent, this.currentComponent);
    }

    private boolean isCurrentComponent(String name) {
        return this.currentComponent != null && this.currentComponent.getName().equals(name);
    }

    protected List<HttpPanelComponentInterface> getEnabledComponents() {
        return this.enabledComponents;
    }

    private void switchEmptyComponent() {
        if (this.currentComponent != null) {
            this.currentComponent.setSelected(false);
            this.currentComponent.clearView();
            if (this.currentComponent.getOptionsPanel() != null) {
                this.componentOptions.remove(0);
            }
            if (this.currentComponent.getMoreOptionsPanel() != null) {
                this.moreOptionsComponent.remove(0);
            }
            this.currentComponent = null;
        }
        if (this.noComponentsPanel == null) {
            this.noComponentsPanel = new JPanel(new BorderLayout(5, 5));
            this.noComponentsPanel.add(new JLabel(NO_SUITABLE_COMPONENT_FOUND_LABEL));
            this.getPanelContent().add((Component)new JScrollPane(this.noComponentsPanel), "");
        }
        this.componentOptions.removeAll();
        this.componentOptions.validate();
        ((CardLayout)this.getPanelContent().getLayout()).show(this.panelContent, "");
    }

    public void addOptions(Component comp, OptionsLocation location) {
        switch (location) {
            case BEGIN: {
                this.allOptions.add(comp);
                break;
            }
            case AFTER_COMPONENTS: {
                this.toolBarMoreOptions.add(comp);
                break;
            }
            case END: {
                this.endAllOptions.add(comp);
                break;
            }
        }
    }

    public void addOptionsSeparator() {
        this.toolBarMoreOptions.addSeparator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addComponent(HttpPanelComponentInterface component) {
        Hashtable<String, HttpPanelComponentInterface> hashtable = this.components;
        synchronized (hashtable) {
            String componentName = component.getName();
            if (this.components.containsKey(componentName)) {
                this.removeComponent(componentName);
            }
            component.setEditable(this.isEditable);
            component.setEnableViewSelect(this.isEnableViewSelect);
            this.components.put(componentName, component);
            this.panelContent.add((Component)component.getMainPanel(), componentName);
            JToggleButton button = component.getButton();
            button.setActionCommand(componentName);
            button.addActionListener(this.getSwitchComponentItemListener());
            button.setEnabled(this.isEnableViewSelect);
            if (component.isEnabled(this.message)) {
                this.enableComponent(component);
                if (this.currentComponent == null) {
                    this.switchComponent(componentName);
                } else if (this.savedLastSelectedComponentName != null && this.savedLastSelectedComponentName.equals(componentName)) {
                    this.switchComponent(componentName);
                } else if (this.savedLastSelectedComponentName == null && this.currentComponent.getPosition() > component.getPosition()) {
                    this.switchComponent(componentName);
                }
            }
        }
    }

    private void enableComponent(HttpPanelComponentInterface component) {
        this.enabledComponents.add(component);
        Collections.sort(this.enabledComponents, HttpPanel.getComponentsComparator());
        if (this.enabledComponents.size() == 1) {
            this.toolBarComponents.addSeparator();
            this.toolBarComponents.addSeparator();
        }
        this.toolBarComponents.add((Component)component.getButton(), this.enabledComponents.indexOf(component) + 1);
    }

    private void disableComponent(HttpPanelComponentInterface component) {
        this.toolBarComponents.remove(component.getButton());
        this.enabledComponents.remove(component);
        if (this.enabledComponents.isEmpty()) {
            this.toolBarComponents.removeAll();
        }
    }

    public void addComponent(HttpPanelComponentInterface component, FileConfiguration fileConfiguration) {
        this.addComponent(component);
        component.setParentConfigurationKey(this.componentsConfigurationKey);
        component.loadConfig(fileConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeComponent(String componentName) {
        Hashtable<String, HttpPanelComponentInterface> hashtable = this.components;
        synchronized (hashtable) {
            HttpPanelComponentInterface component = this.components.get(componentName);
            if (component != null) {
                if (component.isEnabled(this.message)) {
                    this.disableComponent(component);
                }
                if (this.enabledComponents.size() > 0) {
                    this.switchComponent(this.enabledComponents.get(0).getName());
                } else {
                    this.switchEmptyComponent();
                }
                this.components.remove(componentName);
                this.panelContent.remove(component.getMainPanel());
                this.validate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addView(String componentName, HttpPanelView view, Object options, FileConfiguration fileConfiguration) {
        Hashtable<String, HttpPanelComponentInterface> hashtable = this.components;
        synchronized (hashtable) {
            HttpPanelComponentInterface component = this.components.get(componentName);
            if (component != null) {
                component.addView(view, options, fileConfiguration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeView(String componentName, String viewName, Object options) {
        Hashtable<String, HttpPanelComponentInterface> hashtable = this.components;
        synchronized (hashtable) {
            HttpPanelComponentInterface component = this.components.get(componentName);
            if (component != null) {
                component.removeView(viewName, options);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDefaultViewSelector(String componentName, HttpPanelDefaultViewSelector defaultViewSelector, Object options) {
        Hashtable<String, HttpPanelComponentInterface> hashtable = this.components;
        synchronized (hashtable) {
            HttpPanelComponentInterface component = this.components.get(componentName);
            if (component != null) {
                component.addDefaultViewSelector(defaultViewSelector, options);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDefaultViewSelector(String componentName, String defaultViewSelectorName, Object options) {
        Hashtable<String, HttpPanelComponentInterface> hashtable = this.components;
        synchronized (hashtable) {
            HttpPanelComponentInterface component = this.components.get(componentName);
            if (component != null) {
                component.removeDefaultViewSelector(defaultViewSelectorName, options);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfig(FileConfiguration fileConfiguration) {
        this.savedLastSelectedComponentName = fileConfiguration.getString(this.baseConfigurationKey + DEFAULT_COMPONENT_KEY);
        Hashtable<String, HttpPanelComponentInterface> hashtable = this.components;
        synchronized (hashtable) {
            Iterator<HttpPanelComponentInterface> it = this.components.values().iterator();
            while (it.hasNext()) {
                it.next().loadConfig(fileConfiguration);
            }
            if (this.savedLastSelectedComponentName != null && this.components.containsKey(this.savedLastSelectedComponentName)) {
                this.switchComponent(this.savedLastSelectedComponentName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfig(FileConfiguration fileConfiguration) {
        if (this.currentComponent != null) {
            fileConfiguration.setProperty(this.baseConfigurationKey + DEFAULT_COMPONENT_KEY, (Object)this.currentComponent.getName());
        }
        Hashtable<String, HttpPanelComponentInterface> hashtable = this.components;
        synchronized (hashtable) {
            Iterator<HttpPanelComponentInterface> it = this.components.values().iterator();
            while (it.hasNext()) {
                it.next().saveConfig(fileConfiguration);
            }
        }
    }

    private static Comparator<HttpPanelComponentInterface> getComponentsComparator() {
        if (componentsComparator == null) {
            HttpPanel.createComponentsComparator();
        }
        return componentsComparator;
    }

    private static synchronized void createComponentsComparator() {
        if (componentsComparator == null) {
            componentsComparator = new ComponentsComparator();
        }
    }

    private SwitchComponentItemListener getSwitchComponentItemListener() {
        if (this.switchComponentItemListener == null) {
            this.switchComponentItemListener = new SwitchComponentItemListener();
        }
        return this.switchComponentItemListener;
    }

    public void highlightHeader(SearchMatch sm) {
        if (this.currentComponent instanceof SearchableHttpPanelComponent) {
            ((SearchableHttpPanelComponent)((Object)this.currentComponent)).highlightHeader(sm);
        } else {
            HttpPanelComponentInterface component = this.findSearchablePanel();
            if (component != null) {
                this.switchComponent(component.getName());
                ((SearchableHttpPanelComponent)((Object)this.currentComponent)).highlightHeader(sm);
            }
        }
    }

    public void highlightBody(SearchMatch sm) {
        if (this.currentComponent instanceof SearchableHttpPanelComponent) {
            ((SearchableHttpPanelComponent)((Object)this.currentComponent)).highlightBody(sm);
        } else {
            HttpPanelComponentInterface component = this.findSearchablePanel();
            if (component != null) {
                this.switchComponent(component.getName());
                ((SearchableHttpPanelComponent)((Object)this.currentComponent)).highlightBody(sm);
            }
        }
    }

    public void headerSearch(Pattern p, List<SearchMatch> matches) {
        if (this.currentComponent instanceof SearchableHttpPanelComponent) {
            ((SearchableHttpPanelComponent)((Object)this.currentComponent)).searchHeader(p, matches);
        } else {
            HttpPanelComponentInterface component = this.findSearchablePanel();
            if (component != null) {
                ((SearchableHttpPanelComponent)((Object)component)).searchHeader(p, matches);
            }
        }
    }

    public void bodySearch(Pattern p, List<SearchMatch> matches) {
        if (this.currentComponent instanceof SearchableHttpPanelComponent) {
            ((SearchableHttpPanelComponent)((Object)this.currentComponent)).searchBody(p, matches);
        } else {
            HttpPanelComponentInterface component = this.findSearchablePanel();
            if (component != null) {
                ((SearchableHttpPanelComponent)((Object)component)).searchBody(p, matches);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpPanelComponentInterface findSearchablePanel() {
        HttpPanelComponentInterface searchableComponent = null;
        Hashtable<String, HttpPanelComponentInterface> hashtable = this.components;
        synchronized (hashtable) {
            for (HttpPanelComponentInterface component : this.components.values()) {
                if (!(component instanceof SearchableHttpPanelComponent)) continue;
                searchableComponent = component;
                break;
            }
        }
        return searchableComponent;
    }

    public void addMessagePanelEventListener(MessagePanelEventListener listener) {
        this.listenerList.add(MessagePanelEventListener.class, listener);
    }

    public void removeMessagePanelEventListener(MessagePanelEventListener listener) {
        this.listenerList.remove(MessagePanelEventListener.class, listener);
    }

    public void fireMessageViewChangedEvent(HttpPanelView previousView, HttpPanelView currentView) {
        MessageViewSelectedEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MessagePanelEventListener.class) continue;
            if (event == null) {
                event = new MessageViewSelectedEvent(this, previousView, currentView);
            }
            ((MessagePanelEventListener)listeners[i + 1]).viewSelected(event);
        }
    }

    private void fireComponentChangedEvent(HttpPanelComponentInterface previousComponent, HttpPanelComponentInterface currentComponent) {
        ComponentChangedEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MessagePanelEventListener.class) continue;
            if (event == null) {
                event = new ComponentChangedEvent(this, previousComponent, currentComponent);
            }
            ((MessagePanelEventListener)listeners[i + 1]).componentChanged(event);
        }
    }

    private final class SwitchComponentItemListener
    implements ActionListener {
        private SwitchComponentItemListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String componentName = e.getActionCommand();
            if (HttpPanel.this.isEditable() && !HttpPanel.this.isCurrentComponent(componentName)) {
                try {
                    HttpPanel.this.saveData();
                }
                catch (InvalidMessageDataException e1) {
                    HttpPanel.this.components.get(componentName).getButton().setSelected(false);
                    StringBuilder warnMessage = new StringBuilder(150);
                    warnMessage.append(Constant.messages.getString("http.panel.component.warn.datainvalid"));
                    String exceptionMessage = e1.getLocalizedMessage();
                    if (exceptionMessage != null && !exceptionMessage.isEmpty()) {
                        warnMessage.append('\n').append(exceptionMessage);
                    }
                    View.getSingleton().showWarningDialog(warnMessage.toString());
                    return;
                }
            }
            HttpPanel.this.switchComponent(componentName);
        }
    }

    private static final class ComponentsComparator
    implements Comparator<HttpPanelComponentInterface>,
    Serializable {
        private static final long serialVersionUID = -1380844848294384189L;

        private ComponentsComparator() {
        }

        @Override
        public int compare(HttpPanelComponentInterface o1, HttpPanelComponentInterface o2) {
            int position2;
            int position1 = o1.getPosition();
            if (position1 < (position2 = o2.getPosition())) {
                return -1;
            }
            if (position1 > position2) {
                return 1;
            }
            return 0;
        }
    }

    public static enum OptionsLocation {
        BEGIN,
        AFTER_COMPONENTS,
        END;

    }
}

