/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractDialog;
import org.zaproxy.zap.view.ZapSupportPanel;

public class ZapSupportDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger(ZapSupportDialog.class);
    private JPanel mainPanel = null;
    private ZapSupportPanel supportPanel = null;
    private JButton btnOK = null;
    private JButton btnOpen = null;
    private JButton btnCopy = null;

    public ZapSupportDialog() {
        this((Frame)null, true);
    }

    public ZapSupportDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.setContentPane(this.getMainPanel());
        this.pack();
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbcPanel = new GridBagConstraints();
            GridBagConstraints gbcOpenButton = new GridBagConstraints();
            GridBagConstraints gbcCopyButton = new GridBagConstraints();
            GridBagConstraints gbcOkButton = new GridBagConstraints();
            gbcPanel.gridx = 0;
            gbcPanel.gridy = 0;
            gbcPanel.insets = new Insets(0, 0, 0, 0);
            gbcPanel.fill = 1;
            gbcPanel.anchor = 18;
            gbcPanel.weightx = 1.0;
            gbcPanel.weighty = 1.0;
            gbcPanel.ipady = 2;
            gbcPanel.gridwidth = 3;
            int gridx = 0;
            Insets insets = new Insets(2, 2, 2, 2);
            gbcOpenButton.gridx = gridx++;
            gbcOpenButton.gridy = 1;
            gbcOpenButton.insets = insets;
            gbcOpenButton.anchor = 14;
            gbcCopyButton.gridx = gridx++;
            gbcCopyButton.gridy = 1;
            gbcCopyButton.insets = insets;
            gbcCopyButton.anchor = 14;
            gbcOkButton.gridx = gridx;
            gbcOkButton.gridy = 1;
            gbcOkButton.insets = insets;
            gbcOkButton.anchor = 14;
            this.mainPanel.add((Component)this.getSupportPanel(), gbcPanel);
            this.mainPanel.add((Component)this.getBtnOpen(), gbcOpenButton);
            this.mainPanel.add((Component)this.getBtnCopy(), gbcCopyButton);
            this.getRootPane().setDefaultButton(this.getBtnCopy());
            this.mainPanel.add((Component)this.getBtnOK(), gbcOkButton);
        }
        return this.mainPanel;
    }

    private ZapSupportPanel getSupportPanel() {
        if (this.supportPanel == null) {
            this.supportPanel = new ZapSupportPanel();
        }
        return this.supportPanel;
    }

    private JButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new JButton();
            this.btnOK.setText(Constant.messages.getString("all.button.ok"));
            this.btnOK.addActionListener(e -> this.dispose());
        }
        return this.btnOK;
    }

    private JButton getBtnOpen() {
        if (this.btnOpen == null) {
            this.btnOpen = new JButton();
            if (Desktop.isDesktopSupported()) {
                this.btnOpen.setEnabled(Desktop.getDesktop().isSupported(Desktop.Action.OPEN));
            } else {
                this.btnOpen.setEnabled(false);
            }
            this.btnOpen.setText(Constant.messages.getString("support.open.button"));
            this.btnOpen.setToolTipText(Constant.messages.getString("support.open.button.tooltip"));
            this.btnOpen.addActionListener(e -> {
                try {
                    Desktop.getDesktop().open(new File(Constant.getZapHome()));
                }
                catch (IOException e1) {
                    LOGGER.error("An exception occurred while trying to have the OS open ZAP's Home Directory.", (Throwable)e1);
                }
            });
        }
        return this.btnOpen;
    }

    private JButton getBtnCopy() {
        if (this.btnCopy == null) {
            this.btnCopy = new JButton();
            this.btnCopy.setText(Constant.messages.getString("support.copy.button"));
            this.btnCopy.setToolTipText(Constant.messages.getString("support.copy.button.tooltip"));
            this.btnCopy.addActionListener(e -> {
                StringSelection stringSelection = new StringSelection(this.supportPanel.getSupportInfo());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, null);
            });
        }
        return this.btnCopy;
    }
}

