/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.model;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.swing.tree.TreeNode;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordContext;
import org.parosproxy.paros.db.RecordSessionUrl;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SessionListener;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.control.ExtensionFactory;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.IllegalContextNameException;
import org.zaproxy.zap.model.NameValuePair;
import org.zaproxy.zap.model.ParameterParser;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.model.StandardParameterParser;
import org.zaproxy.zap.model.StructuralNodeModifier;
import org.zaproxy.zap.model.Tech;
import org.zaproxy.zap.model.TechSet;
import org.zaproxy.zap.utils.Stats;
import org.zaproxy.zap.utils.ZapXmlConfiguration;

public class Session {
    private static final Logger LOGGER = LogManager.getLogger(Session.class);
    private static final String ROOT = "session";
    private static final String SESSION_DESC = "sessionDesc";
    private static final String SESSION_ID = "sessionId";
    private static final String SESSION_NAME = "sessionName";
    private ZapXmlConfiguration configuration;
    private Model model = null;
    private String fileName = "";
    private String sessionDesc = "";
    private List<String> excludeFromProxyRegexs = new ArrayList<String>();
    private List<String> excludeFromScanRegexs = new ArrayList<String>();
    private List<String> excludeFromSpiderRegexs = new ArrayList<String>();
    private List<Context> contexts = new ArrayList<Context>();
    private int nextContextId = 1;
    private long sessionId = 0L;
    private String sessionName = "";
    private SiteMap siteTree = null;
    private ParameterParser defaultParamParser = new StandardParameterParser();
    private Supplier<List<String>> globalExcludedUrlsSupplier;
    private static List<OnContextsChangedListener> contextsChangedListeners = new LinkedList<OnContextsChangedListener>();

    public Session(Model model) {
        this.configuration = new ZapXmlConfiguration();
        this.configuration.setRootElementName(ROOT);
        this.setSessionId(System.currentTimeMillis());
        this.setSessionName(Constant.messages.getString("session.untitled"));
        this.setSessionDesc("");
        if (!Constant.isLowMemoryOptionSet()) {
            this.siteTree = SiteMap.createTree(model);
        }
        this.model = model;
        this.discardContexts();
        Stats.clearAll();
    }

    private void discardContexts() {
        this.contexts.clear();
        if (View.isInitialised()) {
            View.getSingleton().discardContexts();
        }
        for (OnContextsChangedListener l : contextsChangedListeners) {
            l.contextsChanged();
        }
        this.nextContextId = 1;
    }

    protected void discard() {
        try {
            this.model.getDb().discardSession(this.getSessionId());
        }
        catch (DatabaseException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        this.discardContexts();
    }

    protected void close() {
        this.discardContexts();
    }

    public String getSessionDesc() {
        return this.sessionDesc;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public SiteMap getSiteTree() {
        return this.siteTree;
    }

    public boolean isNewState() {
        return this.fileName.equals("");
    }

    protected void open(final File file, final SessionListener callback) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                Exception thrownException = null;
                try {
                    Session.this.open(file.getAbsolutePath());
                }
                catch (Exception e) {
                    thrownException = e;
                }
                if (callback != null) {
                    callback.sessionOpened(file, thrownException);
                }
            }
        });
        t.setPriority(3);
        t.start();
    }

    protected void open(final String sessionFile, final SessionListener callback) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                Exception thrownException = null;
                try {
                    Session.this.open(sessionFile);
                }
                catch (Exception e) {
                    thrownException = e;
                }
                if (callback != null) {
                    callback.sessionOpened(null, thrownException);
                }
            }
        });
        t.setPriority(3);
        t.start();
    }

    protected void open(String fileName) throws DatabaseException, IOException, Exception {
        HttpMessage msg;
        HistoryReference hRef;
        int historyId;
        int i;
        if ("hsqldb".equals(this.model.getDb().getType())) {
            this.configuration = new ZapXmlConfiguration(new File(fileName));
            this.sessionId = this.configuration.getLong(SESSION_ID);
            this.sessionName = this.configuration.getString(SESSION_NAME, "");
            this.sessionDesc = this.configuration.getString(SESSION_DESC, "");
        } else {
            this.setSessionId(Long.parseLong(fileName));
        }
        this.model.getDb().close(false, this.isCleanUpRequired());
        this.model.getDb().open(fileName);
        this.fileName = fileName;
        if (View.isInitialised()) {
            View.getSingleton().getSiteTreePanel().getTreeSite().setModel(new SiteMap(null, null));
        }
        if (!Constant.isLowMemoryOptionSet()) {
            this.siteTree = SiteMap.createTree(this.model);
        }
        List<Integer> list = this.model.getDb().getTableHistory().getHistoryIdsOfHistType(this.getSessionId(), 1, 15);
        HistoryReference historyRef = null;
        this.discardContexts();
        this.setExcludeFromProxyRegexs(this.sessionUrlListToStringList(this.model.getDb().getTableSessionUrl().getUrlsForType(1)));
        this.setExcludeFromScanRegexs(this.sessionUrlListToStringList(this.model.getDb().getTableSessionUrl().getUrlsForType(2)));
        this.setExcludeFromSpiderRegexs(this.sessionUrlListToStringList(this.model.getDb().getTableSessionUrl().getUrlsForType(3)));
        for (i = 0; i < list.size(); ++i) {
            historyId = list.get(i);
            try {
                historyRef = new HistoryReference(historyId);
                if (View.isInitialised()) {
                    hRef = historyRef;
                    msg = historyRef.getHttpMessage();
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            SiteNode sn = Session.this.getSiteTree().addPath(hRef, msg);
                            if (sn != null) {
                                sn.setIncludedInScope(Session.this.isIncludedInScope(sn), false);
                                sn.setExcludedFromScope(Session.this.isExcludedFromScope(sn), false);
                            }
                        }
                    });
                } else {
                    SiteNode sn = this.getSiteTree().addPath(historyRef);
                    if (sn != null) {
                        sn.setIncludedInScope(this.isIncludedInScope(sn), false);
                        sn.setExcludedFromScope(this.isExcludedFromScope(sn), false);
                    }
                }
                historyRef.loadAlerts();
                if (i % 100 != 99) continue;
                Thread.yield();
                continue;
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        list = this.model.getDb().getTableHistory().getHistoryIdsOfHistType(this.getSessionId(), 2, 7, 10, 3, 24);
        for (i = 0; i < list.size(); ++i) {
            historyId = list.get(i);
            try {
                historyRef = new HistoryReference(historyId);
                if (View.isInitialised()) {
                    hRef = historyRef;
                    msg = historyRef.getHttpMessage();
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            Session.this.getSiteTree().addPath(hRef, msg);
                        }
                    });
                } else {
                    this.getSiteTree().addPath(historyRef);
                }
                historyRef.loadAlerts();
                if (i % 100 != 99) continue;
                Thread.yield();
                continue;
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        List<RecordContext> contextData = this.model.getDb().getTableContext().getAllData();
        for (RecordContext data : contextData) {
            Context ctx = this.getContext(data.getContextId());
            if (ctx == null) {
                ctx = new Context(this, data.getContextId());
                this.addContext(ctx);
                if (this.nextContextId <= data.getContextId()) {
                    this.nextContextId = data.getContextId() + 1;
                }
            }
            switch (data.getType()) {
                case 1: {
                    ctx.setName(data.getData());
                    if (!View.isInitialised() || ctx.getName().equals(String.valueOf(ctx.getId()))) break;
                    View.getSingleton().renameContext(ctx);
                    break;
                }
                case 2: {
                    ctx.setDescription(data.getData());
                    break;
                }
                case 3: {
                    ctx.addIncludeInContextRegex(data.getData());
                    break;
                }
                case 4: {
                    ctx.addExcludeFromContextRegex(data.getData());
                    break;
                }
                case 5: {
                    ctx.setInScope(Boolean.parseBoolean(data.getData()));
                    break;
                }
                case 6: {
                    ctx.getTechSet().include(new Tech(data.getData()));
                    break;
                }
                case 7: {
                    ctx.getTechSet().exclude(new Tech(data.getData()));
                }
            }
        }
        for (Context ctx : this.contexts) {
            ParameterParser parser;
            Class<?> c;
            List<String> strs;
            try {
                strs = this.getContextDataStrings(ctx.getId(), 400);
                if (strs.size() == 1) {
                    c = ExtensionFactory.getAddOnLoader().loadClass(strs.get(0));
                    if (c == null) {
                        LOGGER.error("Failed to load URL parser for context {} : {}", (Object)ctx.getId(), (Object)strs.get(0));
                    } else {
                        parser = (ParameterParser)c.getConstructor(new Class[0]).newInstance(new Object[0]);
                        strs = this.getContextDataStrings(ctx.getId(), 401);
                        if (strs.size() == 1) {
                            parser.init(strs.get(0));
                        }
                        parser.setContext(ctx);
                        ctx.setUrlParamParser(parser);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to load URL parser for context {}", (Object)ctx.getId(), (Object)e);
            }
            try {
                strs = this.getContextDataStrings(ctx.getId(), 402);
                if (strs.size() == 1) {
                    c = ExtensionFactory.getAddOnLoader().loadClass(strs.get(0));
                    if (c == null) {
                        LOGGER.error("Failed to load POST parser for context {} : {}", (Object)ctx.getId(), (Object)strs.get(0));
                    } else {
                        parser = (ParameterParser)c.getConstructor(new Class[0]).newInstance(new Object[0]);
                        strs = this.getContextDataStrings(ctx.getId(), 403);
                        if (strs.size() == 1) {
                            parser.init(strs.get(0));
                        }
                        parser.setContext(ctx);
                        ctx.setPostParamParser(parser);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to load POST parser for context {}", (Object)ctx.getId(), (Object)e);
            }
            try {
                strs = this.getContextDataStrings(ctx.getId(), 404);
                for (String str : strs) {
                    ctx.addDataDrivenNodes(new StructuralNodeModifier(str));
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to load data driven nodes for context {}", (Object)ctx.getId(), (Object)e);
            }
            ctx.restructureSiteTree();
        }
        if (View.isInitialised()) {
            View.getSingleton().getSiteTreePanel().getTreeSite().setModel(this.siteTree);
            View.getSingleton().getSiteTreePanel().expandRoot();
        }
        this.refreshScope();
        Stats.clearAll();
        System.gc();
    }

    boolean isCleanUpRequired() {
        if (!this.isNewState()) {
            return true;
        }
        return !"hsqldb".equals(this.model.getDb().getType());
    }

    private List<String> sessionUrlListToStringList(List<RecordSessionUrl> rsuList) {
        ArrayList<String> urlList = new ArrayList<String>(rsuList.size());
        for (RecordSessionUrl url : rsuList) {
            urlList.add(url.getUrl());
        }
        return urlList;
    }

    protected void save(final String fileName, final SessionListener callback) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                Exception thrownException = null;
                try {
                    Session.this.save(fileName);
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage(), (Throwable)e);
                    thrownException = e;
                }
                if (callback != null) {
                    callback.sessionSaved(thrownException);
                }
            }
        });
        t.setPriority(3);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(String fileName) throws Exception {
        this.configuration.save(new File(fileName));
        if (this.isNewState()) {
            this.model.moveSessionDb(fileName);
        } else if (!this.fileName.equals(fileName)) {
            this.model.copySessionDb(this.fileName, fileName);
        }
        this.fileName = fileName;
        if (!Constant.isLowMemoryOptionSet()) {
            SiteMap siteMap = this.siteTree;
            synchronized (siteMap) {
                this.saveSiteTree(this.siteTree.getRoot());
            }
        }
        this.model.getDb().getTableSession().update(this.getSessionId(), this.getSessionName());
    }

    protected void persistProperties() throws Exception {
        if (this.isNewState()) {
            return;
        }
        if ("hsqldb".equals(this.model.getDb().getType())) {
            this.configuration.save(new File(this.fileName));
        }
        this.model.getDb().getTableSession().update(this.getSessionId(), this.getSessionName());
    }

    protected void snapshot(final String fileName, final SessionListener callback) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                Exception thrownException = null;
                try {
                    Session.this.snapshot(fileName);
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage(), (Throwable)e);
                    thrownException = e;
                }
                if (callback != null) {
                    callback.sessionSnapshot(thrownException);
                }
            }
        });
        t.setPriority(3);
        t.start();
    }

    protected void snapshot(String fileName) throws Exception {
        this.configuration.save(new File(fileName));
        this.model.snapshotSessionDb(this.fileName, fileName);
    }

    public void setSessionDesc(String sessionDesc) {
        this.sessionDesc = sessionDesc;
        this.configuration.setProperty(SESSION_DESC, sessionDesc);
    }

    public void setSessionId(long sessionId) {
        this.sessionId = sessionId;
        this.configuration.setProperty(SESSION_ID, Long.toString(sessionId));
    }

    public void setSessionName(String name) {
        this.sessionName = name;
        this.configuration.setProperty(SESSION_NAME, name);
    }

    public String getFileName() {
        return this.fileName;
    }

    private void saveSiteTree(SiteNode node) {
        HttpMessage msg = null;
        if (!node.isRoot() && node.getHistoryReference().getHistoryType() < 0) {
            this.saveNodeMsg(msg);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            try {
                this.saveSiteTree((SiteNode)node.getChildAt(i));
                continue;
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void saveNodeMsg(HttpMessage msg) {
    }

    public String getSessionFolder() {
        String result = "";
        if (this.fileName.equals("")) {
            result = Constant.getInstance().FOLDER_SESSION;
        } else {
            File file = new File(this.fileName);
            result = file.getParent();
        }
        return result;
    }

    public List<String> getExcludeFromProxyRegexs() {
        return this.excludeFromProxyRegexs;
    }

    private List<String> stripEmptyLines(List<String> list) {
        ArrayList<String> slist = new ArrayList<String>();
        for (String str : list) {
            if (str.length() <= 0) continue;
            slist.add(str);
        }
        return slist;
    }

    private void refreshScope(SiteNode node) {
        if (node == null) {
            return;
        }
        if (node.isIncludedInScope() == !this.isIncludedInScope(node)) {
            node.setIncludedInScope(!node.isIncludedInScope(), false);
        }
        if (node.isExcludedFromScope() == !this.isExcludedFromScope(node)) {
            node.setExcludedFromScope(!node.isExcludedFromScope(), false);
        }
        if (node.getChildCount() > 0) {
            SiteNode c = (SiteNode)node.getFirstChild();
            while (c != null) {
                this.refreshScope(c);
                c = (SiteNode)node.getChildAfter(c);
            }
        }
    }

    private void refreshScope() {
        if (Constant.isLowMemoryOptionSet()) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            this.refreshScope(this.siteTree.getRoot());
            Control.getSingleton().sessionScopeChanged();
        } else {
            try {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Session.this.refreshScope(Session.this.siteTree.getRoot());
                        Control.getSingleton().sessionScopeChanged();
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected boolean isIncludedInScope(SiteNode sn) {
        if (sn == null) {
            return false;
        }
        return this.isIncludedInScope(sn.getHierarchicNodeName(false));
    }

    private boolean isIncludedInScope(String url) {
        if (url == null) {
            return false;
        }
        if (url.indexOf("?") > 0) {
            url = url.substring(0, url.indexOf("?"));
        }
        for (Context context : this.contexts) {
            if (!context.isInScope() || !context.isIncluded(url)) continue;
            return true;
        }
        return false;
    }

    protected boolean isExcludedFromScope(SiteNode sn) {
        if (sn == null) {
            return false;
        }
        return this.isExcludedFromScope(sn.getHierarchicNodeName(false));
    }

    private boolean isExcludedFromScope(String url) {
        if (url == null) {
            return false;
        }
        if (url.indexOf("?") > 0) {
            url = url.substring(0, url.indexOf("?"));
        }
        for (Context context : this.contexts) {
            if (!context.isInScope() || !context.isExcluded(url)) continue;
            return true;
        }
        return false;
    }

    public boolean isInScope(HistoryReference href) {
        if (href == null) {
            return false;
        }
        if (href.getSiteNode() != null) {
            return this.isInScope(href.getSiteNode());
        }
        try {
            return this.isInScope(href.getURI().toString());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean isInScope(SiteNode sn) {
        if (sn == null) {
            return false;
        }
        return this.isInScope(sn.getHierarchicNodeName(false));
    }

    public boolean isInScope(String url) {
        if (url.indexOf("?") > 0) {
            url = url.substring(0, url.indexOf("?"));
        }
        if (!this.isIncludedInScope(url)) {
            return false;
        }
        return !this.isExcludedFromScope(url);
    }

    public List<SiteNode> getNodesInScopeFromSiteTree() {
        LinkedList<SiteNode> nodes = new LinkedList<SiteNode>();
        SiteNode rootNode = this.getSiteTree().getRoot();
        this.fillNodesInScope(rootNode, nodes);
        return nodes;
    }

    public List<SiteNode> getTopNodesInScopeFromSiteTree() {
        LinkedList<SiteNode> nodes = new LinkedList<SiteNode>();
        SiteNode rootNode = this.getSiteTree().getRoot();
        Enumeration<TreeNode> en = rootNode.children();
        while (en.hasMoreElements()) {
            SiteNode sn = (SiteNode)en.nextElement();
            if (!this.isContainsNodesInScope(sn)) continue;
            nodes.add(sn);
        }
        return nodes;
    }

    private boolean isContainsNodesInScope(SiteNode node) {
        if (node.isIncludedInScope()) {
            return true;
        }
        Enumeration<TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            SiteNode sn = (SiteNode)en.nextElement();
            if (!this.isContainsNodesInScope(sn)) continue;
            return true;
        }
        return false;
    }

    private void fillNodesInScope(SiteNode rootNode, List<SiteNode> nodesList) {
        Enumeration<TreeNode> en = rootNode.children();
        while (en.hasMoreElements()) {
            SiteNode sn = (SiteNode)en.nextElement();
            if (this.isInScope(sn)) {
                nodesList.add(sn);
            }
            this.fillNodesInScope(sn, nodesList);
        }
    }

    public List<SiteNode> getNodesInContextFromSiteTree(Context context) {
        LinkedList<SiteNode> nodes = new LinkedList<SiteNode>();
        SiteNode rootNode = this.getSiteTree().getRoot();
        this.fillNodesInContext(rootNode, nodes, context);
        return nodes;
    }

    private void fillNodesInContext(SiteNode rootNode, List<SiteNode> nodesList, Context context) {
        Enumeration<TreeNode> en = rootNode.children();
        while (en.hasMoreElements()) {
            SiteNode sn = (SiteNode)en.nextElement();
            if (context.isInContext(sn)) {
                nodesList.add(sn);
            }
            this.fillNodesInContext(sn, nodesList, context);
        }
    }

    public void setExcludeFromProxyRegexs(List<String> ignoredRegexs) throws DatabaseException {
        for (String url : ignoredRegexs) {
            Pattern.compile(url, 2);
        }
        this.excludeFromProxyRegexs = this.stripEmptyLines(ignoredRegexs);
        this.model.getDb().getTableSessionUrl().setUrls(1, this.excludeFromProxyRegexs);
    }

    public void addExcludeFromProxyRegex(String ignoredRegex) throws DatabaseException {
        Pattern.compile(ignoredRegex, 2);
        this.excludeFromProxyRegexs.add(ignoredRegex);
        this.model.getDb().getTableSessionUrl().setUrls(1, this.excludeFromProxyRegexs);
    }

    public List<String> getExcludeFromScanRegexs() {
        return this.excludeFromScanRegexs;
    }

    public void addExcludeFromScanRegexs(String ignoredRegex) throws DatabaseException {
        Pattern.compile(ignoredRegex, 2);
        this.excludeFromScanRegexs.add(ignoredRegex);
        this.model.getDb().getTableSessionUrl().setUrls(2, this.excludeFromScanRegexs);
    }

    public void setExcludeFromScanRegexs(List<String> ignoredRegexs) throws DatabaseException {
        for (String url : ignoredRegexs) {
            Pattern.compile(url, 2);
        }
        this.excludeFromScanRegexs = this.stripEmptyLines(ignoredRegexs);
        this.model.getDb().getTableSessionUrl().setUrls(2, this.excludeFromScanRegexs);
    }

    public List<String> getExcludeFromSpiderRegexs() {
        return this.excludeFromSpiderRegexs;
    }

    public void addExcludeFromSpiderRegex(String ignoredRegex) throws DatabaseException {
        Pattern.compile(ignoredRegex, 2);
        this.excludeFromSpiderRegexs.add(ignoredRegex);
        this.model.getDb().getTableSessionUrl().setUrls(3, this.excludeFromSpiderRegexs);
    }

    public void setExcludeFromSpiderRegexs(List<String> ignoredRegexs) throws DatabaseException {
        for (String url : ignoredRegexs) {
            Pattern.compile(url, 2);
        }
        this.excludeFromSpiderRegexs = this.stripEmptyLines(ignoredRegexs);
        this.model.getDb().getTableSessionUrl().setUrls(3, this.excludeFromSpiderRegexs);
    }

    @Deprecated
    public void forceGlobalExcludeURLRefresh() {
    }

    public List<String> getGlobalExcludeURLRegexs() {
        List<String> list;
        Supplier<List<String>> supplier = this.globalExcludedUrlsSupplier;
        if (supplier != null && (list = supplier.get()) != null) {
            return list;
        }
        return List.of();
    }

    public void setGlobalExcludedUrlRegexsSupplier(Supplier<List<String>> supplier) {
        this.globalExcludedUrlsSupplier = supplier;
    }

    public void setSessionUrls(int type, List<String> urls) throws DatabaseException {
        this.model.getDb().getTableSessionUrl().setUrls(type, urls);
    }

    public void setSessionUrl(int type, String url) throws DatabaseException {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(url);
        this.setSessionUrls(type, list);
    }

    public List<String> getSessionUrls(int type) throws DatabaseException {
        List<RecordSessionUrl> urls = this.model.getDb().getTableSessionUrl().getUrlsForType(type);
        ArrayList<String> list = new ArrayList<String>(urls.size());
        for (RecordSessionUrl url : urls) {
            list.add(url.getUrl());
        }
        return list;
    }

    public List<String> getContextDataStrings(int contextId, int type) throws DatabaseException {
        List<RecordContext> dataList = this.model.getDb().getTableContext().getDataForContextAndType(contextId, type);
        ArrayList<String> list = new ArrayList<String>();
        for (RecordContext data : dataList) {
            list.add(data.getData());
        }
        return list;
    }

    public String getContextDataString(int contextId, int type, String defaultValue) throws DatabaseException {
        List<RecordContext> dataList = this.model.getDb().getTableContext().getDataForContextAndType(contextId, type);
        if (dataList.size() > 0) {
            return dataList.get(0).getData();
        }
        return defaultValue;
    }

    public int getContextDataInteger(int contextId, int type, int defaultValue) throws DatabaseException {
        List<RecordContext> dataList = this.model.getDb().getTableContext().getDataForContextAndType(contextId, type);
        if (dataList.size() > 0) {
            try {
                return Integer.parseInt(dataList.get(0).getData());
            }
            catch (NumberFormatException e) {
                LOGGER.error("Failed to parse context value type {}", (Object)type, (Object)e);
            }
        }
        return defaultValue;
    }

    public void setContextData(int contextId, int type, String data) throws DatabaseException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(data);
        this.setContextData(contextId, type, list);
    }

    public void setContextData(int contextId, int type, List<String> dataList) throws DatabaseException {
        this.model.getDb().getTableContext().setData(contextId, type, dataList);
    }

    public void clearContextDataForType(int contextId, int type) throws DatabaseException {
        this.model.getDb().getTableContext().deleteAllDataForContextAndType(contextId, type);
    }

    public void clearContextData(int contextId) throws DatabaseException {
        this.model.getDb().getTableContext().deleteAllDataForContext(contextId);
    }

    private List<String> techListToStringList(TreeSet<Tech> techList) {
        ArrayList<String> strList = new ArrayList<String>();
        Iterator<Tech> iter = techList.iterator();
        while (iter.hasNext()) {
            strList.add(iter.next().toString());
        }
        return strList;
    }

    private List<String> snmListToStringList(List<StructuralNodeModifier> list) {
        ArrayList<String> strList = new ArrayList<String>();
        for (StructuralNodeModifier snm : list) {
            strList.add(snm.getConfig());
        }
        return strList;
    }

    public void saveContext(Context c) {
        try {
            this.setContextData(c.getId(), 1, c.getName());
            this.setContextData(c.getId(), 2, c.getDescription());
            this.setContextData(c.getId(), 5, Boolean.toString(c.isInScope()));
            this.setContextData(c.getId(), 3, c.getIncludeInContextRegexs());
            this.setContextData(c.getId(), 4, c.getExcludeFromContextRegexs());
            this.setContextData(c.getId(), 6, this.techListToStringList(c.getTechSet().getIncludeTech()));
            this.setContextData(c.getId(), 7, this.techListToStringList(c.getTechSet().getExcludeTech()));
            this.setContextData(c.getId(), 400, c.getUrlParamParser().getClass().getCanonicalName());
            this.setContextData(c.getId(), 401, c.getUrlParamParser().getConfig());
            this.setContextData(c.getId(), 402, c.getPostParamParser().getClass().getCanonicalName());
            this.setContextData(c.getId(), 403, c.getPostParamParser().getConfig());
            this.setContextData(c.getId(), 404, this.snmListToStringList(c.getDataDrivenNodes()));
            this.model.saveContext(c);
        }
        catch (DatabaseException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        if (View.isInitialised()) {
            View.getSingleton().changeContext(c);
            this.refreshScope();
        }
    }

    public void saveAllContexts() {
        for (Context c : this.contexts) {
            this.saveContext(c);
        }
    }

    public Context getNewContext(String name) {
        this.validateContextName(name);
        Context c = this.createContext(name);
        this.addContext(c);
        return c;
    }

    private Context createContext(String name) {
        Context context = new Context(this, this.nextContextId++);
        context.setName(name);
        return context;
    }

    private void validateContextName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalContextNameException(IllegalContextNameException.Reason.EMPTY_NAME, "The context name must not be null nor empty.");
        }
        if (this.getContext(name) != null) {
            throw new IllegalContextNameException(IllegalContextNameException.Reason.DUPLICATED_NAME, "A context with the given name [" + name + "] already exists.");
        }
    }

    public void addContext(Context c) {
        if (c == null) {
            throw new IllegalArgumentException("The context must not be null. ");
        }
        this.validateContextName(c.getName());
        this.contexts.add(c);
        this.model.loadContext(c);
        for (OnContextsChangedListener l : contextsChangedListeners) {
            l.contextAdded(c);
        }
        if (View.isInitialised()) {
            View.getSingleton().addContext(c);
        }
    }

    public void deleteContext(Context c) {
        this.contexts.remove(c);
        try {
            this.clearContextData(c.getId());
        }
        catch (DatabaseException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        for (OnContextsChangedListener l : contextsChangedListeners) {
            l.contextDeleted(c);
        }
        if (View.isInitialised()) {
            View.getSingleton().deleteContext(c);
            this.refreshScope();
        }
    }

    public Context getContext(int id) {
        for (Context context : this.contexts) {
            if (context.getId() != id) continue;
            return context;
        }
        return null;
    }

    public Context getContext(String name) {
        for (Context context : this.contexts) {
            if (!context.getName().equals(name)) continue;
            return context;
        }
        return null;
    }

    public List<Context> getContexts() {
        return this.contexts;
    }

    public List<Context> getContextsForNode(SiteNode sn) {
        if (sn == null) {
            return new ArrayList<Context>();
        }
        return this.getContextsForUrl(sn.getHierarchicNodeName(false));
    }

    public List<Context> getContextsForUrl(String url) {
        ArrayList<Context> ctxList = new ArrayList<Context>();
        if (url.indexOf("?") > 0) {
            url = url.substring(0, url.indexOf("?"));
        }
        for (Context context : this.contexts) {
            if (!context.isInContext(url)) continue;
            ctxList.add(context);
        }
        return ctxList;
    }

    public void exportContext(int contextId, File file) throws ConfigurationException {
        this.exportContext(this.getContext(contextId), file);
    }

    public void exportContext(Context c, File file) throws ConfigurationException {
        ZapXmlConfiguration config = new ZapXmlConfiguration();
        config.setProperty("context.name", c.getName());
        config.setProperty("context.desc", c.getDescription());
        config.setProperty("context.inscope", c.isInScope());
        config.setProperty("context.incregexes", c.getIncludeInContextRegexs());
        config.setProperty("context.excregexes", c.getExcludeFromContextRegexs());
        config.setProperty("context.tech.include", this.techListToStringList(c.getTechSet().getIncludeTech()));
        config.setProperty("context.tech.exclude", this.techListToStringList(c.getTechSet().getExcludeTech()));
        config.setProperty("context.urlparser.class", c.getUrlParamParser().getClass().getCanonicalName());
        config.setProperty("context.urlparser.config", c.getUrlParamParser().getConfig());
        config.setProperty("context.postparser.class", c.getPostParamParser().getClass().getCanonicalName());
        config.setProperty("context.postparser.config", c.getPostParamParser().getConfig());
        for (StructuralNodeModifier snm : c.getDataDrivenNodes()) {
            config.addProperty("context.ddns", snm.getConfig());
        }
        this.model.exportContext(c, (Configuration)config);
        config.save(file);
    }

    public Context importContext(File file) throws ConfigurationException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return this.importContext(new ZapXmlConfiguration(file));
    }

    public Context importContext(ZapXmlConfiguration config) throws ConfigurationException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Class<?> cl;
        String name = config.getString("context.name");
        this.validateContextName(name);
        Context c = this.createContext(name);
        c.setDescription(config.getString("context.desc"));
        c.setInScope(config.getBoolean("context.inscope", false));
        for (Object obj : config.getList("context.incregexes")) {
            c.addIncludeInContextRegex(obj.toString());
        }
        for (Object obj : config.getList("context.excregexes")) {
            c.addExcludeFromContextRegex(obj.toString());
        }
        TechSet techSet = new TechSet();
        for (Object obj : config.getList("context.tech.include")) {
            techSet.include(new Tech(obj.toString()));
        }
        for (Object obj : config.getList("context.tech.exclude")) {
            techSet.exclude(new Tech(obj.toString()));
        }
        c.setTechSet(techSet);
        String urlParserClass = config.getString("context.urlparser.class");
        if (urlParserClass == null) {
            urlParserClass = config.getString("context.urlparser");
        }
        if (urlParserClass == null) {
            urlParserClass = StandardParameterParser.class.getCanonicalName();
        }
        if ((cl = ExtensionFactory.getAddOnLoader().loadClass(urlParserClass)) == null) {
            throw new ConfigurationException("Failed to load URL parser for context " + urlParserClass);
        }
        ParameterParser parser = (ParameterParser)cl.getConstructor(new Class[0]).newInstance(new Object[0]);
        parser.init(config.getString("context.urlparser.config"));
        parser.setContext(c);
        c.setUrlParamParser(parser);
        String postParserClass = config.getString("context.postparser.class");
        String postParserConfig = config.getString("context.postparser.config");
        if (postParserClass == null) {
            postParserClass = config.getString(urlParserClass);
            postParserConfig = config.getString("context.urlparser.config");
        }
        if (postParserClass == null) {
            postParserClass = StandardParameterParser.class.getCanonicalName();
        }
        if ((cl = ExtensionFactory.getAddOnLoader().loadClass(postParserClass)) == null) {
            throw new ConfigurationException("Failed to load POST parser for context " + postParserClass);
        }
        ParameterParser parser2 = (ParameterParser)cl.getConstructor(new Class[0]).newInstance(new Object[0]);
        parser2.init(postParserConfig);
        parser2.setContext(c);
        c.setPostParamParser(parser2);
        for (Object obj : config.getList("context.ddns")) {
            c.addDataDrivenNodes(new StructuralNodeModifier(obj.toString()));
        }
        this.model.importContext(c, (Configuration)config);
        c.restructureSiteTree();
        this.addContext(c);
        this.saveContext(c);
        return c;
    }

    public ParameterParser getUrlParamParser(String url) {
        List<Context> contexts = this.getContextsForUrl(url);
        if (contexts.size() > 0) {
            return contexts.get(0).getUrlParamParser();
        }
        return this.defaultParamParser;
    }

    public ParameterParser getFormParamParser(String url) {
        List<Context> contexts = this.getContextsForUrl(url);
        if (contexts.size() > 0) {
            return contexts.get(0).getPostParamParser();
        }
        return this.defaultParamParser;
    }

    @Deprecated
    public Map<String, String> getParams(HttpMessage msg, HtmlParameter.Type type) {
        switch (type) {
            case form: {
                return this.getFormParamParser(msg.getRequestHeader().getURI().toString()).getParams(msg, type);
            }
            case url: {
                return this.getUrlParamParser(msg.getRequestHeader().getURI().toString()).getParams(msg, type);
            }
        }
        throw new InvalidParameterException("Type not supported: " + type);
    }

    public List<NameValuePair> getParameters(HttpMessage msg, HtmlParameter.Type type) {
        if (msg == null) {
            throw new IllegalArgumentException("Parameter msg must not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Parameter type must not be null.");
        }
        switch (type) {
            case form: {
                return this.getFormParamParser(msg.getRequestHeader().getURI().toString()).getParameters(msg, type);
            }
            case url: {
                return this.getUrlParamParser(msg.getRequestHeader().getURI().toString()).getParameters(msg, type);
            }
        }
        throw new IllegalArgumentException("The provided type is not supported: " + type);
    }

    @Deprecated
    public Map<String, String> getUrlParams(URI uri) throws URIException {
        HashMap<String, String> map = new HashMap<String, String>();
        for (NameValuePair parameter : this.getUrlParamParser(uri.toString()).parseParameters(uri.getEscapedQuery())) {
            String value = parameter.getValue();
            if (value == null) {
                value = "";
            }
            map.put(parameter.getName(), value);
        }
        return map;
    }

    public List<NameValuePair> getUrlParameters(URI uri) throws URIException {
        return this.getUrlParamParser(uri.toString()).parseParameters(uri.getEscapedQuery());
    }

    @Deprecated
    public Map<String, String> getFormParams(URI uri, String formData) throws URIException {
        return this.getFormParamParser(uri.toString()).parse(formData);
    }

    public List<NameValuePair> getFormParameters(URI uri, String formData) throws URIException {
        return this.getFormParamParser(uri.toString()).parseParameters(formData);
    }

    @Deprecated
    public List<String> getTreePath(URI uri) throws URIException {
        return SessionStructure.getTreePath(Model.getSingleton(), uri);
    }

    @Deprecated
    public List<String> getTreePath(HttpMessage msg) throws URIException {
        return SessionStructure.getTreePath(Model.getSingleton(), msg);
    }

    public void addOnContextsChangedListener(OnContextsChangedListener l) {
        contextsChangedListeners.add(l);
    }

    public void removeOnContextsChangedListener(OnContextsChangedListener l) {
        contextsChangedListeners.remove(l);
    }

    public static interface OnContextsChangedListener {
        public void contextAdded(Context var1);

        public void contextDeleted(Context var1);

        public void contextsChanged();
    }
}

