/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.extension.option.OptionsParamView;
import org.zaproxy.zap.view.ComponentMaximiser;
import org.zaproxy.zap.view.ComponentMaximiserMouseListener;
import org.zaproxy.zap.view.TabbedPanel2;

public class WorkbenchPanel
extends JPanel {
    private static final long serialVersionUID = -4610792807151921550L;
    private static final Logger LOGGER = LogManager.getLogger(WorkbenchPanel.class);
    private static final String PREF_DIVIDER_LOCATION = "divider.location";
    private static final String DIVIDER_VERTICAL = "vertical";
    private static final String DIVIDER_HORIZONTAL = "horizontal";
    private final Preferences preferences;
    private final String prefnzPrefix = this.getClass().getSimpleName() + ".";
    private final AbstractPanel requestPanel;
    private final AbstractPanel responsePanel;
    private final TabbedPanel2 responseTabbedPanel;
    private int requestTabIndex;
    private JSplitPane splitRequestAndResponse;
    private AbstractPanel splitRequestAndResponsePanel;
    private final ComponentMaximiser componentMaximiser;
    private Layout layout;
    private ResponsePanelPosition responsePanelPosition;
    private TabbedPanel2 tabbedStatus;
    private JPanel paneStatus;
    private TabbedPanel2 tabbedSelect;
    private JPanel paneSelect;
    private TabbedPanel2 tabbedWork;
    private JPanel paneWork;
    private TabbedPanel2 tabbedFull;
    private JPanel fullLayoutPanel;
    private boolean showTabNames;
    private final Map<PanelType, Set<AbstractPanel>> layoutPanels = Map.of(PanelType.SELECT, new HashSet(), PanelType.STATUS, new HashSet(), PanelType.WORK, new HashSet());

    public WorkbenchPanel(OptionsParamView viewOptions, AbstractPanel requestPanel, AbstractPanel responsePanel) {
        super(new BorderLayout());
        WorkbenchPanel.validateNotNull(viewOptions, "viewOptions");
        WorkbenchPanel.validateNotNull(requestPanel, "requestPanel");
        WorkbenchPanel.validateNotNull(responsePanel, "responsePanel");
        this.requestPanel = requestPanel;
        this.responsePanel = responsePanel;
        this.layoutPanels.get((Object)PanelType.WORK).add(requestPanel);
        this.layoutPanels.get((Object)PanelType.WORK).add(responsePanel);
        this.componentMaximiser = new ComponentMaximiser(this);
        this.showTabNames = true;
        ComponentMaximiserMouseListener maximiseMouseListener = new ComponentMaximiserMouseListener(viewOptions, this.componentMaximiser);
        this.responseTabbedPanel = new TabbedPanel2();
        this.responseTabbedPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.responseTabbedPanel.addMouseListener(maximiseMouseListener);
        this.responseTabbedPanel.addDetachedTabListener(new TabbedPanel2.DetachedTabListener(){

            @Override
            public void tabDetached(Component c) {
                WorkbenchPanel.this.getPaneWork().removeAll();
                WorkbenchPanel.this.getPaneWork().add(WorkbenchPanel.this.getTabbedWork());
                WorkbenchPanel.this.getPaneWork().validate();
            }

            @Override
            public void tabReattached(Component c) {
                WorkbenchPanel.this.setResponsePanelPosition(WorkbenchPanel.this.responsePanelPosition);
            }
        });
        this.getTabbedWork().addMouseListener(maximiseMouseListener);
        this.getTabbedStatus().addMouseListener(maximiseMouseListener);
        this.getTabbedSelect().addMouseListener(maximiseMouseListener);
        this.addPanel(requestPanel, PanelType.WORK);
        this.addPanel(responsePanel, PanelType.WORK);
        this.preferences = Preferences.userNodeForPackage(this.getClass());
        this.requestTabIndex = -1;
        this.setResponsePanelPosition(ResponsePanelPosition.TABS_SIDE_BY_SIDE);
        this.setWorkbenchLayout(Layout.EXPAND_STATUS);
    }

    private static void validateNotNull(Object parameter, String parameterName) {
        if (parameter == null) {
            throw new IllegalArgumentException("Parameter " + parameterName + " must not be null");
        }
    }

    public Layout getWorkbenchLayout() {
        return this.layout;
    }

    void setWorkbenchLayout(Layout layout) {
        WorkbenchPanel.validateNotNull((Object)layout, "layout");
        if (this.layout == layout) {
            return;
        }
        this.requestTabIndex = this.getCurrentRequestTabIndex();
        Layout previousLayout = this.layout;
        this.layout = layout;
        this.componentMaximiser.unmaximiseComponent();
        this.removeAll();
        Set<Object> detachedTabs = new HashSet<TabbedPanel2.DetachedTabFrame>();
        switch (layout) {
            case FULL: {
                List<AbstractPanel> visiblePanels = this.getTabbedStatus().getVisiblePanels();
                detachedTabs.addAll(this.getTabbedStatus().getDetachedTabs().values());
                this.getTabbedStatus().hideAllTabs();
                visiblePanels.addAll(this.getTabbedWork().getVisiblePanels());
                detachedTabs.addAll(this.getTabbedWork().getDetachedTabs().values());
                this.getTabbedWork().hideAllTabs();
                visiblePanels.addAll(this.getTabbedSelect().getVisiblePanels());
                detachedTabs.addAll(this.getTabbedSelect().getDetachedTabs().values());
                this.getTabbedSelect().hideAllTabs();
                detachedTabs.addAll(this.responseTabbedPanel.getDetachedTabs().values());
                this.responseTabbedPanel.hideAllTabs();
                this.getTabbedFull().setDetachedTabs(detachedTabs);
                this.getTabbedFull().setVisiblePanels(visiblePanels);
                this.updateFullLayout();
                this.add(this.getFullLayoutPanel());
                break;
            }
            default: {
                TabbedPanel2.DetachedTabFrame detachedtab;
                this.add(layout == Layout.EXPAND_STATUS ? this.createStatusPanelsSplit() : this.createSelectPanelsSplit());
                if (previousLayout != Layout.FULL) break;
                List<AbstractPanel> visiblePanels = this.getTabbedFull().getVisiblePanels();
                detachedTabs = Set.copyOf(this.getTabbedFull().getDetachedTabs().values());
                this.getTabbedFull().hideAllTabs();
                this.getTabbedStatus().setDetachedTabs(detachedTabs.stream().filter(t -> this.layoutPanels.get((Object)PanelType.STATUS).contains(t.getPanel())).collect(Collectors.toUnmodifiableSet()));
                this.getTabbedStatus().setVisiblePanels(visiblePanels);
                this.getTabbedWork().setDetachedTabs(detachedTabs.stream().filter(t -> this.layoutPanels.get((Object)PanelType.WORK).contains(t.getPanel())).collect(Collectors.toUnmodifiableSet()));
                this.getTabbedWork().setVisiblePanels(visiblePanels);
                this.getTabbedSelect().setDetachedTabs(detachedTabs.stream().filter(t -> this.layoutPanels.get((Object)PanelType.SELECT).contains(t.getPanel())).collect(Collectors.toUnmodifiableSet()));
                this.getTabbedSelect().setVisiblePanels(visiblePanels);
                if ((this.responsePanelPosition == ResponsePanelPosition.PANELS_SIDE_BY_SIDE || this.responsePanelPosition == ResponsePanelPosition.PANEL_ABOVE) && (detachedtab = this.getTabbedWork().getDetachedTabs().remove(this.responsePanel)) != null) {
                    this.responseTabbedPanel.setDetachedTabs(Set.of(detachedtab));
                }
                this.setResponsePanelPosition(this.responsePanelPosition);
            }
        }
        this.validate();
        this.repaint();
    }

    private int getCurrentRequestTabIndex() {
        int idx;
        if (this.layout == Layout.FULL) {
            if (this.responsePanelPosition == ResponsePanelPosition.TAB_SIDE_BY_SIDE) {
                return this.getTabbedFull().indexOfComponent(this.splitRequestAndResponsePanel);
            }
            return this.getTabbedFull().indexOfComponent(this.requestPanel);
        }
        if (this.responsePanelPosition == ResponsePanelPosition.TAB_SIDE_BY_SIDE && (idx = this.getTabbedWork().indexOfComponent(this.splitRequestAndResponsePanel)) != -1) {
            return idx;
        }
        idx = this.getTabbedWork().indexOfComponent(this.requestPanel);
        if (idx != -1) {
            return idx;
        }
        return this.requestTabIndex;
    }

    private JSplitPane createStatusPanelsSplit() {
        JSplitPane splitVert = new JSplitPane();
        splitVert.setDividerLocation(this.restoreDividerLocation(DIVIDER_VERTICAL, 300));
        splitVert.addPropertyChangeListener("dividerLocation", new DividerResizedListener(DIVIDER_VERTICAL));
        splitVert.setDividerSize(3);
        splitVert.setOrientation(0);
        splitVert.setResizeWeight(0.5);
        switch (this.layout) {
            case EXPAND_SELECT: {
                splitVert.setTopComponent(this.getPaneWork());
                break;
            }
            default: {
                splitVert.setTopComponent(this.createSelectPanelsSplit());
            }
        }
        splitVert.setBottomComponent(this.getPaneStatus());
        splitVert.setContinuousLayout(false);
        splitVert.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        return splitVert;
    }

    private JSplitPane createSelectPanelsSplit() {
        JSplitPane splitHoriz = new JSplitPane();
        splitHoriz.setOneTouchExpandable(true);
        splitHoriz.setLeftComponent(this.getPaneSelect());
        switch (this.layout) {
            case EXPAND_SELECT: {
                splitHoriz.setRightComponent(this.createStatusPanelsSplit());
                break;
            }
            default: {
                splitHoriz.setRightComponent(this.getPaneWork());
            }
        }
        splitHoriz.setDividerLocation(this.restoreDividerLocation(DIVIDER_HORIZONTAL, 300));
        splitHoriz.addPropertyChangeListener("dividerLocation", new DividerResizedListener(DIVIDER_HORIZONTAL));
        splitHoriz.setResizeWeight(0.3);
        splitHoriz.setContinuousLayout(false);
        splitHoriz.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        return splitHoriz;
    }

    private JPanel getPaneStatus() {
        if (this.paneStatus == null) {
            this.paneStatus = new JPanel();
            this.paneStatus.setLayout(new BorderLayout(0, 0));
            this.paneStatus.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.paneStatus.add(this.getTabbedStatus());
        }
        return this.paneStatus;
    }

    private JPanel getPaneSelect() {
        if (this.paneSelect == null) {
            this.paneSelect = new JPanel();
            this.paneSelect.setLayout(new BorderLayout(0, 0));
            this.paneSelect.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.paneSelect.add(this.getTabbedSelect());
        }
        return this.paneSelect;
    }

    private JPanel getPaneWork() {
        if (this.paneWork == null) {
            this.paneWork = new JPanel();
            this.paneWork.setLayout(new BorderLayout(0, 0));
            this.paneWork.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.paneWork.setCursor(new Cursor(0));
            this.paneWork.add(this.getTabbedWork());
        }
        return this.paneWork;
    }

    private JPanel getFullLayoutPanel() {
        if (this.fullLayoutPanel == null) {
            this.fullLayoutPanel = new JPanel();
            this.fullLayoutPanel.setLayout(new BorderLayout(0, 0));
            this.fullLayoutPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.fullLayoutPanel.setCursor(new Cursor(0));
            this.fullLayoutPanel.add(this.getTabbedFull());
        }
        return this.fullLayoutPanel;
    }

    private TabbedPanel2 getTabbedFull() {
        if (this.tabbedFull == null) {
            this.tabbedFull = new TabbedPanel2();
            this.tabbedFull.setName("tabbedFull");
            this.tabbedFull.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        return this.tabbedFull;
    }

    public TabbedPanel2 getTabbedStatus() {
        if (this.tabbedStatus == null) {
            this.tabbedStatus = new TabbedPanel2();
            this.tabbedStatus.setPreferredSize(new Dimension(800, 200));
            this.tabbedStatus.setTabPlacement(1);
            this.tabbedStatus.setName("tabbedStatus");
            this.tabbedStatus.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        return this.tabbedStatus;
    }

    public TabbedPanel2 getTabbedWork() {
        if (this.tabbedWork == null) {
            this.tabbedWork = new TabbedPanel2();
            this.tabbedWork.setPreferredSize(new Dimension(600, 400));
            this.tabbedWork.setName("tabbedWork");
            this.tabbedWork.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        return this.tabbedWork;
    }

    public void toggleTabNames(boolean showTabNames) {
        if (this.showTabNames == showTabNames) {
            return;
        }
        this.showTabNames = showTabNames;
        this.responseTabbedPanel.setShowTabNames(showTabNames);
        if (this.layout != Layout.FULL) {
            this.getTabbedStatus().setShowTabNames(showTabNames);
            this.getTabbedSelect().setShowTabNames(showTabNames);
            this.getTabbedWork().setShowTabNames(showTabNames);
        } else {
            this.getTabbedFull().setShowTabNames(showTabNames);
        }
    }

    public TabbedPanel2 getTabbedSelect() {
        if (this.tabbedSelect == null) {
            this.tabbedSelect = new TabbedPanel2();
            this.tabbedSelect.setPreferredSize(new Dimension(200, 400));
            this.tabbedSelect.setName("tabbedSelect");
            this.tabbedSelect.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        return this.tabbedSelect;
    }

    public void addPanels(List<AbstractPanel> panels, PanelType panelType) {
        WorkbenchPanel.validateNotNull(panels, "panels");
        WorkbenchPanel.validateNotNull((Object)panelType, "panelType");
        boolean fullLayout = this.layout == Layout.FULL;
        WorkbenchPanel.addPanels(this.getTabbedFull(), panels, fullLayout);
        this.layoutPanels.get((Object)panelType).addAll(panels);
        switch (panelType) {
            case SELECT: {
                WorkbenchPanel.addPanels(this.getTabbedSelect(), panels, !fullLayout);
                break;
            }
            case STATUS: {
                WorkbenchPanel.addPanels(this.getTabbedStatus(), panels, !fullLayout);
                break;
            }
            case WORK: {
                WorkbenchPanel.addPanels(this.getTabbedWork(), panels, !fullLayout);
                break;
            }
        }
    }

    private static void addPanels(TabbedPanel2 tabbedPanel, List<AbstractPanel> panels, boolean visible) {
        for (AbstractPanel panel : panels) {
            WorkbenchPanel.addPanel(tabbedPanel, panel, visible);
        }
        tabbedPanel.revalidate();
    }

    private static void addPanel(TabbedPanel2 tabbedPanel, AbstractPanel panel, boolean visible) {
        if (visible) {
            tabbedPanel.addTab(panel);
        } else {
            tabbedPanel.addTabHidden(panel);
        }
    }

    public void addPanel(AbstractPanel panel, PanelType panelType) {
        WorkbenchPanel.validateNotNull(panel, "panel");
        WorkbenchPanel.validateNotNull((Object)panelType, "panelType");
        boolean fullLayout = this.layout == Layout.FULL;
        WorkbenchPanel.addPanel(this.getTabbedFull(), panel, fullLayout);
        this.layoutPanels.get((Object)panelType).add(panel);
        switch (panelType) {
            case SELECT: {
                WorkbenchPanel.addPanel(this.getTabbedSelect(), panel, !fullLayout);
                this.getTabbedSelect().revalidate();
                break;
            }
            case STATUS: {
                WorkbenchPanel.addPanel(this.getTabbedStatus(), panel, !fullLayout);
                this.getTabbedStatus().revalidate();
                break;
            }
            case WORK: {
                WorkbenchPanel.addPanel(this.getTabbedWork(), panel, !fullLayout);
                this.getTabbedWork().revalidate();
                break;
            }
        }
    }

    public void removePanels(List<AbstractPanel> panels, PanelType panelType) {
        WorkbenchPanel.validateNotNull(panels, "panels");
        WorkbenchPanel.validateNotNull((Object)panelType, "panelType");
        WorkbenchPanel.removePanels(this.getTabbedFull(), panels);
        panels.forEach(this.layoutPanels.get((Object)panelType)::remove);
        switch (panelType) {
            case SELECT: {
                WorkbenchPanel.removePanels(this.getTabbedSelect(), panels);
                break;
            }
            case STATUS: {
                WorkbenchPanel.removePanels(this.getTabbedStatus(), panels);
                break;
            }
            case WORK: {
                WorkbenchPanel.removePanels(this.getTabbedWork(), panels);
                break;
            }
        }
    }

    private static void removePanels(TabbedPanel2 tabbedPanel, List<AbstractPanel> panels) {
        for (AbstractPanel panel : panels) {
            WorkbenchPanel.removeTabPanel(tabbedPanel, panel);
        }
        tabbedPanel.revalidate();
    }

    private static void removeTabPanel(TabbedPanel2 tabbedPanel, AbstractPanel panel) {
        tabbedPanel.removeTab(panel);
    }

    public void removePanel(AbstractPanel panel, PanelType panelType) {
        WorkbenchPanel.validateNotNull(panel, "panel");
        WorkbenchPanel.validateNotNull((Object)panelType, "panelType");
        WorkbenchPanel.removeTabPanel(this.getTabbedFull(), panel);
        this.layoutPanels.get((Object)panelType).remove(panel);
        this.getTabbedFull().revalidate();
        switch (panelType) {
            case SELECT: {
                WorkbenchPanel.removeTabPanel(this.getTabbedSelect(), panel);
                this.getTabbedSelect().revalidate();
                break;
            }
            case STATUS: {
                WorkbenchPanel.removeTabPanel(this.getTabbedStatus(), panel);
                this.getTabbedStatus().revalidate();
                break;
            }
            case WORK: {
                WorkbenchPanel.removeTabPanel(this.getTabbedWork(), panel);
                this.getTabbedWork().revalidate();
                break;
            }
        }
    }

    public List<AbstractPanel> getPanels(PanelType panelType) {
        WorkbenchPanel.validateNotNull((Object)panelType, "panelType");
        ArrayList<AbstractPanel> panels = new ArrayList<AbstractPanel>();
        switch (panelType) {
            case SELECT: {
                panels.addAll(this.getTabbedSelect().getPanels());
                break;
            }
            case STATUS: {
                panels.addAll(this.getTabbedStatus().getPanels());
                break;
            }
            case WORK: {
                panels.addAll(this.getTabbedWork().getPanels());
                break;
            }
        }
        return panels;
    }

    public SortedSet<AbstractPanel> getSortedPanels(PanelType panelType) {
        WorkbenchPanel.validateNotNull((Object)panelType, "panelType");
        List<AbstractPanel> panels = this.getPanels(panelType);
        TreeSet<AbstractPanel> sortedPanels = new TreeSet<AbstractPanel>(new Comparator<AbstractPanel>(){

            @Override
            public int compare(AbstractPanel abstractPanel, AbstractPanel otherAbstractPanel) {
                String name = abstractPanel.getName();
                String otherName = otherAbstractPanel.getName();
                if (name == null) {
                    if (otherName == null) {
                        return 0;
                    }
                    return -1;
                }
                if (otherName == null) {
                    return 1;
                }
                return name.compareTo(otherName);
            }
        });
        sortedPanels.addAll(panels);
        return sortedPanels;
    }

    public void setPanelsVisible(boolean visible) {
        if (this.layout == Layout.FULL) {
            this.getTabbedFull().setPanelsVisible(visible);
        } else {
            this.getTabbedSelect().setPanelsVisible(visible);
            this.getTabbedWork().setPanelsVisible(visible);
            this.getTabbedStatus().setPanelsVisible(visible);
        }
    }

    public void pinVisiblePanels() {
        if (this.layout == Layout.FULL) {
            this.getTabbedFull().pinVisibleTabs();
        } else {
            this.getTabbedSelect().pinVisibleTabs();
            this.getTabbedWork().pinVisibleTabs();
            this.getTabbedStatus().pinVisibleTabs();
        }
    }

    public void unpinVisiblePanels() {
        if (this.layout == Layout.FULL) {
            this.getTabbedFull().unpinTabs();
        } else {
            this.getTabbedSelect().unpinTabs();
            this.getTabbedWork().unpinTabs();
            this.getTabbedStatus().unpinTabs();
        }
    }

    public void showPanel(AbstractPanel panel) {
        WorkbenchPanel.validateNotNull(panel, "panel");
        if (this.layout == Layout.FULL) {
            this.getTabbedFull().setVisible(panel, true);
        } else {
            this.getTabbedSelect().setVisible(panel, true);
            this.getTabbedStatus().setVisible(panel, true);
            this.getTabbedWork().setVisible(panel, true);
        }
        panel.setTabFocus();
    }

    void setResponsePanelPosition(ResponsePanelPosition position) {
        WorkbenchPanel.validateNotNull((Object)position, "position");
        this.requestTabIndex = this.getCurrentRequestTabIndex();
        this.responsePanelPosition = position;
        if (this.layout == Layout.FULL) {
            this.updateFullLayout();
            return;
        }
        Component currentTabbedPanel = this.componentMaximiser.getMaximisedComponent();
        if (this.componentMaximiser.isComponentMaximised()) {
            this.componentMaximiser.unmaximiseComponent();
        }
        boolean selectRequest = this.removeSplitRequestAndResponsePanel(this.tabbedWork);
        switch (position) {
            case PANEL_ABOVE: {
                this.splitResponsePanelWithWorkTabbedPanel(0);
                break;
            }
            case PANELS_SIDE_BY_SIDE: {
                this.splitResponsePanelWithWorkTabbedPanel(1);
                break;
            }
            case TAB_SIDE_BY_SIDE: {
                this.splitResponsePanelWithRequestPanel(1, this.tabbedWork);
                this.getPaneWork().removeAll();
                this.getPaneWork().add(this.getTabbedWork());
                this.getPaneWork().validate();
                break;
            }
            default: {
                if (currentTabbedPanel == this.responseTabbedPanel) {
                    currentTabbedPanel = this.tabbedWork;
                }
                this.insertResponseTab(this.tabbedWork);
                this.getPaneWork().removeAll();
                this.getPaneWork().add(this.getTabbedWork());
                this.getPaneWork().validate();
            }
        }
        if (selectRequest || this.getTabbedWork().getTabCount() > 0 && this.getTabbedWork().getSelectedComponent() == null) {
            this.getTabbedWork().setSelectedComponent(this.responsePanelPosition == ResponsePanelPosition.TAB_SIDE_BY_SIDE ? this.splitRequestAndResponsePanel : this.requestPanel);
        }
        if (currentTabbedPanel != null) {
            this.componentMaximiser.maximiseComponent(currentTabbedPanel);
        }
    }

    boolean hasAnyDetachedRequestResponseTabs() {
        TabbedPanel2 tabbedPanel = this.layout == Layout.FULL ? this.getTabbedFull() : this.getTabbedWork();
        return tabbedPanel.getDetachedTabs().containsKey(this.requestPanel) || tabbedPanel.getDetachedTabs().containsKey(this.responsePanel) || tabbedPanel.getDetachedTabs().containsKey(this.splitRequestAndResponsePanel) || this.responseTabbedPanel.getDetachedTabs().containsKey(this.responsePanel);
    }

    void closeAllDetachedRequestResponseTabs() {
        TabbedPanel2 tabbedPanel = this.layout == Layout.FULL ? this.getTabbedFull() : this.getTabbedWork();
        Map<Component, TabbedPanel2.DetachedTabFrame> workDetachedTabs = tabbedPanel.getDetachedTabs();
        if (workDetachedTabs.containsKey(this.requestPanel)) {
            workDetachedTabs.get(this.requestPanel).reattach();
        }
        if (workDetachedTabs.containsKey(this.responsePanel)) {
            workDetachedTabs.get(this.responsePanel).reattach();
        }
        if (workDetachedTabs.containsKey(this.splitRequestAndResponsePanel)) {
            workDetachedTabs.get(this.splitRequestAndResponsePanel).reattach();
        }
        if (this.responseTabbedPanel.getDetachedTabs().containsKey(this.responsePanel)) {
            this.responseTabbedPanel.getDetachedTabs().get(this.responsePanel).reattach();
        }
    }

    private void updateFullLayout() {
        boolean selectRequest = this.removeSplitRequestAndResponsePanel(this.tabbedFull);
        if (this.responsePanelPosition == ResponsePanelPosition.TAB_SIDE_BY_SIDE) {
            this.splitResponsePanelWithRequestPanel(1, this.tabbedFull);
        } else {
            this.addRequestResponseTabs(this.tabbedFull);
        }
        this.getFullLayoutPanel().validate();
        if (selectRequest || this.getTabbedFull().getTabCount() > 0 && this.getTabbedFull().getSelectedComponent() == null) {
            this.tabbedFull.setSelectedComponent(this.responsePanelPosition == ResponsePanelPosition.TAB_SIDE_BY_SIDE ? this.splitRequestAndResponsePanel : this.requestPanel);
        }
    }

    private void addRequestResponseTabs(TabbedPanel2 tabbedPanel) {
        if (!tabbedPanel.getDetachedTabs().containsKey(this.requestPanel)) {
            tabbedPanel.addTab(this.requestPanel, this.requestTabIndex);
        }
        this.insertResponseTab(tabbedPanel);
    }

    private void insertResponseTab(TabbedPanel2 tabbedPanel) {
        if (!tabbedPanel.getDetachedTabs().containsKey(this.responsePanel)) {
            tabbedPanel.addTab(this.responsePanel, tabbedPanel.indexOfComponent(this.requestPanel) + 1);
        }
    }

    private String getNormalisedTabName(AbstractPanel panel) {
        return this.showTabNames ? panel.getName() : "";
    }

    private void splitResponsePanelWithWorkTabbedPanel(int orientation) {
        if (this.responseTabbedPanel.getDetachedTabs().containsKey(this.responsePanel)) {
            this.getPaneWork().removeAll();
            this.getPaneWork().add(this.getTabbedWork());
            return;
        }
        this.responseTabbedPanel.hideAllTabs();
        this.responseTabbedPanel.addTab(this.getNormalisedTabName(this.responsePanel), this.responsePanel.getIcon(), this.responsePanel);
        this.getPaneWork().removeAll();
        JSplitPane split = WorkbenchPanel.createSplitPane(orientation);
        split.setRightComponent(this.responseTabbedPanel);
        split.setLeftComponent(this.getTabbedWork());
        this.getPaneWork().add(split);
        this.getPaneWork().validate();
    }

    private static JSplitPane createSplitPane(int orientation) {
        JSplitPane splitPane = new JSplitPane(orientation);
        splitPane.setDividerSize(3);
        splitPane.setResizeWeight(0.5);
        splitPane.setContinuousLayout(false);
        splitPane.setDoubleBuffered(true);
        splitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        return splitPane;
    }

    private void splitResponsePanelWithRequestPanel(int orientation, TabbedPanel2 tabbedPanel) {
        if (this.splitRequestAndResponsePanel == null) {
            this.splitRequestAndResponsePanel = new AbstractPanel();
            this.splitRequestAndResponsePanel.setLayout(new BorderLayout());
            this.splitRequestAndResponsePanel.setName(Constant.messages.getString("http.panel.requestAndResponse.title"));
            this.splitRequestAndResponsePanel.setIcon(new ImageIcon(WorkbenchPanel.class.getResource("/resource/icon/16/handshake.png")));
            this.splitRequestAndResponsePanel.setHideable(false);
            this.splitRequestAndResponse = WorkbenchPanel.createSplitPane(orientation);
            this.splitRequestAndResponsePanel.add(this.splitRequestAndResponse);
            this.layoutPanels.get((Object)PanelType.WORK).add(this.splitRequestAndResponsePanel);
        }
        Component selectedComponent = tabbedPanel.getSelectedComponent();
        this.splitRequestAndResponse.setLeftComponent(this.requestPanel);
        tabbedPanel.removeTab(this.requestPanel);
        this.splitRequestAndResponse.setRightComponent(this.responsePanel);
        tabbedPanel.removeTab(this.responsePanel);
        if (!tabbedPanel.getDetachedTabs().containsKey(this.splitRequestAndResponsePanel)) {
            tabbedPanel.addTab(this.splitRequestAndResponsePanel, this.requestTabIndex);
            if (selectedComponent == this.requestPanel || selectedComponent == this.responsePanel) {
                tabbedPanel.setSelectedComponent(this.splitRequestAndResponsePanel);
            }
        }
    }

    private boolean removeSplitRequestAndResponsePanel(TabbedPanel2 tabbedPanel) {
        boolean selectRequest = false;
        int pos = tabbedPanel.indexOfComponent(this.splitRequestAndResponsePanel);
        if (pos != -1) {
            selectRequest = tabbedPanel.getSelectedComponent() == this.splitRequestAndResponsePanel;
            tabbedPanel.removeTab(this.splitRequestAndResponsePanel);
            this.addRequestResponseTabs(tabbedPanel);
        }
        return selectRequest;
    }

    private void saveDividerLocation(String prefix, int location) {
        if (location > 0) {
            LOGGER.debug("Saving preference {}{}.{}={}", (Object)this.prefnzPrefix, (Object)prefix, (Object)PREF_DIVIDER_LOCATION, (Object)location);
            this.preferences.put(this.prefnzPrefix + prefix + ".divider.location", Integer.toString(location));
            try {
                this.preferences.flush();
            }
            catch (BackingStoreException e) {
                LOGGER.error("Error while saving the preferences", (Throwable)e);
            }
        }
    }

    private int restoreDividerLocation(String prefix, int fallback) {
        int result = fallback;
        String sizestr = this.preferences.get(this.prefnzPrefix + prefix + ".divider.location", null);
        if (sizestr != null) {
            int location = 0;
            try {
                location = Integer.parseInt(sizestr.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (location > 0) {
                result = location;
                LOGGER.debug("Restoring preference {}{}.{}={}", (Object)this.prefnzPrefix, (Object)prefix, (Object)PREF_DIVIDER_LOCATION, (Object)location);
            }
        }
        return result;
    }

    public static enum PanelType {
        STATUS,
        SELECT,
        WORK;

    }

    public static enum ResponsePanelPosition {
        TABS_SIDE_BY_SIDE,
        PANEL_ABOVE,
        PANELS_SIDE_BY_SIDE,
        TAB_SIDE_BY_SIDE;

    }

    public static enum Layout {
        EXPAND_SELECT(0),
        EXPAND_STATUS(1),
        FULL(2);

        private final int id;

        private Layout(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static Layout getLayout(int id) {
            if (id == EXPAND_SELECT.getId()) {
                return EXPAND_SELECT;
            }
            if (id == EXPAND_STATUS.getId()) {
                return EXPAND_STATUS;
            }
            if (id == FULL.getId()) {
                return FULL;
            }
            return EXPAND_STATUS;
        }
    }

    private final class DividerResizedListener
    implements PropertyChangeListener {
        private final String prefix;

        public DividerResizedListener(String prefix) {
            assert (prefix != null);
            this.prefix = prefix;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JSplitPane component = (JSplitPane)evt.getSource();
            if (component != null) {
                LOGGER.debug("{}{}.location={}", (Object)WorkbenchPanel.this.prefnzPrefix, (Object)this.prefix, (Object)component.getDividerLocation());
                WorkbenchPanel.this.saveDividerLocation(this.prefix, component.getDividerLocation());
            }
        }
    }
}

