/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.keyboard;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.view.MainMenuBar;
import org.zaproxy.zap.extension.keyboard.KeyboardAPI;
import org.zaproxy.zap.extension.keyboard.KeyboardMapping;
import org.zaproxy.zap.extension.keyboard.KeyboardParam;
import org.zaproxy.zap.extension.keyboard.KeyboardShortcut;
import org.zaproxy.zap.extension.keyboard.OptionsKeyboardShortcutPanel;
import org.zaproxy.zap.utils.DesktopUtils;
import org.zaproxy.zap.view.ZapMenuItem;

public class ExtensionKeyboard
extends ExtensionAdaptor {
    private static final Logger LOGGER = LogManager.getLogger(ExtensionKeyboard.class);
    public static final String NAME = "ExtensionKeyboard";
    private OptionsKeyboardShortcutPanel optionsKeyboardPanel = null;
    private KeyboardParam keyboardParam = null;
    private ReferenceMap map = new ReferenceMap();
    private KeyboardAPI api = null;
    private List<String> menusDupDefaultAccelerator;

    public ExtensionKeyboard() {
        super(NAME);
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("keyboard.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        if (this.getView() != null) {
            extensionHook.addOptionsParamSet(this.getKeyboardParam());
            extensionHook.getHookView().addOptionPanel(this.getOptionsKeyboardPanel());
            this.api = new KeyboardAPI(this);
            extensionHook.addApiImplementor(this.api);
        }
    }

    protected KeyboardParam getKeyboardParam() {
        if (this.keyboardParam == null) {
            this.keyboardParam = new KeyboardParam();
        }
        return this.keyboardParam;
    }

    @Override
    public void postInit() {
        if (this.hasView()) {
            LOGGER.info("Initializing keyboard shortcuts");
            this.processMainMenuBarMenus(this::initAllMenuItems);
        }
    }

    private void processMainMenuBarMenus(Consumer<JMenu> action) {
        MainMenuBar mainMenuBar = this.getView().getMainFrame().getMainMenuBar();
        for (int i = 0; i < mainMenuBar.getMenuCount(); ++i) {
            JMenu menu = mainMenuBar.getMenu(i);
            if (menu == null) continue;
            action.accept(menu);
        }
    }

    public void registerMenuItem(ZapMenuItem zme) {
        String identifier = zme.getIdentifier();
        if (identifier != null) {
            this.validateDefaultAccelerator(zme);
            this.setConfiguredAccelerator(zme);
            this.map.put((Object)identifier, (Object)new KeyboardMapping(zme));
        } else {
            LOGGER.warn("ZapMenuItem \"{}\" has a null identifier.", (Object)zme.getName());
        }
    }

    private void validateDefaultAccelerator(ZapMenuItem zme) {
        KeyStroke ks = zme.getDefaultAccelerator();
        if (ks == null) {
            return;
        }
        if (this.isIdentifierWithDuplicatedAccelerator(zme.getIdentifier())) {
            return;
        }
        for (Object obj : this.map.values()) {
            KeyboardMapping km = (KeyboardMapping)obj;
            if (this.isIdentifierWithDuplicatedAccelerator(km.getIdentifier()) || !ExtensionKeyboard.hasSameDefaultAccelerator(km, ks) || zme.getIdentifier().equals(km.getIdentifier())) continue;
            String msg = String.format("Menus %s and %s use the same default accelerator: %s", zme.getIdentifier(), km.getIdentifier(), ks);
            LOGGER.log(Constant.isDevMode() ? Level.ERROR : Level.WARN, msg);
            if (this.menusDupDefaultAccelerator == null) {
                this.menusDupDefaultAccelerator = new ArrayList<String>();
            }
            this.menusDupDefaultAccelerator.add(zme.getIdentifier());
            if (!zme.getDefaultAccelerator().equals(zme.getAccelerator())) continue;
            zme.setAccelerator(null);
        }
    }

    private static boolean hasSameDefaultAccelerator(KeyboardMapping km, KeyStroke ks) {
        KeyStroke kmKs = km.getDefaultKeyStroke();
        if (kmKs == null) {
            return false;
        }
        return kmKs.getKeyCode() == ks.getKeyCode() && kmKs.getModifiers() == ks.getModifiers();
    }

    private boolean isIdentifierWithDuplicatedAccelerator(String identifier) {
        return this.menusDupDefaultAccelerator != null && this.menusDupDefaultAccelerator.contains(identifier);
    }

    private void initAllMenuItems(JMenu menu) {
        for (Component c : menu.getMenuComponents()) {
            if (c instanceof ZapMenuItem) {
                this.registerMenuItem((ZapMenuItem)c);
                continue;
            }
            if (c instanceof JMenu) {
                this.initAllMenuItems((JMenu)c);
                continue;
            }
            if (!(c instanceof JMenuItem)) continue;
            JMenuItem menuItem = (JMenuItem)c;
            LOGGER.debug("Unable to set accelerators on menu {}", (Object)menuItem.getText());
        }
    }

    private void setConfiguredAccelerator(ZapMenuItem menuItem) {
        KeyStroke ks = this.getKeyboardParam().getShortcut(menuItem.getIdentifier());
        if (ks == null) {
            return;
        }
        if (ks.getKeyCode() == 0) {
            LOGGER.debug("Cleaning menu {} accelerator", (Object)menuItem.getIdentifier());
            ks = null;
        } else {
            LOGGER.debug("Setting menu {} accelerator to {}", (Object)menuItem.getIdentifier(), (Object)ks);
        }
        menuItem.setAccelerator(ks);
    }

    public List<KeyboardShortcut> getShortcuts() {
        return this.getShortcuts(false);
    }

    public List<KeyboardShortcut> getShortcuts(boolean reset) {
        if (this.hasView()) {
            ArrayList<KeyboardShortcut> kss = new ArrayList<KeyboardShortcut>();
            this.processMainMenuBarMenus(menu -> this.addAllMenuItems((List<KeyboardShortcut>)kss, (JMenu)menu, reset));
            return kss;
        }
        return null;
    }

    private void addAllMenuItems(List<KeyboardShortcut> kss, JMenu menu, boolean reset) {
        for (Component c : menu.getMenuComponents()) {
            if (c instanceof ZapMenuItem) {
                kss.add(this.menuToShortcut((ZapMenuItem)c, reset));
                continue;
            }
            if (c instanceof JMenu) {
                this.addAllMenuItems(kss, (JMenu)c, reset);
                continue;
            }
            if (!(c instanceof JMenuItem)) continue;
            JMenuItem menuItem = (JMenuItem)c;
            LOGGER.debug("Unable to set accelerators on menu {}", (Object)menuItem.getText());
        }
    }

    private KeyboardShortcut menuToShortcut(ZapMenuItem menuItem, boolean reset) {
        if (reset) {
            return new KeyboardShortcut(menuItem.getIdentifier(), menuItem.getText(), this.getDefaultAccelerator(menuItem));
        }
        this.setConfiguredAccelerator(menuItem);
        return new KeyboardShortcut(menuItem.getIdentifier(), menuItem.getText(), menuItem.getAccelerator());
    }

    private KeyStroke getDefaultAccelerator(ZapMenuItem menuItem) {
        if (this.isIdentifierWithDuplicatedAccelerator(menuItem.getIdentifier())) {
            return null;
        }
        return menuItem.getDefaultAccelerator();
    }

    public KeyStroke getShortcut(String identifier) {
        KeyboardMapping mapping = (KeyboardMapping)this.map.get((Object)identifier);
        if (mapping == null) {
            return null;
        }
        return mapping.getKeyStroke();
    }

    public void setShortcut(String identifier, KeyStroke ks) {
        KeyboardMapping mapping = (KeyboardMapping)this.map.get((Object)identifier);
        if (mapping == null) {
            LOGGER.error("No mapping found for keyboard shortcut: {}", (Object)identifier);
            return;
        }
        mapping.setKeyStroke(ks);
        this.getKeyboardParam().setShortcut(identifier, ks);
    }

    private OptionsKeyboardShortcutPanel getOptionsKeyboardPanel() {
        if (this.optionsKeyboardPanel == null) {
            this.optionsKeyboardPanel = new OptionsKeyboardShortcutPanel(this);
        }
        return this.optionsKeyboardPanel;
    }

    public void displayCheatsheetSortedByAction() {
        try {
            DesktopUtils.openUrlInBrowser(this.api.getCheatSheetActionURI());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void displayCheatsheetSortedByKey() {
        try {
            DesktopUtils.openUrlInBrowser(this.api.getCheatSheetKeyURI());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("keyboard.desc");
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }
}

