/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.script;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import org.zaproxy.zap.extension.script.ScriptNode;
import org.zaproxy.zap.extension.script.ScriptType;
import org.zaproxy.zap.extension.script.ScriptWrapper;
import org.zaproxy.zap.utils.ThreadUtils;

public class ScriptTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 1L;
    private Map<String, ScriptNode> scriptsNodeMap = new HashMap<String, ScriptNode>();
    private Map<String, ScriptNode> templatesNodeMap = new HashMap<String, ScriptNode>();
    private ScriptNode scriptsNode = new ScriptNode(false);
    private ScriptNode templatesNode = new ScriptNode(true);

    ScriptTreeModel() {
        super(new ScriptNode());
        this.getRoot().add(this.scriptsNode);
        this.getRoot().add(this.templatesNode);
    }

    protected void addType(ScriptType type) {
        ScriptNode sNode = new ScriptNode(type, false);
        this.scriptsNodeMap.put(type.getName(), sNode);
        this.addToParentSorted(this.scriptsNode, sNode);
        ScriptNode tNode = new ScriptNode(type, true);
        this.templatesNodeMap.put(type.getName(), tNode);
        this.addToParentSorted(this.templatesNode, tNode);
    }

    protected void removeType(ScriptType type) {
        ScriptNode templateNode;
        String typeName = type.getName();
        ScriptNode scriptNode = this.scriptsNodeMap.remove(typeName);
        if (scriptNode != null) {
            this.removeNodeFromParent(scriptNode);
        }
        if ((templateNode = this.templatesNodeMap.remove(typeName)) != null) {
            this.removeNodeFromParent(templateNode);
        }
    }

    private void addToParentSorted(ScriptNode parent, ScriptNode child) {
        int childCount;
        int idx = childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ScriptNode sn = (ScriptNode)parent.getChildAt(i);
            if (child.getNodeName().compareToIgnoreCase(sn.getNodeName()) >= 0) continue;
            idx = i;
            break;
        }
        this.insertNodeInto(child, parent, idx);
    }

    public ScriptNode getTypeNode(String type) {
        return this.scriptsNodeMap.get(type);
    }

    @Override
    public ScriptNode getRoot() {
        return (ScriptNode)this.root;
    }

    public ScriptNode getScriptsNode() {
        return this.scriptsNode;
    }

    public ScriptNode getTemplatesNode() {
        return this.templatesNode;
    }

    public List<ScriptNode> getNodes(String type) {
        ArrayList<ScriptNode> list = new ArrayList<ScriptNode>();
        ScriptNode parent = this.scriptsNodeMap.get(type);
        if (parent != null) {
            for (int i = 0; i < parent.getChildCount(); ++i) {
                list.add((ScriptNode)parent.getChildAt(i));
            }
        }
        return list;
    }

    public ScriptNode addScript(ScriptWrapper script) {
        if (script == null) {
            return null;
        }
        if (this.getScript(script.getName()) != null) {
            throw new InvalidParameterException("A script with the same name already exists: " + script.getName());
        }
        if (script.getType() == null) {
            throw new InvalidParameterException("Script does not define a type: " + script.getName());
        }
        ScriptNode node = new ScriptNode(script);
        if (script.getType() == null) {
            throw new InvalidParameterException("Unrecognised type: " + script.getTypeName());
        }
        ScriptNode parent = this.scriptsNodeMap.get(script.getType().getName());
        if (parent != null) {
            this.addToParentSorted(parent, node);
            return node;
        }
        throw new InvalidParameterException("Unrecognised type: " + script.getType() + " for script " + script.getName());
    }

    public void removeScript(ScriptWrapper script) {
        if (script == null) {
            return;
        }
        ScriptNode node = this.getNodeForScript(script);
        ScriptNode parent = node.getParent();
        if (parent != null) {
            this.removeNodeFromParent(node);
        }
    }

    public ScriptNode getNodeForScript(ScriptWrapper script) {
        ScriptNode parent = this.scriptsNodeMap.get(script.getType().getName());
        if (parent != null && parent.getChildCount() > 0) {
            ScriptNode node = (ScriptNode)parent.getFirstChild();
            while (node != null) {
                if (script.equals(node.getUserObject())) {
                    return node;
                }
                node = (ScriptNode)parent.getChildAfter(node);
            }
        }
        return null;
    }

    public void nodeStructureChanged(ScriptWrapper script) {
        ScriptNode node = this.getNodeForScript(script);
        if (node != null) {
            ThreadUtils.invokeAndWaitHandled(() -> this.nodeStructureChanged(node));
        }
    }

    public ScriptWrapper getScript(String name) {
        ScriptNode typeNode = (ScriptNode)this.scriptsNode.getFirstChild();
        while (typeNode != null) {
            if (typeNode.getChildCount() > 0) {
                ScriptNode scriptNode = (ScriptNode)typeNode.getFirstChild();
                while (scriptNode != null) {
                    if (((ScriptWrapper)scriptNode.getUserObject()).getName().equals(name)) {
                        return (ScriptWrapper)scriptNode.getUserObject();
                    }
                    scriptNode = (ScriptNode)typeNode.getChildAfter(scriptNode);
                }
            }
            typeNode = (ScriptNode)this.scriptsNode.getChildAfter(typeNode);
        }
        return null;
    }

    public ScriptNode addTemplate(ScriptWrapper template) {
        if (template == null) {
            return null;
        }
        if (this.getTemplate(template.getName()) != null) {
            throw new InvalidParameterException("A template with the same name already exists: " + template.getName());
        }
        ScriptNode node = new ScriptNode(template, true);
        ScriptNode parent = this.templatesNodeMap.get(template.getType().getName());
        if (parent != null) {
            this.addToParentSorted(parent, node);
            return node;
        }
        throw new InvalidParameterException("Unrecognised type: " + template.getType());
    }

    public void removeTemplate(ScriptWrapper template) {
        if (template == null) {
            return;
        }
        ScriptNode node = this.getNodeForTemplate(template);
        ScriptNode parent = node.getParent();
        if (parent != null) {
            this.removeNodeFromParent(node);
        }
    }

    public ScriptWrapper getTemplate(String name) {
        ScriptNode typeNode = (ScriptNode)this.templatesNode.getFirstChild();
        while (typeNode != null) {
            if (typeNode.getChildCount() > 0) {
                ScriptNode scriptNode = (ScriptNode)typeNode.getFirstChild();
                while (scriptNode != null) {
                    if (((ScriptWrapper)scriptNode.getUserObject()).getName().equals(name)) {
                        return (ScriptWrapper)scriptNode.getUserObject();
                    }
                    scriptNode = (ScriptNode)typeNode.getChildAfter(scriptNode);
                }
            }
            typeNode = (ScriptNode)this.templatesNode.getChildAfter(typeNode);
        }
        return null;
    }

    public ScriptNode getNodeForTemplate(ScriptWrapper script) {
        ScriptNode parent = this.templatesNodeMap.get(script.getType().getName());
        if (parent != null) {
            ScriptNode node = (ScriptNode)parent.getFirstChild();
            while (node != null) {
                if (script.equals(node.getUserObject())) {
                    return node;
                }
                node = (ScriptNode)parent.getChildAfter(node);
            }
        }
        return null;
    }

    public List<ScriptWrapper> getTemplates(ScriptType type) {
        ArrayList<ScriptWrapper> list = new ArrayList<ScriptWrapper>();
        ScriptNode typeNode = (ScriptNode)this.templatesNode.getFirstChild();
        while (typeNode != null) {
            if ((type == null || type.equals(typeNode.getType())) && typeNode.getChildCount() > 0) {
                ScriptNode scriptNode = (ScriptNode)typeNode.getFirstChild();
                while (scriptNode != null) {
                    list.add((ScriptWrapper)scriptNode.getUserObject());
                    scriptNode = (ScriptNode)typeNode.getChildAfter(scriptNode);
                }
            }
            typeNode = (ScriptNode)this.templatesNode.getChildAfter(typeNode);
        }
        return list;
    }
}

