/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.session;

import net.sf.json.JSONObject;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.httpclient.HttpState;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.api.ApiDynamicActionImplementor;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.session.AbstractSessionManagementMethodOptionsPanel;
import org.zaproxy.zap.session.SessionManagementMethod;
import org.zaproxy.zap.session.SessionManagementMethodType;
import org.zaproxy.zap.session.WebSession;
import org.zaproxy.zap.utils.ApiUtils;

public class HttpAuthSessionManagementMethodType
extends SessionManagementMethodType {
    private static final int METHOD_IDENTIFIER = 1;
    private static final String METHOD_NAME = Constant.messages.getString("sessionmanagement.method.ha.name");
    private static final String API_METHOD_NAME = "httpAuthSessionManagement";

    @Override
    public SessionManagementMethod createSessionManagementMethod(int contextId) {
        return new HttpAuthSessionManagementMethod();
    }

    @Override
    public String getName() {
        return METHOD_NAME;
    }

    @Override
    public int getUniqueIdentifier() {
        return 1;
    }

    @Override
    public AbstractSessionManagementMethodOptionsPanel buildOptionsPanel(Context uiSharedContext) {
        return null;
    }

    @Override
    public boolean hasOptionsPanel() {
        return false;
    }

    @Override
    public boolean isTypeForMethod(SessionManagementMethod method) {
        return method instanceof HttpAuthSessionManagementMethod;
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
    }

    @Override
    public SessionManagementMethod loadMethodFromSession(Session session, int contextId) throws DatabaseException {
        return new HttpAuthSessionManagementMethod();
    }

    @Override
    public void persistMethodToSession(Session session, int contextId, SessionManagementMethod method) throws SessionManagementMethodType.UnsupportedSessionManagementMethodException, DatabaseException {
    }

    @Override
    public void exportData(Configuration config, SessionManagementMethod sessionMethod) {
    }

    @Override
    public void importData(Configuration config, SessionManagementMethod sessionMethod) throws ConfigurationException {
    }

    @Override
    public ApiDynamicActionImplementor getSetMethodForContextApiAction() {
        return new ApiDynamicActionImplementor(API_METHOD_NAME, null, null){

            @Override
            public void handleAction(JSONObject params) throws ApiException {
                Context context = ApiUtils.getContextByParamId(params, "contextId");
                context.setSessionManagementMethod(HttpAuthSessionManagementMethodType.this.createSessionManagementMethod(context.getId()));
            }
        };
    }

    public static class HttpAuthSessionManagementMethod
    implements SessionManagementMethod {
        @Override
        public boolean isConfigured() {
            return true;
        }

        @Override
        public SessionManagementMethodType getType() {
            return new HttpAuthSessionManagementMethodType();
        }

        @Override
        public WebSession extractWebSession(HttpMessage msg) {
            return new HttpAuthSession();
        }

        @Override
        public WebSession createEmptyWebSession() {
            return new HttpAuthSession();
        }

        @Override
        public void clearWebSessionIdentifiers(HttpMessage msg) {
        }

        @Override
        public ApiResponse getApiResponseRepresentation() {
            return new ApiResponseElement("methodName", HttpAuthSessionManagementMethodType.API_METHOD_NAME);
        }

        @Override
        public void processMessageToMatchSession(HttpMessage message, WebSession session) throws SessionManagementMethod.UnsupportedWebSessionException {
        }

        @Override
        public SessionManagementMethod clone() {
            return new HttpAuthSessionManagementMethod();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return this.getClass() == obj.getClass();
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    public static class HttpAuthSession
    extends WebSession {
        private static int generatedNameIndex;

        public HttpAuthSession(String name) {
            super(name, new HttpState());
        }

        public HttpAuthSession() {
            super("Http Auth Session " + generatedNameIndex++, new HttpState());
        }
    }
}

