/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.dynssl;

import java.awt.BorderLayout;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Locale;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.openssl.jcajce.JcaMiscPEMGenerator;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.zaproxy.zap.extension.dynssl.DynSSLParam;
import org.zaproxy.zap.extension.dynssl.ExtensionDynSSL;
import org.zaproxy.zap.extension.dynssl.SslCertificateUtils;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.utils.ZapTextArea;
import org.zaproxy.zap.utils.ZapXmlConfiguration;
import org.zaproxy.zap.view.widgets.WritableFileChooser;

public class DynamicSSLPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private static final int MIN_CERT_LENGTH = 10;
    private static final String OWASP_ZAP_ROOT_CA_NAME = "owasp_zap_root_ca";
    private static final String OWASP_ZAP_ROOT_CA_FILE_EXT = ".cer";
    private static final String OWASP_ZAP_ROOT_CA_FILENAME = "owasp_zap_root_ca.cer";
    private static final String CONFIGURATION_FILENAME = "config.xml";
    private ZapTextArea txt_PubCert;
    private JButton bt_view;
    private JButton bt_save;
    private KeyStore rootca;
    private ExtensionDynSSL extension;
    private static final Logger logger = Logger.getLogger(DynamicSSLPanel.class);

    public DynamicSSLPanel(ExtensionDynSSL extension) {
        this.extension = extension;
        this.setName(Constant.messages.getString("dynssl.options.name"));
        this.setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.add(panel);
        JLabel lbl_Cert = new JLabel(Constant.messages.getString("dynssl.label.rootca"));
        this.txt_PubCert = new ZapTextArea();
        this.txt_PubCert.setFont(FontUtils.getFont("Monospaced"));
        this.txt_PubCert.setEditable(false);
        this.txt_PubCert.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.checkAndEnableButtons();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.checkAndEnableButtons();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.checkAndEnableButtons();
            }

            private void checkAndEnableButtons() {
                DynamicSSLPanel.this.checkAndEnableViewButton();
                DynamicSSLPanel.this.checkAndEnableSaveButton();
            }
        });
        JScrollPane pubCertScrollPane = new JScrollPane(this.txt_PubCert);
        JButton bt_generate = new JButton(Constant.messages.getString("dynssl.button.generate"));
        bt_generate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DynamicSSLPanel.this.doGenerate();
            }
        });
        bt_generate.setIcon(new ImageIcon(DynamicSSLPanel.class.getResource("/resource/icon/16/041.png")));
        this.bt_save = new JButton(Constant.messages.getString("menu.file.save"));
        this.checkAndEnableSaveButton();
        this.bt_save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DynamicSSLPanel.this.doSave();
            }
        });
        this.bt_save.setIcon(new ImageIcon(DynamicSSLPanel.class.getResource("/resource/icon/16/096.png")));
        this.bt_view = new JButton(Constant.messages.getString("menu.view"));
        this.checkAndEnableViewButton();
        this.bt_view.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DynamicSSLPanel.this.doView();
            }
        });
        this.bt_view.setIcon(new ImageIcon(DynamicSSLPanel.class.getResource("/resource/icon/16/049.png")));
        JButton bt_import = new JButton(Constant.messages.getString("dynssl.button.import"));
        bt_import.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DynamicSSLPanel.this.doImport();
            }
        });
        bt_import.setIcon(new ImageIcon(DynamicSSLPanel.class.getResource("/resource/icon/16/047.png")));
        GroupLayout gl_panel = new GroupLayout(panel);
        gl_panel.setHorizontalGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel.createSequentialGroup().addContainerGap().addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(gl_panel.createSequentialGroup().addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(lbl_Cert, -2, 115, -2).addGroup(gl_panel.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(bt_generate))).addGap(6)).addGroup(gl_panel.createSequentialGroup().addComponent(bt_import).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel.createSequentialGroup().addComponent(this.bt_view).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bt_save)).addComponent(pubCertScrollPane, -1, 369, Short.MAX_VALUE)).addContainerGap()));
        gl_panel.setVerticalGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel.createSequentialGroup().addGap(10).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.BASELINE).addGroup(gl_panel.createSequentialGroup().addComponent(lbl_Cert).addGap(10).addComponent(bt_generate, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(bt_import, -2, 25, -2)).addComponent(pubCertScrollPane, -2, 400, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bt_save, -2, 25, -2).addComponent(this.bt_view, -2, 25, -2)).addGap(0, 29, Short.MAX_VALUE)));
        panel.setLayout(gl_panel);
    }

    @Override
    public void initParam(Object obj) {
        OptionsParam options = (OptionsParam)obj;
        DynSSLParam param = options.getParamSet(DynSSLParam.class);
        this.setRootca(param.getRootca());
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        OptionsParam options = (OptionsParam)obj;
        DynSSLParam param = options.getParamSet(DynSSLParam.class);
        param.setRootca(this.rootca);
        this.extension.setRootCa(this.rootca);
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.dynsslcert";
    }

    private void setRootca(KeyStore rootca) {
        this.rootca = rootca;
        StringWriter sw = new StringWriter();
        if (rootca != null) {
            try {
                Certificate cert = rootca.getCertificate(OWASP_ZAP_ROOT_CA_NAME);
                try (PemWriter pw = new PemWriter((Writer)sw);){
                    pw.writeObject((PemObjectGenerator)new JcaMiscPEMGenerator((Object)cert));
                    pw.flush();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Error while extracting public part from generated Root CA certificate.", (Throwable)e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Certificate defined.\n" + sw.toString()));
        }
        this.txt_PubCert.setText(sw.toString());
    }

    private void checkAndEnableViewButton() {
        boolean enabled = true;
        enabled &= Desktop.isDesktopSupported();
        this.bt_view.setEnabled(enabled &= this.txt_PubCert.getDocument().getLength() > 10);
    }

    private void checkAndEnableSaveButton() {
        boolean enabled = true;
        this.bt_save.setEnabled(enabled &= this.txt_PubCert.getDocument().getLength() > 10);
    }

    private void doImport() {
        if (this.checkExistingCertificate()) {
            return;
        }
        JFileChooser fc = new JFileChooser(System.getProperty("user.home"));
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        fc.setSelectedFile(new File(CONFIGURATION_FILENAME));
        fc.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return Constant.messages.getString("dynssl.filter.file");
            }

            @Override
            public boolean accept(File f) {
                String lcFileName = f.getName().toLowerCase(Locale.ROOT);
                return lcFileName.endsWith(DynamicSSLPanel.CONFIGURATION_FILENAME) || lcFileName.endsWith("pem") || f.isDirectory();
            }
        });
        int result = fc.showOpenDialog(this);
        File f = fc.getSelectedFile();
        if (result == 0 && f.exists()) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Loading Root CA certificate from " + f));
            }
            KeyStore ks = null;
            if (f.getName().toLowerCase().endsWith("pem")) {
                ks = this.convertPemFileToKeyStore(f.toPath());
            } else {
                try {
                    ZapXmlConfiguration conf = new ZapXmlConfiguration(f);
                    String rootcastr = conf.getString("dynssl.param.rootca");
                    if (rootcastr == null || rootcastr.isEmpty()) {
                        JOptionPane.showMessageDialog(this, Constant.messages.getString("dynssl.message.nocertinconf"), Constant.messages.getString("dynssl.message.nocertinconf.title"), 0);
                        return;
                    }
                    ks = SslCertificateUtils.string2Keystore(rootcastr);
                }
                catch (Exception e) {
                    logger.error((Object)"Error importing Root CA cert from config file:", (Throwable)e);
                    JOptionPane.showMessageDialog(this, Constant.messages.getString("dynssl.message1.filecouldntloaded"), Constant.messages.getString("dynssl.message1.title"), 0);
                    return;
                }
            }
            if (ks != null) {
                this.setRootca(ks);
            }
        }
    }

    private KeyStore convertPemFileToKeyStore(Path pemFile) {
        byte[] key;
        byte[] cert;
        String pem;
        try {
            pem = FileUtils.readFileToString((File)pemFile.toFile(), (Charset)StandardCharsets.US_ASCII);
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to read .pem file:", (Throwable)e);
            JOptionPane.showMessageDialog(this, Constant.messages.getString("dynssl.importpem.failedreadfile", e.getLocalizedMessage()), Constant.messages.getString("dynssl.importpem.failed.title"), 0);
            return null;
        }
        try {
            cert = SslCertificateUtils.extractCertificate(pem);
            if (cert.length == 0) {
                JOptionPane.showMessageDialog(this, Constant.messages.getString("dynssl.importpem.nocertsection", "-----BEGIN CERTIFICATE-----", "-----END CERTIFICATE-----"), Constant.messages.getString("dynssl.importpem.failed.title"), 0);
                return null;
            }
        }
        catch (IllegalArgumentException e) {
            logger.warn((Object)"Failed to base64 decode the certificate from .pem file:", (Throwable)e);
            JOptionPane.showMessageDialog(this, Constant.messages.getString("dynssl.importpem.certnobase64"), Constant.messages.getString("dynssl.importpem.failed.title"), 0);
            return null;
        }
        try {
            key = SslCertificateUtils.extractPrivateKey(pem);
            if (key.length == 0) {
                JOptionPane.showMessageDialog(this, Constant.messages.getString("dynssl.importpem.noprivkeysection", "-----BEGIN PRIVATE KEY-----", "-----END PRIVATE KEY-----"), Constant.messages.getString("dynssl.importpem.failed.title"), 0);
                return null;
            }
        }
        catch (IllegalArgumentException e) {
            logger.warn((Object)"Failed to base64 decode the private key from .pem file:", (Throwable)e);
            JOptionPane.showMessageDialog(this, Constant.messages.getString("dynssl.importpem.privkeynobase64"), Constant.messages.getString("dynssl.importpem.failed.title"), 0);
            return null;
        }
        try {
            return SslCertificateUtils.pem2KeyStore(cert, key);
        }
        catch (Exception e) {
            logger.error((Object)"Error creating KeyStore for Root CA cert from .pem file:", (Throwable)e);
            JOptionPane.showMessageDialog(this, Constant.messages.getString("dynssl.importpem.failedkeystore", e.getLocalizedMessage()), Constant.messages.getString("dynssl.importpem.failed.title"), 0);
            return null;
        }
    }

    private void doSave() {
        if (this.txt_PubCert.getDocument().getLength() < 10) {
            logger.error((Object)"Illegal state! There seems to be no certificate available.");
            this.bt_save.setEnabled(false);
        }
        WritableFileChooser fc = new WritableFileChooser(new File(System.getProperty("user.home")));
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        fc.setSelectedFile(new File(OWASP_ZAP_ROOT_CA_FILENAME));
        if (fc.showSaveDialog(this) == 0) {
            File f = fc.getSelectedFile();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Saving Root CA certificate to " + f));
            }
            try {
                this.writePubCertificateToFile(f);
            }
            catch (Exception e) {
                logger.error((Object)("Error while writing certificate data to file " + f), (Throwable)e);
            }
        }
    }

    private void writePubCertificateToFile(File file) throws IOException {
        try (BufferedWriter bw = Files.newBufferedWriter(file.toPath(), StandardCharsets.US_ASCII, new OpenOption[0]);){
            bw.write(this.txt_PubCert.getText());
        }
    }

    private void doGenerate() {
        if (this.checkExistingCertificate()) {
            return;
        }
        try {
            KeyStore newrootca = SslCertificateUtils.createRootCA();
            this.setRootca(newrootca);
        }
        catch (Exception e) {
            logger.error((Object)"Error while generating Root CA certificate", (Throwable)e);
        }
    }

    private boolean checkExistingCertificate() {
        boolean alreadyexists;
        boolean bl = alreadyexists = this.txt_PubCert.getDocument().getLength() > 10;
        if (alreadyexists) {
            int result = JOptionPane.showConfirmDialog(this, Constant.messages.getString("dynssl.message2.caalreadyexists") + "\n" + Constant.messages.getString("dynssl.message2.willreplace") + "\n\n" + Constant.messages.getString("dynssl.message2.wanttooverwrite"), Constant.messages.getString("dynssl.message2.title"), 0);
            alreadyexists = result != 0;
        }
        return alreadyexists;
    }

    private void doView() {
        if (this.txt_PubCert.getDocument().getLength() < 10) {
            logger.error((Object)"Illegal state! There seems to be no certificate available.");
            this.bt_view.setEnabled(false);
        }
        boolean written = false;
        File tmpfile = null;
        try {
            tmpfile = File.createTempFile(OWASP_ZAP_ROOT_CA_NAME, OWASP_ZAP_ROOT_CA_FILE_EXT);
            this.writePubCertificateToFile(tmpfile);
            written = true;
        }
        catch (Exception e) {
            logger.error((Object)"Error while writing certificate data into temporary file.", (Throwable)e);
        }
        if (tmpfile != null && written && Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().open(tmpfile);
            }
            catch (IOException e) {
                logger.error((Object)("Error while telling the Operating System to open " + tmpfile), (Throwable)e);
            }
        }
    }
}

