/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zest.core.v1;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.zaproxy.zest.core.v1.ZestAction;
import org.zaproxy.zest.core.v1.ZestActionFailException;
import org.zaproxy.zest.core.v1.ZestElement;
import org.zaproxy.zest.core.v1.ZestResponse;
import org.zaproxy.zest.core.v1.ZestRuntime;

public class ZestActionInvoke
extends ZestAction {
    private String variableName;
    private String script;
    private List<String[]> parameters = new ArrayList<String[]>();
    private String charset;

    public ZestActionInvoke() {
    }

    public ZestActionInvoke(int index) {
        super(index);
    }

    public ZestActionInvoke(String script, String variableName, List<String[]> parameters) {
        this(script, variableName, parameters, null);
    }

    public ZestActionInvoke(String script, String variableName, List<String[]> parameters, String charset) {
        this.script = script;
        this.variableName = variableName;
        this.parameters = parameters;
        this.charset = charset;
    }

    @Override
    public boolean isSameSubclass(ZestElement ze) {
        return ze instanceof ZestActionInvoke;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String invoke(ZestResponse response, ZestRuntime runtime) throws ZestActionFailException {
        File f = new File(this.script);
        if (!f.exists()) {
            throw new ZestActionFailException((ZestAction)this, "No such file: " + f.getAbsolutePath());
        }
        if (f.isDirectory()) {
            throw new ZestActionFailException((ZestAction)this, "Is a directory: " + f.getAbsolutePath());
        }
        String ext = null;
        if (this.script.indexOf(".") > 0) {
            ext = this.script.substring(this.script.lastIndexOf(".") + 1);
        }
        ScriptEngine engine = null;
        if (ext != null) {
            engine = ext.equalsIgnoreCase("zest") || ext.equalsIgnoreCase("zst") ? runtime.getScriptEngineFactory().getScriptEngine() : new ScriptEngineManager().getEngineByName(ext);
        }
        if (engine == null) {
            if (!f.canExecute()) {
                if (ext == null) throw new ZestActionFailException((ZestAction)this, "Script is not executable and does not have an extension: " + f.getAbsolutePath());
                throw new ZestActionFailException((ZestAction)this, "Unknown script engine for extension: " + ext);
            }
            try {
                String[] cmdarray;
                StringBuilder sb = new StringBuilder();
                if (this.parameters == null) {
                    cmdarray = new String[]{f.getAbsolutePath()};
                } else {
                    cmdarray = new String[this.parameters.size() + 1];
                    cmdarray[0] = f.getAbsolutePath();
                    int i = 1;
                    for (String[] kvPair : this.parameters) {
                        cmdarray[i] = kvPair[0] + "=" + runtime.replaceVariablesInString(kvPair[1], false);
                    }
                }
                Process p = new ProcessBuilder(cmdarray).redirectErrorStream(true).start();
                p.waitFor();
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream(), this.getCharsetImpl()));
                String line = null;
                while (true) {
                    if ((line = br.readLine()) == null) {
                        String result = sb.toString();
                        runtime.setVariable(this.variableName, result);
                        return result;
                    }
                    sb.append(line);
                    sb.append("\n");
                }
            }
            catch (Exception e) {
                throw new ZestActionFailException((ZestAction)this, (Throwable)e);
            }
        }
        engine.getContext().setWriter(runtime.getScriptEngineFactory().getScriptEngine().getContext().getWriter());
        try (BufferedReader reader = Files.newBufferedReader(f.toPath(), this.getCharsetImpl());){
            Object result;
            Bindings bindings = engine.createBindings();
            if (this.parameters != null) {
                for (String[] kvPair : this.parameters) {
                    bindings.put(kvPair[0], (Object)runtime.replaceVariablesInString(kvPair[1], false));
                }
            }
            if ((result = engine.eval((Reader)reader, bindings)) == null) {
                String[] kvPair;
                kvPair = null;
                return kvPair;
            }
            String resultStr = result.toString();
            runtime.setVariable(this.variableName, resultStr);
            String string = resultStr;
            return string;
        }
        catch (Exception e) {
            throw new ZestActionFailException((ZestAction)this, (Throwable)e);
        }
    }

    private Charset getCharsetImpl() {
        if (this.charset == null || this.charset.isEmpty()) {
            return Charset.defaultCharset();
        }
        return Charset.forName(this.charset);
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public List<String[]> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<String[]> parameters) {
        this.parameters = parameters;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public ZestActionInvoke deepCopy() {
        ZestActionInvoke copy = new ZestActionInvoke(this.getIndex());
        copy.script = this.script;
        copy.variableName = this.variableName;
        copy.parameters = new ArrayList<String[]>();
        for (String[] kvPair : this.parameters) {
            copy.parameters.add(new String[]{kvPair[0], kvPair[1]});
        }
        copy.setEnabled(this.isEnabled());
        copy.setCharset(this.getCharset());
        return copy;
    }

    @Override
    public boolean isPassive() {
        return false;
    }
}

