/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zest.core.v1;

import com.machinepublishers.jbrowserdriver.JBrowserDriver;
import com.opera.core.systems.OperaDriver;
import java.io.File;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.safari.SafariOptions;
import org.zaproxy.zest.core.v1.ZestClient;
import org.zaproxy.zest.core.v1.ZestClientFailException;
import org.zaproxy.zest.core.v1.ZestElement;
import org.zaproxy.zest.core.v1.ZestRuntime;
import org.zaproxy.zest.core.v1.ZestStatement;

public class ZestClientLaunch
extends ZestClient {
    private String windowHandle = null;
    private String browserType = null;
    private String url = null;
    private String capabilities = null;
    private boolean headless = true;
    private String profilePath;

    public ZestClientLaunch(String windowHandle, String browserType, String url) {
        this(windowHandle, browserType, url, null);
    }

    public ZestClientLaunch(String windowHandle, String browserType, String url, boolean headless) {
        this(windowHandle, browserType, url, null, headless);
    }

    public ZestClientLaunch(String windowHandle, String browserType, String url, boolean headless, String profilePath) {
        this(windowHandle, browserType, url, null, headless, profilePath);
    }

    public ZestClientLaunch(String windowHandle, String browserType, String url, String capabilities) {
        this(windowHandle, browserType, url, capabilities, true);
    }

    public ZestClientLaunch(String windowHandle, String browserType, String url, String capabilities, boolean headless) {
        this(windowHandle, browserType, url, capabilities, headless, "");
    }

    public ZestClientLaunch(String windowHandle, String browserType, String url, String capabilities, boolean headless, String profilePath) {
        this.windowHandle = windowHandle;
        this.browserType = browserType;
        this.url = url;
        this.capabilities = capabilities;
        this.headless = headless;
        this.profilePath = profilePath;
    }

    public ZestClientLaunch() {
    }

    public String getWindowHandle() {
        return this.windowHandle;
    }

    public void setWindowHandle(String windowHandle) {
        this.windowHandle = windowHandle;
    }

    public String getBrowserType() {
        return this.browserType;
    }

    public void setBrowserType(String browserType) {
        this.browserType = browserType;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(String capabilities) {
        this.capabilities = capabilities;
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public void setHeadless(boolean headless) {
        this.headless = headless;
    }

    public String getProfilePath() {
        return this.profilePath;
    }

    public void setProfilePath(String profilePath) {
        this.profilePath = profilePath;
    }

    @Override
    public ZestStatement deepCopy() {
        ZestClientLaunch copy = new ZestClientLaunch(this.getWindowHandle(), this.getBrowserType(), this.getUrl(), this.getCapabilities(), this.isHeadless(), this.getProfilePath());
        copy.setEnabled(this.isEnabled());
        return copy;
    }

    @Override
    public boolean isPassive() {
        return false;
    }

    @Override
    public String invoke(ZestRuntime runtime) throws ZestClientFailException {
        try {
            HtmlUnitDriver driver = null;
            DesiredCapabilities cap = new DesiredCapabilities();
            cap.setCapability("acceptSslCerts", true);
            cap.setAcceptInsecureCerts(true);
            String httpProxy = runtime.getProxy();
            if (httpProxy.length() > 0) {
                String[] proxy = new Proxy();
                proxy.setHttpProxy(httpProxy);
                proxy.setSslProxy(httpProxy);
                cap.setCapability("proxy", (Object)proxy);
            }
            if (this.capabilities != null) {
                for (String capability : this.capabilities.split("\n")) {
                    if (capability == null || capability.trim().length() <= 0) continue;
                    String[] typeValue = capability.split("=");
                    if (typeValue.length != 2) {
                        throw new ZestClientFailException((ZestElement)this, "Invalid capability, expected type=value : " + capability);
                    }
                    cap.setCapability(typeValue[0], typeValue[1]);
                }
            }
            if ("Firefox".equalsIgnoreCase(this.browserType)) {
                FirefoxOptions firefoxOptions = new FirefoxOptions();
                firefoxOptions.setHeadless(this.isHeadless());
                if (this.isProfilePathSet()) {
                    firefoxOptions.setProfile(new FirefoxProfile(new File(this.profilePath)));
                }
                if (!httpProxy.isEmpty()) {
                    String[] proxyData = httpProxy.split(":");
                    String proxyAddress = proxyData[0];
                    int proxyPort = Integer.parseInt(proxyData[1]);
                    firefoxOptions.addPreference("network.proxy.type", 1);
                    firefoxOptions.addPreference("network.proxy.http", proxyAddress);
                    firefoxOptions.addPreference("network.proxy.http_port", proxyPort);
                    firefoxOptions.addPreference("network.proxy.ssl", proxyAddress);
                    firefoxOptions.addPreference("network.proxy.ssl_port", proxyPort);
                    firefoxOptions.addPreference("network.proxy.share_proxy_settings", true);
                    firefoxOptions.addPreference("network.proxy.no_proxies_on", "");
                    cap.setCapability("proxy", null);
                    firefoxOptions.addPreference("network.proxy.allow_hijacking_localhost", true);
                }
                firefoxOptions.merge((Capabilities)cap);
                driver = new FirefoxDriver(firefoxOptions);
            } else if ("Chrome".equalsIgnoreCase(this.browserType)) {
                ChromeOptions chromeOptions = new ChromeOptions();
                chromeOptions.setHeadless(this.isHeadless());
                if (this.isProfilePathSet()) {
                    Path path = Paths.get(this.profilePath, new String[0]);
                    String userDataDir = path.getParent().toString();
                    String profileDirName = path.getFileName().toString();
                    chromeOptions.addArguments(new String[]{"user-data-dir=" + userDataDir});
                    chromeOptions.addArguments(new String[]{"--profile-directory=" + profileDirName});
                }
                if (!httpProxy.isEmpty()) {
                    chromeOptions.addArguments(new String[]{"--proxy-bypass-list=<-loopback>"});
                }
                chromeOptions.merge((Capabilities)cap);
                driver = new ChromeDriver(chromeOptions);
            } else if ("HtmlUnit".equalsIgnoreCase(this.browserType)) {
                driver = new HtmlUnitDriver((Capabilities)DesiredCapabilities.htmlUnit().merge((Capabilities)cap));
            } else if ("InternetExplorer".equalsIgnoreCase(this.browserType)) {
                driver = new InternetExplorerDriver(new InternetExplorerOptions((Capabilities)cap));
            } else if ("JBD".equalsIgnoreCase(this.browserType)) {
                cap.setCapability("jbd.headless", this.isHeadless());
                cap.setCapability("jbd.ssl", "trustanything");
                driver = new JBrowserDriver((Capabilities)cap);
            } else if ("Opera".equalsIgnoreCase(this.browserType)) {
                driver = new OperaDriver((Capabilities)cap);
            } else if ("PhantomJS".equalsIgnoreCase(this.browserType)) {
                ArrayList<String> cliArgs = new ArrayList<String>(2);
                cliArgs.add("--ssl-protocol=any");
                cliArgs.add("--ignore-ssl-errors=yes");
                cap.setCapability("phantomjs.cli.args", cliArgs);
                driver = new PhantomJSDriver((Capabilities)cap);
            } else if ("Safari".equalsIgnoreCase(this.browserType)) {
                driver = new SafariDriver(new SafariOptions((Capabilities)cap));
            } else {
                try {
                    Class<?> browserClass = this.getClass().getClassLoader().loadClass(this.browserType);
                    Constructor<?> cons = browserClass.getConstructor(Capabilities.class);
                    if (cons == null) {
                        throw new ZestClientFailException((ZestElement)this, "Unsupported browser type: " + this.getBrowserType());
                    }
                    driver = (WebDriver)cons.newInstance(cap);
                }
                catch (ClassNotFoundException e) {
                    throw new ZestClientFailException((ZestElement)this, "Unsupported browser type: " + this.getBrowserType());
                }
            }
            runtime.addWebDriver(this.getWindowHandle(), (WebDriver)driver);
            if (this.url != null && !this.url.isEmpty()) {
                driver.get(runtime.replaceVariablesInString(this.url, true));
            }
            return this.getWindowHandle();
        }
        catch (Exception e) {
            throw new ZestClientFailException((ZestElement)this, (Throwable)e);
        }
    }

    private boolean isProfilePathSet() {
        return this.profilePath != null && !this.profilePath.isEmpty();
    }
}

