/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zest.core.v1;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.zaproxy.zest.core.v1.ZestExpression;
import org.zaproxy.zest.core.v1.ZestRequest;
import org.zaproxy.zest.core.v1.ZestRuntime;

public class ZestExpressionURL
extends ZestExpression {
    private List<String> includeRegexes = new ArrayList<String>();
    private List<String> excludeRegexes = new ArrayList<String>();
    private transient List<Pattern> includePatterns = null;
    private transient List<Pattern> excludePatterns = null;

    public ZestExpressionURL() {
    }

    public ZestExpressionURL(List<String> includeRegexes, List<String> excludeRegexes) {
        this.setIncludeRegexes(includeRegexes);
        this.setExcludeRegexes(excludeRegexes);
    }

    @Override
    public boolean isTrue(ZestRuntime runtime) {
        ZestRequest req = runtime.getLastRequest();
        if (req == null) {
            return false;
        }
        String url = req.getUrl().toString();
        boolean inc = false;
        if (this.includePatterns == null) {
            this.initPatterns();
        }
        for (Pattern pattern : this.includePatterns) {
            if (!pattern.matcher(url).find()) continue;
            inc = true;
            break;
        }
        if (!inc) {
            return false;
        }
        for (Pattern pattern : this.excludePatterns) {
            if (!pattern.matcher(url).find()) continue;
            return false;
        }
        return true;
    }

    public List<String> getIncludeRegexes() {
        return this.includeRegexes;
    }

    public List<String> getExcludeRegexes() {
        return this.excludeRegexes;
    }

    private void initPatterns() {
        this.includePatterns = new ArrayList<Pattern>();
        this.excludePatterns = new ArrayList<Pattern>();
        if (this.includeRegexes != null) {
            for (String regex : this.includeRegexes) {
                this.includePatterns.add(Pattern.compile(regex));
            }
        }
        if (this.excludeRegexes != null) {
            for (String regex : this.excludeRegexes) {
                this.excludePatterns.add(Pattern.compile(regex));
            }
        }
    }

    public void setIncludeRegexes(List<String> includeRegexes) {
        this.includeRegexes = includeRegexes;
        this.includePatterns = null;
    }

    public void setExcludeRegexes(List<String> excludeRegexes) {
        this.excludeRegexes = excludeRegexes;
        this.excludePatterns = null;
    }

    @Override
    public ZestExpressionURL deepCopy() {
        ZestExpressionURL copy = new ZestExpressionURL();
        ArrayList<String> copyIncludeRegex = new ArrayList<String>(this.includeRegexes);
        ArrayList<String> copyExcludeRegex = new ArrayList<String>(this.excludeRegexes);
        copy.setIncludeRegexes(copyIncludeRegex);
        copy.setExcludeRegexes(copyExcludeRegex);
        copy.setInverse(this.isInverse());
        return copy;
    }

    public String toString() {
        StringBuilder expression = new StringBuilder(150);
        if (this.isInverse()) {
            expression.append("NOT ");
        }
        expression.append("URL: ACCEPT:");
        for (String s : this.includeRegexes) {
            expression.append(' ').append(s);
        }
        expression.append(", EXCLUDE:");
        for (String s : this.excludeRegexes) {
            expression.append(' ').append(s);
        }
        return expression.toString();
    }
}

