/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zest.core.v1;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Date;
import org.zaproxy.zest.core.v1.ZestAction;
import org.zaproxy.zest.core.v1.ZestAssignment;
import org.zaproxy.zest.core.v1.ZestAuthentication;
import org.zaproxy.zest.core.v1.ZestElement;
import org.zaproxy.zest.core.v1.ZestExpressionElement;
import org.zaproxy.zest.core.v1.ZestLoop;
import org.zaproxy.zest.core.v1.ZestLoopState;
import org.zaproxy.zest.core.v1.ZestLoopTokenSet;
import org.zaproxy.zest.core.v1.ZestStatement;

public class ZestJSON {
    private static Gson gson = null;

    public static String toString(ZestElement element) {
        return ZestJSON.getGson().toJson((Object)element);
    }

    public static ZestElement fromString(String str) {
        ZestElement ze = (ZestElement)ZestJSON.getGson().fromJson(str, ZestElement.class);
        if (ze != null && ze instanceof ZestStatement) {
            ((ZestStatement)ze).init();
        }
        return ze;
    }

    private static Gson getGson() {
        if (gson == null) {
            GsonBuilder builder = ZestJSON.newDefaultGsonBuilder();
            Arrays.asList(ZestAction.class, ZestAssignment.class, ZestAuthentication.class, ZestElement.class, ZestStatement.class, ZestExpressionElement.class, ZestLoop.class, ZestLoopState.class, ZestLoopTokenSet.class).forEach(type -> builder.registerTypeAdapter((Type)type, (Object)ZestTypeAdapter.INSTANCE));
            gson = builder.create();
        }
        return gson;
    }

    private static GsonBuilder newDefaultGsonBuilder() {
        return new GsonBuilder().registerTypeAdapter(Date.class, (Object)DateTypeAdapter.INSTANCE).setPrettyPrinting();
    }

    private static class DateTypeAdapter
    implements JsonDeserializer<Date>,
    JsonSerializer<Date> {
        static final DateTypeAdapter INSTANCE = new DateTypeAdapter();
        private static final DateTimeFormatter FORMAT = DateTimeFormatter.ISO_DATE_TIME;

        private DateTypeAdapter() {
        }

        public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(FORMAT.format(src.toInstant().atOffset(ZoneOffset.UTC)));
        }

        public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            String value = json.getAsJsonPrimitive().getAsString();
            try {
                return new Date(FORMAT.parse((CharSequence)value, Instant::from).toEpochMilli());
            }
            catch (DateTimeParseException e) {
                throw new JsonParseException("Failed to parse the date: " + value, (Throwable)e);
            }
        }
    }

    private static class ZestTypeAdapter
    implements JsonDeserializer<ZestElement>,
    JsonSerializer<ZestElement> {
        static final ZestTypeAdapter INSTANCE = new ZestTypeAdapter();
        private static final String ZEST_PACKAGE = ZestTypeAdapter.class.getPackage().getName();

        private ZestTypeAdapter() {
        }

        public ZestElement deserialize(JsonElement element, Type rawType, JsonDeserializationContext arg2) {
            String elementType;
            if (element instanceof JsonObject && (elementType = ((JsonObject)element).get("elementType").getAsString()).startsWith("Zest")) {
                try {
                    Class<?> c = Class.forName(ZEST_PACKAGE + "." + elementType);
                    return (ZestElement)ZestJSON.getGson().fromJson(element, c);
                }
                catch (ClassNotFoundException e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            return null;
        }

        public JsonElement serialize(ZestElement element, Type rawType, JsonSerializationContext context) {
            return ZestJSON.newDefaultGsonBuilder().create().toJsonTree((Object)element);
        }
    }
}

