/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zest.core.v1;

import org.zaproxy.zest.core.v1.ZestElement;
import org.zaproxy.zest.core.v1.ZestLoopStateInteger;
import org.zaproxy.zest.core.v1.ZestLoopTokenSet;

public class ZestLoopTokenIntegerSet
extends ZestElement
implements ZestLoopTokenSet<Integer> {
    private int start = 0;
    private int end = 0;
    private int step = 1;

    public ZestLoopTokenIntegerSet() {
        this.start = 0;
        this.end = 0;
    }

    public ZestLoopTokenIntegerSet(int indexStart, int indexEnd) {
        this.start = indexStart;
        this.end = indexEnd;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    @Override
    public ZestLoopTokenIntegerSet deepCopy() {
        return new ZestLoopTokenIntegerSet(this.start, this.end);
    }

    @Override
    public Integer getToken(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("the index must be non negative.");
        }
        if (this.start + index < this.end) {
            return this.start + index;
        }
        throw new IllegalArgumentException("the index given is not inside this set.");
    }

    @Override
    public int indexOf(Integer token) {
        int tokenValue = token;
        int index = tokenValue - this.start;
        if (index < 0 || index >= this.end - this.start) {
            throw new IllegalArgumentException("token not contained in this set.");
        }
        return index;
    }

    @Override
    public Integer getLastToken() {
        return this.end - 1;
    }

    @Override
    public int size() {
        return this.end - this.start;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.end;
        result = 31 * result + this.start;
        result = 31 * result + this.step;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ZestLoopTokenIntegerSet other = (ZestLoopTokenIntegerSet)obj;
        if (this.end != other.end) {
            return false;
        }
        if (this.start != other.start) {
            return false;
        }
        return this.step == other.step;
    }

    public ZestLoopStateInteger getFirstState() {
        ZestLoopStateInteger fisrtState = new ZestLoopStateInteger(this);
        return fisrtState;
    }

    protected void setStep(int newStep) {
        this.step = newStep;
    }

    protected int getStep() {
        return this.step;
    }
}

