/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zest.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import javax.script.ScriptEngineFactory;
import org.openqa.selenium.WebDriver;
import org.zaproxy.zest.core.v1.ZestAction;
import org.zaproxy.zest.core.v1.ZestActionFailException;
import org.zaproxy.zest.core.v1.ZestAssertFailException;
import org.zaproxy.zest.core.v1.ZestAssertion;
import org.zaproxy.zest.core.v1.ZestAssignFailException;
import org.zaproxy.zest.core.v1.ZestAssignment;
import org.zaproxy.zest.core.v1.ZestAuthentication;
import org.zaproxy.zest.core.v1.ZestClient;
import org.zaproxy.zest.core.v1.ZestClientFailException;
import org.zaproxy.zest.core.v1.ZestComment;
import org.zaproxy.zest.core.v1.ZestConditional;
import org.zaproxy.zest.core.v1.ZestControlLoopBreak;
import org.zaproxy.zest.core.v1.ZestControlLoopNext;
import org.zaproxy.zest.core.v1.ZestControlReturn;
import org.zaproxy.zest.core.v1.ZestInvalidCommonTestException;
import org.zaproxy.zest.core.v1.ZestJSON;
import org.zaproxy.zest.core.v1.ZestLoop;
import org.zaproxy.zest.core.v1.ZestRequest;
import org.zaproxy.zest.core.v1.ZestResponse;
import org.zaproxy.zest.core.v1.ZestRunner;
import org.zaproxy.zest.core.v1.ZestRuntime;
import org.zaproxy.zest.core.v1.ZestScript;
import org.zaproxy.zest.core.v1.ZestStatement;
import org.zaproxy.zest.core.v1.ZestVariables;
import org.zaproxy.zest.impl.ComponentsHttpClient;
import org.zaproxy.zest.impl.ZestHttpClient;
import org.zaproxy.zest.impl.ZestScriptEngineFactory;

public class ZestBasicRunner
implements ZestRunner,
ZestRuntime {
    private ScriptEngineFactory scriptEngineFactory = null;
    private ZestHttpClient httpclient;
    private boolean stopOnAssertFail = true;
    private boolean stopOnTestFail = true;
    private Writer outputWriter = null;
    private boolean debug = false;
    private ZestVariables variables;
    private ZestRequest lastRequest = null;
    private ZestResponse lastResponse = null;
    private String result = null;
    private String proxyStr = "";
    private Stack<ZestLoop<?>> loops = new Stack();
    private boolean skipStatements = false;
    private Map<String, WebDriver> webDriverMap = new HashMap<String, WebDriver>();

    public ZestBasicRunner() {
        this(30, false);
    }

    public ZestBasicRunner(Integer timeoutInSeconds, boolean skipSSLCertificateCheck) {
        int timeout = timeoutInSeconds == null ? 30 : timeoutInSeconds;
        this.setHttpClient(new ComponentsHttpClient(timeout, skipSSLCertificateCheck));
    }

    public ZestBasicRunner(ZestHttpClient httpclient) {
        this.setHttpClient(httpclient);
    }

    public ZestBasicRunner(ScriptEngineFactory factory, ZestHttpClient httpclient) {
        this.setHttpClient(httpclient);
        this.scriptEngineFactory = factory;
    }

    public ZestBasicRunner(ScriptEngineFactory factory) {
        this();
        this.scriptEngineFactory = factory;
    }

    @Override
    public String run(ZestScript script, Map<String, String> params) throws ZestAssertFailException, ZestActionFailException, IOException, ZestInvalidCommonTestException, ZestAssignFailException, ZestClientFailException {
        return this.run(script, null, params);
    }

    @Override
    public String run(ZestScript script, ZestRequest target, Map<String, String> tokens) throws ZestAssertFailException, ZestActionFailException, ZestInvalidCommonTestException, IOException, ZestAssignFailException, ZestClientFailException {
        List<ZestAuthentication> auth = script.getAuthentication();
        if (auth != null) {
            for (ZestAuthentication zestAuthentication : auth) {
                this.httpclient.addAuthentication(zestAuthentication);
            }
        }
        this.variables = script.getParameters().deepCopy();
        this.lastRequest = target;
        if (target != null) {
            this.setStandardVariables(this.lastRequest);
            this.lastResponse = target.getResponse();
            this.setStandardVariables(this.lastResponse);
        } else {
            this.lastResponse = null;
        }
        if (tokens != null) {
            for (Map.Entry entry : tokens.entrySet()) {
                this.setVariable((String)entry.getKey(), (String)entry.getValue());
            }
        }
        for (ZestStatement zestStatement : script.getStatements()) {
            this.lastResponse = this.runStatement(script, zestStatement, this.lastResponse);
            if (this.result == null) continue;
            return this.result;
        }
        return null;
    }

    @Override
    public ZestResponse runStatement(ZestScript script, ZestStatement stmt, ZestResponse lastRes) throws ZestAssertFailException, ZestActionFailException, ZestInvalidCommonTestException, IOException, ZestAssignFailException, ZestClientFailException {
        if (this.skipStatements || !stmt.isEnabled()) {
            return lastRes;
        }
        if (script.isPassive() && !stmt.isPassive()) {
            throw new IllegalArgumentException(stmt.getElementType() + " not allowed in passive scripts");
        }
        if (stmt instanceof ZestRequest) {
            this.lastRequest = ((ZestRequest)stmt).deepCopy();
            this.lastRequest.replaceTokens(this.variables);
            this.debug(this.lastRequest.getMethod() + " : " + this.lastRequest.getUrl());
            this.lastResponse = this.send(this.lastRequest);
            this.setStandardVariables(this.lastRequest);
            this.setStandardVariables(this.lastResponse);
            this.handleResponse(this.lastRequest, this.lastResponse);
            return this.lastResponse;
        }
        if (stmt instanceof ZestConditional) {
            ZestConditional zc = (ZestConditional)stmt;
            if (zc.isTrue(this)) {
                this.debug(stmt.getIndex() + " Conditional TRUE: " + zc.getClass().getName());
                for (ZestStatement ifStmt : zc.getIfStatements()) {
                    this.lastResponse = this.runStatement(script, ifStmt, this.lastResponse);
                }
            } else {
                this.debug(stmt.getIndex() + " Conditional FALSE: " + zc.getClass().getName());
                for (ZestStatement elseStmt : zc.getElseStatements()) {
                    this.lastResponse = this.runStatement(script, elseStmt, this.lastResponse);
                }
            }
        } else if (stmt instanceof ZestAction) {
            this.handleAction(script, (ZestAction)stmt, this.lastResponse);
        } else if (stmt instanceof ZestAssignment) {
            this.handleAssignment(script, (ZestAssignment)stmt, this.lastResponse);
        } else if (stmt instanceof ZestLoop) {
            this.lastResponse = this.handleLoop(script, (ZestLoop)stmt, this.lastResponse);
        } else if (stmt instanceof ZestControlLoopBreak) {
            this.debug(stmt.getIndex() + " Break");
            this.handleControlLoopBreak();
        } else if (stmt instanceof ZestControlLoopNext) {
            this.debug(stmt.getIndex() + " Next");
            this.handleControlLoopNext();
        } else {
            if (stmt instanceof ZestControlReturn) {
                ZestControlReturn zr = (ZestControlReturn)stmt;
                this.result = this.variables.replaceInString(zr.getValue(), false);
                this.debug(stmt.getIndex() + " Return " + this.result);
                return null;
            }
            if (stmt instanceof ZestComment) {
                this.debug(stmt.getIndex() + " Comment " + ((ZestComment)stmt).getComment());
            } else if (stmt instanceof ZestClient) {
                ZestClient zc = (ZestClient)stmt;
                this.handleClient(script, zc);
            }
        }
        return this.lastResponse;
    }

    @Override
    public String handleAction(ZestScript script, ZestAction action, ZestResponse lastResponse) throws ZestActionFailException {
        this.debug(action.getIndex() + " Action invoke: " + action.getClass().getName());
        try {
            String result = action.invoke(lastResponse, this);
            if (result != null) {
                this.debug(action.getIndex() + " Action result: " + result);
            }
            return result;
        }
        catch (ZestActionFailException e) {
            this.output(e.getMessage());
            throw e;
        }
    }

    @Override
    public String handleAssignment(ZestScript script, ZestAssignment assign, ZestResponse lastResponse) throws ZestAssignFailException {
        try {
            String result = assign.assign(lastResponse, this);
            this.setVariable(assign.getVariableName(), this.replaceVariablesInString(result, false));
            if (result != null) {
                this.debug(assign.getIndex() + " Assign: " + assign.getVariableName() + " = " + result);
            }
            return result;
        }
        catch (ZestAssignFailException e) {
            this.output(e.getMessage());
            throw e;
        }
    }

    @Override
    public ZestResponse handleLoop(ZestScript script, ZestLoop<?> loop, ZestResponse lastResponse) throws ZestAssertFailException, ZestActionFailException, ZestInvalidCommonTestException, IOException, ZestAssignFailException, ZestClientFailException {
        try {
            loop.init(this);
            String token = "";
            if (loop.getCurrentToken() == null) {
                return lastResponse;
            }
            this.setVariable(loop.getVariableName(), loop.getCurrentToken().toString());
            this.loops.push(loop);
            while (loop.hasMoreElements()) {
                String loopOutput = loop.getIndex() + " Loop " + loop.getVariableName() + " iteration: " + loop.getCurrentIndex();
                if (!token.equals(loop.getCurrentToken().toString())) {
                    token = loop.getCurrentToken().toString();
                    loopOutput = loopOutput + ", Current Token: " + token;
                    this.setVariable(loop.getVariableName(), token);
                }
                this.debug(loopOutput);
                lastResponse = this.runStatement(script, loop.nextElement(), lastResponse);
                if (!this.skipStatements) continue;
                this.skipStatements = false;
            }
            if (!this.loops.isEmpty() && this.loops.peek().equals(loop)) {
                this.loops.pop();
            }
            this.setVariable(loop.getVariableName(), "");
            return lastResponse;
        }
        catch (IOException | ZestActionFailException | ZestAssertFailException | ZestAssignFailException | ZestClientFailException | ZestInvalidCommonTestException e) {
            this.output(e.getMessage());
            throw e;
        }
    }

    public void handleControlLoopBreak() {
        ZestLoop<?> lastLoop = this.loops.pop();
        lastLoop.onControlBreak();
        this.skipStatements = true;
    }

    public void handleControlLoopNext() {
        this.loops.peek().onControlNext();
        this.skipStatements = true;
    }

    @Override
    public String handleClient(ZestScript script, ZestClient client) throws ZestClientFailException {
        this.debug(client.getIndex() + " Client invoke: " + client.getClass().getName());
        try {
            String result = client.invoke(this);
            if (result != null) {
                this.debug(client.getIndex() + " Client result: " + result);
            }
            return result;
        }
        catch (ZestClientFailException e) {
            this.output(e.getMessage());
            throw e;
        }
    }

    @Override
    public void output(String str) {
        if (this.outputWriter != null) {
            try {
                this.outputWriter.append(str);
                this.outputWriter.append("\n");
                this.outputWriter.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void debug(String str) {
        if (this.debug && this.outputWriter != null) {
            try {
                this.outputWriter.append("DEBUG: ");
                this.outputWriter.append(str);
                this.outputWriter.append("\n");
                this.outputWriter.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public ZestResponse send(ZestRequest request) throws IOException {
        return this.httpclient.send(request);
    }

    @Override
    public void handleResponse(ZestRequest request, ZestResponse response) throws ZestAssertFailException {
        boolean passed = true;
        for (ZestAssertion za : request.getAssertions()) {
            if (za.isValid(this)) {
                this.responsePassed(request, response, za);
                continue;
            }
            passed = false;
            this.responseFailed(request, response, za);
        }
        if (passed) {
            this.responsePassed(request, response);
        } else {
            this.responseFailed(request, response);
        }
    }

    @Override
    public void responsePassed(ZestRequest request, ZestResponse response, ZestAssertion assertion) {
        this.debug("Assertion PASSED: " + assertion.getClass().getName());
    }

    @Override
    public void responseFailed(ZestRequest request, ZestResponse response, ZestAssertion assertion) throws ZestAssertFailException {
        this.debug(request.getIndex() + " Assertion FAILED: " + assertion.getClass().getName());
        if (this.getStopOnAssertFail()) {
            throw new ZestAssertFailException(assertion);
        }
    }

    @Override
    public void responsePassed(ZestRequest request, ZestResponse response) {
        this.debug(request.getIndex() + " Response PASSED");
    }

    @Override
    public void responseFailed(ZestRequest request, ZestResponse response) {
        this.debug(request.getIndex() + " Response FAILED");
    }

    @Override
    public String runScript(Reader reader, Map<String, String> params) throws ZestAssertFailException, ZestActionFailException, IOException, ZestInvalidCommonTestException, ZestAssignFailException, ZestClientFailException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader fr = new BufferedReader(reader);){
            String line;
            while ((line = fr.readLine()) != null) {
                sb.append(line);
            }
        }
        return this.run((ZestScript)ZestJSON.fromString(sb.toString()), params);
    }

    @Override
    public String runScript(String script, Map<String, String> params) throws ZestAssertFailException, ZestActionFailException, IOException, ZestInvalidCommonTestException, ZestAssignFailException, ZestClientFailException {
        return this.run((ZestScript)ZestJSON.fromString(script), params);
    }

    @Override
    public void setStopOnAssertFail(boolean stop) {
        this.stopOnAssertFail = stop;
    }

    @Override
    public void setStopOnTestFail(boolean stop) {
        this.stopOnTestFail = stop;
    }

    @Override
    public boolean getStopOnAssertFail() {
        return this.stopOnAssertFail;
    }

    @Override
    public boolean getStopOnTestFail() {
        return this.stopOnTestFail;
    }

    @Override
    public void setOutputWriter(Writer writer) {
        this.outputWriter = writer;
    }

    @Override
    public void setProxy(String host, int port) {
        this.httpclient.setProxy(host, port);
        this.proxyStr = host == null ? "" : host + ":" + port;
    }

    @Override
    public String getProxy() {
        return this.proxyStr;
    }

    @Override
    public String getVariable(String name) {
        return this.variables.getVariable(name);
    }

    @Override
    public Map<String, String> getVariables() {
        return this.variables.getVariablesMap();
    }

    @Override
    public void setVariable(String name, String value) {
        if (this.debug) {
            String val = value;
            if (val != null) {
                if (val.length() > 80) {
                    val = val.substring(0, 80) + "...";
                }
                val = val.replace("\n", "\\n");
                val = val.replace("\r", "\\r");
                val = val.replaceAll("\\s", " ");
            }
            this.debug("Set " + name + " = " + val);
        }
        this.variables.setVariable(name, value);
    }

    @Override
    public void setStandardVariables(ZestRequest request) {
        if (request != null) {
            if (request.getUrl() != null) {
                this.setVariable("request.url", request.getUrl().toString());
            }
            this.setVariable("request.header", request.getHeaders());
            this.setVariable("request.method", request.getMethod());
            this.setVariable("request.body", request.getData());
        }
    }

    @Override
    public void setStandardVariables(ZestResponse response) {
        if (response != null) {
            if (response.getUrl() != null) {
                this.setVariable("response.url", response.getUrl().toString());
            }
            this.setVariable("response.header", response.getHeaders());
            this.setVariable("response.body", response.getBody());
        }
    }

    public void setHttpClient(ZestHttpClient httpclient) {
        this.httpclient = httpclient;
        this.httpclient.init(this);
    }

    @Override
    public ZestResponse getLastResponse() {
        return this.lastResponse;
    }

    @Override
    public ZestRequest getLastRequest() {
        return this.lastRequest;
    }

    @Override
    public String replaceVariablesInString(String str, boolean urlEncode) {
        return this.variables.replaceInString(str, urlEncode);
    }

    @Override
    public void setScriptEngineFactory(ScriptEngineFactory factory) {
        this.scriptEngineFactory = factory;
    }

    @Override
    public ScriptEngineFactory getScriptEngineFactory() {
        if (this.scriptEngineFactory == null) {
            this.scriptEngineFactory = new ZestScriptEngineFactory();
        }
        return this.scriptEngineFactory;
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public void addWebDriver(String handle, WebDriver wd) {
        this.webDriverMap.put(handle, wd);
        wd.manage().timeouts().implicitlyWait(10L, TimeUnit.SECONDS);
    }

    @Override
    public void removeWebDriver(String handle) {
        this.webDriverMap.remove(handle);
    }

    @Override
    public WebDriver getWebDriver(String handle) {
        return this.webDriverMap.get(handle);
    }

    @Override
    public List<WebDriver> getWebDrivers() {
        ArrayList<WebDriver> list = new ArrayList<WebDriver>();
        for (WebDriver wd : this.webDriverMap.values()) {
            list.add(wd);
        }
        return list;
    }

    public static class Default {
        public static final int TIMEOUT_IN_SECONDS = 30;

        private Default() {
        }
    }
}

