/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zest.core.v1;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.zaproxy.zest.core.v1.ZestElement;
import org.zaproxy.zest.core.v1.ZestLoopRegex;
import org.zaproxy.zest.core.v1.ZestLoopStateRegex;
import org.zaproxy.zest.core.v1.ZestLoopTokenSet;
import org.zaproxy.zest.core.v1.ZestLoopTokenStringSet;

public class ZestLoopTokenRegexSet
extends ZestElement
implements ZestLoopTokenSet<String> {
    private String inputVariableName = null;
    private String regex = null;
    private int groupIndex = 0;
    private boolean caseExact;
    private transient ZestLoopTokenStringSet convertedSet = null;
    private transient ZestLoopRegex loop;

    public ZestLoopTokenRegexSet() {
    }

    public ZestLoopTokenRegexSet(ZestLoopRegex loop, String inputVariableName, String regex, int group, boolean caseExact) {
        this.loop = loop;
        this.inputVariableName = inputVariableName;
        this.regex = regex;
        this.groupIndex = group;
        this.caseExact = caseExact;
    }

    protected ZestLoopTokenStringSet getConvertedSet() {
        if (this.convertedSet == null) {
            if (this.loop == null) {
                return null;
            }
            ZestLoopTokenStringSet set = new ZestLoopTokenStringSet();
            Pattern pattern = this.caseExact ? Pattern.compile(this.regex) : Pattern.compile(this.regex, 2);
            String str = this.loop.getRuntime().getVariable(this.inputVariableName);
            if (str != null) {
                Matcher matcher = pattern.matcher(str);
                while (matcher.find()) {
                    String match;
                    if (matcher.groupCount() < this.groupIndex || (match = matcher.group(this.groupIndex)) == null) continue;
                    set.addToken(match);
                }
            }
            this.convertedSet = set;
        }
        return this.convertedSet;
    }

    @Override
    public String getToken(int index) {
        return this.getConvertedSet().getToken(index);
    }

    public List<String> getTokens() {
        return Collections.unmodifiableList(this.getConvertedSet().getTokens());
    }

    @Override
    public int indexOf(String token) {
        return this.getConvertedSet().indexOf(token);
    }

    @Override
    public String getLastToken() {
        return this.getConvertedSet().getLastToken();
    }

    @Override
    public int size() {
        return this.getConvertedSet().size();
    }

    @Override
    public ZestLoopTokenRegexSet deepCopy() {
        return new ZestLoopTokenRegexSet(this.loop, this.inputVariableName, this.regex, this.groupIndex, this.caseExact);
    }

    public String getInputVariableName() {
        return this.inputVariableName;
    }

    public String getRegex() {
        return this.regex;
    }

    public boolean isCaseExact() {
        return this.caseExact;
    }

    public ZestLoopRegex getLoop() {
        return this.loop;
    }

    public void setInputVariableName(String inputVariableName) {
        this.inputVariableName = inputVariableName;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public int getGroupIndex() {
        return this.groupIndex;
    }

    public void setGroupIndex(int groupIndex) {
        this.groupIndex = groupIndex;
    }

    public void setCaseExact(boolean caseExact) {
        this.caseExact = caseExact;
    }

    public void setLoop(ZestLoopRegex loop) {
        this.loop = loop;
    }

    public void setConvertedSet(ZestLoopTokenStringSet convertedSet) {
        this.convertedSet = convertedSet;
    }

    public ZestLoopStateRegex getFirstState() {
        return new ZestLoopStateRegex(this);
    }
}

