/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zest.core.v1;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.zaproxy.zest.core.v1.ZestAssignFailException;
import org.zaproxy.zest.core.v1.ZestAssignment;
import org.zaproxy.zest.core.v1.ZestResponse;
import org.zaproxy.zest.core.v1.ZestRuntime;

public class ZestAssignRegexDelimiters
extends ZestAssignment {
    private String prefix;
    private String postfix;
    private String location;
    public static final transient String LOC_HEAD = "HEAD";
    public static final transient String LOC_BODY = "BODY";
    private transient Pattern prefixPattern = null;
    private transient Pattern postfixPattern = null;
    private static final transient Set<String> LOCATIONS = new HashSet<String>(Arrays.asList("HEAD", "BODY"));

    public ZestAssignRegexDelimiters() {
    }

    public ZestAssignRegexDelimiters(String variableName, String location, String prefix, String postfix) {
        super(variableName);
        this.location = location;
        this.setPrefix(prefix);
        this.setPostfix(postfix);
    }

    public ZestAssignRegexDelimiters(int index) {
        super(index);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        this.prefixPattern = null;
    }

    public String getPostfix() {
        return this.postfix;
    }

    public void setPostfix(String postfix) {
        this.postfix = postfix;
        this.postfixPattern = null;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        if (!LOCATIONS.contains(location)) {
            throw new IllegalArgumentException("Unsupported location: " + location);
        }
        this.location = location;
    }

    @Override
    public ZestAssignRegexDelimiters deepCopy() {
        ZestAssignRegexDelimiters copy = new ZestAssignRegexDelimiters(this.getIndex());
        copy.setVariableName(this.getVariableName());
        copy.location = this.location;
        copy.setPrefix(this.prefix);
        copy.setPostfix(this.postfix);
        copy.setEnabled(this.isEnabled());
        return copy;
    }

    private String getTokenValue(String str) {
        if (str != null) {
            int tokenStart;
            String str2;
            Matcher postfixMatcher;
            this.checkPatterns();
            Matcher prefixMatcher = this.prefixPattern.matcher(str);
            if (prefixMatcher.find() && (postfixMatcher = this.postfixPattern.matcher(str2 = str.substring(tokenStart = prefixMatcher.end()))).find()) {
                int tokenEnd = postfixMatcher.start();
                return str2.substring(0, tokenEnd);
            }
        }
        return null;
    }

    private void checkPatterns() {
        if (this.prefixPattern == null) {
            this.prefixPattern = Pattern.compile(this.prefix);
        }
        if (this.postfixPattern == null) {
            this.postfixPattern = Pattern.compile(this.postfix);
        }
    }

    @Override
    public String assign(ZestResponse response, ZestRuntime runtime) throws ZestAssignFailException {
        String value;
        if (this.prefix == null || this.prefix.length() == 0) {
            throw new ZestAssignFailException(this, "Null prefix");
        }
        if (this.postfix == null || this.postfix.length() == 0) {
            throw new ZestAssignFailException(this, "Null postfix");
        }
        if (response == null) {
            throw new ZestAssignFailException(this, "Null response");
        }
        if (LOC_HEAD.equals(this.location)) {
            value = this.getTokenValue(response.getHeaders());
        } else if (LOC_BODY.equals(this.location)) {
            value = this.getTokenValue(response.getBody());
        } else {
            value = this.getTokenValue(response.getHeaders());
            if (value == null) {
                value = this.getTokenValue(response.getBody());
            }
        }
        if (value != null) {
            return value;
        }
        throw new ZestAssignFailException(this, "Failed to find value between '" + this.prefix + "' and '" + this.postfix + "'");
    }
}

