/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zest.core.v1;

import org.openqa.selenium.WebDriver;
import org.zaproxy.zest.core.v1.ZestClient;
import org.zaproxy.zest.core.v1.ZestRuntime;
import org.zaproxy.zest.core.v1.ZestStatement;

public class ZestClientWindowClose
extends ZestClient {
    private String windowHandle = null;
    private int sleepInSeconds = 0;

    public ZestClientWindowClose() {
    }

    public ZestClientWindowClose(String windowHandle, int sleepInSeconds) {
        this.windowHandle = windowHandle;
        this.sleepInSeconds = sleepInSeconds;
    }

    public String getWindowHandle() {
        return this.windowHandle;
    }

    public void setWindowHandle(String windowHandle) {
        this.windowHandle = windowHandle;
    }

    public int getSleepInSeconds() {
        return this.sleepInSeconds;
    }

    public void setSleepInSeconds(int sleepInSeconds) {
        this.sleepInSeconds = sleepInSeconds;
    }

    @Override
    public ZestStatement deepCopy() {
        ZestClientWindowClose copy = new ZestClientWindowClose(this.getWindowHandle(), this.getSleepInSeconds());
        copy.setEnabled(this.isEnabled());
        return copy;
    }

    @Override
    public boolean isPassive() {
        return false;
    }

    @Override
    public String invoke(ZestRuntime runtime) {
        WebDriver wd = runtime.getWebDriver(this.getWindowHandle());
        if (wd == null) {
            return null;
        }
        if (this.sleepInSeconds > 0) {
            for (int sleepInMs = this.sleepInSeconds * 1000; sleepInMs > 0 && (wd = runtime.getWebDriver(this.getWindowHandle())) != null; sleepInMs -= 200) {
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (wd != null) {
            try {
                wd.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            runtime.removeWebDriver(this.getWindowHandle());
            if (runtime.getWebDrivers().size() == 0 && this.getNext() == null) {
                wd.quit();
            }
        }
        return null;
    }
}

