/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zest.impl;

import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.protocol.RequestAddCookies;
import org.apache.http.client.protocol.RequestAuthCache;
import org.apache.http.client.protocol.RequestExpectContinue;
import org.apache.http.client.protocol.ResponseProcessCookies;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessorBuilder;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.zaproxy.zest.core.v1.ZestAuthentication;
import org.zaproxy.zest.core.v1.ZestCookie;
import org.zaproxy.zest.core.v1.ZestHttpAuthentication;
import org.zaproxy.zest.core.v1.ZestOutputWriter;
import org.zaproxy.zest.core.v1.ZestRequest;
import org.zaproxy.zest.core.v1.ZestResponse;
import org.zaproxy.zest.impl.ZestHttpClient;

class ComponentsHttpClient
implements ZestHttpClient {
    private final HttpClient httpClient;
    private final HttpClientContext httpContext;
    private final RequestConfig defaultRequestConfig;
    private RequestConfig requestConfig;
    private RequestConfig noRedirectsRequestConfig;
    private ZestOutputWriter zestOutputWriter;

    ComponentsHttpClient(int timeoutInSeconds, boolean skipSSLCertificateCheck) {
        this.httpClient = ComponentsHttpClient.getHttpClient(skipSSLCertificateCheck);
        this.httpContext = HttpClientContext.create();
        this.httpContext.setCookieStore((CookieStore)new BasicCookieStore());
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setCircularRedirectsAllowed(true).setConnectTimeout(timeoutInSeconds * 1000).setConnectionRequestTimeout(timeoutInSeconds * 1000).setCookieSpec("standard");
        this.requestConfig = this.defaultRequestConfig = requestConfigBuilder.build();
        this.noRedirectsRequestConfig = requestConfigBuilder.setRedirectsEnabled(false).build();
    }

    private static HttpClient getHttpClient(boolean skipSSLCertificateCheck) {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
        httpClientBuilder.setHttpProcessor(HttpProcessorBuilder.create().addAll(new HttpRequestInterceptor[]{new RequestContent(), new RequestTargetHost(), new RequestExpectContinue(), new RequestAddCookies(), new RequestAuthCache()}).add((HttpResponseInterceptor)new ResponseProcessCookies()).build());
        if (skipSSLCertificateCheck) {
            SSLContext sslContext;
            try {
                sslContext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)TrustAllStrategy.INSTANCE).build();
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected exception when configuring the HTTP client to skip the SSL certificate check.", e);
            }
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory);
        }
        return httpClientBuilder.build();
    }

    @Override
    public void init(ZestOutputWriter zestOutputWriter) {
        this.zestOutputWriter = zestOutputWriter;
    }

    @Override
    public void addAuthentication(ZestAuthentication zestAuthentication) {
        if (zestAuthentication instanceof ZestHttpAuthentication) {
            this.addHttpAuthentication((ZestHttpAuthentication)zestAuthentication);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProxy(String host, int port) {
        RequestConfig requestConfig = this.defaultRequestConfig;
        synchronized (requestConfig) {
            RequestConfig.Builder requestConfigBuilder = RequestConfig.copy((RequestConfig)this.defaultRequestConfig);
            this.requestConfig = host == null || host.isEmpty() ? this.defaultRequestConfig : requestConfigBuilder.setProxy(new HttpHost(host, port)).build();
            this.noRedirectsRequestConfig = requestConfigBuilder.setRedirectsEnabled(false).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHttpAuthentication(ZestHttpAuthentication zestHttpAuthentication) {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(zestHttpAuthentication.getUsername(), zestHttpAuthentication.getPassword());
        AuthScope authScope = new AuthScope(zestHttpAuthentication.getSite(), 80, AuthScope.ANY_REALM);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(authScope, (Credentials)credentials);
        HttpClientContext httpClientContext = this.httpContext;
        synchronized (httpClientContext) {
            this.httpContext.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ZestResponse send(ZestRequest req) throws IOException {
        HttpGet method = switch (req.getMethod()) {
            case "GET" -> new HttpGet(req.getUrl().toString());
            case "POST" -> new HttpPost(req.getUrl().toString());
            case "OPTIONS" -> new HttpOptions(req.getUrl().toString());
            case "HEAD" -> new HttpHead(req.getUrl().toString());
            case "PUT" -> new HttpPut(req.getUrl().toString());
            case "DELETE" -> new HttpDelete(req.getUrl().toString());
            case "TRACE" -> new HttpTrace(req.getUrl().toString());
            default -> throw new IllegalArgumentException("Method not supported: " + req.getMethod());
        };
        method.setConfig(req.isFollowRedirects() ? this.requestConfig : this.noRedirectsRequestConfig);
        ComponentsHttpClient.setHeaders((HttpRequestBase)method, req.getHeaders());
        for (ZestCookie zestCookie : req.getCookies()) {
            BasicClientCookie cookie = new BasicClientCookie(zestCookie.getName(), zestCookie.getValue());
            cookie.setDomain(zestCookie.getDomain());
            cookie.setPath(zestCookie.getPath());
            cookie.setExpiryDate(zestCookie.getExpiryDate());
            cookie.setSecure(zestCookie.isSecure());
            this.httpContext.getCookieStore().addCookie((Cookie)cookie);
        }
        if (method instanceof HttpEntityEnclosingRequestBase) {
            StringEntity requestBody = new StringEntity(req.getData(), (ContentType)null);
            HttpEntityEnclosingRequestBase methodWithEntity = (HttpEntityEnclosingRequestBase)method;
            methodWithEntity.setEntity((HttpEntity)requestBody);
        }
        int code = 0;
        String responseHeader = null;
        String responseBody = null;
        Date start = new Date();
        req.setTimestamp(start.getTime());
        try {
            this.debug(req.getMethod() + ": " + req.getUrl());
            HttpResponse response = this.httpClient.execute((HttpUriRequest)method, (HttpContext)this.httpContext);
            code = response.getStatusLine().getStatusCode();
            responseHeader = response.getStatusLine().toString() + "\r\n" + ComponentsHttpClient.arrayToStr(response.getAllHeaders());
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity != null) {
                responseBody = EntityUtils.toString((HttpEntity)responseEntity);
            }
        }
        finally {
            method.releaseConnection();
        }
        req.setHeaders(ComponentsHttpClient.arrayToStr(this.httpContext.getRequest().getAllHeaders()));
        return new ZestResponse(req.getUrl(), responseHeader, responseBody, code, new Date().getTime() - start.getTime());
    }

    private static void setHeaders(HttpRequestBase method, String headers) {
        String[] headerArray;
        if (headers == null) {
            return;
        }
        for (String line : headerArray = headers.split("\r\n")) {
            int colonIndex = line.indexOf(":");
            if (colonIndex <= 0) continue;
            String header = line.substring(0, colonIndex);
            String value = line.substring(colonIndex + 1).trim();
            String lcHeader = header.toLowerCase(Locale.ROOT);
            if (lcHeader.startsWith("cookie") || lcHeader.startsWith("content-length")) continue;
            method.addHeader(header, value);
        }
    }

    private static String arrayToStr(Header[] headers) {
        StringBuilder sb = new StringBuilder();
        for (Header header : headers) {
            sb.append(header.toString()).append("\r\n");
        }
        return sb.toString();
    }

    private void debug(String str) {
        if (this.zestOutputWriter != null) {
            this.zestOutputWriter.debug(str);
        }
    }
}

