/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zest.core.v1;

import org.openqa.selenium.Cookie;
import org.openqa.selenium.WebDriver;
import org.zaproxy.zest.core.v1.ZestClient;
import org.zaproxy.zest.core.v1.ZestRuntime;
import org.zaproxy.zest.core.v1.ZestStatement;

public class ZestClientAssignCookie
extends ZestClient {
    private String windowHandle;
    private String variableName;
    private String cookieName;

    public ZestClientAssignCookie(String windowHandle, String variableName, String cookieName) {
        this.windowHandle = windowHandle;
        this.variableName = variableName;
        this.cookieName = cookieName;
    }

    public ZestClientAssignCookie() {
    }

    public String getWindowHandle() {
        return this.windowHandle;
    }

    public void setWindowHandle(String windowHandle) {
        this.windowHandle = windowHandle;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    @Override
    public String invoke(ZestRuntime runtime) {
        WebDriver wd = runtime.getWebDriver(this.getWindowHandle());
        String val = "";
        if (this.cookieName != null && this.cookieName.length() > 0) {
            Cookie cookie = wd.manage().getCookieNamed(this.cookieName);
            if (cookie != null) {
                val = cookie.getValue();
            }
        } else {
            StringBuilder sb = new StringBuilder();
            for (Cookie cookie : wd.manage().getCookies()) {
                sb.append(cookie.getName());
                sb.append("=");
                sb.append(cookie.getValue());
                sb.append("; ");
            }
            val = sb.toString();
        }
        runtime.setVariable(this.variableName, val);
        return val;
    }

    @Override
    public ZestStatement deepCopy() {
        ZestClientAssignCookie copy = new ZestClientAssignCookie(this.windowHandle, this.variableName, this.cookieName);
        copy.setEnabled(this.isEnabled());
        return copy;
    }

    @Override
    public boolean isPassive() {
        return false;
    }
}

