/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zest.core.v1;

import java.util.regex.Pattern;
import org.openqa.selenium.WebDriver;
import org.zaproxy.zest.core.v1.ZestClient;
import org.zaproxy.zest.core.v1.ZestClientFailException;
import org.zaproxy.zest.core.v1.ZestElement;
import org.zaproxy.zest.core.v1.ZestRuntime;
import org.zaproxy.zest.core.v1.ZestStatement;

public class ZestClientWindowHandle
extends ZestClient {
    private String windowHandle = null;
    private String url = null;
    private boolean regex = false;

    public ZestClientWindowHandle() {
    }

    public ZestClientWindowHandle(String windowHandle, String url, boolean regex) {
        this.windowHandle = windowHandle;
        this.url = url;
        this.regex = regex;
    }

    public String getWindowHandle() {
        return this.windowHandle;
    }

    public void setWindowHandle(String windowHandle) {
        this.windowHandle = windowHandle;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isRegex() {
        return this.regex;
    }

    public void setRegex(boolean regex) {
        this.regex = regex;
    }

    @Override
    public ZestStatement deepCopy() {
        ZestClientWindowHandle copy = new ZestClientWindowHandle(this.getWindowHandle(), this.getUrl(), this.isRegex());
        copy.setEnabled(this.isEnabled());
        return copy;
    }

    @Override
    public boolean isPassive() {
        return false;
    }

    @Override
    public String invoke(ZestRuntime runtime) throws ZestClientFailException {
        Pattern p = null;
        String runUrl = runtime.replaceVariablesInString(this.url, true);
        if (this.isRegex()) {
            p = Pattern.compile(runUrl);
        }
        boolean found = false;
        block0: for (WebDriver wd : runtime.getWebDrivers()) {
            for (String wh : wd.getWindowHandles()) {
                WebDriver window = wd.switchTo().window(wh);
                if (this.isRegex()) {
                    if (p.matcher(window.getCurrentUrl()).matches()) {
                        runtime.addWebDriver(this.windowHandle, wd);
                        runtime.debug("Matched window " + window.getWindowHandle() + " url: " + window.getCurrentUrl());
                        found = true;
                        continue block0;
                    }
                    runtime.debug("Didnt match window " + window.getWindowHandle() + " url: " + window.getCurrentUrl());
                    continue;
                }
                if (window.getCurrentUrl().equals(runUrl)) {
                    runtime.addWebDriver(this.windowHandle, wd);
                    runtime.debug("Matched window " + window.getWindowHandle() + " url: " + window.getCurrentUrl());
                    found = true;
                    continue block0;
                }
                runtime.debug("Didnt match window " + window.getWindowHandle() + " url: " + window.getCurrentUrl());
            }
        }
        if (!found) {
            runtime.output("Failed to find window " + this.getUrl() + " regex=" + this.isRegex());
            throw new ZestClientFailException((ZestElement)this, "Failed to find window " + this.getUrl() + " regex=" + this.isRegex());
        }
        return this.windowHandle;
    }
}

