/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zest.core.v1;

import java.util.regex.Pattern;
import org.zaproxy.zest.core.v1.ZestExpression;
import org.zaproxy.zest.core.v1.ZestRuntime;

public class ZestExpressionRegex
extends ZestExpression {
    private String regex;
    private String variableName;
    private boolean caseExact = false;
    private transient Pattern pattern = null;

    public ZestExpressionRegex() {
        this("", null, false, false);
    }

    public ZestExpressionRegex(String variableName, String regex) {
        this(variableName, regex, false, false);
    }

    public ZestExpressionRegex(String variableName, String regex, boolean caseExact, boolean inverse) {
        super(inverse);
        this.variableName = variableName;
        this.caseExact = caseExact;
        this.regex = regex;
        if (regex != null) {
            this.pattern = caseExact ? Pattern.compile(regex) : Pattern.compile(regex, 2);
        }
    }

    @Override
    public boolean isTrue(ZestRuntime runtime) {
        String str = runtime.getVariable(this.variableName);
        if (str == null || this.regex == null) {
            return false;
        }
        if (this.pattern == null) {
            this.pattern = this.caseExact ? Pattern.compile(this.regex) : Pattern.compile(this.regex, 2);
        }
        return this.pattern.matcher(str).find();
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
        this.pattern = regex != null ? Pattern.compile(regex) : null;
    }

    public boolean isCaseExact() {
        return this.caseExact;
    }

    public void setCaseExact(boolean caseExact) {
        this.caseExact = caseExact;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public ZestExpressionRegex deepCopy() {
        return new ZestExpressionRegex(this.getVariableName(), this.getRegex(), this.isCaseExact(), this.isInverse());
    }

    public String toString() {
        String expression = (this.isInverse() ? "NOT " : "") + "REGEX: " + this.regex;
        return expression;
    }
}

