/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zest.core.v1;

import org.zaproxy.zest.core.v1.ZestExpression;
import org.zaproxy.zest.core.v1.ZestResponse;
import org.zaproxy.zest.core.v1.ZestRuntime;

public class ZestExpressionResponseTime
extends ZestExpression {
    private boolean greaterThan;
    private long timeInMs;

    public ZestExpressionResponseTime() {
        this(0L);
    }

    public ZestExpressionResponseTime(long time) {
        this(time, true);
    }

    public ZestExpressionResponseTime(long time, boolean greaterThan) {
        this(time, greaterThan, false);
    }

    public ZestExpressionResponseTime(long time, boolean greaterThan, boolean inverse) {
        super(inverse);
        this.timeInMs = time;
        this.greaterThan = greaterThan;
    }

    @Override
    public boolean isTrue(ZestRuntime runtime) {
        ZestResponse response = runtime.getLastResponse();
        if (response == null) {
            return false;
        }
        if (this.greaterThan) {
            return response.getResponseTimeInMs() > this.timeInMs;
        }
        return response.getResponseTimeInMs() < this.timeInMs;
    }

    public boolean isGreaterThan() {
        return this.greaterThan;
    }

    public void setGreaterThan(boolean greaterThan) {
        this.greaterThan = greaterThan;
    }

    public long getTimeInMs() {
        return this.timeInMs;
    }

    public void setTimeInMs(long timeInMs) {
        this.timeInMs = timeInMs;
    }

    @Override
    public ZestExpressionResponseTime deepCopy() {
        return new ZestExpressionResponseTime(this.timeInMs, this.greaterThan, this.isInverse());
    }

    public String toString() {
        String expression = (this.isInverse() ? "NOT " : "") + "Response Time " + (this.isGreaterThan() ? "> " : "< ") + this.timeInMs;
        return expression;
    }
}

