/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zest.core.v1;

import java.util.LinkedList;
import org.zaproxy.zest.core.v1.ZestLoop;
import org.zaproxy.zest.core.v1.ZestLoopStateInteger;
import org.zaproxy.zest.core.v1.ZestLoopTokenIntegerSet;
import org.zaproxy.zest.core.v1.ZestLoopTokenSet;
import org.zaproxy.zest.core.v1.ZestStatement;

public class ZestLoopInteger
extends ZestLoop<Integer> {
    private ZestLoopTokenIntegerSet set;

    public ZestLoopInteger() {
        this.set = new ZestLoopTokenIntegerSet();
        super.init(this.getSet(), new LinkedList<ZestStatement>());
    }

    public ZestLoopInteger(String name) {
        super.setVariableName(name);
        this.set = new ZestLoopTokenIntegerSet();
        super.init(this.set, new LinkedList<ZestStatement>());
    }

    public ZestLoopInteger(String name, int start, int end) {
        super.setVariableName(name);
        this.set = new ZestLoopTokenIntegerSet(start, end);
        super.init(this.set, new LinkedList<ZestStatement>());
    }

    public ZestLoopInteger(int index, int start, int end) {
        super(index);
        this.set = new ZestLoopTokenIntegerSet(start, end);
        super.init(this.set, new LinkedList<ZestStatement>());
    }

    public int getStart() {
        return this.getSet().getStart();
    }

    public int getEnd() {
        return this.getSet().getEnd();
    }

    public ZestLoopInteger(int start, int end) {
        this("", start, end);
    }

    public ZestLoopStateInteger getCurrentState() {
        return (ZestLoopStateInteger)super.getCurrentState();
    }

    public void setStep(int step) {
        this.getSet().setStep(step);
    }

    public int getStep() {
        return this.getSet().getStep();
    }

    @Override
    public ZestLoopInteger deepCopy() {
        ZestLoopStateInteger state = this.getCurrentState().deepCopy();
        ZestLoopTokenIntegerSet set = this.getSet();
        ZestLoopInteger copy = new ZestLoopInteger(set.getStart(), set.getEnd());
        copy.setVariableName(this.getVariableName());
        for (ZestStatement stmt : this.getStatements()) {
            copy.addStatement(stmt.deepCopy());
        }
        copy.setCurrentState(state);
        copy.setEnabled(this.isEnabled());
        return copy;
    }

    public ZestLoopTokenIntegerSet getSet() {
        return this.set;
    }

    @Override
    public void setSet(ZestLoopTokenSet<Integer> newSet) {
        super.setSet(newSet);
        this.set = (ZestLoopTokenIntegerSet)newSet;
    }

    @Override
    public boolean isLastState() {
        return this.getCurrentState().getCurrentIndex() >= this.getSet().size();
    }

    @Override
    public void increase() {
        this.getCurrentState().increase(this.getSet());
    }

    @Override
    public void toLastState() {
        this.getCurrentState().toLastState(this.getSet());
    }

    @Override
    public Integer getCurrentToken() {
        if (super.getCurrentToken() == null) {
            super.init(this.getSet(), this.getStatements());
        }
        return (Integer)super.getCurrentToken();
    }

    public boolean loop() {
        return super.loop(this.getSet());
    }

    public void endLoop() {
        this.endLoop(this.getSet());
    }

    public void setStart(int newStart) {
        this.setSet(new ZestLoopTokenIntegerSet(newStart, this.getEnd()));
    }

    public void setEnd(int newEnd) {
        this.setSet(new ZestLoopTokenIntegerSet(this.getStart(), newEnd));
    }
}

