/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zest.core.v1;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import org.zaproxy.zest.core.v1.ZestElement;
import org.zaproxy.zest.core.v1.ZestLoopStateFile;
import org.zaproxy.zest.core.v1.ZestLoopTokenSet;
import org.zaproxy.zest.core.v1.ZestLoopTokenStringSet;

public class ZestLoopTokenFileSet
extends ZestElement
implements ZestLoopTokenSet<String> {
    private String pathToFile = null;
    private transient ZestLoopTokenStringSet convertedSet = null;

    public ZestLoopTokenFileSet(String pathToFile) throws FileNotFoundException {
        this.pathToFile = pathToFile;
        this.convertedSet = this.getConvertedSet(new File(pathToFile));
    }

    private ZestLoopTokenStringSet getConvertedSet(File file) throws FileNotFoundException {
        if (this.convertedSet == null) {
            try (Scanner in = new Scanner(file);){
                ZestLoopTokenStringSet initializationSet = new ZestLoopTokenStringSet();
                while (in.hasNextLine()) {
                    String line = in.nextLine();
                    if (line.startsWith("#") || line.isEmpty()) continue;
                    initializationSet.addToken(line);
                }
                this.convertedSet = initializationSet;
            }
        }
        return this.convertedSet;
    }

    @Override
    public String getToken(int index) {
        return this.getConvertedSet().getToken(index);
    }

    public List<String> getTokens() {
        List<String> listOfTokens = this.getConvertedSet().getTokens();
        return Collections.unmodifiableList(listOfTokens);
    }

    @Override
    public int indexOf(String token) {
        return this.getConvertedSet().indexOf(token);
    }

    @Override
    public String getLastToken() {
        return this.getConvertedSet().getLastToken();
    }

    @Override
    public int size() {
        return this.getConvertedSet().size();
    }

    @Override
    public ZestLoopTokenFileSet deepCopy() {
        try {
            ZestLoopTokenFileSet copy = new ZestLoopTokenFileSet(this.pathToFile);
            copy.convertedSet = this.getConvertedSet().deepCopy();
            return copy;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public File getFile() {
        return new File(this.pathToFile);
    }

    public String getFilePath() {
        return this.pathToFile;
    }

    protected ZestLoopTokenStringSet getConvertedSet() {
        try {
            return this.getConvertedSet(new File(this.pathToFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return this.convertedSet;
        }
    }

    public ZestLoopStateFile getFirstState() {
        ZestLoopStateFile stateFile = new ZestLoopStateFile(this);
        return stateFile;
    }
}

