/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zest.core.v1;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.openqa.selenium.By;
import org.zaproxy.zest.core.v1.ZestAssignment;
import org.zaproxy.zest.core.v1.ZestAuthentication;
import org.zaproxy.zest.core.v1.ZestClientAssignCookie;
import org.zaproxy.zest.core.v1.ZestClientElementAssign;
import org.zaproxy.zest.core.v1.ZestClientLaunch;
import org.zaproxy.zest.core.v1.ZestClientWindowHandle;
import org.zaproxy.zest.core.v1.ZestContainer;
import org.zaproxy.zest.core.v1.ZestLoop;
import org.zaproxy.zest.core.v1.ZestStatement;
import org.zaproxy.zest.core.v1.ZestVariables;

public class ZestScript
extends ZestStatement
implements ZestContainer {
    public static final String VERSION = "0.8";
    public static final String ZEST_URL = "https://github.com/zaproxy/zest/";
    public static final String ABOUT = "This is a Zest script. For more details about Zest visit https://github.com/zaproxy/zest/";
    private String about = "This is a Zest script. For more details about Zest visit https://github.com/zaproxy/zest/";
    private String zestVersion = "0.8";
    private String generatedBy;
    private String author;
    private String title;
    private String description;
    private String prefix;
    private String type;
    private transient Type scriptType;
    private ZestVariables parameters = new ZestVariables();
    private List<ZestStatement> statements = new ArrayList<ZestStatement>();
    private List<ZestAuthentication> authentication = new ArrayList<ZestAuthentication>();

    public ZestScript() {
    }

    public ZestScript(String title, String description, String type) {
        this();
        this.title = title;
        this.description = description;
        this.setType(type);
    }

    public ZestScript(String title, String description, Type type) {
        this();
        this.title = title;
        this.description = description;
        this.setType(type);
    }

    public void setType(Type type) {
        this.type = type.name();
        this.scriptType = type;
    }

    public void setType(String type) {
        this.setTypeImpl(type);
        if (this.scriptType == null) {
            throw new IllegalArgumentException("Unsupported type: " + type);
        }
    }

    private void setTypeImpl(String type) {
        this.scriptType = Type.getType(type);
        if (this.scriptType != null) {
            this.type = this.scriptType.name();
        }
    }

    public String getType() {
        return this.type;
    }

    @Override
    protected void init() {
        super.init();
        this.setTypeImpl(this.type);
    }

    @Override
    public ZestScript deepCopy() {
        ZestScript script = new ZestScript();
        this.duplicateTo(script);
        return script;
    }

    public void duplicateTo(ZestScript script) {
        script.about = this.about;
        script.zestVersion = this.zestVersion;
        script.generatedBy = this.generatedBy;
        script.author = this.author;
        script.title = this.title;
        script.description = this.description;
        script.prefix = this.prefix;
        script.parameters = this.parameters.deepCopy();
        script.type = this.type;
        script.scriptType = this.scriptType;
        for (ZestStatement zr : this.getStatements()) {
            script.add(zr.deepCopy());
        }
        for (ZestAuthentication za : this.getAuthentication()) {
            script.addAuthentication((ZestAuthentication)za.deepCopy());
        }
        script.setParameters(this.getParameters().deepCopy());
    }

    public void add(ZestStatement stmt) {
        this.add(this.statements.size(), stmt);
    }

    public void add(int index, ZestStatement stmt) {
        ZestStatement prev = this;
        if (index == this.statements.size()) {
            this.statements.add(stmt);
        } else {
            this.statements.add(index, stmt);
        }
        if (index > 0) {
            prev = this.statements.get(index - 1);
        }
        stmt.insertAfter(prev);
        this.checkStatementIndexes();
    }

    @Override
    public void move(int index, ZestStatement req) {
        this.remove(req);
        this.add(index, req);
        this.checkStatementIndexes();
    }

    public void remove(ZestStatement req) {
        this.statements.remove(req);
        req.remove();
        this.checkStatementIndexes();
    }

    public void removeStatement(int index) {
        this.remove(this.statements.get(index));
        this.checkStatementIndexes();
    }

    @Override
    public ZestStatement getStatement(int index) {
        this.checkStatementIndexes();
        for (ZestStatement zr : this.getStatements()) {
            ZestStatement stmt;
            if (zr.getIndex() == index) {
                return zr;
            }
            if (!(zr instanceof ZestContainer) || (stmt = ((ZestContainer)((Object)zr)).getStatement(index)) == null) continue;
            return stmt;
        }
        return null;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<ZestStatement> getStatements() {
        return this.statements;
    }

    @Override
    public List<ZestStatement> getChildren() {
        return Collections.unmodifiableList(this.getStatements());
    }

    public void setStatements(List<ZestStatement> statements) {
        this.statements = statements;
    }

    public void addAuthentication(ZestAuthentication auth) {
        this.authentication.add(auth);
    }

    public void removeAuthentication(ZestAuthentication auth) {
        this.authentication.remove(auth);
    }

    public List<ZestAuthentication> getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(List<ZestAuthentication> authentication) {
        this.authentication = authentication;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String newPrefix) throws MalformedURLException {
        this.setPrefix(this.prefix, newPrefix);
    }

    @Override
    public void setPrefix(String oldPrefix, String newPrefix) throws MalformedURLException {
        if (newPrefix != null && newPrefix.length() > 0) {
            for (ZestStatement stmt : this.statements) {
                stmt.setPrefix(oldPrefix, newPrefix);
            }
        }
        this.prefix = newPrefix;
    }

    public ZestVariables getParameters() {
        return this.parameters;
    }

    public void setParameters(ZestVariables parameters) {
        this.parameters = parameters;
    }

    public String getZestVersion() {
        return this.zestVersion;
    }

    public void setZestVersion(String zestVersion) {
        if (!VERSION.equals(zestVersion)) {
            throw new IllegalArgumentException("Version " + zestVersion + " not supported by this class");
        }
        this.zestVersion = zestVersion;
    }

    public String getGeneratedBy() {
        return this.generatedBy;
    }

    public void setGeneratedBy(String generatedBy) {
        this.generatedBy = generatedBy;
    }

    public String getAbout() {
        return this.about;
    }

    public void setAbout(String about) {
        this.about = about;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @Override
    public Set<String> getVariableNames() {
        HashSet<String> tokens = new HashSet<String>();
        tokens.add("request.url");
        tokens.add("request.method");
        tokens.add("request.header");
        tokens.add("request.body");
        tokens.add("response.url");
        tokens.add("response.header");
        tokens.add("response.body");
        List<String[]> vars = this.getParameters().getVariables();
        for (String[] var : vars) {
            tokens.add(var[0]);
        }
        for (ZestStatement next = this.getNext(); next != null; next = next.getNext()) {
            if (next instanceof ZestAssignment) {
                tokens.add(((ZestAssignment)next).getVariableName());
                continue;
            }
            if (next instanceof ZestClientAssignCookie) {
                tokens.add(((ZestClientAssignCookie)next).getVariableName());
                continue;
            }
            if (next instanceof ZestClientElementAssign) {
                tokens.add(((ZestClientElementAssign)next).getVariableName());
                continue;
            }
            if (!(next instanceof ZestLoop)) continue;
            tokens.add(((ZestLoop)next).getVariableName());
        }
        return tokens;
    }

    public Set<String> getClientWindowHandles() {
        HashSet<String> ids = new HashSet<String>();
        for (ZestStatement next = this.getNext(); next != null; next = next.getNext()) {
            if (next instanceof ZestClientLaunch) {
                ids.add(((ZestClientLaunch)next).getWindowHandle());
                continue;
            }
            if (!(next instanceof ZestClientWindowHandle)) continue;
            ids.add(((ZestClientWindowHandle)next).getWindowHandle());
        }
        return ids;
    }

    @Override
    public int getIndex(ZestStatement child) {
        return this.statements.indexOf(child);
    }

    @Override
    public ZestStatement getLast() {
        return null;
    }

    @Override
    public ZestStatement getChildBefore(ZestStatement child) {
        int childIndex;
        if (this.statements.contains(child) && (childIndex = this.statements.indexOf(child)) > 1) {
            return this.statements.get(childIndex - 1);
        }
        return null;
    }

    @Override
    public boolean isPassive() {
        return Type.Passive.equals((Object)this.scriptType);
    }

    private void checkStatementIndexes() {
    }

    @Override
    protected ZestStatement setPrev(ZestStatement prev) {
        for (ZestStatement statement : this.statements) {
            if (prev != null) {
                prev.setNext(statement);
            }
            prev = statement.setPrev(prev);
        }
        return prev;
    }

    public static By getBy(String elem, String type) {
        if ("className".equalsIgnoreCase(type)) {
            return By.className((String)elem);
        }
        if ("cssSelector".equalsIgnoreCase(type)) {
            return By.cssSelector((String)elem);
        }
        if ("id".equalsIgnoreCase(type)) {
            return By.id((String)elem);
        }
        if ("linkText".equalsIgnoreCase(type)) {
            return By.linkText((String)elem);
        }
        if ("name".equalsIgnoreCase(type)) {
            return By.name((String)elem);
        }
        if ("partialLinkText".equalsIgnoreCase(type)) {
            return By.partialLinkText((String)elem);
        }
        if ("tagName".equalsIgnoreCase(type)) {
            return By.tagName((String)elem);
        }
        if ("xpath".equalsIgnoreCase(type)) {
            return By.xpath((String)elem);
        }
        return null;
    }

    public static enum Type {
        Active,
        Passive,
        StandAlone,
        Targeted;


        static Type getType(String type) {
            if (type == null || type.isEmpty()) {
                return null;
            }
            switch (type.toLowerCase(Locale.ROOT)) {
                case "active": {
                    return Active;
                }
                case "passive": {
                    return Passive;
                }
                case "standalone": {
                    return StandAlone;
                }
                case "targeted": {
                    return Targeted;
                }
            }
            return null;
        }
    }
}

