/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zest.core.v1;

import java.net.MalformedURLException;
import org.zaproxy.zest.core.v1.ZestContainer;
import org.zaproxy.zest.core.v1.ZestElement;

public abstract class ZestStatement
extends ZestElement {
    private int index;
    private transient ZestStatement previous = null;
    private transient ZestStatement next = null;
    private boolean enabled = true;

    public ZestStatement(int index) {
        this.index = index;
    }

    public ZestStatement() {
    }

    @Override
    public boolean isSameSubclass(ZestElement ze) {
        return ze instanceof ZestStatement;
    }

    public ZestStatement getPrevious() {
        return this.previous;
    }

    protected void insertBefore(ZestStatement stmt) {
        ZestStatement prv;
        this.previous = prv = stmt.getPrevious();
        if (prv != null) {
            prv.setNext(this);
        }
        this.setNext(stmt);
        stmt.previous = this;
        this.setIndex(stmt.getIndex(), true);
    }

    protected void insertAfter(ZestStatement stmt) {
        ZestStatement nxt;
        this.next = nxt = stmt.getNext();
        if (nxt != null) {
            nxt.previous = this;
        }
        this.previous = stmt;
        stmt.setNext(this);
        this.setIndex(stmt.getIndex() + 1, true);
    }

    protected void remove() {
        ZestStatement nxt = this.next;
        if (this instanceof ZestContainer) {
            nxt = ((ZestContainer)((Object)this)).getLast().getNext();
        }
        if (this.previous != null) {
            this.previous.setNext(nxt);
        }
        if (nxt != null) {
            nxt.previous = this.previous;
            if (this.previous != null) {
                nxt.setIndex(this.previous.getIndex() + 1, true);
            }
        }
    }

    public ZestStatement getNext() {
        return this.next;
    }

    protected void setNext(ZestStatement next) {
        this.next = next;
    }

    public int getIndex() {
        return this.index;
    }

    private void setIndex(int index, boolean recurse) {
        this.index = index;
        if (recurse && this.next != null) {
            if (this.equals(this.next)) {
                throw new IllegalArgumentException();
            }
            this.next.setIndex(index + 1, true);
        }
    }

    abstract void setPrefix(String var1, String var2) throws MalformedURLException;

    @Override
    public abstract ZestStatement deepCopy();

    protected void init() {
        this.setPrev(this);
    }

    protected ZestStatement setPrev(ZestStatement prev) {
        if (this instanceof ZestContainer) {
            throw new IllegalArgumentException();
        }
        this.previous = prev;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public abstract boolean isPassive();
}

