/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zest.core.v1;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.zaproxy.zest.core.v1.ZestElement;

public class ZestVariables
extends ZestElement {
    public static final String REQUEST_URL = "request.url";
    public static final String REQUEST_METHOD = "request.method";
    public static final String REQUEST_HEADER = "request.header";
    public static final String REQUEST_BODY = "request.body";
    public static final String RESPONSE_URL = "response.url";
    public static final String RESPONSE_HEADER = "response.header";
    public static final String RESPONSE_BODY = "response.body";
    private String tokenStart = "{{";
    private String tokenEnd = "}}";
    private Map<String, String> tokens = new LinkedHashMap<String, String>();

    @Override
    public ZestVariables deepCopy() {
        ZestVariables zt = new ZestVariables();
        zt.setTokenStart(this.tokenStart);
        zt.setTokenEnd(this.tokenEnd);
        for (Map.Entry<String, String> entry : this.tokens.entrySet()) {
            zt.setVariable(entry.getKey(), entry.getValue());
        }
        return zt;
    }

    public String getTokenStart() {
        return this.tokenStart;
    }

    public void setTokenStart(String tokenStart) {
        this.tokenStart = tokenStart;
    }

    public String getTokenEnd() {
        return this.tokenEnd;
    }

    public void setTokenEnd(String tokenEnd) {
        this.tokenEnd = tokenEnd;
    }

    public String getVariable(String name) {
        return this.tokens.get(name);
    }

    public void setVariable(Map<String, String> tokens) {
        this.tokens = new LinkedHashMap<String, String>(tokens);
    }

    public List<String[]> getVariables() {
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (Map.Entry<String, String> entry : this.tokens.entrySet()) {
            list.add(new String[]{entry.getKey(), entry.getValue()});
        }
        return list;
    }

    public Map<String, String> getVariablesMap() {
        return Collections.unmodifiableMap(this.tokens);
    }

    public void addVariable(String name, String value) {
        if (this.tokens.get(name) == null) {
            if (value != null) {
                this.tokens.put(name, value);
            } else {
                this.tokens.put(name, name);
            }
        }
    }

    public void addVariable(String name) {
        if (this.tokens.get(name) == null) {
            this.tokens.put(name, name);
        }
    }

    public void addVariables(Map<String, String> tokens) {
        this.tokens.putAll(tokens);
    }

    public void setVariable(String name, String value) {
        this.tokens.put(name, value);
    }

    private String replaceInString(String str, boolean urlEncode, List<String> previous) {
        if (str == null) {
            return null;
        }
        boolean changed = false;
        for (String[] nvPair : this.getVariables()) {
            Object tokenStr = this.getTokenStart() + nvPair[0] + this.getTokenEnd();
            if (str.contains((CharSequence)tokenStr) && !previous.contains(nvPair[0])) {
                previous.add(nvPair[0]);
                changed = true;
                str = str.replace((CharSequence)tokenStr, this.getReplacementValue(nvPair[1]));
            }
            if (changed || !urlEncode) continue;
            try {
                if (!str.contains((CharSequence)(tokenStr = URLEncoder.encode((String)tokenStr, "UTF-8"))) || previous.contains(nvPair[0])) continue;
                previous.add(nvPair[0]);
                changed = true;
                str = str.replace((CharSequence)tokenStr, this.getReplacementValue(nvPair[1]));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        if (changed) {
            return this.replaceInString(str, urlEncode, previous);
        }
        return str;
    }

    private String getReplacementValue(String value) {
        return value == null ? "" : value;
    }

    public String replaceInString(String str, boolean urlEncode) {
        ArrayList<String> prev = new ArrayList<String>();
        return this.replaceInString(str, urlEncode, prev);
    }
}

