/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zest.core.v1;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import org.zaproxy.zest.core.v1.ZestElement;
import org.zaproxy.zest.core.v1.ZestJSON;

public class ZestYaml {
    public static String toString(ZestElement element) {
        try {
            String jsonString = ZestJSON.toString(element);
            JsonNode jsonNodeTree = new ObjectMapper().readTree(jsonString);
            return new YAMLMapper().configure(YAMLGenerator.Feature.MINIMIZE_QUOTES, true).writeValueAsString((Object)jsonNodeTree);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ZestElement fromString(String str) {
        try {
            ObjectMapper yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
            Object obj = yamlReader.readValue(str, Object.class);
            ObjectMapper jsonWriter = new ObjectMapper();
            return ZestJSON.fromString(jsonWriter.writeValueAsString(obj));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

