/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zest.core.v1;

import org.openqa.selenium.By;
import org.openqa.selenium.ElementClickInterceptedException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.zaproxy.zest.core.v1.ZestClientElement;
import org.zaproxy.zest.core.v1.ZestClientFailException;
import org.zaproxy.zest.core.v1.ZestElement;
import org.zaproxy.zest.core.v1.ZestRuntime;

public class ZestClientElementClick
extends ZestClientElement {
    public ZestClientElementClick(String sessionIdName, String type, String element) {
        super(sessionIdName, type, element);
    }

    public ZestClientElementClick() {
    }

    @Override
    public String invoke(ZestRuntime runtime) throws ZestClientFailException {
        WebElement element = this.getWebElement(runtime);
        try {
            element.click();
        }
        catch (ElementClickInterceptedException e) {
            this.clickOnElementPositon(runtime, element);
        }
        return null;
    }

    private void clickOnElementPositon(ZestRuntime runtime, WebElement element) throws ZestClientFailException {
        try {
            new Actions(runtime.getWebDriver(this.getWindowHandle())).moveToElement(element).click().perform();
        }
        catch (Exception e) {
            throw new ZestClientFailException((ZestElement)this, (Throwable)e);
        }
    }

    @Override
    protected ExpectedCondition<WebElement> getExpectedCondition(By by) {
        return ExpectedConditions.elementToBeClickable((By)by);
    }

    @Override
    public ZestClientElementClick deepCopy() {
        return this.deepCopy(ZestClientElementClick::new);
    }

    @Override
    public boolean isPassive() {
        return false;
    }
}

