/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zest.core.v1;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.zaproxy.zest.core.v1.ZestAssignment;
import org.zaproxy.zest.core.v1.ZestContainer;
import org.zaproxy.zest.core.v1.ZestElement;
import org.zaproxy.zest.core.v1.ZestExpressionElement;
import org.zaproxy.zest.core.v1.ZestRuntime;
import org.zaproxy.zest.core.v1.ZestStatement;

public class ZestConditional
extends ZestStatement
implements ZestContainer {
    private ZestExpressionElement rootExpression = null;
    private List<ZestStatement> ifStatements = new ArrayList<ZestStatement>();
    private List<ZestStatement> elseStatements = new ArrayList<ZestStatement>();

    public ZestConditional() {
    }

    public ZestConditional(ZestExpressionElement rootExp) {
        this.rootExpression = rootExp;
    }

    public ZestConditional(int index) {
        super(index);
    }

    public ZestConditional(int index, ZestExpressionElement rootExp) {
        super(index);
        this.rootExpression = rootExp;
    }

    public void addIf(ZestStatement req) {
        this.addIf(this.ifStatements.size(), req);
    }

    public void addIf(int index, ZestStatement req) {
        ZestStatement prev = this;
        if (index > 0 && (prev = this.ifStatements.get(index - 1)) instanceof ZestContainer) {
            prev = ((ZestContainer)((Object)prev)).getLast();
        }
        req.insertAfter(prev);
        if (index == this.ifStatements.size()) {
            this.ifStatements.add(req);
        } else {
            this.ifStatements.add(index, req);
        }
    }

    public void moveIf(int index, ZestStatement req) {
        this.removeIf(req);
        this.addIf(index, req);
    }

    public void removeIf(ZestStatement req) {
        this.ifStatements.remove(req);
        req.remove();
    }

    public void removeIfStatement(int index) {
        this.removeIf(this.ifStatements.get(index));
    }

    public ZestStatement getIfStatement(int index) {
        return this.ifStatements.get(index);
    }

    public List<ZestStatement> getIfStatements() {
        return this.ifStatements;
    }

    public void addElse(ZestStatement req) {
        this.addElse(this.elseStatements.size(), req);
    }

    @Override
    public List<ZestStatement> getChildren() {
        ArrayList<ZestStatement> children = new ArrayList<ZestStatement>();
        children.addAll(this.getIfStatements());
        children.addAll(this.getElseStatements());
        return Collections.unmodifiableList(children);
    }

    public void addElse(int index, ZestStatement req) {
        ZestStatement prev = this;
        if (this.ifStatements.size() > 0 && (prev = this.ifStatements.get(this.ifStatements.size() - 1)) instanceof ZestContainer) {
            prev = ((ZestContainer)((Object)prev)).getLast();
        }
        if (index > 0 && (prev = this.elseStatements.get(index - 1)) instanceof ZestContainer) {
            prev = ((ZestContainer)((Object)prev)).getLast();
        }
        req.insertAfter(prev);
        if (index == this.elseStatements.size()) {
            this.elseStatements.add(req);
        } else {
            this.elseStatements.add(index, req);
        }
    }

    public void moveElse(int index, ZestStatement req) {
        this.removeElse(req);
        this.addElse(index, req);
    }

    public void removeElse(ZestStatement req) {
        this.elseStatements.remove(req);
        req.remove();
    }

    public void removeElseStatement(int index) {
        this.removeElse(this.elseStatements.get(index));
    }

    public ZestStatement getElseStatement(int index) {
        return this.elseStatements.get(index);
    }

    public List<ZestStatement> getElseStatements() {
        return this.elseStatements;
    }

    @Override
    public int getIndex(ZestStatement child) {
        if (this.ifStatements.contains(child)) {
            return this.ifStatements.indexOf(child);
        }
        return this.elseStatements.indexOf(child);
    }

    @Override
    public void move(int index, ZestStatement stmt) {
        if (this.ifStatements.contains(stmt)) {
            this.removeIf(stmt);
            this.addIf(index, stmt);
        } else if (this.elseStatements.contains(stmt)) {
            this.removeElse(stmt);
            this.addElse(index, stmt);
        } else {
            throw new IllegalArgumentException("Not a direct child: " + String.valueOf(stmt));
        }
    }

    @Override
    public boolean isSameSubclass(ZestElement ze) {
        return ze instanceof ZestConditional;
    }

    @Override
    public void setPrefix(String oldPrefix, String newPrefix) throws MalformedURLException {
        for (ZestStatement stmt : this.ifStatements) {
            stmt.setPrefix(oldPrefix, newPrefix);
        }
        for (ZestStatement stmt : this.elseStatements) {
            stmt.setPrefix(oldPrefix, newPrefix);
        }
    }

    @Override
    public Set<String> getVariableNames() {
        HashSet<String> tokens = new HashSet<String>();
        for (ZestStatement stmt : this.ifStatements) {
            if (stmt instanceof ZestContainer) {
                tokens.addAll(((ZestContainer)((Object)stmt)).getVariableNames());
                continue;
            }
            if (!(stmt instanceof ZestAssignment)) continue;
            tokens.add(((ZestAssignment)stmt).getVariableName());
        }
        for (ZestStatement stmt : this.elseStatements) {
            if (stmt instanceof ZestContainer) {
                tokens.addAll(((ZestContainer)((Object)stmt)).getVariableNames());
                continue;
            }
            if (!(stmt instanceof ZestAssignment)) continue;
            tokens.add(((ZestAssignment)stmt).getVariableName());
        }
        return tokens;
    }

    @Override
    public ZestStatement getLast() {
        if (this.elseStatements.size() > 0) {
            return this.elseStatements.get(this.elseStatements.size() - 1);
        }
        if (this.ifStatements.size() > 0) {
            return this.ifStatements.get(this.ifStatements.size() - 1);
        }
        return this;
    }

    @Override
    public ZestStatement getChildBefore(ZestStatement child) {
        int childIndex;
        if (this.ifStatements.contains(child)) {
            int childIndex2 = this.ifStatements.indexOf(child);
            if (childIndex2 > 1) {
                return this.ifStatements.get(childIndex2 - 1);
            }
        } else if (this.elseStatements.contains(child) && (childIndex = this.elseStatements.indexOf(child)) > 1) {
            return this.elseStatements.get(childIndex - 1);
        }
        return null;
    }

    @Override
    public ZestStatement getStatement(int index) {
        ZestStatement stmt;
        for (ZestStatement zr : this.getIfStatements()) {
            if (zr.getIndex() == index) {
                return zr;
            }
            if (!(zr instanceof ZestContainer) || (stmt = ((ZestContainer)((Object)zr)).getStatement(index)) == null) continue;
            return stmt;
        }
        for (ZestStatement zr : this.getElseStatements()) {
            if (zr.getIndex() == index) {
                return zr;
            }
            if (!(zr instanceof ZestContainer) || (stmt = ((ZestContainer)((Object)zr)).getStatement(index)) == null) continue;
            return stmt;
        }
        return null;
    }

    public boolean isTrue(ZestRuntime runtime) {
        return this.getRootExpression().evaluate(runtime);
    }

    public ZestExpressionElement getRootExpression() {
        return this.rootExpression;
    }

    public ZestExpressionElement setRootExpression(ZestExpressionElement new_root) {
        ZestExpressionElement old_root = this.getRootExpression();
        this.rootExpression = new_root;
        return old_root;
    }

    @Override
    public ZestStatement deepCopy() {
        ZestConditional copy = new ZestConditional(this.getIndex());
        if (this.rootExpression != null) {
            copy.rootExpression = this.rootExpression.deepCopy();
        }
        for (ZestStatement stmt : this.ifStatements) {
            copy.ifStatements.add(stmt.deepCopy());
        }
        for (ZestStatement stmt : this.elseStatements) {
            copy.elseStatements.add(stmt.deepCopy());
        }
        copy.setEnabled(this.isEnabled());
        return copy;
    }

    @Override
    public boolean isPassive() {
        return true;
    }

    @Override
    protected ZestStatement setPrev(ZestStatement prev) {
        for (ZestStatement statement : this.ifStatements) {
            if (prev != null) {
                prev.setNext(statement);
            }
            prev = statement.setPrev(prev);
        }
        for (ZestStatement statement : this.elseStatements) {
            if (prev != null) {
                prev.setNext(statement);
            }
            prev = statement.setPrev(prev);
        }
        return prev;
    }
}

