/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zest.core.v1;

import java.net.URL;
import org.zaproxy.zest.core.v1.ZestExpression;
import org.zaproxy.zest.core.v1.ZestRequest;
import org.zaproxy.zest.core.v1.ZestRuntime;

public class ZestExpressionProtocol
extends ZestExpression {
    private String protocol;

    public ZestExpressionProtocol() {
    }

    public ZestExpressionProtocol(String protocol) {
        this(protocol, false);
    }

    public ZestExpressionProtocol(String protocol, boolean inverse) {
        super(inverse);
        this.protocol = protocol;
    }

    @Override
    public boolean isTrue(ZestRuntime runtime) {
        if (this.protocol == null) {
            return false;
        }
        ZestRequest request = runtime.getLastRequest();
        if (request == null) {
            return false;
        }
        URL url = request.getUrl();
        if (url == null) {
            return false;
        }
        return this.protocol.equalsIgnoreCase(url.getProtocol());
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Override
    public ZestExpressionProtocol deepCopy() {
        return new ZestExpressionProtocol(this.protocol, this.isInverse());
    }

    public String toString() {
        return (this.isInverse() ? "NOT " : "") + "Protocol: " + this.protocol;
    }
}

