/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zest.core.v1;

import java.time.Duration;
import java.util.function.Supplier;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.zaproxy.zest.core.v1.ZestClient;
import org.zaproxy.zest.core.v1.ZestClientFailException;
import org.zaproxy.zest.core.v1.ZestElement;
import org.zaproxy.zest.core.v1.ZestRuntime;
import org.zaproxy.zest.core.v1.ZestScript;

public abstract class ZestClientElement
extends ZestClient {
    private String windowHandle = null;
    private String type = null;
    private String element = null;
    private int waitForMsec = 0;

    public ZestClientElement(String windowHandle, String type, String element, int waitForMsec) {
        this.windowHandle = windowHandle;
        this.type = type;
        this.element = element;
        this.waitForMsec = waitForMsec;
    }

    public ZestClientElement(String windowHandle, String type, String element) {
        this.windowHandle = windowHandle;
        this.type = type;
        this.element = element;
    }

    public ZestClientElement() {
    }

    public String getWindowHandle() {
        return this.windowHandle;
    }

    public void setWindowHandle(String windowHandle) {
        this.windowHandle = windowHandle;
    }

    public String getElement() {
        return this.element;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setElement(String element) {
        this.element = element;
    }

    public int getWaitForMsec() {
        return this.waitForMsec;
    }

    public void setWaitForMsec(int waitForMsec) {
        this.waitForMsec = waitForMsec;
    }

    public WebElement getWebElement(ZestRuntime runtime) throws ZestClientFailException {
        WebDriver wd = runtime.getWebDriver(this.getWindowHandle());
        if (wd == null) {
            throw new ZestClientFailException((ZestElement)this, "No client: " + runtime.getVariable(this.getWindowHandle()));
        }
        try {
            By by = ZestScript.getBy(runtime.replaceVariablesInString(this.getElement(), false), this.type);
            if (by == null) {
                throw new ZestClientFailException((ZestElement)this, "Unsupported type: " + this.type);
            }
            if (this.waitForMsec > 0) {
                WebDriverWait wait = new WebDriverWait(wd, Duration.ofMillis(this.waitForMsec));
                return (WebElement)wait.until(this.getExpectedCondition(by));
            }
            return wd.findElement(by);
        }
        catch (Exception e) {
            throw new ZestClientFailException((ZestElement)this, (Throwable)e);
        }
    }

    protected ExpectedCondition<WebElement> getExpectedCondition(By by) {
        return ExpectedConditions.visibilityOfElementLocated((By)by);
    }

    protected <T extends ZestClientElement> T deepCopy(Supplier<T> t) {
        ZestClientElement copy = (ZestClientElement)t.get();
        copy.setType(this.getType());
        copy.setElement(this.getElement());
        copy.setEnabled(this.isEnabled());
        copy.setWaitForMsec(this.getWaitForMsec());
        copy.setWindowHandle(this.getWindowHandle());
        return (T)copy;
    }
}

