/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zest.core.v1;

import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;
import org.zaproxy.zest.core.v1.ZestClientElement;
import org.zaproxy.zest.core.v1.ZestClientFailException;
import org.zaproxy.zest.core.v1.ZestRuntime;

public class ZestClientElementScrollTo
extends ZestClientElement {
    public ZestClientElementScrollTo(String sessionIdName, String type, String element) {
        super(sessionIdName, type, element);
    }

    public ZestClientElementScrollTo() {
    }

    @Override
    public String invoke(ZestRuntime runtime) throws ZestClientFailException {
        JavascriptExecutor js = (JavascriptExecutor)runtime.getWebDriver(this.getWindowHandle());
        if (!this.isElementInView(js, this.getWebElement(runtime))) {
            String script = "arguments[0].scrollIntoView({ block: \"nearest\" });\n";
            js.executeScript(script, new Object[]{this.getWebElement(runtime)});
        }
        return null;
    }

    private boolean isElementInView(JavascriptExecutor js, WebElement element) {
        return (Boolean)js.executeScript("const rect = arguments[0].getBoundingClientRect()\n\nconst windowHeight = (window.innerHeight || document.documentElement.clientHeight)\nconst windowWidth = (window.innerWidth || document.documentElement.clientWidth)\n\nconst vertInView = (rect.top <= windowHeight) && ((rect.top + rect.height) > 0)\nconst horInView = (rect.left <= windowWidth) && ((rect.left + rect.width) > 0)\n\nreturn (vertInView && horInView)\n", new Object[]{element});
    }

    @Override
    public ZestClientElementScrollTo deepCopy() {
        return this.deepCopy(ZestClientElementScrollTo::new);
    }

    @Override
    public boolean isPassive() {
        return false;
    }
}

